/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.utility.versiontool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.dataone.cn.utility.versiontool.ComponentInfoNameAlphabetizer;
import org.dataone.cn.utility.versiontool.ComponentVersionInfo;

public class WebAppVersionReporter {
    public static final String newline = System.getProperty("line.separator");
    private static final String MANIFEST_PATH = "/META-INF/MANIFEST.MF";
    private static final String LIB_DIR_PATH = "/WEB-INF/lib/";
    private String PROPERTIES_FILE_PATH = null;
    private static final String TOMCAT_PATH_KEY = "tomcat_path";
    private static final String WEBAPP_NAME_KEY = "web_app_name";
    private static String tomcat_webapp_path = null;
    private static ArrayList<String> webAppNames = new ArrayList();

    public WebAppVersionReporter() {
    }

    public WebAppVersionReporter(String propertyFilePath) {
        if (propertyFilePath != null) {
            this.PROPERTIES_FILE_PATH = propertyFilePath;
        }
    }

    public Collection<ComponentVersionInfo> report(StringBuilder log) {
        File webAppDir;
        ArrayList<ComponentVersionInfo> webCompInfoList = new ArrayList<ComponentVersionInfo>();
        if (this.setPropertiesFromFile(log) && (webAppDir = new File(tomcat_webapp_path)).exists()) {
            for (String webAppName : webAppNames) {
                Manifest manifest = this.getWebAppManifest(webAppName, log);
                if (manifest == null) continue;
                ComponentVersionInfo webCompInfo = new ComponentVersionInfo(webAppName, tomcat_webapp_path + webAppName, manifest);
                File libDir = new File(tomcat_webapp_path + webAppName + LIB_DIR_PATH);
                this.addComponentInfoFromLib(webCompInfo, libDir, log);
                webCompInfoList.add(webCompInfo);
            }
        }
        return webCompInfoList;
    }

    private void addComponentInfoFromLib(ComponentVersionInfo webCompInfo, File libDir, StringBuilder log) {
        File[] files;
        for (File f : files = libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("d1_");
            }
        })) {
            JarFile jarFile = null;
            String jarName = null;
            try {
                jarFile = new JarFile(f);
            }
            catch (IOException ioe) {
                log.append("Unable to open jar: " + f.getAbsolutePath() + newline);
                continue;
            }
            jarName = StringUtils.substringBefore(jarFile.getName(), "_java");
            jarName = StringUtils.substringAfterLast(jarName, "/");
            jarName = StringUtils.substringBefore(jarName, "-");
            Manifest manifest = null;
            try {
                manifest = jarFile.getManifest();
            }
            catch (IOException ioe) {
                log.append("Unable to open manifest for: " + f.getAbsolutePath() + newline);
            }
            ComponentVersionInfo jarDep = new ComponentVersionInfo(jarName, f.getAbsolutePath(), manifest);
            if (StringUtils.isEmpty(jarDep.getVersion())) {
                String version = jarFile.getName();
                int index = StringUtils.lastIndexOf((CharSequence)version, "-");
                version = StringUtils.substring(version, index - 5, index + 9);
                jarDep.setVersion(version);
            }
            webCompInfo.addDependency(jarDep);
        }
        Collections.sort(webCompInfo.getDependencies(), new ComponentInfoNameAlphabetizer());
    }

    private Manifest getWebAppManifest(String webAppName, StringBuilder log) {
        Manifest manifest = null;
        try {
            FileInputStream manifestStream = new FileInputStream(tomcat_webapp_path + webAppName + MANIFEST_PATH);
            manifest = new Manifest(manifestStream);
        }
        catch (FileNotFoundException fnfe) {
            log.append("Unable to locate manifest for web app: " + webAppName + newline);
        }
        catch (IOException IOE) {
            log.append("Unable to open manifest for web app: " + webAppName + newline);
        }
        return manifest;
    }

    public boolean setPropertiesFromFile(StringBuilder log) {
        boolean returnValue = true;
        if (this.PROPERTIES_FILE_PATH != null) {
            File file = new File(this.PROPERTIES_FILE_PATH);
            if (file.exists() && file.canRead()) {
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    boolean resetAppList = false;
                    while ((line = in.readLine()) != null) {
                        String key = StringUtils.substringBefore(line, "=");
                        key = StringUtils.trim(key);
                        String value = StringUtils.substringAfter(line, "=");
                        value = StringUtils.trim(value);
                        if (TOMCAT_PATH_KEY.compareTo(key) == 0) {
                            tomcat_webapp_path = value;
                            continue;
                        }
                        if (WEBAPP_NAME_KEY.compareTo(key) != 0) continue;
                        if (!resetAppList) {
                            webAppNames.clear();
                            resetAppList = true;
                        }
                        webAppNames.add(value);
                    }
                    in.close();
                }
                catch (FileNotFoundException fnfe) {
                    returnValue = false;
                    log.append("Unable to locate properties file.  Please add default property file or pass one in via command line." + newline);
                }
                catch (IOException ioe) {
                    returnValue = false;
                    log.append("Unable to read properties file.  Please add default property file or pass one in via command line." + newline);
                }
            } else {
                returnValue = false;
                log.append("Unable to locate properties file: Please add default property file or pass one in via command line." + newline);
            }
        } else {
            returnValue = false;
            log.append("No property file provided.  Please add default property file or pass one in via command line." + newline);
        }
        return returnValue;
    }
}

