/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.dataone.cn.indexer.SolrIndex;
import org.dataone.cn.indexer.annotation.OntologyModelService;
import org.dataone.cn.indexer.object.ObjectManager;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.indexer.queue.IndexQueueMessageParser;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class IndexWorker {
    public static final String CREATE_INDEXT_TYPE = "create";
    public static final String DELETE_INDEX_TYPE = "delete";
    public static final String SYSMETA_CHANGE_TYPE = "sysmeta";
    public static final int HIGHEST_PRIORITY = 4;
    public static final int HIGH_PRIORITY = 3;
    public static final int MEDIUM_PRIORITY = 2;
    public static final int LOW_PRIORITY = 1;
    private static final String HEADER_ID = "id";
    private static final String HEADER_PATH = "path";
    private static final String HEADER_INDEX_TYPE = "index_type";
    private static final String EXCHANGE_NAME = "dataone-index";
    private static final String INDEX_QUEUE_NAME = "index";
    private static final String INDEX_ROUTING_KEY = "index";
    private static final String springConfigFileURL = "/index-parser-context.xml";
    private static final String ENV_NAME_OF_PROPERTIES_FILE = "DATAONE_INDEXER_CONFIG";
    private static Logger logger = Logger.getLogger(IndexWorker.class);
    private static String defaultExternalPropertiesFile = "/etc/dataone/dataone-indexer.properties";
    protected static String propertyFilePath = null;
    protected boolean multipleThread = true;
    protected int nThreads = 1;
    private String rabbitMQhost = null;
    private int rabbitMQport = 0;
    private String rabbitMQusername = null;
    private String rabbitMQpassword = null;
    private int rabbitMQMaxPriority = 10;
    private Connection rabbitMQconnection = null;
    private Channel rabbitMQchannel = null;
    private ApplicationContext context = null;
    protected SolrIndex solrIndex = null;
    private String specifiedThreadNumberStr = null;
    private int specifiedThreadNumber = 0;
    private ExecutorService executor = null;

    public static void main(String[] args) {
        logger.info((Object)"IndexWorker.main - Starting index worker...");
        String propertyFile = null;
        IndexWorker.loadExternalPropertiesFile(propertyFile);
        try {
            IndexWorker worker = new IndexWorker();
            worker.start();
        }
        catch (Exception e) {
            logger.fatal((Object)("IndexWorker.main() exiting due to fatal error: " + e.getMessage()), (Throwable)e);
            System.exit(1);
        }
        IndexWorker.startLivenessProbe();
    }

    public static void loadExternalPropertiesFile(String propertyFile) {
        File defaultFile;
        if (propertyFile != null && !propertyFile.trim().equals("")) {
            propertyFilePath = propertyFile;
            logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path specified by users is " + propertyFilePath));
            defaultFile = new File(propertyFilePath);
            if (defaultFile.exists() && defaultFile.canRead()) {
                logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path users specified is  " + propertyFilePath + ". The file exists and is readable. So it will be used."));
            } else {
                logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path users specified is  " + propertyFilePath + ". But the file does NOT exist or is NOT readable. So it will NOT be used."));
                propertyFilePath = null;
            }
        }
        if (propertyFilePath == null || propertyFilePath.trim().equals("")) {
            propertyFilePath = System.getenv(ENV_NAME_OF_PROPERTIES_FILE);
            logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path from the env variable is " + propertyFilePath));
            if (propertyFilePath != null && !propertyFilePath.trim().equals("")) {
                defaultFile = new File(propertyFilePath);
                if (defaultFile.exists() && defaultFile.canRead()) {
                    logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path can be read from the env variable DATAONE_INDEXER_CONFIG and its value is " + propertyFilePath + ". The file exists and it will be used."));
                } else {
                    logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configuration path can be read from the env variable DATAONE_INDEXER_CONFIG and its value is " + propertyFilePath + ". But the file does NOT exist or is NOT readable. So it will NOT be used."));
                    propertyFilePath = null;
                }
            }
        }
        if ((propertyFilePath == null || propertyFilePath.trim().equals("")) && (defaultFile = new File(defaultExternalPropertiesFile)).exists() && defaultFile.canRead()) {
            logger.info((Object)("IndexWorker.loadExternalPropertiesFile - the configure path can't be read either by users specified or from the env variable DATAONE_INDEXER_CONFIG. However, the default external file " + defaultExternalPropertiesFile + " exists and it will be used."));
            propertyFilePath = defaultExternalPropertiesFile;
        }
        if (propertyFilePath != null && !propertyFilePath.trim().equals("")) {
            try {
                Settings.augmentConfiguration((String)propertyFilePath);
                logger.info((Object)("IndexWorker.loadExternalPropertiesFile - loaded the properties from the file " + propertyFilePath));
            }
            catch (ConfigurationException e) {
                logger.error((Object)("IndexWorker.loadExternalPropertiesFile - can't load any properties from the file " + propertyFilePath + " since " + e.getMessage() + ". It will use the default properties in the jar file."));
            }
        } else {
            logger.info((Object)("IndexWorker.loadExternalPropertiesFile - can't load an external properties file from the env variable DATAONE_INDEXER_CONFIG or from the default path " + defaultExternalPropertiesFile + ". Dataone-indexer will use the properties file embedded in the jar file"));
        }
    }

    public static void loadAdditionalPropertyFile(String propertyFile) {
        if (propertyFile != null && !propertyFile.trim().equals("")) {
            try {
                Settings.augmentConfiguration((String)propertyFile);
                logger.info((Object)("IndexWorker.loadAdditionalPropertyFile - loaded the properties from the file " + propertyFile));
            }
            catch (ConfigurationException e) {
                logger.error((Object)("IndexWorker.loadAdditionalPropertyFile - can't load any properties from the file " + propertyFile + " since " + e.getMessage() + "."));
            }
        } else {
            logger.info((Object)"IndexWorker.loadAdditionalPropertyFile - can't load an additional property file since its path is null or blank.");
        }
    }

    public IndexWorker() throws IOException, TimeoutException, ServiceFailure {
        this(true);
    }

    public IndexWorker(Boolean initialize) throws IOException, TimeoutException, ServiceFailure {
        if (initialize.booleanValue()) {
            this.initExecutorService();
            this.initIndexQueue();
            this.initIndexParsers();
            ObjectManager.getInstance();
            OntologyModelService.getInstance();
        }
    }

    private void initIndexQueue() throws IOException, TimeoutException {
        this.rabbitMQhost = Settings.getConfiguration().getString("index.rabbitmq.hostname", "localhost");
        this.rabbitMQport = Settings.getConfiguration().getInt("index.rabbitmq.hostport", 5672);
        this.rabbitMQusername = Settings.getConfiguration().getString("index.rabbitmq.username", "guest");
        this.rabbitMQpassword = Settings.getConfiguration().getString("index.rabbitmq.password", "guest");
        this.rabbitMQMaxPriority = Settings.getConfiguration().getInt("index.rabbitmq.max.priority");
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.rabbitMQhost);
        factory.setPort(this.rabbitMQport);
        factory.setPassword(this.rabbitMQpassword);
        factory.setUsername(this.rabbitMQusername);
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(10000);
        logger.debug((Object)("IndexWorker.initIndexQueue - Set RabbitMQ host to: " + this.rabbitMQhost));
        logger.debug((Object)("IndexWorker.initIndexQueue - Set RabbitMQ port to: " + this.rabbitMQport));
        boolean durable = true;
        this.rabbitMQconnection = factory.newConnection();
        this.rabbitMQchannel = this.rabbitMQconnection.createChannel();
        this.rabbitMQchannel.exchangeDeclare(EXCHANGE_NAME, "direct", durable);
        boolean exclusive = false;
        boolean autoDelete = false;
        HashMap<String, Integer> argus = new HashMap<String, Integer>();
        argus.put("x-max-priority", this.rabbitMQMaxPriority);
        logger.debug((Object)("IndexWorker.initIndexQueue - Set RabbitMQ max priority to: " + this.rabbitMQMaxPriority));
        this.rabbitMQchannel.queueDeclare("index", durable, exclusive, autoDelete, argus);
        this.rabbitMQchannel.queueBind("index", EXCHANGE_NAME, "index");
        logger.info((Object)("IndexWorker.initIndexQueue - the allowed unacknowledged message(s) number is " + this.nThreads));
        this.rabbitMQchannel.basicQos(this.nThreads);
        logger.debug((Object)"IndexWorker.initIndexQueue - Connected to the RabbitMQ queue with the name of index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initIndexParsers() {
        if (this.context == null) {
            Class<IndexWorker> clazz = IndexWorker.class;
            // MONITORENTER : org.dataone.cn.indexer.IndexWorker.class
            if (this.context == null) {
                this.context = new ClassPathXmlApplicationContext(springConfigFileURL);
            }
            // MONITOREXIT : clazz
        }
        this.solrIndex = (SolrIndex)this.context.getBean("solrIndex");
    }

    protected void initExecutorService() {
        this.specifiedThreadNumberStr = Settings.getConfiguration().getString("index.thread.number", "0");
        try {
            this.specifiedThreadNumber = Integer.parseInt(this.specifiedThreadNumberStr);
        }
        catch (NumberFormatException e) {
            this.specifiedThreadNumber = 0;
            logger.warn((Object)("IndexWorker.initExecutorService - IndexWorker cannot parse the string " + this.specifiedThreadNumberStr + " specified by property index.thread.number into a number since " + e.getLocalizedMessage() + ". The default value 0 will be used as the specified value"));
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.nThreads = Math.max(1, --availableProcessors);
        if (this.specifiedThreadNumber > 0 && this.specifiedThreadNumber < this.nThreads) {
            this.nThreads = this.specifiedThreadNumber;
        }
        if (this.nThreads != 1) {
            logger.info((Object)("IndexWorker.initExecutorService - the size of index thread pool specified in the propery file is " + this.specifiedThreadNumber + ". The size computed from the available processors is " + availableProcessors + ". Final computed thread pool size for index executor: " + this.nThreads));
            this.executor = Executors.newFixedThreadPool(this.nThreads);
            this.multipleThread = true;
        } else {
            logger.info((Object)("IndexWorker.initExecutorService - the size of index thread pool specified in the propery file is " + this.specifiedThreadNumber + ". The size computed from the available processors is " + availableProcessors + ". Final computed thread pool size for index executor: " + this.nThreads + ". Since its value is 1, we do NOT need the executor service and use a single thread way."));
            this.multipleThread = false;
        }
    }

    public void start() throws IOException {
        DefaultConsumer consumer = new DefaultConsumer(this.rabbitMQchannel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                String identifier = null;
                try {
                    final IndexQueueMessageParser parser = new IndexQueueMessageParser();
                    parser.parse(properties, body);
                    final Envelope finalEnvelop = envelope;
                    if (IndexWorker.this.multipleThread) {
                        logger.debug((Object)("IndexWorker.start.handleDelivery - using multiple threads to index identifier " + parser.getIdentifier().getValue()));
                        Runnable runner = new Runnable(){

                            @Override
                            public void run() {
                                IndexWorker.this.indexOjbect(parser, finalEnvelop.getDeliveryTag(), IndexWorker.this.multipleThread);
                            }
                        };
                        IndexWorker.this.executor.submit(runner);
                    } else {
                        logger.debug((Object)("IndexWorker.start.handleDelivery - using single thread to index identifier " + parser.getIdentifier().getValue()));
                        IndexWorker.this.indexOjbect(parser, finalEnvelop.getDeliveryTag(), IndexWorker.this.multipleThread);
                    }
                }
                catch (InvalidRequest e) {
                    logger.error((Object)("IndexWorker.start.handleDelivery - cannot index the task for identifier  " + identifier + " since " + e.getMessage()));
                    boolean requeue = false;
                    IndexWorker.this.rabbitMQchannel.basicReject(envelope.getDeliveryTag(), requeue);
                }
            }
        };
        boolean autoAck = false;
        this.rabbitMQchannel.basicConsume("index", autoAck, (Consumer)consumer);
        logger.info((Object)"IndexWorker.start - Calling basicConsume and waiting for the coming messages");
    }

    private void indexOjbect(IndexQueueMessageParser parser, long deliveryTag, boolean multipleThread) {
        long start = System.currentTimeMillis();
        Identifier pid = parser.getIdentifier();
        String indexType = parser.getIndexType();
        int priority = parser.getPriority();
        String finalFilePath = parser.getObjectPath();
        try {
            this.rabbitMQchannel.basicAck(deliveryTag, false);
        }
        catch (Exception e) {
            logger.error((Object)("IndexWorker.indexOjbect - identifier: " + pid.getValue() + " , the index type: " + indexType + ", sending acknowledgement back to rabbitmq failed since " + e.getMessage() + ". So rabbitmq may resend the message again"));
        }
        try {
            boolean sysmetaOnly;
            long threadId = Thread.currentThread().getId();
            logger.info((Object)("IndexWorker.consumer.indexOjbect by multiple thread? " + multipleThread + ", with the thread id " + threadId + " - Received the index task from the index queue with the identifier: " + pid.getValue() + " , the index type: " + indexType + ", the file path (null means not to have): " + finalFilePath + ", the priotity: " + priority));
            if (indexType.equals(CREATE_INDEXT_TYPE)) {
                sysmetaOnly = false;
                this.solrIndex.update(pid, finalFilePath, sysmetaOnly);
            } else if (indexType.equals(SYSMETA_CHANGE_TYPE)) {
                sysmetaOnly = true;
                this.solrIndex.update(pid, finalFilePath, sysmetaOnly);
            } else if (indexType.equals(DELETE_INDEX_TYPE)) {
                this.solrIndex.remove(pid);
            } else {
                throw new InvalidRequest("0000", "DataONE indexer does not know the index type: " + indexType + " in the index task");
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("IndexWorker.indexOjbect with the thread id " + threadId + " - Completed the index task from the index queue with the identifier: " + pid.getValue() + " , the index type: " + indexType + ", the file path (null means not to have): " + finalFilePath + ", the priotity: " + priority + " and the time taking is " + (end - start) + " milliseconds"));
        }
        catch (InvalidToken e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotAuthorized e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (NotImplemented e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (ServiceFailure e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (NotFound e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (XPathExpressionException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (UnsupportedType e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (MarshallingException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (EncoderException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (InvalidRequest e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()));
        }
        catch (InstantiationException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("IndexWorker.indexOjbect - cannot index the task for identifier " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop() throws IOException, TimeoutException {
        this.rabbitMQchannel.close();
        this.rabbitMQconnection.close();
        logger.info((Object)"IndexWorker.stop - stop the index queue connection.");
    }

    private static void startLivenessProbe() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Path path = Paths.get("./livenessprobe", new String[0]);
        Runnable task = () -> {
            try {
                Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
            }
            catch (IOException e) {
                logger.error((Object)("IndexWorker.startLivenessProbe - failed to update file: " + path), (Throwable)e);
            }
        };
        scheduler.scheduleAtFixedRate(task, 0L, 10L, TimeUnit.SECONDS);
        logger.info((Object)"IndexWorker.startLivenessProbe - livenessProbe started");
    }
}

