/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.dataone.cn.indexer.solrhttp.OutputStreamHttpEntity;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTTPService {
    private static final String CHAR_ENCODING = "UTF-8";
    static final String PARAM_START = "start";
    static final String PARAM_ROWS = "rows";
    static final String PARAM_INDENT = "indent";
    static final String VALUE_INDENT_ON = "on";
    static final String VALUE_INDENT_OFF = "off";
    static final String PARAM_QUERY = "q";
    private Log log = LogFactory.getLog(HTTPService.class);
    private HttpComponentsClientHttpRequestFactory httpRequestFactory;
    private String SOLR_SCHEMA_PATH;
    private String solrIndexUri;
    private List<String> validSolrFieldNames = new ArrayList<String>();

    public HTTPService(HttpComponentsClientHttpRequestFactory requestFactory) {
        this.httpRequestFactory = requestFactory;
    }

    public void sendUpdate(String uri, SolrElementAdd data, String encoding) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setEntity((HttpEntity)new OutputStreamHttpEntity(data, encoding));
            response = this.getHttpClient().execute((HttpUriRequest)post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
            }
            post.abort();
        }
        catch (Exception ex) {
            this.writeError(ex, data, inputStreamResponse, uri);
        }
    }

    public void sendUpdate(String uri, SolrElementAdd data) throws IOException {
        this.sendUpdate(uri, data, CHAR_ENCODING);
    }

    private void sendPost(String uri, String data, String encoding) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            ByteArrayEntity entity = new ByteArrayEntity(data.getBytes());
            entity.setContentEncoding(encoding);
            post.setEntity((HttpEntity)entity);
            response = this.getHttpClient().execute((HttpUriRequest)post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
            }
            post.abort();
        }
        catch (Exception ex) {
            this.writeError(ex, data, inputStreamResponse, uri);
        }
    }

    public void sendSolrDelete(String pid) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.write((String)"<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, (String)CHAR_ENCODING);
            IOUtils.write((String)("<delete><id>" + pid + "</id></delete>"), (OutputStream)outputStream, (String)CHAR_ENCODING);
            this.sendPost(this.getSolrIndexUri(), outputStream.toString(), CHAR_ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeError(Exception ex, SolrElementAdd data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                this.log.error((Object)"Unable to write to stream", (Throwable)ex);
            }
            this.log.error((Object)("URL: " + uri));
            this.log.error((Object)"Post: ");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            data.serialize((OutputStream)baos, CHAR_ENCODING);
            this.log.error((Object)new String(baos.toByteArray(), CHAR_ENCODING));
            this.log.error((Object)"\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStreamResonse, (OutputStream)baosResponse);
            this.log.error((Object)new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeError(Exception ex, String data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                this.log.error((Object)"Unable to write to stream", (Throwable)ex);
            }
            this.log.error((Object)("URL: " + uri));
            this.log.error((Object)"Post: ");
            this.log.error((Object)data);
            this.log.error((Object)"\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStreamResonse, (OutputStream)baosResponse);
            this.log.error((Object)new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<SolrDoc> getDocuments(String uir, List<String> ids) throws IOException, XPathExpressionException, EncoderException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        this.loadSolrSchemaFields();
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("id:").append(HTTPService.escapeQueryChars(id));
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_QUERY, sb.toString()));
        params.add(new BasicNameValuePair(PARAM_START, "0"));
        params.add(new BasicNameValuePair(PARAM_ROWS, Integer.toString(ids.size())));
        params.add(new BasicNameValuePair(PARAM_INDENT, VALUE_INDENT_ON));
        String paramString = URLEncodedUtils.format(params, (String)CHAR_ENCODING);
        String requestURI = uir + "?" + paramString;
        this.log.info((Object)("REQUEST URI= " + requestURI));
        HttpGet commandGet = new HttpGet(requestURI);
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)commandGet);
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(content);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        commandGet.abort();
        List<SolrDoc> docs = this.parseResults(document);
        return docs;
    }

    public SolrDoc retrieveDocumentFromSolrServer(String id, String solrQueryUri) throws XPathExpressionException, IOException, EncoderException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List<SolrDoc> indexedDocuments = this.getDocuments(solrQueryUri, ids);
        return indexedDocuments.get(0);
    }

    private List<SolrDoc> parseResults(Document document) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/response/result/doc", document, XPathConstants.NODESET);
        ArrayList<SolrDoc> docList = new ArrayList<SolrDoc>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element docElement = (Element)nodeList.item(i);
            docList.add(this.parseDoc(docElement));
        }
        return docList;
    }

    private SolrDoc parseDoc(Element docElement) {
        SolrDoc doc = new SolrDoc();
        doc.LoadFromElement(docElement, this.validSolrFieldNames);
        return doc;
    }

    public void setSolrSchemaPath(String path) {
        this.SOLR_SCHEMA_PATH = path;
    }

    private void loadSolrSchemaFields() {
        if (this.SOLR_SCHEMA_PATH != null && this.validSolrFieldNames.isEmpty()) {
            Document doc = this.loadSolrSchemaDocument();
            NodeList nList = doc.getElementsByTagName("copyField");
            ArrayList<String> copyDestinationFields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String destinationField = node.getAttributes().getNamedItem("dest").getNodeValue();
                copyDestinationFields.add(destinationField);
            }
            nList = doc.getElementsByTagName("field");
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String fieldName = node.getAttributes().getNamedItem("name").getNodeValue();
                fields.add(fieldName);
            }
            fields.removeAll(copyDestinationFields);
            this.validSolrFieldNames = fields;
        }
    }

    private Document loadSolrSchemaDocument() {
        Document doc = null;
        File schemaFile = new File(this.SOLR_SCHEMA_PATH);
        if (schemaFile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(schemaFile);
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                doc = dBuilder.parse(fis);
            }
            catch (SAXException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return doc;
    }

    public void setSolrIndexUri(String uri) {
        this.solrIndexUri = uri;
    }

    public String getSolrIndexUri() {
        return this.solrIndexUri;
    }

    public HttpClient getHttpClient() {
        return this.httpRequestFactory.getHttpClient();
    }
}

