/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.impl.AbstractBagVisitor;
import gov.loc.repository.bagit.transformer.HolePuncher;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.utilities.UrlHelper;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HolePuncherImpl
extends AbstractBagVisitor
implements HolePuncher {
    private static final Log log = LogFactory.getLog(HolePuncherImpl.class);
    private String baseUrl;
    private Bag originalBag;
    private Bag newBag;
    private FetchTxt fetch;
    private boolean includePayloadDirectory = false;
    private boolean includeTags = false;
    private BagFactory bagFactory;
    private boolean resume = false;
    private boolean leaveTags = true;
    private SimpleResult bagVerifyResult;

    public HolePuncherImpl(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
    }

    @Override
    public Bag makeHoley(Bag bag, String baseUrl, boolean includePayloadDirectoryInUrl, boolean includeTags, boolean resume) {
        return this.makeHoley(bag, baseUrl, includePayloadDirectoryInUrl, includeTags, true, resume);
    }

    @Override
    public Bag makeHoley(Bag bag, String baseUrl, boolean includePayloadDirectoryInUrl, boolean includeTags, boolean leaveTags, boolean resume) {
        log.info((Object)"Making bag holey");
        this.originalBag = bag;
        this.resume = resume;
        this.baseUrl = baseUrl;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        this.includePayloadDirectory = includePayloadDirectoryInUrl;
        this.includeTags = includeTags;
        if (includeTags) {
            this.includePayloadDirectory = true;
        }
        this.leaveTags = leaveTags;
        bag.accept(this);
        return this.newBag;
    }

    @Override
    public void startBag(Bag bag) {
        this.newBag = this.bagFactory.createBag(bag.getBagConstants().getVersion());
        this.fetch = this.newBag.getBagPartFactory().createFetchTxt();
        this.newBag.putBagFile(this.fetch);
        this.originalBag.putBagFile(this.fetch);
        this.bagVerifyResult = this.originalBag.verifyValid(FailModeSupporting.FailMode.FAIL_SLOW);
    }

    @Override
    public void visitPayload(BagFile bagFile) {
        if (this.resume && !SimpleResultHelper.isMissingOrInvalid(this.bagVerifyResult, bagFile.getFilepath())) {
            return;
        }
        String url = this.baseUrl;
        url = this.includePayloadDirectory ? url + UrlHelper.encodeFilepath(bagFile.getFilepath()) : url + UrlHelper.encodeFilepath(bagFile.getFilepath().substring(this.newBag.getBagConstants().getDataDirectory().length() + 1));
        this.fetch.add(new FetchTxt.FilenameSizeUrl(bagFile.getFilepath(), bagFile.exists() ? Long.valueOf(bagFile.getSize()) : null, url));
    }

    @Override
    public void visitTag(BagFile bagFile) {
        if (this.resume && !SimpleResultHelper.isMissingOrInvalid(this.bagVerifyResult, bagFile.getFilepath())) {
            return;
        }
        if (this.includeTags) {
            String url = this.baseUrl + UrlHelper.encodeFilepath(bagFile.getFilepath());
            this.fetch.add(new FetchTxt.FilenameSizeUrl(bagFile.getFilepath(), bagFile.exists() ? Long.valueOf(bagFile.getSize()) : null, url));
        }
        if (!this.includeTags || this.leaveTags) {
            this.newBag.putBagFile(bagFile);
        }
    }
}

