/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;

public class Condition
implements ConditionInterface {
    private Entity entity = null;
    private Attribute attribute = null;
    private String operator = null;
    private Object value = null;

    public Condition(Entity entity, Attribute attribute, String operator, Object value) {
        this.entity = entity;
        this.attribute = attribute;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public String toSQLString() throws UnWellFormedQueryException {
        String attributeName;
        String condition = null;
        StringBuffer conditionBuffer = new StringBuffer();
        if (this.entity != null) {
            String entityName = null;
            try {
                entityName = DataManager.getDBTableName(this.entity);
            }
            catch (SQLException sqle) {
                System.err.println("entity name is null " + sqle.getMessage());
            }
            if (entityName != null && !entityName.trim().equals("")) {
                conditionBuffer.append(entityName);
                conditionBuffer.append(".");
            }
        }
        if (this.attribute != null) {
            attributeName = null;
            try {
                attributeName = DataManager.getDBFieldName(this.entity, this.attribute);
            }
            catch (SQLException sqle) {
                System.err.println("attribute name is null " + sqle.getMessage());
            }
            if (attributeName == null || attributeName.trim().equals("")) {
                throw new UnWellFormedQueryException("Attribute couldn't be null in condition");
            }
        } else {
            throw new UnWellFormedQueryException("Attribute couldn't be null in condition");
        }
        conditionBuffer.append(attributeName);
        conditionBuffer.append(this.handleOperatorAndValue());
        condition = conditionBuffer.toString();
        return condition;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String handleOperatorAndValue() throws UnWellFormedQueryException {
        StringBuffer sql = new StringBuffer();
        if (this.isInStringOperatorList(this.operator)) {
            if (this.value == null) throw new UnWellFormedQueryException("Value couldn't be null in condition");
            sql.append(" ");
            sql.append(this.operator);
            sql.append(" ");
            sql.append("'");
            sql.append(this.value);
            sql.append("'");
            return sql.toString();
        } else {
            if (!this.isInNumericOperatorList(this.operator)) throw new UnWellFormedQueryException("Sorry, we couldn't handle this operator: " + this.operator);
            if (this.value != null && this.value instanceof Number) {
                sql.append(" ");
                sql.append(this.operator);
                sql.append(" ");
                sql.append(this.value);
                return sql.toString();
            } else {
                if (this.value == null) throw new UnWellFormedQueryException("Value couldn't be null in condition");
                throw new UnWellFormedQueryException("" + this.value + " is NOT a number in condition, but it should be because it uses a numeric operator " + this.operator);
            }
        }
    }

    private boolean isInStringOperatorList(String operator) throws UnWellFormedQueryException {
        return this.isInOperatorList(operator, STRING_OPERATOR_LIST);
    }

    private boolean isInNumericOperatorList(String operator) throws UnWellFormedQueryException {
        return this.isInOperatorList(operator, NUMBER_OPERATOR_LIST);
    }

    private boolean isInOperatorList(String operator, String[] operatorList) throws UnWellFormedQueryException {
        boolean inList = false;
        if (operator == null) {
            throw new UnWellFormedQueryException("Operator couldn't be null in condition");
        }
        if (operatorList != null) {
            for (String operatorInList : operatorList) {
                if (operatorInList == null || !operatorInList.equalsIgnoreCase(operator)) continue;
                inList = true;
                break;
            }
        }
        return inList;
    }
}

