/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.concurrentmap.AddMapIndex;
import com.hazelcast.impl.concurrentmap.MapState;
import com.hazelcast.query.Index;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InitialState
extends AbstractRemotelyProcessable {
    List<MapState> lsMapStates = new ArrayList<MapState>();

    public void createAndAddMapState(CMap cmap) {
        MapState mapState = new MapState(cmap.getName());
        Index[] indexes = cmap.getMapIndexService().getIndexesInOrder();
        if (indexes != null) {
            for (Index index : indexes) {
                AddMapIndex mi = new AddMapIndex(cmap.getName(), index.getExpression(), index.isOrdered(), index.getAttributeIndex());
                mapState.addMapIndex(mi);
            }
        }
        this.lsMapStates.add(mapState);
    }

    public void process() {
        FactoryImpl factory = this.getNode().factory;
        if (factory.node.isActive()) {
            for (MapState mapState : this.lsMapStates) {
                CMap cmap = factory.node.concurrentMapManager.getOrCreateMap(mapState.name);
                for (AddMapIndex mapIndex : mapState.lsMapIndexes) {
                    cmap.addIndex(mapIndex.getExpression(), mapIndex.isOrdered(), mapIndex.getAttributeIndex());
                }
            }
        }
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.lsMapStates.size());
        for (MapState mapState : this.lsMapStates) {
            mapState.writeData(out);
        }
    }

    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MapState mapState = new MapState();
            mapState.readData(in);
            this.lsMapStates.add(mapState);
        }
    }
}

