/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSizeCallable
implements Callable<Integer>,
DataSerializable,
HazelcastInstanceAware {
    private int partitionVersion;
    private String mapName;
    private transient HazelcastInstance hazelcast;

    public MapSizeCallable(String mapName, int partitionVersion) {
        this.mapName = mapName;
        this.partitionVersion = partitionVersion;
    }

    public MapSizeCallable() {
    }

    @Override
    public Integer call() throws Exception {
        FactoryImpl factory = (FactoryImpl)this.hazelcast;
        CMap cmap = factory.node.concurrentMapManager.getMap(this.mapName);
        if (cmap == null) {
            return 0;
        }
        return cmap.size(this.partitionVersion);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeInt(this.partitionVersion);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.partitionVersion = in.readInt();
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }
}

