/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A distributed AtomicLong")
public class AtomicNumberMBean
extends AbstractMBean<AtomicNumber> {
    public AtomicNumberMBean(AtomicNumber managedObject, ManagementService managementService) {
        super(managedObject, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("AtomicLong", this.getName());
    }

    @JMXAttribute(value="ActualValue")
    @JMXDescription(value="get() result")
    public long getActualValue() {
        return this.get();
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Instance name of the atomic long")
    public String getName() {
        return ((AtomicNumber)this.getManagedObject()).getName();
    }

    @JMXOperation(value="get")
    @JMXDescription(value="return value")
    public long get() {
        return ((AtomicNumber)this.getManagedObject()).get();
    }

    @JMXOperation(value="set")
    @JMXDescription(value="set value")
    public void set(long newValue) {
        ((AtomicNumber)this.getManagedObject()).set(newValue);
    }

    @JMXOperation(value="add")
    @JMXDescription(value="add value and return")
    public void add(long delta) {
        ((AtomicNumber)this.getManagedObject()).addAndGet(delta);
    }

    @JMXOperation(value="getAndAdd")
    @JMXDescription(value="add value return original")
    public long getAdd(long delta) {
        return ((AtomicNumber)this.getManagedObject()).addAndGet(delta);
    }

    @JMXOperation(value="getAndSet")
    @JMXDescription(value="set value return original")
    public long getSet(long delta) {
        return ((AtomicNumber)this.getManagedObject()).addAndGet(delta);
    }

    @JMXOperation(value="increment")
    @JMXDescription(value="add 1 and return")
    public void incrementAndGet() {
        ((AtomicNumber)this.getManagedObject()).incrementAndGet();
    }

    @JMXOperation(value="decrement")
    @JMXDescription(value="subtract 1 and return")
    public void decrementAndGet() {
        ((AtomicNumber)this.getManagedObject()).decrementAndGet();
    }

    @JMXOperation(value="reset")
    @JMXDescription(value="reset value to 0")
    public void reset() {
        ((AtomicNumber)this.getManagedObject()).set(0L);
    }

    @JMXOperation(value="compareAndSet")
    @JMXDescription(value="if expected set value")
    public void compareAndSet(long expectedValue, long newValue) {
        ((AtomicNumber)this.getManagedObject()).compareAndSet(expectedValue, newValue);
    }
}

