/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter1;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.logging.Log;

public abstract class QueryIterRepeatApply
extends QueryIter1 {
    int count = 0;
    private QueryIterator currentStage = null;
    private volatile boolean cancelRequested = false;

    public QueryIterRepeatApply(QueryIterator input, ExecutionContext context) {
        super(input, context);
        if (input == null) {
            Log.fatal(this, "[QueryIterRepeatApply] Repeated application to null input iterator");
            return;
        }
    }

    protected QueryIterator getCurrentStage() {
        return this.currentStage;
    }

    protected abstract QueryIterator nextStage(Binding var1);

    @Override
    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        while (true) {
            if (this.currentStage == null) {
                this.currentStage = this.makeNextStage();
            }
            if (this.currentStage == null) {
                return false;
            }
            if (this.cancelRequested) {
                QueryIterRepeatApply.performRequestCancel(this.currentStage);
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage.close();
            this.currentStage = null;
        }
    }

    @Override
    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
        }
        return this.currentStage.nextBinding();
    }

    private QueryIterator makeNextStage() {
        ++this.count;
        if (this.getInput() == null) {
            return null;
        }
        if (!this.getInput().hasNext()) {
            this.getInput().close();
            return null;
        }
        Binding binding = (Binding)this.getInput().next();
        QueryIterator iter = this.nextStage(binding);
        return iter;
    }

    @Override
    protected void closeSubIterator() {
        if (this.currentStage != null) {
            this.currentStage.close();
        }
    }

    @Override
    protected void requestSubCancel() {
        if (this.currentStage != null) {
            this.currentStage.cancel();
        }
        this.cancelRequested = true;
    }
}

