/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library.leviathan;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionBase1;
import java.math.BigInteger;

public class sq
extends FunctionBase1 {
    @Override
    public NodeValue exec(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("sq", v)) {
            case OP_INTEGER: {
                BigInteger i = v.getInteger();
                return NodeValue.makeInteger(i.pow(2));
            }
            case OP_DECIMAL: {
                double dec = v.getDecimal().doubleValue();
                return NodeValue.makeDecimal(Math.pow(dec, 2.0));
            }
            case OP_FLOAT: 
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.pow(v.getDouble(), 2.0));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }
}

