/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import java.util.Map;

public class GraphPrefixesProjection
extends PrefixMappingImpl {
    private String graphName;
    private DatasetPrefixStorage prefixes;

    public GraphPrefixesProjection(String graphName, DatasetPrefixStorage prefixes) {
        this.graphName = graphName;
        this.prefixes = prefixes;
    }

    public String getNsURIPrefix(String uri) {
        String x = super.getNsURIPrefix(uri);
        if (x != null) {
            return x;
        }
        x = this.prefixes.readByURI(this.graphName, uri);
        if (x != null) {
            super.set(x, uri);
        }
        return x;
    }

    public Map<String, String> getNsPrefixMap() {
        Map<String, String> m = this.prefixes.readPrefixMap(this.graphName);
        for (Map.Entry<String, String> e2 : m.entrySet()) {
            super.set(e2.getKey(), e2.getValue());
        }
        return m;
    }

    protected void set(String prefix, String uri) {
        String x = this.get(prefix);
        if (x != null) {
            if (x.equals(uri)) {
                return;
            }
            this.prefixes.removeFromPrefixMap(this.graphName, prefix);
        }
        this.prefixes.insertPrefix(this.graphName, prefix, uri);
        super.set(prefix, uri);
    }

    protected String get(String prefix) {
        String x = super.get(prefix);
        if (x != null) {
            return x;
        }
        x = this.prefixes.readPrefix(this.graphName, prefix);
        if (x != null) {
            super.set(prefix, x);
        }
        return x;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String uri = super.getNsPrefixURI(prefix);
        if (uri != null) {
            this.prefixes.removeFromPrefixMap(this.graphName, prefix);
        }
        super.removeNsPrefix(prefix);
        return this;
    }
}

