/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.JSONMaker;
import org.apache.jena.atlas.json.io.JsonWriter;
import org.apache.jena.atlas.json.io.parser.JSONParser;

public class JSON {
    private static final boolean useJavaCC = false;

    public static JsonObject parse(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(input, maker);
        return (JsonObject)maker.jsonValue();
    }

    public static JsonObject parse(String string) {
        return JSON._parse(new StringReader(string));
    }

    public static JsonValue parseAny(InputStream input) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(input, maker);
        return maker.jsonValue();
    }

    public static JsonValue parseAny(String string) {
        return JSON._parseAny(new StringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject read(String filename) {
        JsonObject jsonObject;
        InputStream in = IO.openFileEx(filename);
        try {
            jsonObject = JSON.parse(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("File not found: " + filename, ex);
            }
            catch (IOException ex) {
                IO.exception("IOException: " + filename, ex);
                return null;
            }
        }
        in.close();
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonValue readAny(String filename) {
        JsonValue jsonValue;
        InputStream in = IO.openFileEx(filename);
        try {
            jsonValue = JSON.parseAny(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("File not found: " + filename, ex);
            }
            catch (IOException ex) {
                IO.exception("IOException: " + filename, ex);
                return null;
            }
        }
        in.close();
        return jsonValue;
    }

    private static JsonObject _parse(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(r, maker);
        return (JsonObject)maker.jsonValue();
    }

    private static JsonValue _parseAny(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(r, maker);
        return maker.jsonValue();
    }

    private static void _parse(Reader r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(Reader r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    private static void _parse(InputStream r, JSONMaker maker) {
        JSONParser.parse(r, (JSONHandler)maker);
    }

    private static void _parseAny(InputStream r, JSONMaker maker) {
        JSONParser.parseAny(r, (JSONHandler)maker);
    }

    public static void write(OutputStream output, JsonValue jValue) {
        IndentedWriter iOut = new IndentedWriter(output);
        JSON.write(iOut, jValue);
        iOut.flush();
    }

    public static void write(IndentedWriter output, JsonValue jValue) {
        JsonWriter w = new JsonWriter(output);
        w.startOutput();
        jValue.visit(w);
        w.finishOutput();
    }

    public static void write(JsonValue jValue) {
        JSON.write(IndentedWriter.stdout, jValue);
    }
}

