/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.user;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunction;
import com.hp.hpl.jena.sparql.function.user.UserDefinedFunctionDefinition;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import java.util.List;
import java.util.Map;

public class ExprTransformExpand
extends ExprTransformCopy {
    private Map<String, UserDefinedFunctionDefinition> definitions;

    public ExprTransformExpand(Map<String, UserDefinedFunctionDefinition> defs) {
        if (defs == null) {
            throw new IllegalArgumentException("defs cannot be null");
        }
        this.definitions = defs;
    }

    @Override
    public Expr transform(ExprFunctionN func, ExprList args) {
        ExprFunction f = func.getFunction();
        if (this.shouldExpand(f)) {
            UserDefinedFunctionDefinition def = this.definitions.get(f.getFunction().getFunctionIRI());
            UserDefinedFunction uFunc = (UserDefinedFunction)def.newFunctionInstance();
            List<Var> defArgs = def.getArgList();
            ExprList subArgs = new ExprList();
            for (int i = 0; i < args.size(); ++i) {
                Expr arg = args.get(i);
                String var = arg.getVarName();
                if (var == null) {
                    subArgs.add(arg);
                    continue;
                }
                if (i > defArgs.size()) {
                    throw new ExprBuildException("Unable to expand function dependency, the function <" + def.getUri() + "> is called but uses an argument ?" + var + " which is not an argument to the outer function");
                }
                subArgs.add(arg);
            }
            uFunc.build(def.getUri(), subArgs);
            return uFunc.getActualExpr();
        }
        return super.transform(func, args);
    }

    private boolean shouldExpand(ExprFunction func) {
        return this.definitions.containsKey(func.getFunctionIRI());
    }
}

