/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.page.Page;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;

public abstract class BPTreePage
implements Page {
    protected final BPlusTree bpTree;
    protected final BPlusTreeParams params;

    protected BPTreePage(BPlusTree bpTree) {
        if (bpTree == null) {
            System.err.println("NULL B+Tree");
        }
        this.bpTree = bpTree;
        this.params = bpTree.getParams();
    }

    public final BPlusTree getBPlusTree() {
        return this.bpTree;
    }

    public final BPlusTreeParams getParams() {
        return this.params;
    }

    abstract BPTreePage split();

    abstract Record shiftRight(BPTreePage var1, Record var2);

    abstract Record shiftLeft(BPTreePage var1, Record var2);

    abstract BPTreePage merge(BPTreePage var1, Record var2);

    abstract boolean isFull();

    abstract boolean isMinSize();

    abstract int getCount();

    abstract void setCount(int var1);

    abstract int getMaxSize();

    abstract boolean hasAnyKeys();

    abstract Record internalSearch(Record var1);

    abstract Record internalInsert(Record var1);

    abstract Record internalDelete(Record var1);

    abstract Record getLowRecord();

    abstract Record getHighRecord();

    abstract Record minRecord();

    abstract Record maxRecord();

    abstract void write();

    abstract void promote();

    abstract void release();

    abstract void free();

    abstract void checkNode();

    abstract void checkNodeDeep();

    abstract Record getSplitKey();
}

