/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableCache;
import com.hp.hpl.jena.tdb.nodetable.NodeTableInline;
import com.hp.hpl.jena.tdb.nodetable.NodeTableNative;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import com.hp.hpl.jena.tdb.transaction.TransactionLifecycle;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTableTrans
implements NodeTable,
TransactionLifecycle {
    private static Logger log = LoggerFactory.getLogger(NodeTableTrans.class);
    private final NodeTable base;
    private long allocOffset;
    private NodeTable nodeTableJournal = null;
    private static int CacheSize = 10000;
    private boolean passthrough = false;
    private Index nodeIndex;
    private ObjectFile journalObjFile;
    private long journalObjFileStartOffset;
    private final String label;
    private final Transaction txn;
    public static boolean APPEND_LOG = false;

    public NodeTableTrans(Transaction txn, String label, NodeTable sub, Index nodeIndex, ObjectFile objFile) {
        this.txn = txn;
        this.base = sub;
        this.nodeIndex = nodeIndex;
        this.journalObjFile = objFile;
        this.journalObjFile.truncate(0L);
        this.label = label;
    }

    public void setPassthrough(boolean v) {
        this.passthrough = v;
    }

    public NodeTable getBaseNodeTable() {
        return this.base;
    }

    public NodeTable getJournalTable() {
        return this.nodeTableJournal;
    }

    public Transaction getTransaction() {
        return this.txn;
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        if (this.passthrough) {
            return this.base.getAllocateNodeId(node);
        }
        NodeId nodeId = this.getNodeIdForNode(node);
        if (!NodeId.isDoesNotExist(nodeId)) {
            return nodeId;
        }
        nodeId = this.allocate(node);
        return nodeId;
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        if (this.passthrough) {
            return this.base.getNodeIdForNode(node);
        }
        NodeId nodeId = this.nodeTableJournal.getNodeIdForNode(node);
        if (!NodeId.isDoesNotExist(nodeId)) {
            return this.mapFromJournal(nodeId);
        }
        nodeId = this.base.getNodeIdForNode(node);
        return nodeId;
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        if (NodeId.isAny(id)) {
            return Node.ANY;
        }
        if (this.passthrough) {
            return this.base.getNodeForNodeId(id);
        }
        long x = id.getId();
        if (x < this.allocOffset) {
            return this.base.getNodeForNodeId(id);
        }
        id = this.mapToJournal(id);
        Node node = this.nodeTableJournal.getNodeForNodeId(id);
        return node;
    }

    private NodeId mapToJournal(NodeId id) {
        if (this.passthrough) {
            throw new TDBTransactionException("Not in an active transaction");
        }
        if (NodeId.isInline(id)) {
            return id;
        }
        return NodeId.create(id.getId() - this.allocOffset);
    }

    private NodeId mapFromJournal(NodeId id) {
        if (this.passthrough) {
            throw new TDBTransactionException("Not in an active transaction");
        }
        if (NodeId.isInline(id)) {
            return id;
        }
        return NodeId.create(id.getId() + this.allocOffset);
    }

    private NodeId allocate(Node node) {
        NodeId nodeId = this.nodeTableJournal.getAllocateNodeId(node);
        nodeId = this.mapFromJournal(nodeId);
        return nodeId;
    }

    @Override
    public NodeId allocOffset() {
        if (this.passthrough) {
            return this.base.allocOffset();
        }
        NodeId x1 = this.nodeTableJournal.allocOffset();
        NodeId x2 = this.mapFromJournal(x1);
        return x2;
    }

    @Override
    public void begin(Transaction txn) {
        if (this.txn.getTxnId() != txn.getTxnId()) {
            throw new TDBException(String.format("Different transactions: %s %s", this.txn.getLabel(), txn.getLabel()));
        }
        if (this.passthrough) {
            throw new TDBException("Already active");
        }
        this.passthrough = false;
        this.allocOffset = this.base.allocOffset().getId();
        this.journalObjFileStartOffset = this.journalObjFile.length();
        if (this.journalObjFileStartOffset != 0L) {
            FmtLog.warn((Logger)log, (String)"%s journalStartOffset not zero: %d/0x%02X", (Object[])new Object[]{txn.getLabel(), this.journalObjFileStartOffset, this.journalObjFileStartOffset});
        }
        this.allocOffset += this.journalObjFileStartOffset;
        this.nodeTableJournal = new NodeTableNative(this.nodeIndex, this.journalObjFile);
        this.nodeTableJournal = NodeTableCache.create(this.nodeTableJournal, CacheSize, CacheSize, 100);
        this.nodeTableJournal = NodeTableInline.create(this.nodeTableJournal);
    }

    void append() {
        Iterator<Pair<NodeId, Node>> iter = this.nodeTableJournal.all();
        Pair<NodeId, Node> firstPair = null;
        Pair<NodeId, Node> lastPair = null;
        while (iter.hasNext()) {
            Pair<NodeId, Node> x = iter.next();
            if (firstPair == null) {
                firstPair = x;
            }
            lastPair = x;
            NodeId nodeId = (NodeId)x.getLeft();
            Node node = (Node)x.getRight();
            this.debug("  append: %s -> %s", x, this.mapFromJournal(nodeId));
            NodeId nodeId2 = this.base.getAllocateNodeId(node);
            if (nodeId2.equals(this.mapFromJournal(nodeId))) continue;
            this.inconsistent(node, nodeId, nodeId2);
        }
    }

    private void inconsistent(Node node, NodeId nodeId, NodeId nodeId2) {
        String msg = String.format("Different ids for %s: allocated: expected %s, got %s", node, this.mapFromJournal(nodeId), nodeId2);
        System.err.println();
        System.err.println();
        System.err.println(msg);
        this.dump();
        System.err.println();
        throw new TDBException(msg);
    }

    private void dump() {
        System.err.println(">>>>>>>>>>");
        System.err.println("label = " + this.label);
        System.err.println("txn = " + this.txn);
        System.err.println("offset = " + this.allocOffset);
        System.err.println("journalStartOffset = " + this.journalObjFileStartOffset);
        System.err.println("journal = " + this.journalObjFile.getLabel());
    }

    @Override
    public void commitPrepare(Transaction txn) {
        this.debug("commitPrepare", new Object[0]);
        if (this.nodeTableJournal == null) {
            throw new TDBTransactionException(txn.getLabel() + ": Not in a transaction for a commit to happen");
        }
        this.writeNodeJournal();
        if (this.journalObjFile != null && this.journalObjFile.length() != 0L) {
            long x = this.journalObjFile.length();
            throw new TDBTransactionException(txn.getLabel() + ": journalObjFile not cleared (" + x + ")");
        }
    }

    @Override
    public void commitEnact(Transaction txn) {
        this.debug("commitEnact", new Object[0]);
    }

    private void writeNodeJournal() {
        long expected = this.base.allocOffset().getId();
        long len = this.journalObjFile.length();
        if (expected != this.allocOffset) {
            Log.warn((Object)log, (String)("Inconsistency: base.allocOffset() = " + expected + " : allocOffset = " + this.allocOffset));
        }
        long newbase = -1L;
        this.append();
        this.nodeIndex.clear();
        this.journalObjFile.truncate(this.journalObjFileStartOffset);
        this.journalObjFile.close();
        this.journalObjFile = null;
        this.base.sync();
        this.allocOffset = -99L;
        this.passthrough = true;
    }

    @Override
    public void commitClearup(Transaction txn) {
        this.debug("commitClearup", new Object[0]);
        this.finish();
    }

    @Override
    public void abort(Transaction txn) {
        this.debug("abort", new Object[0]);
        if (this.nodeTableJournal == null) {
            throw new TDBTransactionException(txn.getLabel() + ": Not in a transaction for a commit to happen");
        }
        this.nodeTableJournal = null;
        if (this.journalObjFile != null) {
            this.journalObjFile.truncate(this.journalObjFileStartOffset);
            this.journalObjFile.sync();
        }
        this.finish();
    }

    private void finish() {
        this.close();
        this.passthrough = true;
        this.nodeTableJournal = null;
        this.journalObjFile = null;
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return Iter.concat(this.base.all(), this.nodeTableJournal.all());
    }

    @Override
    public boolean isEmpty() {
        return this.nodeTableJournal.isEmpty() && this.base.isEmpty();
    }

    public void sync() {
        if (this.passthrough) {
            this.base.sync();
        }
    }

    public void close() {
        if (this.nodeIndex != null) {
            this.nodeIndex.close();
        }
        this.nodeIndex = null;
        if (this.journalObjFile != null) {
            this.journalObjFile.close();
        }
        this.journalObjFile = null;
    }

    public String toString() {
        return "NodeTableTrans:" + this.label + "(#" + Integer.toHexString(super.hashCode()) + ")";
    }

    private void debug(String fmt, Object ... args) {
        if (log.isDebugEnabled()) {
            String x = String.format(fmt, args);
            log.debug(this.label + ": " + x);
        }
    }
}

