/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HarvestListEditor
extends JFrame
implements ActionListener {
    String clipboardDocumentType = "";
    String clipboardDocumentURL = "";
    String clipboardIdentifier = "";
    String clipboardRevision = "";
    String clipboardScope = "";
    JButton copyButton;
    JButton cutButton;
    String defaultDocumentType = "eml://ecoinformatics.org/eml-2.0.1";
    String defaultDocumentURL = "http://";
    String defaultHarvestList = "";
    String defaultIdentifier = "1";
    String defaultRevision = "1";
    String defaultScope = "dataset";
    Document doc;
    JScrollPane docPane;
    JFileChooser fileChooser = new JFileChooser();
    File harvestListFile;
    boolean harvestListHasChanged = false;
    JMenuBar menuBar;
    final int numColumns = 6;
    final int numRows = 1200;
    JButton pasteButton;
    JButton pasteDefaultsButton;
    Properties properties;
    private String schemaLocation = "eml://ecoinformatics.org/harvestList harvestList.xsd";
    int selectedRow = -1;
    final JTable table;
    TableModel tableModel;
    File tempFile;
    String title = "Harvest List Editor";
    JMenuItem exitMenuItem = new JMenuItem("Exit");
    JMenuItem newMenuItem = new JMenuItem("New");
    JMenuItem openMenuItem = new JMenuItem("Open...");
    JMenuItem saveMenuItem = new JMenuItem("Save");
    JMenuItem saveAsMenuItem = new JMenuItem("Save As...");
    JMenuItem validateMenuItem = new JMenuItem("Validate");

    public static void main(String[] stringArray) {
        HarvestListEditor harvestListEditor = new HarvestListEditor();
    }

    public HarvestListEditor() {
        super("Harvest List Editor");
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"New", "Open...", "Save", "Save As...", "Exit"};
        JMenu jMenu = new JMenu("File");
        char[] cArray = new char[]{'N', 'O', 'S', 'A', 'X'};
        this.loadProperties();
        this.setSize(1000, 400);
        this.setDefaultCloseOperation(3);
        this.menuBar = new JMenuBar();
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.newMenuItem.addActionListener(this);
        jMenu.add(this.newMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.openMenuItem.addActionListener(this);
        jMenu.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.saveMenuItem.addActionListener(this);
        this.saveMenuItem.setEnabled(false);
        jMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.saveAsMenuItem.addActionListener(this);
        jMenu.add(this.saveAsMenuItem);
        this.validateMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        this.validateMenuItem.addActionListener(this);
        jMenu.add(this.validateMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this.exitMenuItem.addActionListener(this);
        jMenu.add(this.exitMenuItem);
        this.menuBar.add(jMenu);
        this.setJMenuBar(this.menuBar);
        this.table = new JTable(new HarvestListTableModel());
        this.table.setPreferredScrollableViewportSize(new Dimension(900, 300));
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(50);
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(50);
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(320);
        this.table.setSelectionMode(0);
        this.tableModel = this.table.getModel();
        this.initHarvestList();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    HarvestListEditor.this.selectedRow = -1;
                    HarvestListEditor.this.cutButton.setEnabled(false);
                    HarvestListEditor.this.copyButton.setEnabled(false);
                    HarvestListEditor.this.pasteButton.setEnabled(false);
                    HarvestListEditor.this.pasteDefaultsButton.setEnabled(false);
                } else {
                    HarvestListEditor.this.selectedRow = listSelectionModel.getMinSelectionIndex();
                    HarvestListEditor.this.manageButtons(HarvestListEditor.this.selectedRow);
                }
            }
        });
        this.docPane = new JScrollPane(this.table);
        this.getContentPane().add((Component)this.docPane, "Center");
        this.cutButton = new JButton("Cut");
        this.copyButton = new JButton("Copy");
        this.pasteButton = new JButton("Paste");
        this.pasteDefaultsButton = new JButton("Paste Defaults");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HarvestListEditor.this.copyRow(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.manageButtons(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.harvestListHasChanged = true;
            }
        });
        this.cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HarvestListEditor.this.cutRow(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.manageButtons(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.harvestListHasChanged = true;
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HarvestListEditor.this.pasteRow(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.manageButtons(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.harvestListHasChanged = true;
            }
        });
        this.pasteDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HarvestListEditor.this.pasteDefaultValues(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.manageButtons(HarvestListEditor.this.selectedRow);
                HarvestListEditor.this.harvestListHasChanged = true;
            }
        });
        this.cutButton.setEnabled(false);
        this.copyButton.setEnabled(false);
        this.pasteButton.setEnabled(false);
        this.pasteDefaultsButton.setEnabled(false);
        jPanel.add(this.cutButton);
        jPanel.add(this.copyButton);
        jPanel.add(this.pasteButton);
        jPanel.add(this.pasteDefaultsButton);
        jPanel.setOpaque(true);
        this.getContentPane().add((Component)jPanel, "South");
        if (this.defaultHarvestList != null && !this.defaultHarvestList.equals("")) {
            this.harvestListFile = new File(this.defaultHarvestList);
            if (this.harvestListFile.exists()) {
                try {
                    this.loadHarvestList(this.harvestListFile);
                    this.saveMenuItem.setEnabled(true);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    System.out.println("Error parsing Harvest List: " + parserConfigurationException.getMessage());
                }
            } else {
                System.out.println("Warning: the default harvest list file that was specified in the .harvestListEditor configuration file does not exist:\n" + this.harvestListFile);
                this.fileNew();
            }
        } else {
            this.fileNew();
        }
        try {
            this.tempFile = File.createTempFile("harvestListTemp", ".xml");
        }
        catch (IOException iOException) {
            System.out.println("Error creating temporary file: " + iOException.getMessage());
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("New")) {
            this.fileNew();
        } else if (actionEvent.getActionCommand().equals("Open...")) {
            this.fileOpen();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            this.fileSave();
        } else if (actionEvent.getActionCommand().equals("Save As...")) {
            this.fileSaveAs();
        } else if (actionEvent.getActionCommand().equals("Validate")) {
            this.fileValidate();
        } else if (actionEvent.getActionCommand().equals("Exit")) {
            this.fileExit();
        }
    }

    void addRow(int n, String string, String string2, String string3, String string4, String string5) {
        this.tableModel.setValueAt(string, n, 1);
        this.tableModel.setValueAt(string2, n, 2);
        this.tableModel.setValueAt(string3, n, 3);
        this.tableModel.setValueAt(string4, n, 4);
        this.tableModel.setValueAt(string5, n, 5);
    }

    String composeLine(int n, String string, String string2) {
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            string3 = string3 + " ";
        }
        string3 = string3 + "<" + string + ">";
        string3 = string3 + string2;
        string3 = string3 + "</" + string + ">";
        return string3;
    }

    void clearHarvestList() {
        for (int i = 0; i < 1200; ++i) {
            this.clearRow(i);
        }
    }

    void clearRow(int n) {
        this.tableModel.setValueAt("", n, 1);
        this.tableModel.setValueAt("", n, 2);
        this.tableModel.setValueAt("", n, 3);
        this.tableModel.setValueAt("", n, 4);
        this.tableModel.setValueAt("", n, 5);
    }

    void copyRow(int n) {
        this.clipboardScope = (String)this.tableModel.getValueAt(n, 1);
        this.clipboardIdentifier = (String)this.tableModel.getValueAt(n, 2);
        this.clipboardRevision = (String)this.tableModel.getValueAt(n, 3);
        this.clipboardDocumentType = (String)this.tableModel.getValueAt(n, 4);
        this.clipboardDocumentURL = (String)this.tableModel.getValueAt(n, 5);
    }

    void cutRow(int n) {
        this.copyRow(n);
        this.clearRow(n);
    }

    void fileExit() {
        if (this.harvestListHasChanged) {
            int n = this.saveChangesDialog();
            if (n == 0) {
                try {
                    this.fileSave();
                    System.exit(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n == 1) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    void fileNew() {
        if (this.harvestListHasChanged) {
            int n = this.saveChangesDialog();
            if (n == 0) {
                try {
                    this.fileSave();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n == 2) {
                return;
            }
        }
        this.clearHarvestList();
        this.harvestListFile = null;
        this.setTitle(this.title + ": (Untitled)");
        this.saveMenuItem.setEnabled(false);
        this.harvestListHasChanged = false;
    }

    void fileOpen() {
        int n;
        if (this.harvestListHasChanged) {
            n = this.saveChangesDialog();
            if (n == 0) {
                try {
                    this.fileSave();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n == 2) {
                return;
            }
        }
        if ((n = this.fileChooser.showOpenDialog(this)) == 0) {
            this.harvestListFile = this.fileChooser.getSelectedFile();
            try {
                this.clearHarvestList();
                this.loadHarvestList(this.harvestListFile);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.out.println("Error parsing Harvest List: " + parserConfigurationException.getMessage());
            }
            this.harvestListHasChanged = false;
            this.saveMenuItem.setEnabled(true);
        }
    }

    void fileSave() {
        if (this.harvestListFile != null) {
            this.writeFile(this.harvestListFile);
            this.harvestListHasChanged = false;
        } else {
            System.out.println("No action taken");
        }
    }

    void fileSaveAs() {
        int n = this.fileChooser.showOpenDialog(this);
        if (n == 0) {
            this.harvestListFile = this.fileChooser.getSelectedFile();
            this.writeFile(this.harvestListFile);
            this.setTitle(this.title + ": " + this.harvestListFile.getName());
            this.saveMenuItem.setEnabled(true);
            this.harvestListHasChanged = false;
        }
    }

    void fileValidate() {
        HarvestListHandler harvestListHandler = new HarvestListHandler();
        boolean bl = false;
        boolean bl2 = true;
        this.writeFile(this.tempFile);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.tempFile);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            harvestListHandler.runParser(this, inputStreamReader, this.schemaLocation, bl, bl2);
            fileInputStream.close();
            this.tempFile.delete();
            this.harvestListMessage("Harvest List is valid");
        }
        catch (SAXException sAXException) {
            this.harvestListMessage("Validation error: " + sAXException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Error opening file: " + iOException.getMessage());
        }
    }

    void harvestListMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    void initHarvestList() {
        for (int i = 0; i < 1200; ++i) {
            this.tableModel.setValueAt(new Integer(i + 1).toString(), i, 0);
        }
    }

    boolean isEmptyClipboard() {
        boolean bl = true;
        bl = bl && this.clipboardScope.equals("");
        bl = bl && this.clipboardIdentifier.equals("");
        bl = bl && this.clipboardRevision.equals("");
        bl = bl && this.clipboardDocumentType.equals("");
        bl = bl && this.clipboardDocumentURL.equals("");
        return bl;
    }

    boolean isEmptyRow(int n) {
        boolean bl = true;
        String string = (String)this.tableModel.getValueAt(n, 1);
        String string2 = (String)this.tableModel.getValueAt(n, 2);
        String string3 = (String)this.tableModel.getValueAt(n, 3);
        String string4 = (String)this.tableModel.getValueAt(n, 4);
        String string5 = (String)this.tableModel.getValueAt(n, 5);
        bl = bl && (string == null || string.equals(""));
        bl = bl && (string2 == null || string2.equals(""));
        bl = bl && (string3 == null || string3.equals(""));
        bl = bl && (string4 == null || string4.equals(""));
        bl = bl && (string5 == null || string5.equals(""));
        return bl;
    }

    void loadHarvestList(File file) throws ParserConfigurationException {
        HarvestListHandler harvestListHandler = new HarvestListHandler();
        boolean bl = true;
        boolean bl2 = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            harvestListHandler.runParser(this, inputStreamReader, this.schemaLocation, bl, bl2);
            fileInputStream.close();
            this.setTitle(this.title + ": " + this.harvestListFile.getName());
        }
        catch (SAXException sAXException) {
            System.out.println("Error parsing Harvest List: " + sAXException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Error opening file: " + iOException.getMessage());
        }
    }

    void loadProperties() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".harvestListEditor");
        this.properties = new Properties();
        if (file.exists()) {
            try {
                this.properties.load(new FileInputStream(file));
                this.defaultHarvestList = this.properties.getProperty("defaultHarvestList");
                this.defaultDocumentType = this.properties.getProperty("defaultDocumentType");
                this.defaultDocumentURL = this.properties.getProperty("defaultDocumentURL");
                this.defaultIdentifier = this.properties.getProperty("defaultIdentifier");
                this.defaultRevision = this.properties.getProperty("defaultRevision");
                this.defaultScope = this.properties.getProperty("defaultScope");
            }
            catch (IOException iOException) {
                System.out.println("Error loading properties file: " + iOException.getMessage());
            }
        }
    }

    void manageButtons(int n) {
        if (this.isEmptyRow(n)) {
            this.cutButton.setEnabled(false);
            this.copyButton.setEnabled(false);
        } else {
            this.cutButton.setEnabled(true);
            this.copyButton.setEnabled(true);
        }
        if (this.isEmptyClipboard()) {
            this.pasteButton.setEnabled(false);
        } else {
            this.pasteButton.setEnabled(true);
        }
        this.pasteDefaultsButton.setEnabled(true);
    }

    void pasteRow(int n) {
        this.tableModel.setValueAt(this.clipboardScope, n, 1);
        this.tableModel.setValueAt(this.clipboardIdentifier, n, 2);
        this.tableModel.setValueAt(this.clipboardRevision, n, 3);
        this.tableModel.setValueAt(this.clipboardDocumentType, n, 4);
        this.tableModel.setValueAt(this.clipboardDocumentURL, n, 5);
    }

    void pasteDefaultValues(int n) {
        this.tableModel.setValueAt(this.defaultScope, n, 1);
        this.tableModel.setValueAt(this.defaultIdentifier, n, 2);
        this.tableModel.setValueAt(this.defaultRevision, n, 3);
        this.tableModel.setValueAt(this.defaultDocumentType, n, 4);
        this.tableModel.setValueAt(this.defaultDocumentURL, n, 5);
    }

    int saveChangesDialog() {
        Object[] objectArray = new Object[]{"Yes", "No", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "Save Changes?", "Warning", -1, 2, null, objectArray, objectArray[0]);
        return n;
    }

    void writeFile(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            this.writeHarvestList(printWriter);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    void writeHarvestList(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        printWriter.println("");
        printWriter.println("<hrv:harvestList xmlns:hrv=\"eml://ecoinformatics.org/harvestList\" >");
        for (int i = 0; i < 1200; ++i) {
            if (this.isEmptyRow(i)) continue;
            this.writeRow(printWriter, i);
        }
        printWriter.println("");
        printWriter.println("</hrv:harvestList>");
        printWriter.close();
    }

    void writeRow(PrintWriter printWriter, int n) {
        int n2 = 6;
        String string = (String)this.tableModel.getValueAt(n, 1);
        String string2 = (String)this.tableModel.getValueAt(n, 2);
        String string3 = (String)this.tableModel.getValueAt(n, 3);
        String string4 = (String)this.tableModel.getValueAt(n, 4);
        String string5 = (String)this.tableModel.getValueAt(n, 5);
        printWriter.println("");
        printWriter.println("  <document>");
        printWriter.println("    <docid>");
        printWriter.println(this.composeLine(n2, "scope", string));
        printWriter.println(this.composeLine(n2, "identifier", string2));
        printWriter.println(this.composeLine(n2, "revision", string3));
        printWriter.println("    </docid>");
        n2 = 4;
        printWriter.println(this.composeLine(n2, "documentType", string4));
        printWriter.println(this.composeLine(n2, "documentURL", string5));
        printWriter.println("  </document>");
    }

    class HarvestListHandler
    extends DefaultHandler
    implements ErrorHandler {
        public String scope;
        public int identifier;
        public String identifierString;
        public String documentType;
        private HarvestListEditor harvestListEditor;
        boolean loadHarvestList;
        public int revision;
        public String revisionString;
        private int rowIndex = 0;
        public String documentURL;
        private String currentQname;
        public static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
        private boolean schemaValidate = true;
        private boolean validateHarvestList;

        HarvestListHandler() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            if (n2 > 0) {
                if (this.currentQname.equals("scope")) {
                    this.scope = this.scope + string;
                } else if (this.currentQname.equals("identifier")) {
                    this.identifierString = this.identifierString + string;
                } else if (this.currentQname.equals("revision")) {
                    this.revisionString = this.revisionString + string;
                } else if (this.currentQname.equals("documentType")) {
                    this.documentType = this.documentType + string;
                } else if (this.currentQname.equals("documentURL")) {
                    this.documentURL = this.documentURL + string;
                }
            }
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("identifier")) {
                this.identifier = Integer.parseInt(this.identifierString);
            } else if (string3.equals("revision")) {
                this.revision = Integer.parseInt(this.revisionString);
            } else if (string3.equals("document")) {
                if (this.loadHarvestList) {
                    this.harvestListEditor.addRow(this.rowIndex, this.scope, this.identifierString, this.revisionString, this.documentType, this.documentURL);
                }
                ++this.rowIndex;
            }
            this.currentQname = "";
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println("SAXParseException: " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        public void runParser(HarvestListEditor harvestListEditor, Reader reader, String string, boolean bl, boolean bl2) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
            this.harvestListEditor = harvestListEditor;
            this.loadHarvestList = bl;
            this.validateHarvestList = bl2;
            this.rowIndex = 0;
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", string);
            if (this.schemaValidate) {
                xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            xMLReader.parse(new InputSource(reader));
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.currentQname = string3;
            if (string3.equals("scope")) {
                this.scope = "";
            } else if (string3.equals("identifier")) {
                this.identifierString = "";
            } else if (string3.equals("revision")) {
                this.revisionString = "";
            } else if (string3.equals("documentType")) {
                this.documentType = "";
            } else if (string3.equals("documentURL")) {
                this.documentURL = "";
            }
        }
    }

    class HarvestListTableModel
    extends AbstractTableModel {
        final boolean DEBUG = false;
        private String[] columnNames = new String[]{"Row #", "Scope", "Identifier", "Revision", "Document Type", "Document URL"};
        private Object[][] data = new Object[1200][6];

        HarvestListTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

