/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import com.oreilly.servlet.MailMessage;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.harvesterClient.HarvestDocument;
import edu.ucsb.nceas.metacat.harvesterClient.Harvester;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HarvestSiteSchedule {
    private String contactEmail;
    private String dateLastHarvest;
    private String dateNextHarvest;
    private long delta;
    private String documentListURL;
    private Harvester harvester;
    private ArrayList harvestDocumentList = new ArrayList();
    private String harvestSiteEndTime;
    private String harvestSiteStartTime;
    private String ldapDN;
    private String ldapPwd;
    private final long millisecondsPerDay = 86400000L;
    private String schemaLocation = "eml://ecoinformatics.org/harvestList ../../lib/harvester/harvestList.xsd";
    int siteScheduleID;
    private String unit;
    private int updateFrequency;

    public HarvestSiteSchedule(Harvester harvester, int n, String string, String string2, String string3, String string4, String string5, int n2, String string6, String string7) {
        this.harvester = harvester;
        this.siteScheduleID = n;
        this.documentListURL = string;
        this.ldapDN = string2;
        this.ldapPwd = string3;
        this.dateNextHarvest = string4;
        this.dateLastHarvest = string5;
        this.updateFrequency = n2;
        this.unit = string6;
        this.contactEmail = string7;
        this.delta = (long)n2 * 86400000L;
        if (string6.equals("weeks")) {
            this.delta *= 7L;
        } else if (string6.equals("months")) {
            this.delta *= 30L;
        }
    }

    private void dbUpdateHarvestDates() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        Connection connection = this.harvester.getConnection();
        date = new Date();
        long l = date.getTime();
        long l2 = l + this.delta;
        Date date2 = new Date(l2);
        String string = "'" + simpleDateFormat.format(date2) + "'";
        String string2 = "'" + simpleDateFormat.format(date) + "'";
        try {
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET DATENEXTHARVEST = " + string + " WHERE SITE_SCHEDULE_ID = " + this.siteScheduleID);
            statement.executeUpdate("UPDATE HARVEST_SITE_SCHEDULE SET DATELASTHARVEST = " + string2 + " WHERE SITE_SCHEDULE_ID = " + this.siteScheduleID);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("SQLException: " + sQLException.getMessage());
        }
    }

    public boolean dueForHarvest() {
        boolean bl = false;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        long l = date.getTime();
        long l2 = 0L;
        try {
            Date date2 = simpleDateFormat.parse(this.dateNextHarvest);
            l2 = date2.getTime();
            if (l2 < l) {
                bl = true;
                System.out.println("Due for harvest: " + this.documentListURL);
            } else {
                System.out.println("Not due for harvest: " + this.documentListURL);
            }
        }
        catch (ParseException parseException) {
            System.out.println("Error parsing date: " + parseException.getMessage());
        }
        return bl;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void harvestDocumentList() {
        if (this.dueForHarvest()) {
            try {
                boolean bl = this.parseHarvestList();
                if (bl) {
                    this.metacatLogin();
                    for (int i = 0; i < this.harvestDocumentList.size(); ++i) {
                        HarvestDocument harvestDocument = (HarvestDocument)this.harvestDocumentList.get(i);
                        if (harvestDocument == null) continue;
                        harvestDocument.harvestDocument();
                    }
                    this.metacatLogout();
                    this.dbUpdateHarvestDates();
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.out.println("ParserConfigurationException: " + parserConfigurationException.getMessage());
            }
            this.reportToSiteContact();
        }
    }

    public void metacatLogin() {
        Metacat metacat = this.harvester.metacat;
        if (this.harvester.connectToMetacat()) {
            try {
                System.out.println("Logging in to Metacat: " + this.ldapDN);
                String string = metacat.login(this.ldapDN, this.ldapPwd);
            }
            catch (MetacatInaccessibleException metacatInaccessibleException) {
                System.out.println("Metacat login failed." + metacatInaccessibleException.getMessage());
            }
            catch (Exception exception) {
                System.out.println("Metacat login failed." + exception.getMessage());
            }
        }
    }

    private void metacatLogout() {
        Metacat metacat = this.harvester.metacat;
        if (this.harvester.connectToMetacat()) {
            try {
                System.out.println("Logging out from Metacat");
                metacat.logout();
            }
            catch (MetacatInaccessibleException metacatInaccessibleException) {
                System.out.println("Metacat inaccessible: " + metacatInaccessibleException.getMessage());
            }
            catch (MetacatException metacatException) {
                System.out.println("Metacat exception: " + metacatException.getMessage());
            }
        }
    }

    public boolean parseHarvestList() throws ParserConfigurationException {
        DocumentListHandler documentListHandler = new DocumentListHandler();
        String string = this.getSchemaLocation();
        boolean bl = false;
        try {
            URL uRL = new URL(this.documentListURL);
            InputStream inputStream = uRL.openStream();
            this.harvester.addLogEntry(0, "Retrieved: " + this.documentListURL, "harvester.GetHarvestListSuccess", this.siteScheduleID, null, "");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            documentListHandler.runParser(inputStreamReader, string);
            this.harvester.addLogEntry(0, "Validated: " + this.documentListURL, "harvester.ValidateHarvestListSuccess", this.siteScheduleID, null, "");
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            this.harvester.addLogEntry(1, "MalformedURLException: " + malformedURLException.getMessage(), "harvester.GetHarvestListError", this.siteScheduleID, null, "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.harvester.addLogEntry(1, "FileNotFoundException: " + fileNotFoundException.getMessage(), "harvester.GetHarvestListError", this.siteScheduleID, null, "");
        }
        catch (SAXException sAXException) {
            this.harvester.addLogEntry(1, "SAXException: " + sAXException.getMessage(), "harvester.ValidateHarvestListError", this.siteScheduleID, null, "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.harvester.addLogEntry(1, "ClassNotFoundException: " + classNotFoundException.getMessage(), "harvester.ValidateHarvestListError", this.siteScheduleID, null, "");
        }
        catch (IOException iOException) {
            this.harvester.addLogEntry(1, "IOException: " + iOException.getMessage(), "harvester.GetHarvestListError", this.siteScheduleID, null, "");
        }
        return bl;
    }

    public void printOutput(PrintStream printStream) {
        printStream.println("* siteScheduleID:       " + this.siteScheduleID);
        printStream.println("* documentListURL:      " + this.documentListURL);
        printStream.println("* ldapDN:               " + this.ldapDN);
        printStream.println("* dateNextHarvest:      " + this.dateNextHarvest);
        printStream.println("* dateLastHarvest:      " + this.dateLastHarvest);
        printStream.println("* updateFrequency:      " + this.updateFrequency);
        printStream.println("* unit:                 " + this.unit);
        printStream.println("* contactEmail:         " + this.contactEmail);
    }

    void printSiteSummary(PrintStream printStream) {
        HarvestDocument harvestDocument;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < this.harvestDocumentList.size(); ++n) {
            harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
            if (harvestDocument == null) continue;
            if (harvestDocument.accessError) {
                ++n2;
            }
            if (harvestDocument.inserted) {
                ++n3;
            }
            if (harvestDocument.metacatHasIt) {
                ++n4;
            }
            if (harvestDocument.updated) {
                ++n5;
            }
            if (!harvestDocument.uploadError) continue;
            ++n6;
        }
        if (n3 > 0) {
            this.printSiteSummaryHeader(printStream);
            printStream.println("* The following document(s) were successfully inserted:");
            for (n = 0; n < this.harvestDocumentList.size(); ++n) {
                harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
                if (harvestDocument == null || !harvestDocument.inserted) continue;
                harvestDocument.prettyPrint(printStream);
            }
            this.printSiteSummaryTrailer(printStream);
        }
        if (n5 > 0) {
            this.printSiteSummaryHeader(printStream);
            printStream.println("* The following document(s) were successfully updated:");
            for (n = 0; n < this.harvestDocumentList.size(); ++n) {
                harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
                if (harvestDocument == null || !harvestDocument.updated) continue;
                harvestDocument.prettyPrint(printStream);
            }
            this.printSiteSummaryTrailer(printStream);
        }
        if (n2 > 0) {
            this.printSiteSummaryHeader(printStream);
            printStream.println("* The following document(s) could not be accessed");
            printStream.println("* at the site. Please check the URL to ensure that it is");
            printStream.println("* accessible at the site.");
            for (n = 0; n < this.harvestDocumentList.size(); ++n) {
                harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
                if (harvestDocument == null || !harvestDocument.accessError) continue;
                harvestDocument.prettyPrint(printStream);
            }
            this.printSiteSummaryTrailer(printStream);
        }
        if (n6 > 0) {
            this.printSiteSummaryHeader(printStream);
            printStream.println("* The following document(s) could not be uploaded to");
            printStream.println("* Metacat because an error of some kind occurred.");
            printStream.println("* (See log entries below for additional details.) :");
            for (n = 0; n < this.harvestDocumentList.size(); ++n) {
                harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
                if (harvestDocument == null || !harvestDocument.uploadError) continue;
                harvestDocument.prettyPrint(printStream);
            }
            this.printSiteSummaryTrailer(printStream);
        }
        if (n4 > 0) {
            this.printSiteSummaryHeader(printStream);
            printStream.println("* The following document(s) were already found in Metacat:");
            for (n = 0; n < this.harvestDocumentList.size(); ++n) {
                harvestDocument = (HarvestDocument)this.harvestDocumentList.get(n);
                if (harvestDocument == null || !harvestDocument.metacatHasIt) continue;
                harvestDocument.prettyPrint(printStream);
            }
            this.printSiteSummaryTrailer(printStream);
        }
    }

    void printSiteSummaryHeader(PrintStream printStream) {
        printStream.println("");
        printStream.println("*****************************************************************************");
        printStream.println("*");
    }

    void printSiteSummaryTrailer(PrintStream printStream) {
        printStream.println("*");
        printStream.println("*****************************************************************************");
    }

    void reportToSiteContact() {
        String string = this.harvester.harvesterAdministrator;
        String string2 = "notice";
        boolean bl = false;
        String string3 = "Report from Metacat Harvester: " + this.harvester.timestamp;
        String string4 = this.contactEmail;
        if (!string4.equals("")) {
            System.out.println("Sending report to siteScheduleID=" + this.siteScheduleID + " at address: " + this.contactEmail);
            try {
                int n;
                String[] stringArray;
                MailMessage mailMessage = new MailMessage(this.harvester.smtpServer);
                if (string.indexOf(44) > 0) {
                    stringArray = string.split(",");
                    for (n = 0; n < stringArray.length; ++n) {
                        if (n == 0) {
                            mailMessage.from(stringArray[n]);
                        }
                        mailMessage.cc(stringArray[n]);
                    }
                } else if (string.indexOf(59) > 0) {
                    stringArray = string.split(";");
                    for (n = 0; n < stringArray.length; ++n) {
                        if (n == 0) {
                            mailMessage.from(stringArray[n]);
                        }
                        mailMessage.cc(stringArray[n]);
                    }
                } else {
                    mailMessage.from(string);
                    mailMessage.cc(string);
                }
                if (string4.indexOf(44) > 0) {
                    String[] stringArray2 = string4.split(",");
                    for (n = 0; n < stringArray2.length; ++n) {
                        mailMessage.to(stringArray2[n]);
                    }
                } else if (string4.indexOf(59) > 0) {
                    String[] stringArray3 = string4.split(";");
                    for (n = 0; n < stringArray3.length; ++n) {
                        mailMessage.to(stringArray3[n]);
                    }
                } else {
                    mailMessage.to(string4);
                }
                mailMessage.setSubject(string3);
                PrintStream printStream = mailMessage.getPrintStream();
                this.harvester.printHarvestHeader(printStream, this.siteScheduleID);
                this.printSiteSummary(printStream);
                this.harvester.printHarvestLog(printStream, string2, this.siteScheduleID);
                mailMessage.sendAndClose();
            }
            catch (IOException iOException) {
                System.out.println("There was a problem sending email to " + string4);
                System.out.println("IOException: " + iOException.getMessage());
            }
        }
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    class DocumentListHandler
    extends DefaultHandler
    implements ErrorHandler {
        public String scope;
        public int identifier;
        public String identifierString;
        public String documentType;
        public int revision;
        public String revisionString;
        public String documentURL;
        private String currentQname;
        public static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
        private boolean schemaValidate = true;

        DocumentListHandler() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            if (n2 > 0) {
                if (this.currentQname.equals("scope")) {
                    this.scope = this.scope + string;
                } else if (this.currentQname.equals("identifier")) {
                    this.identifierString = this.identifierString + string;
                } else if (this.currentQname.equals("revision")) {
                    this.revisionString = this.revisionString + string;
                } else if (this.currentQname.equals("documentType")) {
                    this.documentType = this.documentType + string;
                } else if (this.currentQname.equals("documentURL")) {
                    this.documentURL = this.documentURL + string;
                }
            }
        }

        @Override
        public void endDocument() {
            System.out.println("Finished parsing " + HarvestSiteSchedule.this.documentListURL);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("identifier")) {
                this.identifier = Integer.parseInt(this.identifierString);
            } else if (string3.equals("revision")) {
                this.revision = Integer.parseInt(this.revisionString);
            } else if (string3.equals("document")) {
                HarvestDocument harvestDocument = new HarvestDocument(HarvestSiteSchedule.this.harvester, HarvestSiteSchedule.this, this.scope, this.identifier, this.revision, this.documentType, this.documentURL);
                HarvestSiteSchedule.this.harvestDocumentList.add(harvestDocument);
            }
            this.currentQname = "";
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            System.out.println("SAXParseException: " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        public void runParser(Reader reader, String string) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", string);
            if (this.schemaValidate) {
                xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            xMLReader.parse(new InputSource(reader));
        }

        @Override
        public void startDocument() {
            System.out.println("Started parsing " + HarvestSiteSchedule.this.documentListURL);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.currentQname = string3;
            if (string3.equals("scope")) {
                this.scope = "";
            } else if (string3.equals("identifier")) {
                this.identifierString = "";
            } else if (string3.equals("revision")) {
                this.revisionString = "";
            } else if (string3.equals("documentType")) {
                this.documentType = "";
            } else if (string3.equals("documentURL")) {
                this.documentURL = "";
            }
        }
    }
}

