/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.harvesterClient;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.IOUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MetUpload
extends HttpServlet {
    private static final String CONFIG_DIR = "WEB-INF";
    private static final String CONFIG_NAME = "metacat.properties";
    private ServletConfig config = null;
    private ServletContext context = null;
    private String metacatURL;

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        boolean bl = false;
        String string = "";
        String string2 = "";
        FilePart filePart = null;
        PrintWriter printWriter = httpServletResponse.getWriter();
        MultipartParser multipartParser = new MultipartParser(httpServletRequest, 0x100000);
        HttpSession httpSession = httpServletRequest.getSession(true);
        String string3 = (String)httpSession.getAttribute("password");
        StringReader stringReader = null;
        boolean bl2 = false;
        String string4 = (String)httpSession.getAttribute("username");
        httpServletResponse.setContentType("text/plain");
        try {
            Part part;
            while ((part = multipartParser.readNextPart()) != null) {
                String string5;
                if (part.isParam()) {
                    ParamPart paramPart = (ParamPart)part;
                    string5 = paramPart.getName();
                    if (string5 == null) continue;
                    if (string5.equals("docid")) {
                        string = paramPart.getStringValue();
                        continue;
                    }
                    if (string5.equals("Upload")) {
                        bl2 = true;
                        continue;
                    }
                    if (!string5.equals("Delete")) continue;
                    bl = true;
                    continue;
                }
                if (!part.isFile()) continue;
                filePart = (FilePart)part;
                string5 = filePart.getName();
                string2 = filePart.getFileName();
                stringReader = this.writeTempFile(filePart, printWriter, string, string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing parameters: " + exception.getMessage());
        }
        if (bl2) {
            this.upload(printWriter, string, stringReader, string4, string3);
        }
        if (bl) {
            this.delete(printWriter, string, string4, string3);
        }
    }

    private void delete(PrintWriter printWriter, String string, String string2, String string3) {
        if (string.equals("")) {
            printWriter.println("Error deleting document: No DocID specified");
            return;
        }
        try {
            Metacat metacat = MetacatFactory.createMetacatConnection((String)this.metacatURL);
            metacat.login(string2, string3);
            String string4 = metacat.delete(string);
            printWriter.println(string4);
        }
        catch (MetacatAuthException metacatAuthException) {
            printWriter.println("Metacat delete failed: MetacatAuthException:" + metacatAuthException.getMessage());
        }
        catch (MetacatInaccessibleException metacatInaccessibleException) {
            printWriter.println("Metacat delete failed:  MetacatInaccessibleException:" + metacatInaccessibleException.getMessage());
        }
        catch (InsufficientKarmaException insufficientKarmaException) {
            printWriter.println("Metacat delete failed: InsufficientKarmaException:" + insufficientKarmaException.getMessage());
        }
        catch (MetacatException metacatException) {
            printWriter.println("Metacat delete failed: MetacatException:" + metacatException.getMessage());
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        String string = this.context.getRealPath(CONFIG_DIR);
        try {
            PropertyService.getInstance();
            this.metacatURL = SystemUtil.getServletURL();
        }
        catch (ServiceException serviceException) {
            System.out.println("Service problem while initializing MetUpload: " + serviceException.getMessage());
        }
        catch (GeneralPropertyException generalPropertyException) {
            System.out.println("Error initializing properties utility: " + generalPropertyException.getMessage());
        }
        System.out.println("metacatURL: " + this.metacatURL);
    }

    private void upload(PrintWriter printWriter, String string, StringReader stringReader, String string2, String string3) {
        if (string.equals("")) {
            printWriter.println("Error uploading: No docid specified");
            return;
        }
        if (stringReader == null) {
            printWriter.println("Error uploading: No EML file specified");
            return;
        }
        try {
            Metacat metacat = MetacatFactory.createMetacatConnection((String)this.metacatURL);
            metacat.login(string2, string3);
            int n = string.length();
            String string4 = string.substring(n - 2, n);
            String string5 = string4.equals(".1") ? metacat.insert(string, (Reader)stringReader, null) : metacat.update(string, (Reader)stringReader, null);
            printWriter.println(string5);
        }
        catch (MetacatAuthException metacatAuthException) {
            printWriter.println("Metacat upload failed: MetacatAuthException:" + metacatAuthException.getMessage());
        }
        catch (MetacatInaccessibleException metacatInaccessibleException) {
            printWriter.println("Metacat upload failed:  MetacatInaccessibleException:" + metacatInaccessibleException.getMessage());
        }
        catch (InsufficientKarmaException insufficientKarmaException) {
            printWriter.println("Metacat upload failed: InsufficientKarmaException:" + insufficientKarmaException.getMessage());
        }
        catch (MetacatException metacatException) {
            printWriter.println("Metacat upload failed: MetacatException:" + metacatException.getMessage());
        }
        catch (IOException iOException) {
            printWriter.println("Metacat upload failed: IOException:" + iOException.getMessage());
        }
    }

    private StringReader writeTempFile(FilePart filePart, PrintWriter printWriter, String string, String string2) {
        StringReader stringReader = null;
        String string3 = "";
        String string4 = "";
        if (string2 == null || string2.equals("")) {
            return stringReader;
        }
        String string5 = System.getProperties().getProperty("java.io.tmpdir");
        File file = new File(string5);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            printWriter.println("Can't create directory: " + file.getPath());
            printWriter.println(securityException.getMessage());
        }
        try {
            File file2 = new File(string5, string2);
            filePart.writeTo(file2);
            string3 = string5 + File.separator + string2;
            FileReader fileReader = new FileReader(string3);
            string4 = IOUtil.getAsString((Reader)fileReader, (boolean)true);
            stringReader = new StringReader(string4);
            file2.delete();
        }
        catch (IOException iOException) {
            printWriter.println("IOException: " + string3 + iOException.getMessage());
        }
        return stringReader;
    }
}

