/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.client;

import edu.ucsb.nceas.metacat.client.DocumentNotFoundException;
import edu.ucsb.nceas.metacat.client.InputStreamKnownSizeBody;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.utilities.IOUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetacatClient
implements Metacat {
    private String metacatUrl = null;
    private String sessionId = null;
    private String encoding = "UTF-8";

    public static void main(String[] args) {
        try {
            Metacat mc = MetacatFactory.createMetacatConnection(args[0]);
            InputStream r = mc.read(args[1]);
            FileOutputStream fos = new FileOutputStream(args[2]);
            BufferedOutputStream bfos = new BufferedOutputStream(fos);
            int c = r.read();
            while (c != -1) {
                bfos.write(c);
                c = r.read();
            }
            bfos.flush();
            bfos.close();
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected MetacatClient() {
    }

    @Override
    public String login(String username, String password) throws MetacatAuthException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "login");
        prop.put("qformat", "xml");
        prop.put("username", username);
        prop.put("password", password);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<login>") == -1) {
            this.setSessionId("");
            throw new MetacatAuthException(response);
        }
        int start = response.indexOf("<sessionId>") + 11;
        int end = response.indexOf("</sessionId>");
        if (start != -1 && end != -1) {
            this.setSessionId(response.substring(start, end));
        }
        return response;
    }

    @Override
    public String getloggedinuserinfo() throws MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "getloggedinuserinfo");
        prop.put("qformat", "xml");
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        return response;
    }

    @Override
    public String logout() throws MetacatInaccessibleException, MetacatException {
        Properties prop = new Properties();
        prop.put("action", "logout");
        prop.put("qformat", "xml");
        if (this.sessionId != null) {
            prop.put("sessionid", this.sessionId);
        }
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<logout>") == -1) {
            throw new MetacatException(response);
        }
        this.setSessionId("");
        return response;
    }

    public String validateSession(String sessionId) throws MetacatAuthException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "validatesession");
        prop.put("sessionid", sessionId);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<validateSession><status>") == -1) {
            this.setSessionId("");
            throw new MetacatAuthException(response);
        }
        return response;
    }

    public String isAuthorized(String resourceLsid, String permission, String sessionId) throws MetacatAuthException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "isauthorized");
        prop.put("resourceLsid", resourceLsid);
        prop.put("permission", permission);
        prop.put("sessionId", sessionId);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<resourceAuthorization>") == -1) {
            System.out.println("invalid response: " + response);
            throw new MetacatAuthException(response);
        }
        return response;
    }

    @Override
    public InputStream read(String docid) throws InsufficientKarmaException, MetacatInaccessibleException, MetacatException, DocumentNotFoundException {
        InputStreamReader r = null;
        Properties prop = new Properties();
        prop.put("action", "read");
        prop.put("qformat", "xml");
        prop.put("docid", docid);
        InputStream response = null;
        try {
            response = this.sendParameters(prop);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        BufferedInputStream bis = new BufferedInputStream(response);
        r = new InputStreamReader(bis);
        try {
            bis.mark(512);
            char[] characters = new char[512];
            int len = ((Reader)r).read(characters, 0, 512);
            StringWriter sw = new StringWriter();
            sw.write(characters, 0, len);
            String message = sw.toString();
            sw.close();
            bis.reset();
            if (message.indexOf("<error>") != -1) {
                if (message.indexOf("does not have permission") != -1) {
                    throw new InsufficientKarmaException(message);
                }
                if (message.indexOf("does not exist") != -1) {
                    throw new DocumentNotFoundException(message);
                }
                throw new MetacatException(message);
            }
        }
        catch (IOException ioe) {
            throw new MetacatException("MetacatClient: Error converting Reader to String." + ioe.getMessage());
        }
        return bis;
    }

    @Override
    public InputStream readInlineData(String inlinedataid) throws InsufficientKarmaException, MetacatInaccessibleException, MetacatException {
        InputStreamReader r = null;
        Properties prop = new Properties();
        prop.put("action", "readinlinedata");
        prop.put("inlinedataid", inlinedataid);
        InputStream response = null;
        try {
            response = this.sendParameters(prop);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        BufferedInputStream bis = new BufferedInputStream(response);
        r = new InputStreamReader(bis);
        try {
            bis.mark(512);
            char[] characters = new char[512];
            int len = ((Reader)r).read(characters, 0, 512);
            StringWriter sw = new StringWriter();
            sw.write(characters, 0, len);
            String message = sw.toString();
            sw.close();
            bis.reset();
            if (message.indexOf("<error>") != -1) {
                if (message.indexOf("does not have permission") != -1) {
                    throw new InsufficientKarmaException(message);
                }
                throw new MetacatException(message);
            }
        }
        catch (IOException ioe) {
            throw new MetacatException("MetacatClient: Error converting Reader to String." + ioe.getMessage());
        }
        return bis;
    }

    @Override
    public Reader query(Reader xmlQuery) throws MetacatInaccessibleException, IOException {
        String qformat = "xml";
        return this.query(xmlQuery, qformat);
    }

    @Override
    public Reader query(Reader xmlQuery, String qformat) throws MetacatInaccessibleException, IOException {
        InputStreamReader reader = null;
        String query = null;
        query = IOUtil.getAsString((Reader)xmlQuery, (boolean)true);
        Properties prop = new Properties();
        prop.put("action", "squery");
        prop.put("qformat", qformat);
        prop.put("query", query);
        InputStream response = null;
        try {
            response = this.sendParameters(prop);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        reader = new InputStreamReader(response);
        return reader;
    }

    @Override
    public String insert(String docid, Reader xmlDocument, Reader schema) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        String doctext = null;
        String schematext = null;
        doctext = IOUtil.getAsString((Reader)xmlDocument, (boolean)true);
        if (schema != null) {
            schematext = IOUtil.getAsString((Reader)schema, (boolean)true);
        }
        Properties prop = new Properties();
        prop.put("action", "insert");
        prop.put("docid", docid);
        prop.put("doctext", doctext);
        if (schematext != null) {
            prop.put("dtdtext", schematext);
        }
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String update(String docid, Reader xmlDocument, Reader schema) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        String doctext = null;
        String schematext = null;
        doctext = IOUtil.getAsString((Reader)xmlDocument, (boolean)true);
        if (schema != null) {
            schematext = IOUtil.getAsString((Reader)schema, (boolean)true);
        }
        Properties prop = new Properties();
        prop.put("action", "update");
        prop.put("docid", docid);
        prop.put("doctext", doctext);
        if (schematext != null) {
            prop.put("dtdtext", schematext);
        }
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String upload(String docid, File file) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        httpclient.getParams().setParameter("http.protocol.content-charset", (Object)this.encoding);
        HttpPost post = new HttpPost(this.metacatUrl);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("datafile", (ContentBody)new FileBody(file));
        Properties prop = new Properties();
        prop.put("action", "upload");
        prop.put("docid", docid);
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = prop.getProperty(key);
            entity.addPart(key, (ContentBody)new StringBody(value, Charset.forName(this.encoding)));
        }
        post.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
        post.setEntity((HttpEntity)entity);
        String response = null;
        try {
            response = EntityUtils.toString((HttpEntity)httpclient.execute((HttpUriRequest)post).getEntity(), (String)this.encoding);
            httpclient.getConnectionManager().shutdown();
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String upload(String docid, String filename, InputStream fileData, int size) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        httpclient.getParams().setParameter("http.protocol.content-charset", (Object)this.encoding);
        HttpPost post = new HttpPost(this.metacatUrl);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        Object content = null;
        content = size < 0 ? new InputStreamBody(fileData, filename) : new InputStreamKnownSizeBody(fileData, filename, size);
        entity.addPart("datafile", (ContentBody)content);
        Properties prop = new Properties();
        prop.put("action", "upload");
        prop.put("docid", docid);
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = prop.getProperty(key);
            entity.addPart(key, (ContentBody)new StringBody(value, Charset.forName(this.encoding)));
        }
        post.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
        post.setEntity((HttpEntity)entity);
        String response = null;
        try {
            response = EntityUtils.toString((HttpEntity)httpclient.execute((HttpUriRequest)post).getEntity(), (String)this.encoding);
            httpclient.getConnectionManager().shutdown();
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String delete(String docid) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "delete");
        prop.put("docid", docid);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String getAccessControl(String docid) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "getaccesscontrol");
        prop.put("docid", docid);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String setAccess(String docid, String principal, String permission, String permType, String permOrder) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "setaccess");
        prop.put("docid", docid);
        prop.put("principal", principal);
        prop.put("permission", permission);
        prop.put("permType", permType);
        prop.put("permOrder", permOrder);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String setAccess(String docid, String accessBlock) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties prop = new Properties();
        prop.put("action", "setaccess");
        prop.put("docid", docid);
        prop.put("accessBlock", accessBlock);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public void setMetacatUrl(String metacatUrl) {
        this.metacatUrl = metacatUrl;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public int getNewestDocRevision(String docId) throws MetacatException {
        int rev = 0;
        Properties prop = new Properties();
        prop.put("action", "getrevisionanddoctype");
        prop.put("docid", docId);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
            String revStr = this.parserRevisionResponse(response);
            Integer revObj = new Integer(revStr);
            rev = revObj;
            if (response.indexOf("<error>") != -1 && revStr == null) {
                throw new MetacatException(response);
            }
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return rev;
    }

    @Override
    public String getLastDocid(String scope) throws MetacatException {
        String lastIdentifier = "";
        Properties prop = new Properties();
        prop.put("action", "getlastdocid");
        prop.put("scope", scope);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            Node root = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)responseReader);
            Node docidNode = XMLUtilities.getNodeWithXPath((Node)root, (String)"/lastDocid/docid");
            lastIdentifier = docidNode.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return lastIdentifier;
    }

    @Override
    public Vector getAllDocids(String scope) throws MetacatException {
        Vector<String> resultVec = new Vector<String>();
        Properties prop = new Properties();
        prop.put("action", "getalldocids");
        if (scope != null) {
            prop.put("scope", scope);
        }
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            Node root = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)responseReader);
            NodeList nlist = root.getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node n = nlist.item(i);
                if (!n.getNodeName().equals("docid")) continue;
                String nodeVal = n.getFirstChild().getNodeValue();
                resultVec.addElement(nodeVal);
            }
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return resultVec;
    }

    @Override
    public boolean isRegistered(String docid) throws MetacatException {
        Vector resultVec = new Vector();
        Properties prop = new Properties();
        prop.put("action", "isregistered");
        if (docid == null) {
            throw new MetacatException("<error>Cannot check if a null docid is registered.</error>");
        }
        prop.put("docid", docid);
        String response = null;
        try {
            InputStream result = this.sendParameters(prop);
            response = IOUtils.toString((InputStream)result, (String)this.encoding);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            return response.indexOf("true") != -1;
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
    }

    public synchronized InputStream sendParameters(Properties prop) throws Exception {
        InputStream result = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            httpclient.getParams().setParameter("http.protocol.content-charset", (Object)this.encoding);
            HttpPost post = new HttpPost(this.metacatUrl);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            Enumeration<Object> keys = prop.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = prop.getProperty(key);
                BasicNameValuePair nvp = new BasicNameValuePair(key, value);
                nameValuePairs.add(nvp);
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, this.encoding));
            post.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
            result = httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        return result;
    }

    public synchronized InputStream sendParametersInverted(Properties prop) throws Exception {
        InputStream result = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            httpclient.getParams().setParameter("http.protocol.content-charset", (Object)this.encoding);
            HttpPost post = new HttpPost(this.metacatUrl);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            Enumeration<Object> keys = prop.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = prop.getProperty(key);
                BasicNameValuePair nvp = new BasicNameValuePair(value, key);
                nameValuePairs.add(nvp);
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, this.encoding));
            post.setHeader("Cookie", "JSESSIONID=" + this.sessionId);
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
            result = httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        return result;
    }

    private String parserRevisionResponse(String response) throws Exception {
        String revision = null;
        if (response != null) {
            if (response.indexOf("<error>") != -1) {
                if (response.indexOf("There is not record") != -1) {
                    return "0";
                }
                return null;
            }
            int firstSemiCol = response.indexOf(";");
            revision = response.substring(0, firstSemiCol);
        }
        return revision;
    }

    public static MetacatClient getMetacatClient(HttpServletRequest request) throws MetacatInaccessibleException {
        String metacatPath = "http://%1$s%2$s/metacat";
        HttpSession session = request.getSession();
        MetacatClient result = (MetacatClient)session.getAttribute("MetacatClient");
        if (result == null) {
            String host = request.getHeader("host");
            String context = request.getContextPath();
            metacatPath = metacatPath.replaceFirst("%1$s", host);
            metacatPath = metacatPath.replaceFirst("%2$s", context);
            result = (MetacatClient)MetacatFactory.createMetacatConnection(metacatPath);
            session.setAttribute("MetacatClient", (Object)result);
        }
        return result;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

