/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssociateAccessPolicy {
    private DBConnection conn = null;
    private Vector docIdInAccessTable = null;
    private Vector docIdWithoutAccessEntry = null;
    private Vector notFoundDataSetId = null;
    private Vector itsDataSetIdWithouAccessEntry = null;
    private Hashtable docIdMapDataSetId = null;
    private Log logMetacat = LogFactory.getLog(AssociateAccessPolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String str;
        DBConnection localConn = null;
        int serialNumber = -1;
        AssociateAccessPolicy policy = null;
        try {
            localConn = DBConnectionPool.getDBConnection("AssociateAccessPolict.main");
            serialNumber = localConn.getCheckOutSerialNumber();
            policy = new AssociateAccessPolicy(localConn);
            policy.associateAccess();
        }
        catch (Exception e) {
            System.err.println("Error in AssociateAccessPolicy.main");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            DBConnectionPool.returnDBConnection(localConn, serialNumber);
        }
        if (!policy.getNotFoundDataSetId().isEmpty()) {
            System.out.println("Following docid which could not find a mapped dataset was associated with defualt policy:");
            for (int i = 0; i < policy.getNotFoundDataSetId().size(); ++i) {
                str = (String)policy.getNotFoundDataSetId().elementAt(i);
                System.out.println(str);
            }
        }
        if (!policy.geItsDataSetIdWithouAccessEntry().isEmpty()) {
            System.out.println("Following docid which's mapped dataset doesn't has an access entry was associated with defualt policy:");
            for (int i = 0; i < policy.geItsDataSetIdWithouAccessEntry().size(); ++i) {
                str = (String)policy.geItsDataSetIdWithouAccessEntry().elementAt(i);
                System.out.println(str);
            }
        }
    }

    public AssociateAccessPolicy(DBConnection conn) throws IOException, SQLException, Exception {
        this.conn = conn;
        this.docIdInAccessTable = new Vector();
        this.docIdWithoutAccessEntry = new Vector();
        this.notFoundDataSetId = new Vector();
        this.itsDataSetIdWithouAccessEntry = new Vector();
        this.docIdMapDataSetId = new Hashtable();
        this.getDocIdInAccessTable();
        this.getDocIdWithoutAccessEntry();
        this.getDocIdMapDataSetId();
    }

    public Vector getNotFoundDataSetId() {
        return this.notFoundDataSetId;
    }

    public Vector geItsDataSetIdWithouAccessEntry() {
        return this.itsDataSetIdWithouAccessEntry;
    }

    private void getDocIdInAccessTable() throws SQLException, McdbException, Exception {
        ResultSet rs = null;
        String query = "SELECT id.docid from xml_access xa, identifier id where xa.guid = id.guid";
        try {
            PreparedStatement pStmt = this.conn.prepareStatement(query);
            pStmt.execute();
            rs = pStmt.getResultSet();
            while (rs.next()) {
                String docId = rs.getString(1);
                if (this.docIdInAccessTable.contains(docId)) continue;
                this.docIdInAccessTable.add(docId);
            }
            pStmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error in getDocidListForDataPackage: " + e.getMessage()));
        }
    }

    private void associateDefaultValue(String docId) throws SQLException, McdbException, Exception {
        String query = null;
        query = "INSERT INTO xml_access (docid, principal_name, permission, perm_type, perm_order)VALUES (?,'public','4','allow','allowFirst')";
        try {
            PreparedStatement pStmt = this.conn.prepareStatement(query);
            pStmt.setString(1, docId);
            this.logMetacat.debug((Object)("running sql: " + pStmt.toString()));
            pStmt.execute();
            pStmt.close();
        }
        catch (SQLException e) {
            System.out.println("Error in associateDefaultValue: " + e.getMessage());
        }
    }

    private void getDocIdWithoutAccessEntry() throws SQLException, McdbException, Exception {
        Statement pStmt = null;
        ResultSet rs = null;
        String query = "SELECT docid from xml_documents";
        try {
            pStmt = this.conn.prepareStatement(query);
            pStmt.execute();
            rs = pStmt.getResultSet();
            while (rs.next()) {
                String docId = rs.getString(1);
                if (this.docIdInAccessTable.contains(docId)) continue;
                this.docIdWithoutAccessEntry.add(docId);
            }
            pStmt.close();
        }
        catch (SQLException e) {
            pStmt.close();
            this.logMetacat.error((Object)("Error in getDocidListForDataPackage: " + e.getMessage()));
        }
    }

    private void getDocIdMapDataSetId() throws SQLException, McdbException, Exception {
        Statement pStmt = null;
        ResultSet rs = null;
        String docId = null;
        String dataSetId = null;
        if (this.docIdWithoutAccessEntry.isEmpty()) {
            throw new Exception("Every docid in xml_documents table has access policy");
        }
        String query = "SELECT docid from xml_relation where subject= ? or object= ?";
        try {
            for (int i = 0; i < this.docIdWithoutAccessEntry.size(); ++i) {
                docId = (String)this.docIdWithoutAccessEntry.elementAt(i);
                pStmt = this.conn.prepareStatement(query);
                pStmt.setString(1, docId);
                pStmt.setString(2, docId);
                pStmt.execute();
                rs = pStmt.getResultSet();
                if (rs.next()) {
                    dataSetId = rs.getString(1);
                    this.docIdMapDataSetId.put(docId, dataSetId);
                } else {
                    this.associateDefaultValue(docId);
                    this.notFoundDataSetId.add(docId);
                }
                pStmt.close();
            }
        }
        catch (SQLException e) {
            pStmt.close();
            System.out.println("Error ingetDocIdMapDataSetId: " + e.getMessage());
        }
    }

    public void associateAccess() throws SQLException, McdbException, Exception {
        String docId = null;
        String dataSetId = null;
        String accessFileId = null;
        String principal = null;
        int permission = 0;
        String permType = null;
        String permOrder = null;
        String beginTime = null;
        String endTime = null;
        int ticketCount = -1;
        Statement pStmt = null;
        Statement insertStatement = null;
        ResultSet rs = null;
        String query = null;
        boolean hasRecord = false;
        if (this.docIdWithoutAccessEntry.isEmpty()) {
            throw new Exception("Every docid in xml_documents table has access policy");
        }
        if (!this.docIdMapDataSetId.isEmpty()) {
            try {
                Enumeration docList = this.docIdMapDataSetId.keys();
                while (docList.hasMoreElements()) {
                    docId = (String)docList.nextElement();
                    dataSetId = (String)this.docIdMapDataSetId.get(docId);
                    query = "select accessfileid, principal_name,permission,perm_type,perm_order,begin_time,end_time,ticket_count from xml_access xa, identifier id where id.docid = ? and id.guid = xa.guid";
                    pStmt = this.conn.prepareStatement(query);
                    pStmt.setString(1, dataSetId);
                    pStmt.execute();
                    rs = pStmt.getResultSet();
                    hasRecord = rs.next();
                    if (!hasRecord) {
                        this.itsDataSetIdWithouAccessEntry.add(docId);
                        this.associateDefaultValue(docId);
                        continue;
                    }
                    while (hasRecord) {
                        accessFileId = rs.getString(1);
                        principal = rs.getString(2);
                        permission = rs.getInt(3);
                        permType = rs.getString(4);
                        permOrder = rs.getString(5);
                        beginTime = rs.getString(6);
                        endTime = rs.getString(7);
                        ticketCount = rs.getInt(8);
                        insertStatement = this.conn.prepareStatement("INSERT INTO xml_access (docid, principal_name, permission, perm_type, perm_order,ticket_count, accessfileid) VALUES (?,?,?,?,?,?,?)");
                        insertStatement.setString(1, docId);
                        insertStatement.setString(2, principal);
                        insertStatement.setInt(3, permission);
                        insertStatement.setString(4, permType);
                        insertStatement.setString(5, permOrder);
                        insertStatement.setString(7, accessFileId);
                        if (ticketCount > 0) {
                            insertStatement.setString(6, "" + ticketCount);
                        } else {
                            insertStatement.setString(6, null);
                        }
                        this.logMetacat.debug((Object)("running sql: " + insertStatement.toString()));
                        insertStatement.execute();
                        hasRecord = rs.next();
                    }
                    insertStatement.close();
                }
                pStmt.close();
            }
            catch (SQLException e) {
                pStmt.close();
                insertStatement.close();
                this.logMetacat.error((Object)("Error in getDocidListForDataPackadge: " + e.getMessage()));
            }
        }
    }
}

