/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.QueryGroup;
import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.RemoteDocument;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.triple.Triple;
import edu.ucsb.nceas.utilities.triple.TripleCollection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBQuery {
    public static final String XPATHQUERYOFFINFO = "The Metacat Path Query Engine is turned off. If you want to turn it on, please contact the administrator.";
    static final int ALL = 1;
    static final int WRITE = 2;
    static final int READ = 4;
    private String qformat = "xml";
    private String operator = null;
    private String parserName = null;
    private Log logMetacat = LogFactory.getLog(DBQuery.class);
    private final boolean METACAT_SPATIAL = true;
    Vector docidOverride = new Vector();
    private static Hashtable queryResultCache = new Hashtable();
    private static final int QUERYRESULTCACHESIZE;
    private static final int NONPAGESIZE = 99999999;
    private int returnfield_id;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java DBQuery [-t] [-index] <xmlfile>");
            return;
        }
        try {
            int i = 0;
            boolean showRuntime = false;
            boolean useXMLIndex = false;
            if (args[i].equals("-t")) {
                showRuntime = true;
                ++i;
            }
            if (args[i].equals("-index")) {
                useXMLIndex = true;
                ++i;
            }
            String xmlfile = args[i];
            double startTime = System.currentTimeMillis();
            double connTime = System.currentTimeMillis();
            DBQuery queryobj = new DBQuery();
            InputStreamReader xml = new InputStreamReader(new FileInputStream(new File(xmlfile)));
            Hashtable nodelist = null;
            StringBuffer result = new StringBuffer();
            String document = null;
            String docid = null;
            result.append("<?xml version=\"1.0\"?>\n");
            result.append("<resultset>\n");
            if (!showRuntime) {
                Enumeration doclist = nodelist.keys();
                while (doclist.hasMoreElements()) {
                    docid = (String)doclist.nextElement();
                    document = (String)nodelist.get(docid);
                    result.append("  <document>\n    " + document + "\n  </document>\n");
                }
                result.append("</resultset>\n");
            }
            double stopTime = System.currentTimeMillis();
            double dbOpenTime = (connTime - startTime) / 1000.0;
            double readTime = (stopTime - connTime) / 1000.0;
            double executionTime = (stopTime - startTime) / 1000.0;
            if (showRuntime) {
                System.out.print("  " + executionTime);
                System.out.print("  " + dbOpenTime);
                System.out.print("  " + readTime);
                System.out.print("  " + nodelist.size());
                System.out.println();
            }
            if (!showRuntime) {
                File f = new File("./result.txt");
                OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(f));
                BufferedWriter out = new BufferedWriter(fw);
                out.write(result.toString());
                out.flush();
                out.close();
                ((Writer)fw).close();
            }
        }
        catch (Exception e) {
            System.err.println("Error in DBQuery.main");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public DBQuery() throws PropertyNotFoundException {
        String parserName;
        this.parserName = parserName = PropertyService.getProperty("xml.saxparser");
    }

    public DBQuery(Vector docids) throws PropertyNotFoundException {
        String parserName;
        int size = new Integer(PropertyService.getProperty("database.appResultsetSize"));
        this.logMetacat.info((Object)("DBQuery.DBQuery - The size of select doicds is " + docids.size()));
        this.logMetacat.info((Object)("DBQuery.DBQuery - The application result size in metacat.properties is " + size));
        Vector subset = new Vector();
        if (docids != null && docids.size() > size) {
            int index = 0;
            for (int i = 0; i < docids.size(); ++i) {
                if (index < size) {
                    subset.add(docids.elementAt(i));
                    ++index;
                    continue;
                }
                this.docidOverride.add(subset);
                subset = new Vector();
                subset.add(docids.elementAt(i));
                index = 1;
            }
            if (!subset.isEmpty()) {
                this.docidOverride.add(subset);
            }
        } else {
            this.docidOverride.add(docids);
        }
        this.parserName = parserName = PropertyService.getProperty("xml.saxparser");
    }

    public void findDocuments(HttpServletResponse response, Writer out, Hashtable params, String user, String[] groups, String sessionid) throws PropertyNotFoundException {
        boolean useXMLIndex = new Boolean(PropertyService.getProperty("database.usexmlindex"));
        this.findDocuments(response, out, params, user, groups, sessionid, useXMLIndex);
    }

    private void findDocuments(HttpServletResponse response, Writer out, Hashtable params, String user, String[] groups, String sessionid, boolean useXMLIndex) {
        if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
            try {
                String output = "";
                output = output + "<?xml version=\"1.0\"?>";
                output = output + "<error>";
                output = output + XPATHQUERYOFFINFO;
                output = output + "</error>";
                out.write(output);
                out.close();
            }
            catch (IOException e) {
                this.logMetacat.warn((Object)("DBQuery.findDocuments - metacat can't write the message that the pathquery is off to the client since :" + e.getMessage()));
            }
            return;
        }
        int pagesize = 0;
        int pagestart = 0;
        long transferWarnLimit = 0L;
        if (params.containsKey("pagesize") && params.containsKey("pagestart")) {
            String pagesizeStr = ((String[])params.get("pagesize"))[0];
            String pagestartStr = ((String[])params.get("pagestart"))[0];
            if (pagesizeStr != null && pagestartStr != null) {
                pagesize = new Integer(pagesizeStr);
                pagestart = new Integer(pagestartStr);
            }
        }
        String xmlquery = null;
        String qformat = null;
        try {
            xmlquery = ((String[])params.get("query"))[0];
            this.logMetacat.info((Object)("DBQuery.findDocuments - SESSIONID: " + sessionid));
            this.logMetacat.info((Object)("DBQuery.findDocuments - xmlquery: " + xmlquery));
            qformat = ((String[])params.get("qformat"))[0];
            this.logMetacat.info((Object)("DBQuery.findDocuments - qformat: " + qformat));
        }
        catch (Exception ee) {
            this.logMetacat.error((Object)("DBQuery.findDocuments - Couldn't retrieve xmlquery or qformat value from params hashtable in DBQuery.findDocuments: " + ee.getMessage()));
        }
        QuerySpecification qspec = null;
        if (xmlquery != null) {
            xmlquery = this.transformQuery(xmlquery);
            try {
                qspec = new QuerySpecification(xmlquery, this.parserName, PropertyService.getProperty("document.accNumSeparator"));
            }
            catch (Exception ee) {
                this.logMetacat.error((Object)("DBQuery.findDocuments - error generating QuerySpecification object: " + ee.getMessage()));
            }
        }
        if (qformat != null && qformat.equals("xml")) {
            if (response != null) {
                response.setContentType("text/xml");
            }
            this.createResultDocument(xmlquery, qspec, out, user, groups, useXMLIndex, pagesize, pagestart, sessionid, qformat, false);
        } else {
            response.setContentType("text/html");
            Writer nonout = null;
            StringBuffer xml = this.createResultDocument(xmlquery, qspec, nonout, user, groups, useXMLIndex, pagesize, pagestart, sessionid, qformat, false);
            try {
                long startHTMLTransform = System.currentTimeMillis();
                DBTransform trans = new DBTransform();
                response.setContentType("text/html");
                if (AuthUtil.isModerator(user, groups)) {
                    params.put("isModerator", new String[]{"true"});
                }
                trans.transformXMLDocument(xml.toString(), "-//NCEAS//resultset//EN", "-//W3C//HTML//EN", qformat, out, params, sessionid);
                long transformRunTime = System.currentTimeMillis() - startHTMLTransform;
                transferWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.transformTimeWarnLimit"));
                if (transformRunTime > transferWarnLimit) {
                    this.logMetacat.warn((Object)("DBQuery.findDocuments - The time to transfrom resultset from xml to html format is " + transformRunTime));
                }
                MetacatUtil.writeDebugToFile("---------------------------------------------------------------------------------------------------------------Transfrom xml to html  " + transformRunTime);
                MetacatUtil.writeDebugToDelimiteredFile(" " + transformRunTime, false);
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("DBQuery.findDocuments - Error in MetaCatServlet.transformResultset:" + e.getMessage()));
            }
        }
    }

    public StringBuffer createResultDocument(String xmlquery, QuerySpecification qspec, Writer out, String user, String[] groups, boolean useXMLIndex) {
        return this.createResultDocument(xmlquery, qspec, out, user, groups, useXMLIndex, 0, 0, "", this.qformat, false);
    }

    public String performPathquery(String xmlquery, String user, String[] groups) throws PropertyNotFoundException, IOException {
        xmlquery = this.transformQuery(xmlquery);
        QuerySpecification qspec = new QuerySpecification(xmlquery, this.parserName, PropertyService.getProperty("document.accNumSeparator"));
        Writer nonout = null;
        boolean useXMLIndex = new Boolean(PropertyService.getProperty("database.usexmlindex"));
        StringBuffer xml = this.createResultDocument(xmlquery, qspec, nonout, user, groups, useXMLIndex, 0, 0, "", this.qformat, true);
        return xml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer createResultDocument(String xmlquery, QuerySpecification qspec, Writer out, String user, String[] groups, boolean useXMLIndex, int pagesize, int pagestart, String sessionid, String qformat, boolean includeGuid) {
        DBConnection dbconn = null;
        int serialNumber = -1;
        StringBuffer resultset = new StringBuffer();
        resultset.append("<?xml version=\"1.0\"?>\n");
        resultset.append("<resultset>\n");
        resultset.append("  <pagestart>" + pagestart + "</pagestart>\n");
        resultset.append("  <pagesize>" + pagesize + "</pagesize>\n");
        resultset.append("  <nextpage>" + (pagestart + 1) + "</nextpage>\n");
        resultset.append("  <previouspage>" + (pagestart - 1) + "</previouspage>\n");
        resultset.append("  <query><![CDATA[" + xmlquery + "]]></query>");
        if (out != null) {
            try {
                out.write(resultset.toString());
            }
            catch (IOException e) {
                this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (qspec != null) {
            try {
                dbconn = DBConnectionPool.getDBConnection("DBQuery.findDocuments");
                serialNumber = dbconn.getCheckOutSerialNumber();
                Vector givenDocids = new Vector();
                StringBuffer resultContent = new StringBuffer();
                if (this.docidOverride == null || this.docidOverride.size() == 0) {
                    this.logMetacat.debug((Object)"DBQuery.createResultDocument - Not in map query");
                    resultContent = this.findResultDoclist(qspec, out, user, groups, dbconn, useXMLIndex, pagesize, pagestart, sessionid, givenDocids, qformat, includeGuid);
                } else {
                    this.logMetacat.debug((Object)"DBQuery.createResultDocument - In map query");
                    for (int i = 0; i < this.docidOverride.size(); ++i) {
                        this.logMetacat.debug((Object)("DBQuery.createResultDocument - in loop===== " + i));
                        givenDocids = (Vector)this.docidOverride.elementAt(i);
                        StringBuffer subset = this.findResultDoclist(qspec, out, user, groups, dbconn, useXMLIndex, pagesize, pagestart, sessionid, givenDocids, qformat, includeGuid);
                        resultContent.append(subset);
                    }
                }
                resultset.append(resultContent);
            }
            catch (IOException ioe) {
                this.logMetacat.error((Object)("DBQuery.createResultDocument - IO error: " + ioe.getMessage()));
            }
            catch (SQLException e) {
                this.logMetacat.error((Object)("DBQuery.createResultDocument - SQL Error: " + e.getMessage()));
            }
            catch (Exception ee) {
                this.logMetacat.error((Object)("DBQuery.createResultDocument - General exception: " + ee.getMessage()));
                ee.printStackTrace();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbconn, serialNumber);
            }
        }
        String closeRestultset = "</resultset>";
        resultset.append(closeRestultset);
        if (out != null) {
            try {
                out.write(closeRestultset);
            }
            catch (IOException e) {
                this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return resultset;
    }

    private StringBuffer findResultDoclist(QuerySpecification qspec, Writer out, String user, String[] groups, DBConnection dbconn, boolean useXMLIndex, int pagesize, int pagestart, String sessionid, Vector givenDocids, String qformat, boolean includeGuid) throws Exception {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        StringBuffer resultsetBuffer = new StringBuffer();
        String query = null;
        int count = 0;
        boolean index = false;
        ResultDocumentSet docListResult = new ResultDocumentSet();
        PreparedStatement pstmt = null;
        String docid = null;
        String guid = null;
        String docname = null;
        String doctype = null;
        String createDate = null;
        String updateDate = null;
        StringBuffer document = null;
        boolean lastpage = false;
        int rev = 0;
        double startTime = 0.0;
        int offset = 1;
        long startSelectionTime = System.currentTimeMillis();
        ResultSet rs = null;
        offset = out == null ? new Integer(PropertyService.getProperty("database.webResultsetSize")).intValue() : new Integer(PropertyService.getProperty("database.appResultsetSize")).intValue();
        ArrayList<Object> docidValues = new ArrayList<Object>();
        if (givenDocids == null || givenDocids.size() == 0) {
            query = qspec.printSQL(useXMLIndex, docidValues);
            parameterValues.addAll(docidValues);
        } else {
            ArrayList<String> docidConditionValues = new ArrayList<String>();
            StringBuffer docidCondition = new StringBuffer();
            docidCondition.append(" xml_documents.docid IN (");
            for (int i = 0; i < givenDocids.size(); ++i) {
                docidCondition.append("?");
                if (i < givenDocids.size() - 1) {
                    docidCondition.append(",");
                }
                docidConditionValues.add((String)givenDocids.elementAt(i));
            }
            docidCondition.append(") ");
            if (this.operator == null) {
                query = "SELECT xml_documents.docid, identifier.guid, docname, doctype, date_created, date_updated, xml_documents.rev FROM xml_documents, identifier WHERE xml_documents.docid = identifier.docid AND xml_documents.rev = identifier.rev AND ";
                query = query + docidCondition.toString();
                parameterValues.addAll(docidConditionValues);
            } else {
                query = qspec.printSQL(useXMLIndex, docidValues);
                parameterValues.addAll(docidValues);
                String myOperator = "";
                if (!(query.endsWith("WHERE") || query.endsWith("OR") || query.endsWith("AND"))) {
                    myOperator = this.operator.equalsIgnoreCase(QueryGroup.UNION) ? " OR " : " AND ";
                }
                query = query + myOperator + docidCondition.toString();
                parameterValues.addAll(docidConditionValues);
            }
        }
        ArrayList<Object> ownerValues = new ArrayList<Object>();
        String ownerQuery = this.getOwnerQuery(user, ownerValues);
        this.logMetacat.debug((Object)("DBQuery.findResultDoclist - owner query: " + ownerQuery));
        if (!query.equals(ownerQuery)) {
            qspec.setUserName(user);
            qspec.setGroup(groups);
            String accessQuery = qspec.getAccessQuery();
            query = !query.endsWith("AND") ? query + accessQuery : query + accessQuery.substring(4, accessQuery.length());
        }
        this.logMetacat.debug((Object)("DBQuery.findResultDoclist - final selection query: " + query));
        pstmt = dbconn.prepareStatement(query);
        pstmt = DBQuery.setPreparedStatementValues(parameterValues, pstmt);
        String queryCacheKey = null;
        if (user != null && user.equalsIgnoreCase("public") && pagesize == 0 && PropertyService.getProperty("database.queryCacheOn").equals("true")) {
            queryCacheKey = pstmt.toString() + qspec.getReturnDocList() + qspec.getReturnFieldList();
            String cachedResult = this.getResultXMLFromCache(queryCacheKey);
            this.logMetacat.debug((Object)("=======DBQuery.findResultDoclist - The key of query cache is " + queryCacheKey));
            if (cachedResult != null) {
                this.logMetacat.info((Object)"DBQuery.findResultDoclist - result from cache !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                if (out != null) {
                    out.write(cachedResult);
                }
                resultsetBuffer.append(cachedResult);
                pstmt.close();
                return resultsetBuffer;
            }
        }
        startTime = System.currentTimeMillis() / 1000L;
        this.logMetacat.debug((Object)("Prepared statement after setting parameter values: " + pstmt.toString()));
        rs = pstmt.executeQuery();
        double queryExecuteTime = System.currentTimeMillis() / 1000L;
        this.logMetacat.debug((Object)("DBQuery.findResultDoclist - Time to execute select docid query is " + (queryExecuteTime - startTime)));
        MetacatUtil.writeDebugToFile("\n\n\n\n\n\nExecute selection query  " + (queryExecuteTime - startTime));
        MetacatUtil.writeDebugToDelimiteredFile("" + (queryExecuteTime - startTime), false);
        boolean tableHasRows = rs.next();
        if (pagesize == 0) {
            pagesize = 99999999;
            pagestart = 99999999;
        }
        int currentIndex = 0;
        while (tableHasRows) {
            int i;
            ResultDocumentSet pagedResultsHash;
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist - getting result: " + currentIndex));
            docid = rs.getString(1).trim();
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist -  docid: " + docid));
            guid = rs.getString(2).trim();
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist -  guid: " + guid));
            docname = rs.getString(3);
            doctype = rs.getString(4);
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist - doctype: " + doctype));
            createDate = rs.getString(5);
            updateDate = rs.getString(6);
            rev = rs.getInt(7);
            Vector returndocVec = qspec.getReturnDocList();
            if (returndocVec.size() == 0 || returndocVec.contains(doctype)) {
                this.logMetacat.debug((Object)"DBQuery.findResultDoclist - NOT Back tracing now...");
                document = new StringBuffer();
                String completeDocid = docid + PropertyService.getProperty("document.accNumSeparator");
                completeDocid = completeDocid + rev;
                document.append("<docid>").append(completeDocid).append("</docid>");
                if (includeGuid) {
                    document.append("<guid>").append(guid).append("</guid>");
                }
                if (docname != null) {
                    document.append("<docname>" + docname + "</docname>");
                }
                if (doctype != null) {
                    document.append("<doctype>" + doctype + "</doctype>");
                }
                if (createDate != null) {
                    document.append("<createdate>" + createDate + "</createdate>");
                }
                if (updateDate != null) {
                    document.append("<updatedate>" + updateDate + "</updatedate>");
                }
                docListResult.addResultDocument(new ResultDocument(docid, document.toString()));
                this.logMetacat.info((Object)("DBQuery.findResultDoclist - real result: " + docid));
                ++currentIndex;
                ++count;
            }
            if (count == offset && pagesize == 99999999) {
                count = 0;
                this.handleSubsetResult(qspec, resultsetBuffer, out, docListResult, user, groups, dbconn, useXMLIndex, qformat);
                docListResult = new ResultDocumentSet();
            }
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist - currentIndex: " + currentIndex));
            this.logMetacat.debug((Object)("DBQuery.findResultDoclist - page comparator: " + pagesize * pagestart + pagesize));
            if (currentIndex >= pagesize * pagestart + pagesize) {
                pagedResultsHash = new ResultDocumentSet();
                for (i = pagesize * pagestart; i < docListResult.size(); ++i) {
                    pagedResultsHash.put(docListResult.get(i));
                }
                docListResult = pagedResultsHash;
                break;
            }
            tableHasRows = rs.next();
            if (tableHasRows) continue;
            pagedResultsHash = new ResultDocumentSet();
            if (pagesize != 99999999) {
                for (i = pagesize * pagestart; i < docListResult.size(); ++i) {
                    pagedResultsHash.put(docListResult.get(i));
                }
                docListResult = pagedResultsHash;
            }
            lastpage = true;
            break;
        }
        rs.close();
        pstmt.close();
        long docListTime = System.currentTimeMillis() - startSelectionTime;
        long docListWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.findDocListTimeWarnLimit"));
        if (docListTime > docListWarnLimit) {
            this.logMetacat.warn((Object)("DBQuery.findResultDoclist - Total time to get docid list is: " + docListTime));
        }
        MetacatUtil.writeDebugToFile("---------------------------------------------------------------------------------------------------------------Total selection: " + docListTime);
        MetacatUtil.writeDebugToDelimiteredFile(" " + docListTime, false);
        if (docListResult.size() != 0) {
            this.handleSubsetResult(qspec, resultsetBuffer, out, docListResult, user, groups, dbconn, useXMLIndex, qformat);
        }
        resultsetBuffer.append("\n<lastpage>" + lastpage + "</lastpage>\n");
        if (out != null) {
            out.write("\n<lastpage>" + lastpage + "</lastpage>\n");
        }
        if (user != null && user.equalsIgnoreCase("public") && pagesize == 99999999 && PropertyService.getProperty("database.queryCacheOn").equals("true")) {
            this.storeQueryResultIntoCache(queryCacheKey, resultsetBuffer.toString());
        }
        return resultsetBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer handleSubsetResult(QuerySpecification qspec, StringBuffer resultset, Writer out, ResultDocumentSet partOfDoclist, String user, String[] groups, DBConnection dbconn, boolean useXMLIndex, String qformat) throws Exception {
        long totalReturnFieldWarnLimit;
        long storeReturnFieldWarnLimit;
        long queryResultWarnLimit;
        double startReturnFieldTime = System.currentTimeMillis();
        int usage_count = this.getXmlReturnfieldsTableId(qspec, dbconn);
        boolean enterRecords = false;
        int count = new Integer(PropertyService.getProperty("database.xmlReturnfieldCount"));
        if (usage_count > count) {
            enterRecords = true;
        }
        if (this.returnfield_id < 0) {
            this.logMetacat.warn((Object)"DBQuery.handleSubsetResult - Error in getting returnfield id fromxml_returnfield table");
            enterRecords = false;
        }
        this.logMetacat.info((Object)("DBQuery.handleSubsetResult - size of partOfDoclist before docidsInQueryresultTable(): " + partOfDoclist.size()));
        long startGetReturnValueFromQueryresultable = System.currentTimeMillis();
        Hashtable queryresultDocList = this.docidsInQueryresultTable(this.returnfield_id, partOfDoclist, dbconn);
        Enumeration _keys = queryresultDocList.keys();
        while (_keys.hasMoreElements()) {
            partOfDoclist.remove((String)_keys.nextElement());
        }
        long queryResultReturnValuetime = System.currentTimeMillis() - startGetReturnValueFromQueryresultable;
        if (queryResultReturnValuetime > (queryResultWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.findQueryResultsTimeWarnLimit")))) {
            this.logMetacat.warn((Object)("DBQuery.handleSubsetResult - Time to get return fields from xml_queryresult table is (Part1 in return fields) " + queryResultReturnValuetime));
        }
        MetacatUtil.writeDebugToFile("-----------------------------------------Get fields from xml_queryresult(Part1 in return fields) " + queryResultReturnValuetime);
        MetacatUtil.writeDebugToDelimiteredFile(" " + queryResultReturnValuetime, false);
        long startExtendedQuery = System.currentTimeMillis();
        Hashtable partOfDoclistBackup = new Hashtable();
        Iterator itt = partOfDoclist.getDocids();
        while (itt.hasNext()) {
            Object key = itt.next();
            partOfDoclistBackup.put(key, partOfDoclist.get(key));
        }
        this.logMetacat.info((Object)("DBQuery.handleSubsetResult - size of partOfDoclist after docidsInQueryresultTable(): " + partOfDoclist.size()));
        partOfDoclist = this.addReturnfield(partOfDoclist, qspec, user, groups, dbconn, useXMLIndex, qformat);
        long extendedQueryRunTime = startExtendedQuery - System.currentTimeMillis();
        long extendedQueryWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.extendedQueryRunTimeWarnLimit"));
        if (extendedQueryRunTime > extendedQueryWarnLimit) {
            this.logMetacat.warn((Object)("DBQuery.handleSubsetResult - Get fields from index and node table (Part2 in return fields) " + extendedQueryRunTime));
        }
        MetacatUtil.writeDebugToFile("-----------------------------------------Get fields from extened query(Part2 in return fields) " + extendedQueryRunTime);
        MetacatUtil.writeDebugToDelimiteredFile(" " + extendedQueryRunTime, false);
        long startStoreReturnField = System.currentTimeMillis();
        Iterator keys = partOfDoclist.getDocids();
        String key = null;
        String element = null;
        String query = null;
        int offset = new Integer(PropertyService.getProperty("database.queryresultStringLength"));
        while (keys.hasNext()) {
            key = (String)keys.next();
            element = (String)partOfDoclist.get(key);
            if (enterRecords && element != null && element.length() < offset && element.compareTo((String)partOfDoclistBackup.get(key)) != 0) {
                query = "INSERT INTO xml_queryresult (returnfield_id, docid, queryresult_string) VALUES (?, ?, ?)";
                PreparedStatement pstmt = null;
                pstmt = dbconn.prepareStatement(query);
                pstmt.setInt(1, this.returnfield_id);
                pstmt.setString(2, key);
                pstmt.setString(3, element);
                dbconn.increaseUsageCount(1);
                try {
                    pstmt.execute();
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("DBQuery.handleSubsetResult - couldn't insert the element to xml_queryresult table " + e.getLocalizedMessage()));
                }
                finally {
                    pstmt.close();
                }
            }
            String xmlElement = "  <document>" + element + "</document>";
            if (out != null) {
                out.write(xmlElement);
            }
            resultset.append(xmlElement);
        }
        double storeReturnFieldTime = System.currentTimeMillis() - startStoreReturnField;
        if (storeReturnFieldTime > (double)(storeReturnFieldWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.storeReturnFieldTimeWarnLimit")))) {
            this.logMetacat.warn((Object)("DBQuery.handleSubsetResult - Time to store new return fields into xml_queryresult table (Part4 in return fields) " + storeReturnFieldTime));
        }
        MetacatUtil.writeDebugToFile("-----------------------------------------Insert new record to xml_queryresult(Part4 in return fields) " + storeReturnFieldTime);
        MetacatUtil.writeDebugToDelimiteredFile(" " + storeReturnFieldTime, false);
        Enumeration keysE = queryresultDocList.keys();
        while (keysE.hasMoreElements()) {
            key = (String)keysE.nextElement();
            element = (String)queryresultDocList.get(key);
            String xmlElement = "  <document>" + element + "</document>";
            if (out != null) {
                out.write(xmlElement);
            }
            resultset.append(xmlElement);
        }
        double returnFieldTime = (double)System.currentTimeMillis() - startReturnFieldTime;
        if (returnFieldTime > (double)(totalReturnFieldWarnLimit = Long.parseLong(PropertyService.getProperty("dbquery.totalReturnFieldTimeWarnLimit")))) {
            this.logMetacat.warn((Object)("DBQuery.handleSubsetResult - Total time to get return fields is: " + returnFieldTime));
        }
        MetacatUtil.writeDebugToFile("DBQuery.handleSubsetResult - ---------------------------------------------------------------------------------------------------------------Total to get return fields  " + returnFieldTime);
        MetacatUtil.writeDebugToDelimiteredFile("DBQuery.handleSubsetResult - " + returnFieldTime, false);
        return resultset;
    }

    private Hashtable docidsInQueryresultTable(int returnfield_id, ResultDocumentSet partOfDoclist, DBConnection dbconn) {
        Hashtable<String, String> returnValue = new Hashtable<String, String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        Iterator keylist = partOfDoclist.getDocids();
        StringBuffer doclist = new StringBuffer();
        while (keylist.hasNext()) {
            doclist.append("?,");
            parameterValues.add((String)keylist.next());
        }
        if (doclist.length() > 0) {
            doclist.deleteCharAt(doclist.length() - 1);
            String query = "select docid, queryresult_string from xml_queryresult where returnfield_id = " + returnfield_id + " and docid in (" + doclist + ")";
            this.logMetacat.info((Object)("DBQuery.docidsInQueryresultTable - Query to get docids from xml_queryresult:" + query));
            try {
                pstmt = dbconn.prepareStatement(query);
                pstmt = DBQuery.setPreparedStatementValues(parameterValues, pstmt);
                dbconn.increaseUsageCount(1);
                pstmt.execute();
                rs = pstmt.getResultSet();
                boolean tableHasRows = rs.next();
                while (tableHasRows) {
                    String key = rs.getString(1);
                    String element = rs.getString(2);
                    if (element != null) {
                        returnValue.put(key, element);
                    } else {
                        this.logMetacat.info((Object)"DBQuery.docidsInQueryresultTable - Null elment found (DBQuery.docidsInQueryresultTable)");
                    }
                    tableHasRows = rs.next();
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("DBQuery.docidsInQueryresultTable - Error getting docids from queryresult: " + e.getMessage()));
            }
        }
        return returnValue;
    }

    private int getXmlReturnfieldsTableId(QuerySpecification qspec, DBConnection dbconn) {
        int id = -1;
        int count = 1;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String returnfield = qspec.getSortedReturnFieldString();
        String query = "SELECT returnfield_id, usage_count FROM xml_returnfield WHERE returnfield_string LIKE ?";
        this.logMetacat.info((Object)("DBQuery.getXmlReturnfieldsTableId - ReturnField Query:" + query));
        try {
            pstmt = dbconn.prepareStatement(query);
            pstmt.setString(1, returnfield);
            dbconn.increaseUsageCount(1);
            pstmt.execute();
            rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            if (tableHasRows) {
                id = rs.getInt(1);
                count = rs.getInt(2) + 1;
                rs.close();
                pstmt.close();
                query = "UPDATE xml_returnfield SET usage_count = ? WHERE returnfield_id = ?";
                this.logMetacat.info((Object)("DBQuery.getXmlReturnfieldsTableId - ReturnField Table Update:" + query));
                pstmt = dbconn.prepareStatement(query);
                pstmt.setInt(1, count);
                pstmt.setInt(2, id);
                dbconn.increaseUsageCount(1);
                pstmt.execute();
                pstmt.close();
            } else {
                rs.close();
                pstmt.close();
                query = "INSERT INTO xml_returnfield (returnfield_string, usage_count)VALUES (?, '1')";
                this.logMetacat.info((Object)("DBQuery.getXmlReturnfieldsTableId - ReturnField Table Insert:" + query));
                pstmt = dbconn.prepareStatement(query);
                pstmt.setString(1, returnfield);
                dbconn.increaseUsageCount(1);
                pstmt.execute();
                pstmt.close();
                query = "SELECT returnfield_id FROM xml_returnfield WHERE returnfield_string LIKE ?";
                this.logMetacat.info((Object)("DBQuery.getXmlReturnfieldsTableId - ReturnField query after Insert:" + query));
                pstmt = dbconn.prepareStatement(query);
                pstmt.setString(1, returnfield);
                dbconn.increaseUsageCount(1);
                pstmt.execute();
                rs = pstmt.getResultSet();
                id = rs.next() ? rs.getInt(1) : -1;
                rs.close();
                pstmt.close();
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("DBQuery.getXmlReturnfieldsTableId - Error getting id from xml_returnfield in DBQuery.getXmlReturnfieldsTableId: " + e.getMessage()));
            id = -1;
        }
        this.returnfield_id = id;
        return count;
    }

    private ResultDocumentSet addReturnfield(ResultDocumentSet docListResult, QuerySpecification qspec, String user, String[] groups, DBConnection dbconn, boolean useXMLIndex, String qformat) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String docid = null;
        String fieldname = null;
        String fieldtype = null;
        String fielddata = null;
        Object relation = null;
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        if (qspec.containsExtendedSQL()) {
            qspec.setUserName(user);
            qspec.setGroup(groups);
            Vector extendedFields = new Vector(qspec.getReturnFieldList());
            Vector results = new Vector();
            Iterator keylist = docListResult.getDocids();
            StringBuffer doclist = new StringBuffer();
            ArrayList<Object> doclistValues = new ArrayList<Object>();
            Vector parentidList = new Vector();
            Hashtable returnFieldValue = new Hashtable();
            while (keylist.hasNext()) {
                String key = (String)keylist.next();
                doclist.append("?,");
                doclistValues.add(key);
            }
            if (doclist.length() > 0) {
                Hashtable controlPairs = new Hashtable();
                doclist.deleteCharAt(doclist.length() - 1);
                boolean tableHasRows = false;
                String extendedQuery = qspec.printExtendedSQL(doclist.toString(), useXMLIndex, parameterValues, doclistValues);
                this.logMetacat.info((Object)("DBQuery.addReturnfield - Extended query: " + extendedQuery));
                if (extendedQuery != null) {
                    pstmt = dbconn.prepareStatement(extendedQuery);
                    pstmt = DBQuery.setPreparedStatementValues(parameterValues, pstmt);
                    dbconn.increaseUsageCount(1);
                    pstmt.execute();
                    rs = pstmt.getResultSet();
                    tableHasRows = rs.next();
                    while (tableHasRows) {
                        ReturnFieldValue returnValue = new ReturnFieldValue();
                        docid = rs.getString(1).trim();
                        fieldname = rs.getString(2);
                        if (qformat.toLowerCase().trim().equals("xml")) {
                            byte[] b = rs.getBytes(3);
                            fielddata = new String(b, 0, b.length, "UTF-8");
                        } else {
                            fielddata = rs.getString(3);
                        }
                        fielddata = MetacatUtil.normalize(fielddata);
                        String parentId = rs.getString(4);
                        fieldtype = rs.getString(5);
                        StringBuffer value = new StringBuffer();
                        if (useXMLIndex || !this.containsKey(parentidList, parentId)) {
                            ReturnFieldValue existingRFV;
                            if (fieldtype != null && !fieldtype.equals("ATTRIBUTE") && (existingRFV = this.getArrayValue(parentidList, parentId)) != null && !existingRFV.getFieldType().equals("ATTRIBUTE")) {
                                fielddata = existingRFV.getFieldValue() + fielddata;
                            }
                            value.append("<param name=\"");
                            value.append(fieldname);
                            value.append("\">");
                            value.append(fielddata);
                            value.append("</param>");
                            returnValue.setDocid(docid);
                            returnValue.setFieldValue(fielddata);
                            returnValue.setFieldType(fieldtype);
                            returnValue.setXMLFieldValue(value.toString());
                            this.putInArray(parentidList, parentId, returnValue);
                        } else {
                            fielddata = this.getArrayValue(parentidList, parentId).getFieldValue() + fielddata;
                            value.append("<param name=\"");
                            value.append(fieldname);
                            value.append("\">");
                            value.append(fielddata);
                            value.append("</param>");
                            returnValue.setDocid(docid);
                            returnValue.setFieldValue(fielddata);
                            returnValue.setFieldType(fieldtype);
                            returnValue.setXMLFieldValue(value.toString());
                            parentidList.remove(parentId);
                            this.putInArray(parentidList, parentId, returnValue);
                        }
                        tableHasRows = rs.next();
                    }
                    rs.close();
                    pstmt.close();
                    Enumeration xmlFieldValue = this.getElements(parentidList).elements();
                    while (xmlFieldValue.hasMoreElements()) {
                        ReturnFieldValue object = (ReturnFieldValue)xmlFieldValue.nextElement();
                        docid = object.getDocid();
                        if (docListResult.containsDocid(docid)) {
                            String removedelement = docListResult.remove(docid);
                            docListResult.addResultDocument(new ResultDocument(docid, removedelement + object.getXMLFieldValue()));
                            continue;
                        }
                        docListResult.addResultDocument(new ResultDocument(docid, object.getXMLFieldValue()));
                    }
                }
            }
        }
        return docListResult;
    }

    private String transformQuery(String xmlquery) {
        int index = (xmlquery = xmlquery.trim()).indexOf("?>");
        if (index != -1) {
            return xmlquery.substring(index + 2, xmlquery.length());
        }
        return xmlquery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeQueryResultIntoCache(String query, String resultXML) {
        Hashtable hashtable = queryResultCache;
        synchronized (hashtable) {
            if (queryResultCache.size() >= QUERYRESULTCACHESIZE) {
                queryResultCache.clear();
            }
            queryResultCache.put(query, resultXML);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResultXMLFromCache(String query) {
        String resultSet = null;
        Hashtable hashtable = queryResultCache;
        synchronized (hashtable) {
            try {
                this.logMetacat.info((Object)"DBQuery.getResultXMLFromCache - Get query from cache");
                resultSet = (String)queryResultCache.get(query);
            }
            catch (Exception e) {
                resultSet = null;
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearQueryResultCache() {
        Hashtable hashtable = queryResultCache;
        synchronized (hashtable) {
            queryResultCache.clear();
        }
    }

    public static PreparedStatement setPreparedStatementValues(List<Object> parameterValues, PreparedStatement pstmt) throws SQLException {
        int parameterIndex = 1;
        for (Object parameterValue : parameterValues) {
            if (parameterValue instanceof String) {
                pstmt.setString(parameterIndex, (String)parameterValue);
            } else if (parameterValue instanceof Integer) {
                pstmt.setInt(parameterIndex, (Integer)parameterValue);
            } else if (parameterValue instanceof Float) {
                pstmt.setFloat(parameterIndex, ((Float)parameterValue).floatValue());
            } else if (parameterValue instanceof Double) {
                pstmt.setDouble(parameterIndex, (Double)parameterValue);
            } else if (parameterValue instanceof Date) {
                pstmt.setTimestamp(parameterIndex, new Timestamp(((Date)parameterValue).getTime()));
            } else {
                pstmt.setObject(parameterIndex, parameterValue);
            }
            ++parameterIndex;
        }
        return pstmt;
    }

    private boolean containsKey(Vector parentidList, String parentId) {
        Vector tempVector = null;
        for (int count = 0; count < parentidList.size(); ++count) {
            tempVector = (Vector)parentidList.get(count);
            if (parentId.compareTo((String)tempVector.get(0)) != 0) continue;
            return true;
        }
        return false;
    }

    private void putInArray(Vector parentidList, String key, ReturnFieldValue value) {
        Vector tempVector = null;
        String fieldType = value.getFieldType();
        if (fieldType != null && !fieldType.equals("ATTRIBUTE")) {
            for (int count = 0; count < parentidList.size(); ++count) {
                tempVector = (Vector)parentidList.get(count);
                if (key.compareTo((String)tempVector.get(0)) != 0) continue;
                tempVector.remove(1);
                tempVector.add(1, value);
                return;
            }
        }
        tempVector = new Vector();
        tempVector.add(0, key);
        tempVector.add(1, value);
        parentidList.add(tempVector);
    }

    private ReturnFieldValue getArrayValue(Vector parentidList, String key) {
        Vector tempVector = null;
        for (int count = 0; count < parentidList.size(); ++count) {
            tempVector = (Vector)parentidList.get(count);
            if (key.compareTo((String)tempVector.get(0)) != 0) continue;
            return (ReturnFieldValue)tempVector.get(1);
        }
        return null;
    }

    private Vector getElements(Vector parentidList) {
        Vector enumVector = new Vector();
        Vector tempVector = null;
        for (int count = 0; count < parentidList.size(); ++count) {
            tempVector = (Vector)parentidList.get(count);
            enumVector.add(tempVector.get(1));
        }
        return enumVector;
    }

    private String getOwnerQuery(String owner, List<Object> parameterValues) {
        if (owner != null) {
            owner = owner.toLowerCase();
        }
        StringBuffer self = new StringBuffer();
        self.append("SELECT docid,docname,doctype,");
        self.append("date_created, date_updated, rev ");
        self.append("FROM xml_documents WHERE docid IN (");
        self.append("(");
        self.append("SELECT DISTINCT docid FROM xml_nodes WHERE \n");
        self.append("nodedata LIKE '%%%' ");
        self.append(") \n");
        self.append(") ");
        self.append(" AND (");
        self.append(" lower(user_owner) = ?");
        self.append(") ");
        parameterValues.add(owner);
        return self.toString();
    }

    public static String createSQuery(Hashtable params) throws PropertyNotFoundException {
        int i;
        StringBuffer query = new StringBuffer();
        Object filterDoctype = null;
        String casesensitive = null;
        String searchmode = null;
        query.append("<?xml version=\"1.0\"?>\n");
        query.append("<pathquery version=\"1.2\">\n");
        if (params.containsKey("meta_file_id")) {
            query.append("<meta_file_id>");
            query.append(((String[])params.get("meta_file_id"))[0]);
            query.append("</meta_file_id>");
        }
        if (params.containsKey("returndoctype")) {
            String[] returnDoctypes = (String[])params.get("returndoctype");
            for (i = 0; i < returnDoctypes.length; ++i) {
                String doctype = returnDoctypes[i];
                if (doctype.equals("any") || doctype.equals("ANY") || doctype.equals("")) continue;
                query.append("<returndoctype>").append(doctype);
                query.append("</returndoctype>");
            }
        }
        if (params.containsKey("filterdoctype")) {
            String[] filterDoctypes = (String[])params.get("filterdoctype");
            for (i = 0; i < filterDoctypes.length; ++i) {
                query.append("<filterdoctype>").append(filterDoctypes[i]);
                query.append("</filterdoctype>");
            }
        }
        if (params.containsKey("returnfield")) {
            String[] returnfield = (String[])params.get("returnfield");
            for (i = 0; i < returnfield.length; ++i) {
                query.append("<returnfield>").append(returnfield[i]);
                query.append("</returnfield>");
            }
        }
        if (params.containsKey("owner")) {
            String[] owner = (String[])params.get("owner");
            for (i = 0; i < owner.length; ++i) {
                query.append("<owner>").append(owner[i]);
                query.append("</owner>");
            }
        }
        if (params.containsKey("site")) {
            String[] site = (String[])params.get("site");
            for (i = 0; i < site.length; ++i) {
                query.append("<site>").append(site[i]);
                query.append("</site>");
            }
        }
        if (params.containsKey("operator")) {
            query.append("<querygroup operator=\"" + ((String[])params.get("operator"))[0] + "\">");
        } else {
            query.append("<querygroup operator=\"UNION\">");
        }
        casesensitive = params.containsKey("casesensitive") ? ((String[])params.get("casesensitive"))[0] : "false";
        searchmode = params.containsKey("searchmode") ? ((String[])params.get("searchmode"))[0] : "contains";
        if (params.containsKey("anyfield")) {
            String[] anyfield = (String[])params.get("anyfield");
            for (i = 0; i < anyfield.length; ++i) {
                if (anyfield[i] == null || anyfield[i].equals("")) continue;
                query.append("<queryterm casesensitive=\"" + casesensitive + "\" searchmode=\"" + searchmode + "\"><value>" + StringEscapeUtils.escapeXml((String)anyfield[i]) + "</value></queryterm>");
            }
        }
        Enumeration elements = params.elements();
        Enumeration keys = params.keys();
        while (keys.hasMoreElements() && elements.hasMoreElements()) {
            Object nextkey = keys.nextElement();
            Object nextelement = elements.nextElement();
            Vector<String> ignoredParams = new Vector<String>();
            ignoredParams.add("returndoctype");
            ignoredParams.add("filterdoctype");
            ignoredParams.add("action");
            ignoredParams.add("qformat");
            ignoredParams.add("anyfield");
            ignoredParams.add("returnfield");
            ignoredParams.add("owner");
            ignoredParams.add("site");
            ignoredParams.add("operator");
            ignoredParams.add("sessionid");
            ignoredParams.add("pagesize");
            ignoredParams.add("pagestart");
            ignoredParams.add("searchmode");
            String paramsToIgnore = PropertyService.getProperty("database.queryignoredparams");
            StringTokenizer st = new StringTokenizer(paramsToIgnore, ",");
            while (st.hasMoreTokens()) {
                ignoredParams.add(st.nextToken());
            }
            if (ignoredParams.contains(nextkey.toString())) continue;
            for (int i2 = 0; i2 < ((String[])nextelement).length; ++i2) {
                if (((String[])nextelement)[i2].equals("")) continue;
                query.append("<queryterm casesensitive=\"" + casesensitive + "\" searchmode=\"" + searchmode + "\"><value>" + StringEscapeUtils.escapeXml((String)((String[])nextelement)[i2]) + "</value><pathexpr>" + nextkey.toString() + "</pathexpr></queryterm>");
            }
        }
        query.append("</querygroup></pathquery>");
        return query.toString();
    }

    public static String createQuery(String value, String doctype) {
        StringBuffer xmlquery = new StringBuffer();
        xmlquery.append("<?xml version=\"1.0\"?>\n");
        xmlquery.append("<pathquery version=\"1.0\">");
        if (!doctype.equals("any") && !doctype.equals("ANY")) {
            xmlquery.append("<returndoctype>");
            xmlquery.append(doctype).append("</returndoctype>");
        }
        xmlquery.append("<querygroup operator=\"UNION\">");
        if (!value.equals("")) {
            xmlquery.append("<queryterm casesensitive=\"false\" ");
            xmlquery.append("searchmode=\"contains\">");
            xmlquery.append("<value>").append(value).append("</value>");
            xmlquery.append("</queryterm>");
        }
        xmlquery.append("</querygroup>");
        xmlquery.append("</pathquery>");
        return xmlquery.toString();
    }

    public static String createQuery(String value) {
        return DBQuery.createQuery(value, "any");
    }

    private boolean hasPermission(String user, String[] groups, String docid) throws SQLException, Exception {
        PermissionController controller = new PermissionController(docid);
        return controller.hasPermission(user, groups, "READ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getCurrentDocidListForDataPackage(String dataPackageDocid) {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Vector<String> docIdList = new Vector<String>();
        Statement pStmt = null;
        ResultSet rs = null;
        String docIdInSubjectField = null;
        String docIdInObjectField = null;
        if (dataPackageDocid == null) return docIdList;
        if (dataPackageDocid.equals("")) {
            return docIdList;
        }
        String query = "SELECT subject, object from xml_relation where docId = ?";
        try {
            dbConn = DBConnectionPool.getDBConnection("DBQuery.getCurrentDocidListForDataPackage");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(1, dataPackageDocid);
            pStmt.execute();
            rs = pStmt.getResultSet();
            while (rs.next()) {
                docIdInSubjectField = rs.getString(1);
                docIdInObjectField = rs.getString(2);
                if (!docIdList.contains(docIdInSubjectField)) {
                    docIdList.add(docIdInSubjectField);
                }
                if (docIdList.contains(docIdInObjectField)) continue;
                docIdList.add(docIdInObjectField);
            }
            pStmt.close();
            return docIdList;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("DBQuery.getCurrentDocidListForDataPackage - Error in getDocidListForDataPackage: " + e.getMessage()));
            return docIdList;
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                this.logMetacat.error((Object)("DBQuery.getCurrentDocidListForDataPackage - SQL Error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    private Vector getOldVersionDocidListForDataPackage(String dataPackageDocidWithRev) {
        Vector<String> docIdList = new Vector<String>();
        Vector tripleList = null;
        String xml = null;
        if (dataPackageDocidWithRev == null || dataPackageDocidWithRev.equals("")) {
            return docIdList;
        }
        try {
            DocumentImpl packageDocument = new DocumentImpl(dataPackageDocidWithRev);
            xml = packageDocument.toString();
            TripleCollection tripleForPackage = new TripleCollection((Reader)new StringReader(xml));
            tripleList = tripleForPackage.getCollection();
            for (int i = 0; i < tripleList.size(); ++i) {
                if (!docIdList.contains(((Triple)tripleList.elementAt(i)).getSubject())) {
                    docIdList.add(((Triple)tripleList.get(i)).getSubject());
                }
                if (docIdList.contains(((Triple)tripleList.elementAt(i)).getObject())) continue;
                docIdList.add(((Triple)tripleList.get(i)).getObject());
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("DBQuery.getCurrentDocidListForDataPackage - General error: " + e.getMessage()));
        }
        return docIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDataPackageId(String docId) {
        boolean result = false;
        Statement pStmt = null;
        ResultSet rs = null;
        String query = "SELECT docId from xml_relation where docId = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBQuery.isDataPackageId");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(1, docId);
            pStmt.execute();
            rs = pStmt.getResultSet();
            if (rs.next()) {
                result = true;
            }
            pStmt.close();
            return result;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("DBQuery.isDataPackageId - SQL Error: " + e.getMessage()));
            return result;
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                this.logMetacat.error((Object)("DBQuery.isDataPackageId - SQL Error in isDataPackageId: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getQformat() {
        return this.qformat;
    }

    public void setQformat(String qformat) {
        this.qformat = qformat;
    }

    private boolean hasPermissionToExportPackage(String docId, String user, String[] groups) throws Exception {
        return DocumentImpl.hasReadPermission(user, groups, docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCurrentRevFromXMLDoumentsTable(String docId) throws SQLException {
        int rev = -5;
        Statement pStmt = null;
        ResultSet rs = null;
        String query = "SELECT rev from xml_documents where docId = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBQuery.getCurrentRevFromXMLDocumentsTable");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement(query);
            pStmt.setString(1, docId);
            pStmt.execute();
            rs = pStmt.getResultSet();
            if (rs.next()) {
                rev = rs.getInt(1);
                return rev;
            }
            rev = -5;
            return rev;
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("DBQuery.getCurrentRevFromXMLDoumentsTable - SQL Error: " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                pStmt.close();
            }
            catch (SQLException ee) {
                this.logMetacat.error((Object)("DBQuery.getCurrentRevFromXMLDoumentsTable - SQL Error: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    private void addDocToZipOutputStream(DocumentImpl docImpl, ZipOutputStream zipOut, String packageZipEntry) throws ClassNotFoundException, IOException, SQLException, McdbException, Exception {
        byte[] byteString = null;
        ZipEntry zEntry = null;
        byteString = docImpl.getBytes();
        String fullDocId = docImpl.getDocID() + PropertyService.getProperty("document.accNumSeparator") + docImpl.getRev();
        zEntry = new ZipEntry(packageZipEntry + "/metadata/" + fullDocId);
        zEntry.setSize(byteString.length);
        zipOut.putNextEntry(zEntry);
        zipOut.write(byteString, 0, byteString.length);
        zipOut.closeEntry();
    }

    private Vector getCurrentAllDocumentImpl(Vector docIdList) throws McdbException, Exception {
        Vector<Object> documentImplList = new Vector<Object>();
        int rev = 0;
        if (docIdList.isEmpty()) {
            return documentImplList;
        }
        for (int i = 0; i < docIdList.size(); ++i) {
            try {
                String smartDocid = DocumentUtil.getSmartDocId((String)docIdList.elementAt(i));
                rev = this.getCurrentRevFromXMLDoumentsTable(smartDocid);
                if (rev == -5) {
                    documentImplList.add((String)docIdList.elementAt(i));
                    continue;
                }
                String docidPlusVersion = smartDocid + PropertyService.getProperty("document.accNumSeparator") + rev;
                DocumentImpl documentImplObject = new DocumentImpl(docidPlusVersion);
                documentImplList.add(documentImplObject);
                continue;
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("DBQuery.getCurrentAllDocumentImpl - General error: " + e.getMessage()));
            }
        }
        return documentImplList;
    }

    private Vector getOldVersionAllDocumentImpl(Vector docIdList) {
        Vector<Object> documentImplList = new Vector<Object>();
        Object siteCode = null;
        Object uniqueId = null;
        boolean rev = false;
        if (docIdList.isEmpty()) {
            return documentImplList;
        }
        for (int i = 0; i < docIdList.size(); ++i) {
            String docidPlusVersion = (String)docIdList.elementAt(i);
            try {
                DocumentImpl documentImplObject = new DocumentImpl(docidPlusVersion);
                documentImplList.add(documentImplObject);
                continue;
            }
            catch (McdbDocNotFoundException notFoundE) {
                this.logMetacat.error((Object)("DBQuery.getOldVersionAllDocument - Error finding doc " + docidPlusVersion + " : " + notFoundE.getMessage()));
                documentImplList.add(docidPlusVersion);
                continue;
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("DBQuery.getOldVersionAllDocument - General error: " + e.getMessage()));
            }
        }
        return documentImplList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataFileToZipOutputStream(DocumentImpl docImpl, ZipOutputStream zipOut, String packageZipEntry) throws ClassNotFoundException, IOException, SQLException, McdbException, Exception {
        Object byteString = null;
        ZipEntry zEntry = null;
        String filePath = PropertyService.getProperty("application.datafilepath");
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        String fileName = docImpl.getDocID() + PropertyService.getProperty("document.accNumSeparator") + docImpl.getRev();
        String entityName = docImpl.getDocname();
        filePath = filePath + fileName;
        zEntry = new ZipEntry(packageZipEntry + "/data/" + fileName + "-" + entityName);
        zipOut.putNextEntry(zEntry);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filePath);
            byte[] buf = new byte[4096];
            int b = fin.read(buf);
            while (b != -1) {
                zipOut.write(buf, 0, b);
                b = fin.read(buf);
            }
            fin.close();
            zipOut.closeEntry();
        }
        catch (IOException ioe) {
            try {
                this.logMetacat.error((Object)("DBQuery.addDataFileToZipOutputStream - I/O error: " + ioe.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    private void addHtmlSummaryToZipOutputStream(Vector docImplList, ZipOutputStream zipOut, String packageZipEntry) throws Exception {
        StringBuffer htmlDoc = new StringBuffer();
        ZipEntry zEntry = null;
        byte[] byteString = null;
        DBTransform xmlToHtml = new DBTransform();
        htmlDoc.append("<html><head></head><body>");
        for (int i = 0; i < docImplList.size(); ++i) {
            String dataFileid;
            if (docImplList.elementAt(i).getClass().toString().equals("class java.lang.String")) {
                htmlDoc.append("<a href=\"");
                dataFileid = (String)docImplList.elementAt(i);
                htmlDoc.append("./data/").append(dataFileid).append("\">");
                htmlDoc.append("Data File: ");
                htmlDoc.append(dataFileid).append("</a><br>");
                htmlDoc.append("<br><hr><br>");
                continue;
            }
            if (((DocumentImpl)docImplList.elementAt(i)).getDoctype().compareTo("BIN") != 0) {
                htmlDoc.append("<h2>");
                htmlDoc.append(((DocumentImpl)docImplList.elementAt(i)).getDocID());
                htmlDoc.append("</h2>");
                StringWriter docString = new StringWriter();
                xmlToHtml.transformXMLDocument(((DocumentImpl)docImplList.elementAt(i)).toString(), ((DocumentImpl)docImplList.elementAt(i)).getDoctype(), "-//W3C//HTML//EN", this.qformat, docString, null, null);
                htmlDoc.append(((Object)docString).toString());
                htmlDoc.append("<br><br><hr><br><br>");
                continue;
            }
            htmlDoc.append("<a href=\"");
            dataFileid = ((DocumentImpl)docImplList.elementAt(i)).getDocID();
            htmlDoc.append("./data/").append(dataFileid).append("\">");
            htmlDoc.append("Data File: ");
            htmlDoc.append(dataFileid).append("</a><br>");
            htmlDoc.append("<br><hr><br>");
        }
        htmlDoc.append("</body></html>");
        byteString = htmlDoc.toString().getBytes("UTF-8");
        zEntry = new ZipEntry(packageZipEntry + "/metadata.html");
        zEntry.setSize(byteString.length);
        zipOut.putNextEntry(zEntry);
        zipOut.write(byteString, 0, byteString.length);
        zipOut.closeEntry();
    }

    public ZipOutputStream getZippedPackage(String docIdString, ServletOutputStream out, String user, String[] groups, String passWord) throws ClassNotFoundException, IOException, SQLException, McdbException, NumberFormatException, Exception {
        ZipOutputStream zOut = null;
        Object elementDocid = null;
        DocumentImpl docImpls = null;
        Vector docIdList = new Vector();
        Vector documentImplList = new Vector();
        Vector<Object> htmlDocumentImplList = new Vector<Object>();
        String packageId = null;
        String rootName = "package";
        String docId = null;
        int version = -5;
        docId = DocumentUtil.getDocIdFromString(docIdString);
        version = DocumentUtil.getVersionFromString(docIdString);
        if (!this.isDataPackageId(docId)) {
            if (!this.hasPermissionToExportPackage(docId, user, groups)) {
                Exception e = new Exception("User " + user + " does not have permission to export the data package " + docIdString);
                throw e;
            }
            docImpls = new DocumentImpl(docIdString);
            if (DocumentImpl.hasReadPermission(user, groups, docImpls.getDocID())) {
                zOut = new ZipOutputStream((OutputStream)out);
                if (docImpls.getDoctype().compareTo("BIN") != 0) {
                    this.addDocToZipOutputStream(docImpls, zOut, rootName);
                } else {
                    this.addDataFileToZipOutputStream(docImpls, zOut, rootName);
                    htmlDocumentImplList.add(docImpls);
                }
            }
            zOut.finish();
            return zOut;
        }
        if (!this.hasPermissionToExportPackage(docIdString, user, groups)) {
            Exception e = new Exception("User " + user + " does not have permission to export the data package " + docIdString);
            throw e;
        }
        packageId = docId;
        int currentVersion = this.getCurrentRevFromXMLDoumentsTable(packageId);
        if (version == -1 || version == currentVersion) {
            version = currentVersion;
            rootName = packageId + PropertyService.getProperty("document.accNumSeparator") + version + PropertyService.getProperty("document.accNumSeparator") + "package";
            docIdList = this.getCurrentDocidListForDataPackage(packageId);
            documentImplList = this.getCurrentAllDocumentImpl(docIdList);
        } else {
            if (version > currentVersion || version < -1) {
                throw new Exception("The user specified docid: " + docId + "." + version + " doesn't exist");
            }
            rootName = docIdString + PropertyService.getProperty("document.accNumSeparator") + "package";
            docIdList = this.getOldVersionDocidListForDataPackage(docIdString);
            documentImplList = this.getOldVersionAllDocumentImpl(docIdList);
        }
        if (documentImplList.isEmpty()) {
            throw new Exception("Couldn't find component for data package: " + packageId);
        }
        zOut = new ZipOutputStream((OutputStream)out);
        for (int i = 0; i < documentImplList.size(); ++i) {
            if (documentImplList.elementAt(i).getClass().toString().equals("class java.lang.String")) {
                String documentId = (String)documentImplList.elementAt(i);
                this.logMetacat.info((Object)("DBQuery.getZippedPackage - docid: " + documentId));
                String docidWithoutRevision = DocumentUtil.getDocIdFromString(documentId);
                this.logMetacat.info((Object)("DBQuery.getZippedPackage - docidWithoutRevsion: " + docidWithoutRevision));
                String revision = DocumentUtil.getRevisionStringFromString(documentId);
                this.logMetacat.info((Object)("DBQuery.getZippedPackage - revision from docIdentifier: " + revision));
                String zipEntryPath = rootName + "/data/";
                RemoteDocument remoteDoc = new RemoteDocument(docidWithoutRevision, revision, user, passWord, zipEntryPath);
                String docType = remoteDoc.getDocType();
                if (docType == null || !docType.equals("BIN")) continue;
                remoteDoc.readDocumentFromRemoteServerByZip(zOut);
                String elementInHtmlList = remoteDoc.getDocIdWithoutRevsion() + PropertyService.getProperty("document.accNumSeparator") + remoteDoc.getRevision();
                htmlDocumentImplList.add(elementInHtmlList);
                continue;
            }
            docImpls = (DocumentImpl)documentImplList.elementAt(i);
            String fullDocId = docImpls.getDocID() + PropertyService.getProperty("document.accNumSeparator") + docImpls.getRev();
            if (!DocumentImpl.hasReadPermission(user, groups, fullDocId)) continue;
            if (docImpls.getDoctype().compareTo("BIN") != 0) {
                this.addDocToZipOutputStream(docImpls, zOut, rootName);
                htmlDocumentImplList.add(docImpls);
                continue;
            }
            this.addDataFileToZipOutputStream(docImpls, zOut, rootName);
            htmlDocumentImplList.add(docImpls);
        }
        this.addHtmlSummaryToZipOutputStream(htmlDocumentImplList, zOut, rootName);
        zOut.finish();
        return zOut;
    }

    static {
        int qryRsltCacheSize = 0;
        try {
            qryRsltCacheSize = Integer.parseInt(PropertyService.getProperty("database.queryresultCacheSize"));
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get QUERYRESULTCACHESIZE property in static block: " + pnfe.getMessage());
        }
        QUERYRESULTCACHESIZE = qryRsltCacheSize;
    }

    private class ResultDocumentSet {
        private Vector docids = new Vector();
        private Vector documents = new Vector();

        public void addResultDocument(ResultDocument rd) {
            if (rd.docid == null) {
                return;
            }
            if (rd.document == null) {
                rd.document = "";
            }
            this.docids.addElement(rd.docid);
            this.documents.addElement(rd.document);
        }

        public Iterator getDocids() {
            return this.docids.iterator();
        }

        public Iterator getDocuments() {
            return this.documents.iterator();
        }

        public int size() {
            return this.docids.size();
        }

        private boolean containsDocid(String docid) {
            for (int i = 0; i < this.docids.size(); ++i) {
                String docid0 = (String)this.docids.elementAt(i);
                if (!docid0.trim().equals(docid.trim())) continue;
                return true;
            }
            return false;
        }

        public String remove(String docid) {
            for (int i = 0; i < this.docids.size(); ++i) {
                String docid0 = (String)this.docids.elementAt(i);
                if (!docid0.trim().equals(docid.trim())) continue;
                String returnDoc = (String)this.documents.elementAt(i);
                this.documents.remove(i);
                this.docids.remove(i);
                return returnDoc;
            }
            return null;
        }

        public void put(ResultDocument rd) {
            this.addResultDocument(rd);
        }

        public void put(String docid, String document) {
            this.addResultDocument(new ResultDocument(docid, document));
        }

        public Object get(String docid) {
            for (int i = 0; i < this.docids.size(); ++i) {
                String docid0 = (String)this.docids.elementAt(i);
                if (!docid0.trim().equals(docid.trim())) continue;
                return this.documents.elementAt(i);
            }
            return null;
        }

        public Object get(Object o) {
            return this.get((String)o);
        }

        public ResultDocument get(int index) {
            return new ResultDocument((String)this.docids.elementAt(index), (String)this.documents.elementAt(index));
        }

        public String toString() {
            String s = "";
            for (int i = 0; i < this.docids.size(); ++i) {
                s = s + (String)this.docids.elementAt(i) + "\n";
            }
            return s;
        }

        public void set(String docid, String document) {
            for (int i = 0; i < this.docids.size(); ++i) {
                String docid0 = (String)this.docids.elementAt(i);
                if (!docid0.trim().equals(docid.trim())) continue;
                this.documents.set(i, document);
            }
        }
    }

    private class ResultDocument {
        public String docid;
        public String document;

        public ResultDocument(String docid, String document) {
            this.docid = docid;
            this.document = document;
        }
    }

    private class ReturnFieldValue {
        private String docid = null;
        private String fieldValue = null;
        private String xmlFieldValue = null;
        private String fieldType = null;

        private ReturnFieldValue() {
        }

        public void setDocid(String myDocid) {
            this.docid = myDocid;
        }

        public String getDocid() {
            return this.docid;
        }

        public void setFieldValue(String myValue) {
            this.fieldValue = myValue;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public void setXMLFieldValue(String xml) {
            this.xmlFieldValue = xml;
        }

        public String getXMLFieldValue() {
            return this.xmlFieldValue;
        }

        public void setFieldType(String myType) {
            this.fieldType = myType;
        }

        public String getFieldType() {
            return this.fieldType;
        }
    }
}

