/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.BasicNode;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class DBSAXNode
extends BasicNode {
    private DBConnection connection;
    private DBSAXNode parentNode;
    private Log logMetacat = LogFactory.getLog(DBSAXNode.class);

    public DBSAXNode(DBConnection conn, String docid) throws SAXException {
        this.connection = conn;
        this.parentNode = null;
        this.writeChildNodeToDB("DOCUMENT", null, null, docid);
        this.updateRootNodeID(this.getNodeID());
    }

    public DBSAXNode(DBConnection conn, String qName, String lName, DBSAXNode parentNode, long rootnodeid, String docid, String doctype) throws SAXException {
        super(lName);
        this.connection = conn;
        this.parentNode = parentNode;
        this.setParentID(parentNode.getNodeID());
        this.setRootNodeID(rootnodeid);
        this.setDocID(docid);
        this.setNodeIndex(parentNode.incChildNum());
        this.writeChildNodeToDB("ELEMENT", qName, null, docid);
    }

    public DBSAXNode(DBConnection conn, String docName, String publicId, String systemId, DBSAXNode parentNode, long rootnodeid, String docid) throws SAXException {
        this.connection = conn;
        this.parentNode = parentNode;
        this.setParentID(parentNode.getNodeID());
        this.setRootNodeID(rootnodeid);
        this.setDocID(docid);
        if (systemId != null) {
            if (docName != null) {
                this.setNodeIndex(parentNode.incChildNum());
                this.writeDTDNodeToDB("docname", docName, docid);
            }
            if (publicId != null) {
                this.setNodeIndex(parentNode.incChildNum());
                this.writeDTDNodeToDB("publicid", publicId, docid);
            }
            this.setNodeIndex(parentNode.incChildNum());
            this.writeDTDNodeToDB("systemid", systemId, docid);
        }
    }

    public long writeChildNodeToDB(String nodetype, String nodename, String data, String docid) throws SAXException {
        String limitedData = null;
        int leftover = 0;
        if (data != null) {
            leftover = data.length();
        }
        int offset = 0;
        boolean moredata = true;
        long endNodeId = -1L;
        while (moredata) {
            if (leftover > 4000) {
                limitedData = data.substring(offset, 4000);
                leftover -= 3999;
                offset += 3999;
            } else {
                limitedData = data != null ? data.substring(offset, offset + leftover) : null;
                moredata = false;
            }
            endNodeId = this.writeChildNodeToDBDataLimited(nodetype, nodename, limitedData, docid);
        }
        return endNodeId;
    }

    public long writeChildNodeToDBDataLimited(String nodetype, String nodename, String data, String docid) throws SAXException {
        long nid = -1L;
        try {
            int idx;
            PreparedStatement pstmt;
            if (nodetype == "DOCUMENT") {
                pstmt = this.connection.prepareStatement("INSERT INTO xml_nodes (nodetype, nodename, nodeprefix, docid) VALUES (?, ?, ?, ?)");
                this.logMetacat.debug((Object)("DBSAXNode.writeChildNodeToDBDataLimited - inserting doc name: " + nodename));
            } else {
                pstmt = this.connection.prepareStatement("INSERT INTO xml_nodes (nodetype, nodename, nodeprefix, docid, rootnodeid, parentnodeid, nodedata, nodeindex) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            }
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, nodetype);
            if (nodename != null && (idx = nodename.indexOf(":")) != -1) {
                pstmt.setString(2, nodename.substring(idx + 1));
                pstmt.setString(3, nodename.substring(0, idx));
            } else {
                pstmt.setString(2, nodename);
                pstmt.setString(3, null);
            }
            pstmt.setString(4, docid);
            if (nodetype != "DOCUMENT") {
                if (nodetype == "ELEMENT") {
                    pstmt.setLong(5, this.getRootNodeID());
                    pstmt.setLong(6, this.getParentID());
                    pstmt.setString(7, data);
                    pstmt.setInt(8, this.getNodeIndex());
                } else {
                    pstmt.setLong(5, this.getRootNodeID());
                    pstmt.setLong(6, this.getNodeID());
                    pstmt.setString(7, data);
                    pstmt.setInt(8, this.incChildNum());
                }
            }
            this.logMetacat.debug((Object)("DBSAXNode.writeChildNodeToDBDataLimited - SQL insert: " + pstmt.toString()));
            pstmt.execute();
            pstmt.close();
            nid = DatabaseService.getInstance().getDBAdapter().getUniqueID(this.connection.getConnections(), "xml_nodes");
            if (nodetype.equals("DOCUMENT")) {
                this.setRootNodeID(nid);
            }
            if (nodetype.equals("DOCUMENT") || nodetype.equals("ELEMENT")) {
                this.setNodeID(nid);
                this.setNodeType(nodetype);
            }
        }
        catch (SQLException sqle) {
            this.logMetacat.error((Object)("DBSAXNode.writeChildNodeToDBDataLimited - SQL error inserting node: (" + nodetype + ", " + nodename + ", " + data + ") : " + sqle.getMessage()));
            sqle.printStackTrace(System.err);
            throw new SAXException(sqle.getMessage());
        }
        return nid;
    }

    public void updateRootNodeID(long nodeid) throws SAXException {
        try {
            PreparedStatement pstmt = this.connection.prepareStatement("UPDATE xml_nodes set rootnodeid = ? WHERE nodeid = ?");
            this.connection.increaseUsageCount(1);
            pstmt.setLong(1, nodeid);
            pstmt.setLong(2, nodeid);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            System.out.println("Error in DBSaxNode.updateRootNodeID: " + e.getMessage());
            throw new SAXException(e.getMessage());
        }
    }

    public void writeNodename(String nodename) throws SAXException {
        try {
            PreparedStatement pstmt = this.connection.prepareStatement("UPDATE xml_nodes set nodename = ? WHERE nodeid = ?");
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, nodename);
            pstmt.setLong(2, this.getNodeID());
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            System.out.println("Error in DBSaxNode.writeNodeName: " + e.getMessage());
            throw new SAXException(e.getMessage());
        }
    }

    public long writeDTDNodeToDB(String nodename, String data, String docid) throws SAXException {
        long nid = -1L;
        try {
            this.logMetacat.info((Object)("DBSAXNode.writeDTDNodeToDB - Insert dtd into db: " + nodename + " " + data));
            PreparedStatement pstmt = this.connection.prepareStatement("INSERT INTO xml_nodes (nodetype, nodename, docid, rootnodeid, parentnodeid, nodedata, nodeindex) VALUES (?, ?, ?, ?, ?, ?, ?)");
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, "DTD");
            pstmt.setString(2, nodename);
            pstmt.setString(3, docid);
            pstmt.setLong(4, this.getRootNodeID());
            pstmt.setLong(5, this.getParentID());
            pstmt.setString(6, data);
            pstmt.setInt(7, this.getNodeIndex());
            pstmt.execute();
            pstmt.close();
            nid = DatabaseService.getInstance().getDBAdapter().getUniqueID(this.connection.getConnections(), "xml_nodes");
        }
        catch (SQLException e) {
            System.out.println("Error in DBSaxNode.writeDTDNodeToDB");
            System.err.println("Error inserting node: (DTD, " + nodename + ", " + data + ")");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            throw new SAXException(e.getMessage());
        }
        return nid;
    }

    private long generateNodeID() throws SAXException {
        long nid = 0L;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBSAXNode.generateNodeID");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String sql = "SELECT xml_nodes_id_seq.nextval FROM dual";
            PreparedStatement pstmt = dbConn.prepareStatement(sql);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            if (tableHasRows) {
                nid = rs.getLong(1);
            }
            pstmt.close();
        }
        catch (SQLException e) {
            System.out.println("Error in DBSaxNode.generateNodeID: " + e.getMessage());
            throw new SAXException(e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return nid;
    }

    public long setAttribute(String attName, String attValue, String docid) throws SAXException {
        long nodeId = -1L;
        if (attName == null) {
            System.err.println("Attribute name must not be null!");
            throw new SAXException("Attribute name must not be null!");
        }
        super.setAttribute(attName, attValue);
        nodeId = this.writeChildNodeToDB("ATTRIBUTE", attName, attValue, docid);
        return nodeId;
    }

    public long setNamespace(String prefix, String uri, String docid) throws SAXException {
        long nodeId = -1L;
        if (prefix == null) {
            System.err.println("Namespace prefix must not be null!");
            throw new SAXException("Namespace prefix must not be null!");
        }
        super.setNamespace(prefix, uri);
        nodeId = this.writeChildNodeToDB("NAMESPACE", prefix, uri, docid);
        return nodeId;
    }

    public void updateNodeIndex(DBConnection conn, String docid, String doctype) throws SAXException {
        Hashtable<String, Long> pathlist = new Hashtable<String, Long>();
        boolean atStartingNode = true;
        boolean atRootDocumentNode = false;
        DBSAXNode nodePointer = this;
        StringBuffer currentPath = new StringBuffer();
        int counter = 0;
        while (!atRootDocumentNode) {
            if (atStartingNode) {
                currentPath.insert(0, nodePointer.getTagName());
                pathlist.put(currentPath.toString(), new Long(this.getNodeID()));
                ++counter;
                atStartingNode = false;
            } else {
                currentPath.insert(0, "/");
                currentPath.insert(0, nodePointer.getTagName());
                pathlist.put(currentPath.toString(), new Long(this.getNodeID()));
                ++counter;
            }
            if (!(nodePointer = nodePointer.getParentNode()).getNodeType().equals("DOCUMENT")) continue;
            currentPath.insert(0, "/");
            pathlist.put(currentPath.toString(), new Long(this.getNodeID()));
            ++counter;
            atRootDocumentNode = true;
        }
        try {
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO xml_index (nodeid, path, docid, doctype, parentnodeid) VALUES (?, ?, ?, ?, ?)");
            conn.increaseUsageCount(1);
            pstmt.setString(3, docid);
            pstmt.setString(4, doctype);
            pstmt.setLong(5, this.getParentID());
            Enumeration en = pathlist.keys();
            while (en.hasMoreElements()) {
                String path = (String)en.nextElement();
                Long nodeid = (Long)pathlist.get(path);
                pstmt.setLong(1, nodeid);
                pstmt.setString(2, path);
                pstmt.executeUpdate();
            }
            pstmt.close();
        }
        catch (SQLException sqe) {
            System.err.println("SQL Exception while inserting path to index in DBSAXNode.updateNodeIndex for document " + docid);
            System.err.println(sqe.getMessage());
            throw new SAXException(sqe.getMessage());
        }
    }

    public DBSAXNode getParentNode() {
        return this.parentNode;
    }
}

