/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DocumentIdentifier {
    private String docid = null;
    private String rev = null;
    private String uniqueId = null;
    private String siteCode = null;
    private String separator = null;

    public DocumentIdentifier(String docid) throws AccessionNumberException {
        this.docid = docid;
        try {
            this.separator = PropertyService.getProperty("document.accNumSeparator");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AccessionNumberException("Could not get property 'accNumSeparator' :" + pnfe.getMessage());
        }
        if (docid.endsWith(this.separator)) {
            throw new AccessionNumberException("Accession number cannot end with a seperator.");
        }
        if (docid.startsWith(this.separator)) {
            throw new AccessionNumberException("Accession number cannot begin with a seperator.");
        }
        this.parseDocid();
    }

    private void parseDocid() throws AccessionNumberException {
        try {
            int firstIndex = this.docid.indexOf(this.separator);
            int lastIndex = this.docid.lastIndexOf(this.separator);
            if (firstIndex != lastIndex) {
                this.rev = this.docid.substring(lastIndex + 1);
                this.uniqueId = this.docid.substring(firstIndex + 1, lastIndex);
                this.siteCode = this.docid.substring(0, firstIndex);
            } else {
                this.uniqueId = this.docid.substring(firstIndex + 1);
                this.siteCode = this.docid.substring(0, firstIndex);
                this.rev = this.getNewestRev();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new AccessionNumberException("Error in DocumentIdentifier.parseDocid(). Use accession number format as: sitecode" + this.separator + "uniqueid" + this.separator + "revisionid");
        }
        catch (SQLException e) {
            throw new AccessionNumberException("Error in DocumentIdentifier.parseDocid(). DB Error when reading revisionid");
        }
        catch (ClassNotFoundException e) {
            throw new AccessionNumberException("Error in DocumentIdentifier.parseDocid(). " + e.getMessage());
        }
        try {
            if (this.rev.equals("newest")) {
                this.rev = this.getNewestRev();
            }
        }
        catch (SQLException e) {
            throw new AccessionNumberException("Error in DocumentIdentifier.parseDocid(). DB Error when reading revisionid");
        }
        catch (ClassNotFoundException e) {
            throw new AccessionNumberException("Error in DocumentIdentifier.parseDocid(). " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewestRev() throws SQLException, ClassNotFoundException {
        Statement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("DocumentIdentifier.getNewestRev");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("select rev from xml_documents where docid like ? ");
            pstmt.setString(1, this.docid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (tablehasrows) {
                String retStr = rs.getString(1);
                pstmt.close();
                String string = retStr;
                return string;
            }
        }
        catch (SQLException e) {
            System.out.println("error in DocumentIdentifier.getNewestRev(): " + e.getMessage());
            throw e;
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        return "1";
    }

    private int countSeparator() {
        int count = 0;
        for (int i = 0; i < this.docid.length(); ++i) {
            if (this.docid.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    public String getRev() {
        return this.rev;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getIdentifier() {
        return this.siteCode + this.separator + this.uniqueId;
    }

    public String toString() {
        return this.docid;
    }

    public static void main(String[] args) {
        try {
            DocumentIdentifier d = new DocumentIdentifier(args[0]);
            System.out.println("rev: " + d.getRev());
            System.out.println("uniqueId: " + d.getUniqueId());
            System.out.println("siteCode: " + d.getSiteCode());
        }
        catch (Exception e) {
            System.out.println("error: " + e.getMessage());
        }
    }
}

