/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetacatResultSet
extends DefaultHandler {
    private Vector<Document> documents;
    private Document document;
    private String currentElement;
    private String paramName;
    private boolean inDocument = false;

    public MetacatResultSet(String s) throws Exception {
        try {
            this.documents = new Vector();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(s)), (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not parse the resultset: " + e.getMessage());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String content = new String(ch, start, length);
        if (!this.currentElement.equals("document")) {
            if (this.currentElement.equals("docid")) {
                this.document.docid = content;
            } else if (this.currentElement.equals("docname")) {
                this.document.docname = content;
            } else if (this.currentElement.equals("doctype")) {
                this.document.doctype = content;
            } else if (this.currentElement.equals("createdate")) {
                this.document.createdate = content;
            } else if (this.currentElement.equals("updatedate")) {
                this.document.updatedate = content;
            } else if (this.currentElement.equals("param")) {
                this.document.setField(this.paramName, content);
            }
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currentElement = qName;
        if (qName.equals("document")) {
            this.document = new Document();
            this.inDocument = true;
        }
        if (qName.equals("param")) {
            this.paramName = attributes.getValue("name");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("document")) {
            this.documents.add(this.document);
        }
    }

    public List getDocuments() {
        return this.documents;
    }

    public class Document {
        private Hashtable<String, String> fields = new Hashtable();
        public String docid = null;
        public String docname = null;
        public String doctype = null;
        public String createdate = null;
        public String updatedate = null;

        public String getField(String name) {
            return this.fields.get(name);
        }

        public void setField(String name, String value) {
            String val = this.fields.get(name);
            val = val != null ? val + value : value;
            this.fields.put(name, val);
        }

        public String toString() {
            String s = new String();
            s = "{docid=" + this.docid.trim() + ", docname=" + this.docname.trim() + ", doctype=" + this.doctype.trim() + ", createdate=" + this.createdate.trim() + ", updatedate=" + this.updatedate.trim();
            Enumeration<String> keys = this.fields.keys();
            while (keys.hasMoreElements()) {
                s = s + ", ";
                String name = keys.nextElement();
                String value = this.fields.get(name);
                s = s + name.trim() + "=" + value.trim();
            }
            s = s + "}";
            return s;
        }
    }
}

