/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MetacatURL {
    private String[][] params = new String[200][2];
    private Hashtable paramsHash = new Hashtable();
    private String protocol = null;
    private String host = null;
    private String url;

    public MetacatURL(String url) throws MalformedURLException {
        this.url = url;
        this.parseURL(url);
    }

    private void parseURL(String url) throws MalformedURLException {
        Object pname = null;
        Object param = null;
        String temp = "";
        boolean ampflag = true;
        boolean poundflag = false;
        int arrcount = 0;
        int protocolIndex = url.indexOf("://");
        if (protocolIndex == -1) {
            throw new MalformedURLException("Invalid URL format: no protocol provided.");
        }
        this.protocol = url.substring(0, protocolIndex);
        this.paramsHash.put("protocol", this.protocol);
        if (this.protocol.equals("http")) {
            this.params[0][0] = "httpurl";
            this.params[0][1] = url.substring(0, url.length());
            this.paramsHash.put(this.params[0][0], this.params[0][1]);
            for (int i = url.length() - 1; i > 0; --i) {
                if (url.charAt(i) == '/') {
                    i = 0;
                    continue;
                }
                String exchange = temp;
                temp = "";
                temp = temp + url.charAt(i);
                temp = temp + exchange;
            }
            this.params[1][0] = "filename";
            this.params[1][1] = temp;
            this.paramsHash.put(this.params[1][0], this.params[1][1]);
        } else {
            int hostIndex = url.indexOf("?");
            this.host = url.substring(protocolIndex + 3, hostIndex);
            this.paramsHash.put("host", this.host);
            for (int i = hostIndex + 1; i < url.length(); ++i) {
                if (url.charAt(i) == '=') {
                    if (poundflag || !ampflag) {
                        throw new MalformedURLException("metacatURL: Two parameter names not allowed in sequence");
                    }
                    this.params[arrcount][0] = temp.trim();
                    temp = "";
                    poundflag = true;
                    ampflag = false;
                    continue;
                }
                if (url.charAt(i) == '&' || i == url.length() - 1) {
                    if (i == url.length() - 1 && url.charAt(i) != '=') {
                        temp = temp + url.charAt(i);
                    }
                    if (!ampflag && poundflag) {
                        this.params[arrcount][1] = temp.trim();
                        this.paramsHash.put(this.params[arrcount][0], this.params[arrcount][1]);
                        temp = "";
                        ++arrcount;
                    } else {
                        throw new MalformedURLException("metacatURL: Two parameter values not allowed in sequence");
                    }
                    poundflag = false;
                    ampflag = true;
                    continue;
                }
                temp = temp + url.charAt(i);
            }
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String[][] getParams() {
        return this.params;
    }

    public Hashtable getHashParams() {
        return this.paramsHash;
    }

    public Object getHashParam(String paramname) {
        return this.paramsHash.get(paramname);
    }

    public String toString() {
        return this.url;
    }

    public void printHashParams() {
        Enumeration e = this.paramsHash.keys();
        System.out.println("name          value");
        System.out.println("-------------------");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.out.print(key);
            System.out.print("          ");
            System.out.println((String)this.paramsHash.get(key));
        }
    }

    public void printParams() {
        String[][] p = null;
        System.out.println("protocol: " + this.getProtocol());
        System.out.println("parameters: ");
        p = this.getParams();
        System.out.println("name          value");
        System.out.println("-------------------");
        for (int i = 0; i < p.length; ++i) {
            if (p[i][0] == null) continue;
            System.out.print(p[i][0]);
            System.out.print("          ");
            System.out.print(p[i][1]);
            System.out.println();
        }
    }

    public String[] getParam(int index) {
        String[] s = new String[]{this.params[index][0].trim(), this.params[index][1].trim()};
        return s;
    }

    public static void main(String[] args) {
        String testurl = "metacat://dev.nceas.ucsb.edu?docid=NCEAS:10&username=chad&pasword=xyz";
        String testurl2 = "http://dev.nceas.ucsb.edu/berkley/testdata.dat";
        String testurl3 = "NCEAS.1287873498.32";
        try {
            System.out.println("*********************************************");
            MetacatURL murl = new MetacatURL(testurl);
            System.out.println("protocol: " + murl.getProtocol());
            System.out.println("parameters: ");
            murl.printParams();
            murl.printHashParams();
            System.out.println("*********************************************");
            MetacatURL murl2 = new MetacatURL(testurl2);
            System.out.println("protocol: " + murl2.getProtocol());
            System.out.println("parameters: ");
            murl2.printParams();
            murl2.printHashParams();
            System.out.println("*********************************************");
            MetacatURL murl3 = new MetacatURL(testurl3);
            System.out.println("protocol: " + murl3.getProtocol());
            System.out.println("parameters: ");
            murl3.printParams();
            System.out.println("*********************************************");
        }
        catch (MalformedURLException murle) {
            System.out.println("bad url " + murle.getMessage());
        }
    }
}

