/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeRecord {
    private long _nodeid = -1L;
    private long _parentnodeid = -1L;
    private long _nodeindex = -1L;
    private String _nodename = null;
    private String _nodeprefix = null;
    private String _nodetype = null;
    private String _nodedata = null;
    private float _nodedatanumerical = -1.0f;
    private Timestamp _nodedatadate = null;
    private Log logMetacat = LogFactory.getLog(NodeRecord.class);

    public NodeRecord(long nodeid, long parentnodeid, long nodeindex, String nodetype, String nodename, String nodeprefix, String nodedata) {
        this.setNodeId(nodeid);
        this.setParentNodeId(parentnodeid);
        this.setNodeIndex(nodeindex);
        this.setNodeName(nodename);
        this.setNodePrefix(nodeprefix);
        this.setNodeType(nodetype);
        this.setNodeData(nodedata);
    }

    public NodeRecord(long nodeid, long parentnodeid, long nodeindex, String nodetype, String nodename, String nodeprefix, String nodedata, float nodedatanumerical, Timestamp nodedatadate) {
        this.setNodeId(nodeid);
        this.setParentNodeId(parentnodeid);
        this.setNodeIndex(nodeindex);
        this.setNodeName(nodename);
        this.setNodePrefix(nodeprefix);
        this.setNodeType(nodetype);
        this.setNodeData(nodedata);
        this.setNodeDataNumerical(nodedatanumerical);
        this.setNodeDataDate(nodedatadate);
    }

    public long getNodeId() {
        return this._nodeid;
    }

    public long getParentNodeId() {
        return this._parentnodeid;
    }

    public long getNodeIndex() {
        return this._nodeindex;
    }

    public String getNodeName() {
        return this._nodename;
    }

    public String getNodeType() {
        return this._nodetype;
    }

    public String getNodePrefix() {
        return this._nodeprefix;
    }

    public String getNodeData() {
        return this._nodedata;
    }

    public float getNodeDataNumerical() {
        return this._nodedatanumerical;
    }

    public Timestamp getNodeDataDate() {
        return this._nodedatadate;
    }

    public void setNodeId(long id) {
        this._nodeid = id;
    }

    public void setParentNodeId(long parentid) {
        this._parentnodeid = parentid;
    }

    public void setNodeName(String name) {
        this._nodename = name != null ? name.trim() : null;
    }

    public void setNodePrefix(String prefix) {
        this._nodeprefix = prefix != null ? prefix.trim() : null;
    }

    public void setNodeIndex(long index) {
        this._nodeindex = index;
    }

    public void setNodeType(String type) {
        this._nodetype = type != null ? type.trim() : null;
    }

    public void setNodeData(String data) {
        this._nodedata = data != null ? data.trim() : null;
    }

    public void setNodeDataNumerical(float datanumerical) {
        this._nodedatanumerical = datanumerical;
    }

    public void setNodeDataDate(Timestamp datadate) {
        this._nodedatadate = datadate;
    }

    public boolean contentEquals(NodeRecord record) {
        boolean flag = true;
        this.logMetacat.info((Object)("First nodetype: " + this._nodetype));
        this.logMetacat.info((Object)("Second nodetype: " + record.getNodeType()));
        this.logMetacat.info((Object)("First nodename: " + this._nodename));
        this.logMetacat.info((Object)("Second nodename: " + record.getNodeName()));
        this.logMetacat.info((Object)("First nodeprefix: " + this._nodeprefix));
        this.logMetacat.info((Object)("Second nodeprefix: " + record.getNodePrefix()));
        this.logMetacat.info((Object)("First nodedata: " + this._nodedata));
        this.logMetacat.info((Object)("Second nodedata: " + record.getNodeData()));
        if (this._nodename == null && record.getNodeName() != null || this._nodename != null && record.getNodeName() == null || this._nodename != null && record.getNodeName() != null && !this._nodename.equals(record.getNodeName())) {
            flag = false;
        } else if (this._nodetype == null && record.getNodeType() != null || this._nodetype != null && record.getNodeType() == null || this._nodetype != null && record.getNodeType() != null && !this._nodetype.equals(record.getNodeType())) {
            flag = false;
        } else if (this._nodeprefix == null && record.getNodePrefix() != null || this._nodeprefix != null && record.getNodePrefix() == null || this._nodeprefix != null && record.getNodePrefix() != null && !this._nodeprefix.equals(record.getNodePrefix())) {
            flag = false;
        } else if (this._nodedata == null && record.getNodeData() != null || this._nodedata != null && record.getNodeData() == null || this._nodedata != null && record.getNodeData() != null && !this._nodedata.equals(record.getNodeData())) {
            flag = false;
        }
        return flag;
    }
}

