/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteDocument {
    private MetacatClient metacat = null;
    private String docIdWithoutRevision = null;
    private String revision = null;
    private String dataSetId = null;
    private String documentHomeServerURL = null;
    private String docType = null;
    private String userName = null;
    private String passWord = null;
    private String zipEntry = null;
    private String revisionAndDocType;
    private Log logMetacat = LogFactory.getLog(RemoteDocument.class);

    public RemoteDocument(String myDocIdWithoutRevision, String myRevision, String myUserName, String myPassWord, String myZipEntryPath) throws Exception {
        this.docIdWithoutRevision = myDocIdWithoutRevision;
        this.dataSetId = DBUtil.findDataSetDocIdForGivenDocument(this.docIdWithoutRevision);
        this.documentHomeServerURL = this.getMetacatURLForGivenDocId(this.dataSetId);
        this.metacat = (MetacatClient)MetacatFactory.createMetacatConnection(this.documentHomeServerURL);
        this.getRevisionAndDocTypeString();
        this.revision = myRevision;
        if (this.revision == null || this.revision.equals("")) {
            this.revision = this.setRevision();
        }
        this.docType = this.setDocType();
        this.userName = myUserName;
        this.passWord = myPassWord;
        this.zipEntry = myZipEntryPath + this.docIdWithoutRevision + PropertyService.getProperty("document.accNumSeparator") + this.revision;
    }

    public String getDocIdWithoutRevsion() {
        return this.docIdWithoutRevision;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getDocType() {
        return this.docType;
    }

    private String setRevision() {
        String revision = null;
        int index = -1;
        if (this.revisionAndDocType == null || this.revisionAndDocType.equals("")) {
            revision = "1";
        } else {
            index = this.revisionAndDocType.indexOf(";");
            revision = this.revisionAndDocType.substring(0, index);
            if (revision == null || revision.equals("")) {
                revision = "1";
            }
        }
        return revision;
    }

    private String setDocType() {
        String remoteDocType = null;
        int index = -1;
        if (this.revisionAndDocType == null || this.revisionAndDocType.equals("")) {
            remoteDocType = null;
        } else {
            index = this.revisionAndDocType.indexOf(";");
            remoteDocType = this.revisionAndDocType.substring(index + 1);
        }
        return remoteDocType;
    }

    private String getMetacatURLForGivenDocId(String givenDocId) throws Exception {
        DocumentImpl document = null;
        String replicationDocHomeServer = null;
        String metacatURL = null;
        if (givenDocId == null || givenDocId.equals("")) {
            throw new Exception("Couldn't find a dataset docid for the required id");
        }
        String accNumber = givenDocId + PropertyService.getProperty("document.accNumSeparator") + DBUtil.getLatestRevisionInDocumentTable(givenDocId);
        document = new DocumentImpl(accNumber, false);
        replicationDocHomeServer = document.getDocHomeServer();
        if (replicationDocHomeServer.equals(MetacatUtil.getLocalReplicationServerName())) {
            throw new Exception("Couldn't find the docid: " + this.docIdWithoutRevision + "." + this.revision);
        }
        int index = replicationDocHomeServer.indexOf("replication");
        String subString = replicationDocHomeServer.substring(0, index);
        metacatURL = "https://" + subString + "metacat";
        this.logMetacat.info((Object)("metacatURL: " + metacatURL));
        return metacatURL;
    }

    private void getRevisionAndDocTypeString() {
        Properties prop = new Properties();
        prop.put("action", "getrevisionanddoctype");
        prop.put("docid", this.docIdWithoutRevision);
        String response = this.getMetacatString(prop);
        if (response.indexOf("<error>") != -1) {
            response = null;
        }
        this.revisionAndDocType = response != null ? response.trim() : response;
    }

    public void readDocumentFromRemoteServer(ServletOutputStream outPut) throws Exception {
        Properties prop = new Properties();
        String qformat = "xml";
        String action = "read";
        InputStream remoteResponse = null;
        if (this.docIdWithoutRevision == null || this.docIdWithoutRevision.equals("")) {
            throw new Exception("User didn't specify the required docid");
        }
        String specifiedDocId = this.docIdWithoutRevision + PropertyService.getProperty("document.accNumSeparator") + this.revision;
        this.logMetacat.info((Object)("The requried docid is: " + specifiedDocId));
        this.logIn(this.userName, this.passWord);
        prop.put("action", action);
        prop.put("qformat", qformat);
        prop.put("docid", specifiedDocId);
        remoteResponse = this.getMetacatInputStream(prop);
        byte[] buf = new byte[4096];
        int index = remoteResponse.read(buf);
        while (index != -1) {
            outPut.write(buf, 0, index);
            index = remoteResponse.read(buf);
        }
        if (remoteResponse != null) {
            remoteResponse.close();
        }
    }

    public void readDocumentFromRemoteServerByZip(ZipOutputStream outPut) throws Exception {
        Properties prop = new Properties();
        String qformat = "xml";
        String action = "read";
        InputStream remoteResponse = null;
        if (this.docIdWithoutRevision == null || this.docIdWithoutRevision.equals("")) {
            throw new Exception("User didn't specify the required docid");
        }
        String specifiedDocId = this.docIdWithoutRevision + PropertyService.getProperty("document.accNumSeparator") + this.revision;
        this.logMetacat.info((Object)("The requried docid is: " + specifiedDocId));
        this.logIn(this.userName, this.passWord);
        prop.put("action", action);
        prop.put("qformat", qformat);
        prop.put("docid", specifiedDocId);
        remoteResponse = this.getMetacatInputStream(prop);
        ZipEntry zentry = new ZipEntry(this.zipEntry);
        outPut.putNextEntry(zentry);
        byte[] buf = new byte[4096];
        int index = remoteResponse.read(buf);
        while (index != -1) {
            outPut.write(buf, 0, index);
            index = remoteResponse.read(buf);
        }
        if (remoteResponse != null) {
            remoteResponse.close();
        }
        outPut.closeEntry();
    }

    private void logIn(String userName, String passWord) {
        if (userName == null || passWord == null || userName.equals("") || passWord.equals("")) {
            return;
        }
        Properties prop = new Properties();
        prop.put("action", "login");
        prop.put("qformat", "xml");
        prop.put("username", userName);
        prop.put("password", passWord);
        String response = this.getMetacatString(prop);
        this.logMetacat.info((Object)("Login Message: " + response));
    }

    private void logOut() {
        Properties prop = new Properties();
        prop.put("action", "logout");
        prop.put("qformat", "xml");
        String response = this.getMetacatString(prop);
        this.logMetacat.debug((Object)("Logout Message: " + response));
    }

    private String getMetacatString(Properties prop) {
        String response = null;
        try {
            int len;
            InputStreamReader returnStream = new InputStreamReader(this.getMetacatInputStream(prop));
            StringWriter sw = new StringWriter();
            char[] characters = new char[512];
            while ((len = returnStream.read(characters, 0, 512)) != -1) {
                sw.write(characters, 0, len);
            }
            returnStream.close();
            response = sw.toString();
            sw.close();
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Error in RemoteDocument.getMetacatString: " + e.getMessage()));
            return null;
        }
        return response;
    }

    private InputStream getMetacatInputStream(Properties prop) throws Exception {
        InputStream returnStream = this.metacat.sendParameters(prop);
        return returnStream;
    }
}

