/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.utilities.StringUtil;
import java.util.Vector;

public class Version
implements Comparable<Version> {
    protected static int allowedVersionLevels = 4;
    protected int[] subversions = new int[]{0, 0, 0, 0};
    protected String versionString = null;

    public Version(String versionID) {
        this.setSubversions(versionID);
        this.versionString = versionID;
    }

    @Override
    public int compareTo(Version anotherVersion) {
        for (int i = 0; i < allowedVersionLevels; ++i) {
            if (this.getSubversion(i) < anotherVersion.getSubversion(i)) {
                return -1;
            }
            if (this.getSubversion(i) <= anotherVersion.getSubversion(i)) continue;
            return 1;
        }
        return 0;
    }

    public int getSubversion(int level) {
        return this.subversions[level];
    }

    private void setSubversions(String versionID) throws NumberFormatException {
        Vector subversionStrings = StringUtil.toVector((String)versionID, (char)'.');
        for (int i = 0; i < subversionStrings.size() && i < allowedVersionLevels; ++i) {
            int subversion;
            this.subversions[i] = subversion = Integer.parseInt((String)subversionStrings.elementAt(i));
        }
    }

    public String getVersionString() {
        return this.versionString;
    }
}

