/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.accesscontrol;

import edu.ucsb.nceas.metacat.BasicNode;
import edu.ucsb.nceas.metacat.DBEntityResolver;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.AccessControlInterface;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AccessControlList
extends DefaultHandler
implements AccessControlInterface,
LexicalHandler {
    private DBConnection connection;
    private String parserName;
    private Stack elementStack;
    private String sep;
    private boolean processingDTD;
    private String user;
    private String[] groups;
    private String aclid;
    private int rev;
    private String docname;
    private String doctype;
    private String systemid;
    private String docurl;
    private Vector resourceURL;
    private Vector resourceID;
    private Vector principal;
    private int permission;
    private String permType;
    private String permOrder;
    private String beginTime;
    private String endTime;
    private int ticketCount;
    private int serverCode = 1;
    private Vector aclObjects = new Vector();
    private boolean instarttag = true;
    private String tagName = "";
    private static Log logMetacat = LogFactory.getLog(AccessControlList.class);

    public AccessControlList(DBConnection conn) throws SQLException {
        this.connection = conn;
    }

    public AccessControlList(DBConnection conn, String aclid, int rev, String user, String[] groups, int serverCode) throws SAXException, IOException, McdbException, PropertyNotFoundException {
        String parserName = PropertyService.getProperty("xml.saxparser");
        this.sep = PropertyService.getProperty("document.accNumSeparator");
        this.connection = conn;
        this.parserName = parserName;
        this.processingDTD = false;
        this.elementStack = new Stack();
        this.user = user;
        this.groups = groups;
        this.aclid = aclid;
        this.resourceURL = new Vector();
        this.resourceID = new Vector();
        this.principal = new Vector();
        this.permission = 0;
        this.ticketCount = 0;
        this.serverCode = serverCode;
        DocumentImpl acldoc = new DocumentImpl(aclid + this.sep + rev);
        String acl = acldoc.toString();
        this.rev = acldoc.getRev();
        XMLReader parser = this.initializeParser();
        if (acl == null) {
            throw new McdbException("Could not retrieve access control list for:  " + aclid + this.sep + rev);
        }
        parser.parse(new InputSource(new StringReader(acl)));
    }

    private XMLReader initializeParser() throws SAXException {
        XMLReader parser = null;
        parser = XMLReaderFactory.createXMLReader(this.parserName);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        parser.setContentHandler(this);
        DBEntityResolver eresolver = new DBEntityResolver(this.connection, this, null);
        parser.setEntityResolver(eresolver);
        parser.setDTDHandler(this);
        parser.setErrorHandler(this);
        return parser;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.aclObjects = this.getACLObjects(this.aclid);
            if (this.aclid != null) {
                this.deletePermissionsForRelatedResources(this.aclid);
            }
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.instarttag = true;
        if (localName.equals("allow")) {
            this.tagName = "allow";
        } else if (localName.equals("deny")) {
            this.tagName = "deny";
        }
        BasicNode currentNode = new BasicNode(localName);
        if (atts != null) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                currentNode.setAttribute(atts.getLocalName(i), atts.getValue(i));
            }
        }
        if (currentNode.getTagName().equals("acl")) {
            this.permOrder = currentNode.getAttribute("order");
        }
        this.elementStack.push(currentNode);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.instarttag) {
            return;
        }
        String inputString = new String(ch, start, length);
        inputString = inputString.trim();
        BasicNode currentNode = (BasicNode)this.elementStack.peek();
        String currentTag = currentNode.getTagName();
        if (currentTag.equals("principal")) {
            this.principal.addElement(inputString);
        } else if (currentTag.equals("permission")) {
            if (inputString.trim().toUpperCase().equals("READ")) {
                this.permission |= 4;
            } else if (inputString.trim().toUpperCase().equals("WRITE")) {
                this.permission |= 2;
            } else if (inputString.trim().toUpperCase().equals("CHANGEPERMISSION")) {
                this.permission |= 1;
            } else if (inputString.trim().toUpperCase().equals("ALL")) {
                this.permission |= 7;
            }
        } else if (currentTag.equals("startDate") && this.beginTime == null) {
            this.beginTime = inputString.trim();
        } else if (currentTag.equals("stopDate") && this.endTime == null) {
            this.endTime = inputString.trim();
        } else if (currentTag.equals("ticketCount") && this.ticketCount == 0) {
            try {
                this.ticketCount = new Integer(inputString.trim());
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Wrong integer format for:" + inputString);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.instarttag = false;
        BasicNode leaving = (BasicNode)this.elementStack.pop();
        String leavingTagName = leaving.getTagName();
        if (leavingTagName.equals("allow") || leavingTagName.equals("deny")) {
            if (this.permission > 0) {
                try {
                    for (int i = 0; i < this.aclObjects.size(); ++i) {
                        String docid = (String)this.aclObjects.elementAt(i);
                        this.insertPermissions(docid, leavingTagName);
                    }
                }
                catch (SQLException sqle) {
                    throw new SAXException(sqle);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            this.principal = new Vector();
            this.permission = 0;
            this.beginTime = null;
            this.endTime = null;
            this.ticketCount = 0;
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.processingDTD = true;
        logMetacat.debug((Object)"AccessControlList.startDTD - Setting processingDTD to true");
        logMetacat.debug((Object)"AccessControlList.startDTD - start DTD");
        this.docname = name;
        this.doctype = publicId;
        this.systemid = systemId;
    }

    @Override
    public void endDTD() throws SAXException {
        this.processingDTD = false;
        logMetacat.debug((Object)"AccessControlList.endDTD - Setting processingDTD to false");
        logMetacat.debug((Object)"AccessControlList.endDTD - end DTD");
    }

    @Override
    public void startEntity(String name) throws SAXException {
        logMetacat.debug((Object)"AccessControlList.startEntity ");
        if (name.equals("[dtd]")) {
            logMetacat.debug((Object)"AccessControlList.startEntity  set processingDTD to true.");
            this.processingDTD = true;
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        logMetacat.debug((Object)"AccessControlList.endEntity ");
        if (name.equals("[dtd]")) {
            logMetacat.debug((Object)"AccessControlList.endEntity  set processingDTD to false.");
            this.processingDTD = false;
        }
    }

    public String getDocname() {
        return this.docname;
    }

    public boolean processingDTD() {
        return this.processingDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getACLObjects(String aclid) throws SQLException {
        Vector<String> aclObjects = new Vector<String>();
        DBConnection conn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlList.getACLObject");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT object FROM xml_relation WHERE subject = ? ");
            pstmt.setString(1, aclid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRows = rs.next();
            while (hasRows) {
                String object = rs.getString(1);
                aclObjects.addElement(object);
                hasRows = rs.next();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return aclObjects;
    }

    private void deletePermissionsForRelatedResources(String aclid) throws SQLException {
        try (Statement pstmt = null;){
            String sql = "DELETE FROM xml_access WHERE accessfileid = ?";
            pstmt = this.connection.prepareStatement(sql);
            pstmt.setString(1, aclid);
            this.connection.increaseUsageCount(1);
            logMetacat.debug((Object)("running sql: " + pstmt.toString()));
            pstmt.execute();
        }
    }

    private void insertPermissions(String docid, String permType) throws SQLException {
        try (Statement pstmt = null;){
            String guid = docid;
            pstmt = this.connection.prepareStatement("INSERT INTO xml_access (guid, principal_name, permission, perm_type, perm_order,ticket_count, accessfileid) VALUES (?,?,?,?,?,?,?)");
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, guid);
            pstmt.setInt(3, this.permission);
            pstmt.setString(4, permType);
            pstmt.setString(5, this.permOrder);
            pstmt.setString(7, this.aclid);
            if (this.ticketCount > 0) {
                pstmt.setInt(6, this.ticketCount);
            } else {
                pstmt.setInt(6, 0);
            }
            for (int j = 0; j < this.principal.size(); ++j) {
                String prName = (String)this.principal.elementAt(j);
                pstmt.setString(2, prName);
                logMetacat.debug((Object)("running sql: " + pstmt.toString()));
                pstmt.execute();
            }
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPermissions(int permission, String principal, String docid, String permOrder) throws SQLException {
        Statement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlList.getPermissions");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT permission FROM xml_access WHERE docid = ? AND principal_name = ? AND perm_order NOT = ?");
            pstmt.setString(1, docid);
            pstmt.setString(2, principal);
            pstmt.setString(3, permOrder);
            logMetacat.debug((Object)("running sql: " + pstmt.toString()));
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRow = rs.next();
            int perm = 0;
            while (hasRow) {
                perm = rs.getInt(1);
                if ((perm = permission & perm) != 0) {
                    pstmt.close();
                    int n = perm;
                    return n;
                }
                hasRow = rs.next();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
        return 0;
    }

    public static int intValue(String permission) {
        int thisPermission = 0;
        try {
            thisPermission = new Integer(permission);
            if (thisPermission >= 0 && thisPermission <= 7) {
                return thisPermission;
            }
            thisPermission = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (permission.toUpperCase().contains("CHANGEPERMISSION")) {
            thisPermission |= 1;
        }
        if (permission.toUpperCase().contains("READ")) {
            thisPermission |= 4;
        }
        if (permission.toUpperCase().contains("WRITE")) {
            thisPermission |= 2;
        }
        if (permission.toUpperCase().contains("ALL")) {
            thisPermission |= 7;
        }
        return thisPermission;
    }

    public static String txtValue(int permission) {
        StringBuffer txtPerm = new StringBuffer();
        if ((permission & 7) == 7) {
            return "ALL";
        }
        if ((permission & 1) == 1) {
            txtPerm.append("CHANGEPERMISSION");
        }
        if ((permission & 4) == 4) {
            if (txtPerm.length() > 0) {
                txtPerm.append(",");
            }
            txtPerm.append("READ");
        }
        if ((permission & 2) == 2) {
            if (txtPerm.length() > 0) {
                txtPerm.append(",");
            }
            txtPerm.append("WRITE");
        }
        return txtPerm.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPublicAccess(String docid) throws SQLException {
        int publicAcc = 0;
        Statement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlList.getPublicAcces");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT public_access FROM xml_documents WHERE docid = ?");
            pstmt.setString(1, docid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                publicAcc = rs.getInt(1);
            }
            String string = publicAcc == 1 ? "yes" : "no";
            return string;
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        logMetacat.trace((Object)"AccessControlList.comment - starting comment");
    }

    @Override
    public void startCDATA() throws SAXException {
        logMetacat.trace((Object)"AccessControlList.startCDATA - starting CDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        logMetacat.trace((Object)"AccessControlList.endCDATA - end CDATA");
    }

    public static void main(String[] args) {
        System.out.println("text value for CHMOD (1): " + AccessControlList.txtValue(1));
        System.out.println("text value for READ: (4): " + AccessControlList.txtValue(4));
        System.out.println("text value for WRITE: (2): " + AccessControlList.txtValue(2));
        System.out.println("text value for ALL: (7): " + AccessControlList.txtValue(7));
        int chmod_read = 5;
        System.out.println("text value for CHMOD|READ: (" + chmod_read + "): " + AccessControlList.txtValue(5));
        int chmod_write = 3;
        System.out.println("text value for CHMOD|WRITE: (" + chmod_write + "): " + AccessControlList.txtValue(3));
        int chmod_all = 7;
        System.out.println("text value for CHMOD|ALL: (" + chmod_all + "): " + AccessControlList.txtValue(7));
        int read_write = 6;
        System.out.println("text value for READ|WRITE: (" + read_write + "): " + AccessControlList.txtValue(6));
        int read_all = 7;
        System.out.println("text value for READ|ALL: (" + read_all + "): " + AccessControlList.txtValue(7));
        int write_all = 7;
        System.out.println("text value for WRITE|ALL: (" + write_all + "): " + AccessControlList.txtValue(7));
        int chmod_read_write = 7;
        System.out.println("text value for CHMOD|READ|WRITE: (" + chmod_read_write + "): " + AccessControlList.txtValue(7));
        int chmod_read_all = 7;
        System.out.println("text value for CHMOD|READ|ALL: (" + chmod_read_all + "): " + AccessControlList.txtValue(7));
        int chmod_write_all = 7;
        System.out.println("text value for CHMOD|WRITE|ALL: (" + chmod_write_all + "): " + AccessControlList.txtValue(7));
        int read_write_all = 7;
        System.out.println("text value for READ|WRITE|ALL: (" + read_write_all + "): " + AccessControlList.txtValue(7));
        int chmod_read_write_all = 7;
        System.out.println("text value for CHMOD|READ|WRITE|ALL: (" + chmod_read_write_all + "): " + AccessControlList.txtValue(7));
        System.out.println();
        System.out.println("int value for GOOBER: " + AccessControlList.intValue("GOOBER"));
        System.out.println("int value for CHANGEPERMISSION: " + AccessControlList.intValue("CHANGEPERMISSION"));
        System.out.println("int value for READ: " + AccessControlList.intValue("READ"));
        System.out.println("int value for WRITE: " + AccessControlList.intValue("WRITE"));
        System.out.println("int value for ALL: " + AccessControlList.intValue("ALL"));
        System.out.println("int value for CHANGEPERMISSION,READ: " + AccessControlList.intValue("CHANGEPERMISSION,READ"));
        System.out.println("int value for CHANGEPERMISSION,WRITE: " + AccessControlList.intValue("CHANGEPERMISSION,WRITE"));
        System.out.println("int value for CHANGEPERMISSION,ALL: " + AccessControlList.intValue("CHANGEPERMISSION,ALL"));
        System.out.println("int value for READ,WRITE: " + AccessControlList.intValue("READ,WRITE"));
        System.out.println("int value for READ,ALL: " + AccessControlList.intValue("READ,ALL"));
        System.out.println("int value for WRITE,ALL: " + AccessControlList.intValue("WRITE,ALL"));
        System.out.println("int value for CHANGEPERMISSION,READ,WRITE: " + AccessControlList.intValue("CHANGEPERMISSION,READ,WRITE"));
        System.out.println("int value for CHANGEPERMISSION,READ,ALL: " + AccessControlList.intValue("CHANGEPERMISSION,READ,ALL"));
        System.out.println("int value for CHANGEPERMISSION,READ,ALL: " + AccessControlList.intValue("CHANGEPERMISSION,WRITE,ALL"));
        System.out.println("int value for READ,WRITE,ALL: " + AccessControlList.intValue("READ,WRITE,ALL"));
        System.out.println("int value for CHANGEPERMISSION,READ,WRITE,ALL: " + AccessControlList.intValue("CHANGEPERMISSION,READ,WRITE,ALL"));
    }
}

