/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.MetaCatServlet;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.AuthAdmin;
import edu.ucsb.nceas.metacat.admin.BackupAdmin;
import edu.ucsb.nceas.metacat.admin.D1Admin;
import edu.ucsb.nceas.metacat.admin.DBAdmin;
import edu.ucsb.nceas.metacat.admin.EZIDAdmin;
import edu.ucsb.nceas.metacat.admin.LoginAdmin;
import edu.ucsb.nceas.metacat.admin.PropertiesAdmin;
import edu.ucsb.nceas.metacat.admin.QuotaAdmin;
import edu.ucsb.nceas.metacat.admin.ReplicationAdmin;
import edu.ucsb.nceas.metacat.admin.SkinsAdmin;
import edu.ucsb.nceas.metacat.admin.SolrAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.ConfigurationUtil;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetacatAdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Log logMetacat = LogFactory.getLog(MetacatAdminServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleGetOrPost(request, response);
    }

    private void handleGetOrPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("configureType");
        this.logMetacat.info((Object)("MetacatAdminServlet.handleGetOrPost - Processing admin action: " + action));
        Vector<String> processingMessage = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        try {
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                SessionService.getInstance().touchSession(httpSession.getId());
            }
            if (!ConfigurationUtil.isBackupDirConfigured()) {
                processingMessage.add("You must configure the backup directory before you can continue with Metacat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "backup";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'backup'");
            } else if (!AuthUtil.isAuthConfigured()) {
                processingMessage.add("You must configure authentication before you can continue with MetaCat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "auth";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'auth'");
            } else if (!AuthUtil.isUserLoggedInAsAdmin(request)) {
                processingMessage.add("You must log in as an administrative user before you can continue with MetaCat configuration.");
                RequestUtil.setRequestMessage(request, processingMessage);
                action = "login";
                this.logMetacat.debug((Object)"MetacatAdminServlet.handleGetOrPost - Admin action changed to 'login'");
            }
            if (action == null || action.equals("configure")) {
                this.intitialConfigurationParameters(request);
                RequestUtil.forwardRequest(request, response, "/admin/metacat-configuration.jsp?configureType=configure", null);
                return;
            }
            if (action.equals("properties")) {
                PropertiesAdmin.getInstance().configureProperties(request, response);
                return;
            }
            if (action.equals("skins")) {
                SkinsAdmin.getInstance().configureSkins(request, response);
                return;
            }
            if (action.equals("database")) {
                DBAdmin.getInstance().configureDatabase(request, response);
                return;
            }
            if (action.equals("auth")) {
                AuthAdmin.getInstance().configureAuth(request, response);
                return;
            }
            if (action.equals("login")) {
                LoginAdmin.getInstance().authenticateUser(request, response);
                return;
            }
            if (action.equals("backup")) {
                BackupAdmin.getInstance().configureBackup(request, response);
                return;
            }
            if (action.equals("dataone")) {
                D1Admin.getInstance().configureDataONE(request, response);
                return;
            }
            if (action.equals("replication")) {
                ReplicationAdmin.getInstance().handleRequest(request, response);
                return;
            }
            if (action.equals("ezid")) {
                EZIDAdmin.getInstance().configureEZID(request, response);
                return;
            }
            if (action.equals("quota")) {
                QuotaAdmin.getInstance().configureQuota(request, response);
                return;
            }
            if (action.equals("solrserver")) {
                SolrAdmin.getInstance().configureSolr(request, response);
                return;
            }
            if (action.equals("refreshStylesheets")) {
                this.clearStylesheetCache(response);
                return;
            }
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Invalid action in configuration request: " + action;
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (GeneralPropertyException ge) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Property problem while handling request: " + ge.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (AdminException ae) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Admin problem while handling request: " + ae.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (MetacatUtilException ue) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Utility problem while handling request: " + ue.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (ServiceException e) {
            String errorMessage = "MetacatAdminServlet.handleGetOrPost - Service problem while handling request: " + e.getMessage();
            this.logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        if (processingErrors.size() > 0) {
            RequestUtil.clearRequestMessages(request);
            RequestUtil.setRequestErrors(request, processingErrors);
            try {
                this.intitialConfigurationParameters(request);
                RequestUtil.forwardRequest(request, response, "/admin/metacat-configuration.jsp?configureType=configure", null);
            }
            catch (Exception e) {
                this.logMetacat.error((Object)("MetacatAdminServlet.handleGetOrPost - couldn't forward the error message to the metacat configuration page since " + e.getMessage()));
            }
        }
    }

    private void clearStylesheetCache(HttpServletResponse response) throws IOException {
        Boolean forceRebuild = true;
        DBTransform.setForceRebuild(forceRebuild);
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        out.print("<success>");
        out.print("The style sheet cache has been cleared and they will be reload from the disk.");
        out.print("</success>");
        out.close();
    }

    private void intitialConfigurationParameters(HttpServletRequest request) throws GeneralPropertyException, AdminException, MetacatUtilException {
        if (request != null) {
            request.setAttribute("metaCatVersion", (Object)SystemUtil.getMetacatVersion());
            request.setAttribute("propsConfigured", (Object)new Boolean(PropertyService.arePropertiesConfigured()));
            request.setAttribute("authConfigured", (Object)new Boolean(AuthUtil.isAuthConfigured()));
            request.setAttribute("skinsConfigured", (Object)new Boolean(SkinUtil.areSkinsConfigured()));
            request.setAttribute("metacatConfigured", (Object)new Boolean(ConfigurationUtil.isMetacatConfigured()));
            request.setAttribute("dataoneConfigured", (Object)PropertyService.getProperty("configutil.dataoneConfigured"));
            request.setAttribute("ezidConfigured", (Object)PropertyService.getProperty("configutil.ezidConfigured"));
            request.setAttribute("quotaConfigured", (Object)PropertyService.getProperty("configutil.quotaConfigured"));
            request.setAttribute("solrserverConfigured", (Object)PropertyService.getProperty("configutil.solrserverConfigured"));
            request.setAttribute("metcatServletInitialized", (Object)MetaCatServlet.isFullyInitialized());
            if (PropertyService.arePropertiesConfigured()) {
                request.setAttribute("databaseVersion", (Object)DBAdmin.getInstance().getDBVersion());
                request.setAttribute("contextURL", (Object)SystemUtil.getContextURL());
            }
        }
    }
}

