/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.File;
import java.io.FileFilter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpgradeEmptyReplicatedDataFile
implements UpgradeUtilityInterface {
    protected static Log log = LogFactory.getLog(UpgradeEmptyReplicatedDataFile.class);
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upgrade() throws AdminException {
        boolean success = true;
        Connection sqlca = null;
        PreparedStatement pstmt = null;
        File dataDir = null;
        try {
            dataDir = new File(PropertyService.getProperty("application.datafilepath"));
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        File[] emptyFiles = dataDir.listFiles((FileFilter)EmptyFileFilter.EMPTY);
        if (emptyFiles.length == 0) {
            log.info((Object)"No empty data files found");
            return true;
        }
        ArrayList<File> processedFiles = new ArrayList<File>();
        try {
            this.driver = PropertyService.getProperty("database.driver");
            this.url = PropertyService.getProperty("database.connectionURI");
            this.user = PropertyService.getProperty("database.user");
            this.password = PropertyService.getProperty("database.password");
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            sqlca = DriverManager.getConnection(this.url, this.user, this.password);
            sqlca.setAutoCommit(false);
            for (File emptyFile : emptyFiles) {
                int count = 0;
                String emptyDocid = emptyFile.getName();
                String docid = DocumentUtil.getDocIdFromString(emptyDocid);
                String rev = DocumentUtil.getRevisionStringFromString(emptyDocid);
                pstmt = sqlca.prepareStatement("DELETE FROM xml_documents WHERE docid = ? and server_location != '1'");
                pstmt.setString(1, docid);
                count = pstmt.executeUpdate();
                pstmt = sqlca.prepareStatement("DELETE FROM xml_revisions WHERE docid = ? and server_location != '1'");
                pstmt.setString(1, docid);
                if ((count += pstmt.executeUpdate()) <= 0) continue;
                processedFiles.add(emptyFile);
            }
            sqlca.commit();
        }
        catch (Exception e) {
            try {
                sqlca.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            success = false;
        }
        finally {
            if (sqlca != null) {
                try {
                    sqlca.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (success) {
            for (File emptyFile : processedFiles) {
                log.info((Object)("Deleting empty replicated data file from filesystem: " + emptyFile.getAbsolutePath()));
                emptyFile.delete();
            }
        }
        return success;
    }

    public static void main(String[] ags) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            UpgradeEmptyReplicatedDataFile upgrader = new UpgradeEmptyReplicatedDataFile();
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

