/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchQueryTerm;
import java.util.ArrayList;

public class AdvancedSearchQueryGroup {
    private boolean includeOuterQueryGroup = true;
    private String indent;
    private final int initialLength = 500;
    private String operator;
    private StringBuffer stringBuffer;
    private ArrayList queryGroupList = new ArrayList();
    private ArrayList queryTermList = new ArrayList();

    public AdvancedSearchQueryGroup(String operator, String indent) {
        this.operator = operator;
        this.indent = indent;
        if (!operator.equals("INTERSECT") && !operator.equals("UNION")) {
            System.err.println("Invalid AdvancedSearchQueryGroup operator: " + operator);
        }
    }

    public void addQueryGroup(AdvancedSearchQueryGroup queryGroup) {
        this.queryGroupList.add(queryGroup);
    }

    public void addQueryTerm(AdvancedSearchQueryTerm queryTerm) {
        this.queryTermList.add(queryTerm);
    }

    public void setIncludeOuterQueryGroup(boolean b) {
        this.includeOuterQueryGroup = b;
    }

    public String toString() {
        int i;
        this.stringBuffer = new StringBuffer(500);
        if (this.includeOuterQueryGroup) {
            this.stringBuffer.append(this.indent + "<querygroup operator=\"" + this.operator + "\">\n");
        }
        for (i = 0; i < this.queryGroupList.size(); ++i) {
            AdvancedSearchQueryGroup queryGroup = (AdvancedSearchQueryGroup)this.queryGroupList.get(i);
            this.stringBuffer.append(queryGroup.toString());
        }
        for (i = 0; i < this.queryTermList.size(); ++i) {
            AdvancedSearchQueryTerm queryTerm = (AdvancedSearchQueryTerm)this.queryTermList.get(i);
            this.stringBuffer.append(queryTerm.toString());
        }
        if (this.includeOuterQueryGroup) {
            this.stringBuffer.append(this.indent + "</querygroup>\n");
        }
        return this.stringBuffer.toString();
    }
}

