/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

public class LTERSite {
    public String site;
    public final String[] sites = new String[]{"AND", "ARC", "BES", "BNZ", "CAP", "CCE", "CDR", "CWT", "FCE", "GCE", "HBR", "HFR", "JRN", "KBS", "KNZ", "LNO", "LUQ", "MCM", "MCR", "NTL", "NWT", "PAL", "PIE", "SBC", "SEV", "SGS", "VCR"};
    public final String[] siteKeywords = new String[]{"Andrews LTER", "Arctic LTER", "Baltimore Ecosystem Study", "Bonanza Creek", "Central Arizona - Phoenix Urban", "California Current Ecosystem", "Cedar Creek", "Coweeta", "Florida Coastal Everglades", "Georgia Coastal Ecosystems", "Hubbard Brook", "Harvard Forest", "Jornada Basin", "Kellogg Biological Station", "Konza Prairie", "LTER Network Office", "Luquillo", "McMurdo Dry Valleys", "Moorea Coral Reef", "North Temperate Lakes", "Niwot Ridge", "Palmer Station", "Plum Island Ecosystem", "Santa Barbara Coastal", "Sevilleta", "Shortgrass Steppe", "Virginia Coastal Reserve"};
    public final String[] siteNames = new String[]{"Andrews LTER", "Arctic LTER", "Baltimore Ecosystem Study", "Bonanza Creek LTER", "Central Arizona - Phoenix Urban LTER", "California Current Ecosystem", "Cedar Creek Natural History Area", "Coweeta LTER", "Florida Coastal Everglades LTER", "Georgia Coastal Ecosystems LTER", "Hubbard Brook LTER", "Harvard Forest LTER", "Jornada Basin LTER", "Kellogg Biological Station LTER", "Konza Prairie LTER", "LTER Network Office", "Luquillo LTER", "McMurdo Dry Valleys LTER", "Moorea Coral Reef", "North Temperate Lakes LTER", "Niwot Ridge LTER", "Palmer Station LTER", "Plum Island Ecosystem LTER", "Santa Barbara Coastal LTER", "Sevilleta LTER", "Shortgrass Steppe", "Virginia Coastal Reserve LTER"};

    public LTERSite(String site) {
        if (site != null) {
            this.site = site.toUpperCase();
        }
    }

    public String getPackageId() {
        String packageId = this.site == null ? "" : (this.site.equals("SEV") ? "sev." : "knb-lter-" + this.site.toLowerCase());
        return packageId;
    }

    public String getSiteKeyword() {
        String siteKeyword = "";
        if (this.isValidSite()) {
            for (int i = 0; i < this.sites.length; ++i) {
                if (!this.site.equals(this.sites[i])) continue;
                siteKeyword = this.siteKeywords[i];
                break;
            }
        }
        return siteKeyword;
    }

    public String getSystem() {
        String system = this.site == null ? "" : (this.site.equals("CAP") ? "ces_dataset" : (this.site.equals("CWT") ? "cwt-lter" : "knb"));
        return system;
    }

    public boolean isValidSite() {
        boolean isValid = false;
        if (this.site != null) {
            for (int i = 0; i < this.sites.length; ++i) {
                if (!this.site.equals(this.sites[i])) continue;
                isValid = true;
                break;
            }
        }
        return isValid;
    }
}

