/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.LoginBean;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatHelper;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatLogin;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginServlet
extends HttpServlet {
    private static final String CONFIG_DIR = "WEB-INF";
    private static final String CONFIG_NAME = "metacat.properties";
    static final long serialVersionUID = 0L;
    private String contextString = "";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher dispatcher;
        HttpSession httpSession = request.getSession();
        boolean loginSuccess = false;
        Metacat metacat = (Metacat)httpSession.getAttribute("metacat");
        ServletContext servletContext = httpSession.getServletContext();
        String metacatURL = servletContext.getInitParameter("metacatURL");
        if (metacatURL == null || metacatURL.equals("")) {
            MetacatHelper metacatHelper = new MetacatHelper();
            String serverName = request.getServerName();
            int serverPort = request.getServerPort();
            metacatURL = metacatHelper.constructMetacatURL(serverName, serverPort, this.contextString);
        }
        if (metacat == null) {
            try {
                metacat = MetacatFactory.createMetacatConnection(metacatURL);
            }
            catch (MetacatInaccessibleException mie) {
                System.err.println("Metacat Inaccessible:\n" + mie.getMessage());
            }
        }
        LoginBean loginBean = (LoginBean)request.getAttribute("loginBean");
        MetacatLogin metacatLogin = new MetacatLogin(loginBean);
        loginSuccess = metacatLogin.executeLogin(metacatURL, metacat);
        httpSession.setAttribute("metacat", (Object)metacat);
        if (loginSuccess) {
            httpSession.setAttribute("loggedIn", (Object)new Boolean(true));
            String username = loginBean.getUsername();
            httpSession.setAttribute("username", (Object)username);
            dispatcher = request.getRequestDispatcher("/style/skins/lter/index.jsp");
        } else {
            httpSession.setAttribute("loggedIn", (Object)new Boolean(false));
            request.setAttribute("loginFailure", (Object)"true");
            dispatcher = request.getRequestDispatcher("/style/skins/lter/index_login.jsp");
        }
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = null;
        super.init(config);
        context = config.getServletContext();
        String dirPath = context.getRealPath(CONFIG_DIR);
        try {
            PropertyService.getInstance();
            this.contextString = PropertyService.getProperty("application.context");
        }
        catch (ServiceException se) {
            System.err.println("Error in loading properties: " + se.getMessage());
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("couldn't read property during initialization: " + pnfe.getMessage());
        }
    }
}

