/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.LoginBean;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatHelper;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;

public class MetacatLogin {
    private LoginBean loginBean = null;

    public MetacatLogin(LoginBean loginBean) {
        this.loginBean = loginBean;
    }

    public boolean executeLogin(String metacatURL, Metacat metacat) {
        boolean loginSuccess = false;
        MetacatHelper metacatHelper = new MetacatHelper();
        String metacatResponse = "";
        String organization = this.loginBean.getOrganization();
        String password = this.loginBean.getPassword();
        String username = this.loginBean.getUsername();
        if (username == null || organization == null || password == null || username.equals("") || organization.equals("") || password.equals("")) {
            return loginSuccess;
        }
        System.err.println("Metacat URL: " + metacatURL);
        try {
            String DN = metacatHelper.constructDN(username, organization);
            metacatResponse = metacat.login(DN, password);
            System.err.println("metacatResponse:\n" + metacatResponse);
            if (metacatResponse.indexOf("Authentication successful") > -1) {
                loginSuccess = true;
            }
        }
        catch (MetacatAuthException mae) {
            System.err.println("MetacatAuthException:\n" + mae.getMessage());
        }
        catch (MetacatInaccessibleException mie) {
            System.err.println("Metacat Inaccessible:\n" + mie.getMessage());
        }
        catch (Exception e) {
            System.err.println("General exception:\n" + e.getMessage());
            e.printStackTrace();
        }
        return loginSuccess;
    }
}

