/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.annotation;

import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BioPortalService {
    private static Log logMetacat = LogFactory.getLog(BioPortalService.class);
    private static final String REST_URL = "http://data.bioontology.org";
    private static final String API_KEY = "24e4775e-54e0-11e0-9d7b-005056aa3316";

    public static Resource lookupAnnotationClass(OntClass superClass, String text, String ontologies) {
        block7: {
            if (text == null || text.length() == 0) {
                return null;
            }
            try {
                String urlParameters = "apikey=24e4775e-54e0-11e0-9d7b-005056aa3316";
                urlParameters = urlParameters + "&format=xml";
                if (ontologies != null) {
                    urlParameters = urlParameters + "&ontologies=" + ontologies;
                }
                urlParameters = urlParameters + "&text=" + URLEncoder.encode(text, "UTF-8");
                String url = "http://data.bioontology.org/annotator?" + urlParameters;
                URL restURL = new URL(url);
                InputStream is = restURL.openStream();
                Document doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)new InputStreamReader(is, "UTF-8"));
                NodeList classNodeList = XMLUtilities.getNodeListWithXPath((Node)doc, (String)"//annotation/annotatedClass/id");
                if (classNodeList == null || classNodeList.getLength() <= 0) break block7;
                for (int i = 0; i < classNodeList.getLength(); ++i) {
                    String classURI = classNodeList.item(i).getFirstChild().getNodeValue();
                    logMetacat.info((Object)("annotator suggested: " + classURI));
                    Resource subclass = superClass.getModel().getResource(classURI);
                    boolean isSubclass = false;
                    try {
                        isSubclass = superClass.hasSubClass(subclass);
                    }
                    catch (ConversionException ce) {
                        logMetacat.warn((Object)("Skipping unknown subclass: " + classURI), (Throwable)ce);
                        continue;
                    }
                    if (!isSubclass) continue;
                    return subclass;
                }
            }
            catch (Exception e) {
                logMetacat.error((Object)("Could not lookup BioPortal annotation for text=" + text), (Throwable)e);
            }
        }
        return null;
    }
}

