/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.cart;

import edu.ucsb.nceas.metacat.cart.DocumentCart;
import edu.ucsb.nceas.metacat.service.SessionService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CartManager {
    private static Log log = LogFactory.getLog(CartManager.class);
    private String sessionId = null;
    private DocumentCart documentCart = null;

    public CartManager() {
        this.init();
    }

    public CartManager(String sessionId) {
        this.sessionId = sessionId;
        this.init();
    }

    private void init() {
        this.documentCart = SessionService.getInstance().getRegisteredSession(this.sessionId).getDocumentCart();
        if (this.documentCart == null) {
            this.documentCart = new DocumentCart();
        }
    }

    public void editCart(String operation, String[] docids, Map fields) {
        if (operation.equalsIgnoreCase("addField")) {
            this.documentCart.addFields(fields);
        }
        if (operation.equalsIgnoreCase("removeField")) {
            String field = (String)fields.keySet().toArray()[0];
            this.documentCart.removeField(field);
        }
        if (operation.equalsIgnoreCase("addFields")) {
            this.documentCart.addFields(fields);
        }
        if (operation.equalsIgnoreCase("clearfields")) {
            this.documentCart.clearFields();
        }
        if (operation.equalsIgnoreCase("clear")) {
            this.documentCart.clear();
        }
        if (docids != null) {
            for (int i = 0; i < docids.length; ++i) {
                if (operation.equalsIgnoreCase("add")) {
                    this.documentCart.addDocument(docids[i], fields);
                }
                if (!operation.equalsIgnoreCase("remove")) continue;
                this.documentCart.removeDocument(docids[i]);
            }
        }
        SessionService.getInstance().getRegisteredSession(this.sessionId).setDocumentCart(this.documentCart);
    }
}

