/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.clientview;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlForSingleFile;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlList;
import edu.ucsb.nceas.metacat.accesscontrol.XMLAccessAccess;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.clientview.ClientFgdcHelper;
import edu.ucsb.nceas.metacat.clientview.ClientHtmlHelper;
import edu.ucsb.nceas.metacat.clientview.ClientView;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.XMLUtilities;
import edu.ucsb.nceas.utilities.access.DocInfoHandler;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ClientViewHelper {
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private HttpSession clientSession;
    private ClientView clientViewBean = null;
    private MetacatClient metacatClient = null;
    private boolean loggedIn = false;
    private Document metadataDoc = null;
    private int sizeLimit;
    private String contactName = "";
    private static final int DEFAULTFILESIZE = -1;
    private static final String LDAP_TEMPLATE = "uid=%1s,o=%2s,dc=ecoinformatics,dc=org";
    public static final String DOWNLOAD_ACTION = "Download";
    public static final String PERMISSION_TYPE_ALLOW = "allow";
    public static final String PERMISSION_TYPE_DISALLOW = "deny";

    public ClientViewHelper(HttpServletRequest request) throws MetacatInaccessibleException {
        this.clientSession = request.getSession(false);
        String host = request.getHeader("host");
        String context = request.getContextPath();
        this.init(host, context);
    }

    public ClientViewHelper(String host, String context, ClientView bean) throws MetacatInaccessibleException {
        this.clientViewBean = bean;
        this.init(host, context);
    }

    private void init(String host, String context) throws MetacatInaccessibleException {
        String metacatPath = "http://%1s%2s/metacat";
        String tmp = metacatPath.replaceFirst("%1s", host);
        metacatPath = tmp.replaceFirst("%2s", context);
        this.metacatClient = (MetacatClient)MetacatFactory.createMetacatConnection(metacatPath);
        try {
            this.sizeLimit = new Integer(PropertyService.getProperty("replication.datafilesizelimit"));
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatInaccessibleException(pnfe.getMessage());
        }
    }

    public String clientRequest(HttpServletRequest request, HttpServletResponse response) {
        String result = null;
        this.getMetacatClient().setSessionId(request.getSession().getId());
        if (this.clientViewBean == null) {
            this.clientViewBean = (ClientView)this.clientSession.getAttribute("clientViewBean");
            if (this.clientViewBean == null) {
                this.clientViewBean = new ClientView();
                this.clientSession.setAttribute("clientViewBean", (Object)this.clientViewBean);
            }
        }
        if (this.clientViewBean != null) {
            String action = this.clientViewBean.getAction();
            String contentType = request.getContentType();
            this.clientViewBean.setSessionid(request.getSession().getId());
            if (action == null || action.equals("")) {
                if (contentType != null && contentType.indexOf("multipart/form-data") > -1) {
                    action = "Upload";
                } else {
                    action = request.getParameter("action");
                    this.clientViewBean.setDocId(request.getParameter("docid"));
                    this.clientViewBean.setMetaFileDocId(request.getParameter("metadataDocId"));
                    this.clientViewBean.setQformat(request.getParameter("qformat"));
                    this.clientViewBean.setPublicAccess(request.getParameter("publicAccess") != null);
                    this.clientViewBean.setContentStandard(request.getParameter("contentStandard"));
                }
                this.clientViewBean.setAction(action);
            }
            if (action != null) {
                HashMap<String, Object> responseMap;
                if (action.equals("Login")) {
                    responseMap = this.handleClientRequest(null);
                    this.clientViewBean.setAction("");
                    if (this.isLoggedIn()) {
                        Cookie jSessionCookie = new Cookie("JSESSIONID", this.clientViewBean.getSessionid());
                        response.addCookie(jSessionCookie);
                    }
                } else if (action.equals("Logout")) {
                    responseMap = this.handleClientRequest(null);
                    this.clientViewBean.setAction("");
                } else if (action.equals("Upload")) {
                    try {
                        MultipartParser multipartParser = new MultipartParser(request, this.sizeLimit * 1024 * 1024);
                        responseMap = this.handleClientRequest(multipartParser);
                    }
                    catch (IOException ex) {
                        responseMap = new HashMap();
                        responseMap.put("message", ex.getMessage());
                    }
                    this.clientViewBean.setAction("");
                } else if (action.equals(DOWNLOAD_ACTION)) {
                    responseMap = this.handleClientRequest(null);
                    try {
                        this.handleDownloadResponse(responseMap, response);
                    }
                    catch (IOException ex) {
                        responseMap = new HashMap();
                        responseMap.put("message", ex.getMessage());
                    }
                } else if (action.equals("Set Access")) {
                    responseMap = this.handleClientRequest(null);
                    this.clientViewBean.setAction("");
                } else {
                    responseMap = this.handleClientRequest(null);
                }
                result = (String)responseMap.get("message");
            }
        } else {
            result = "ClientViewHelper.clientRequest: ClientView bean is not instantiated.";
        }
        return result;
    }

    public HashMap<String, Object> handleClientRequest(MultipartParser multipartParser) {
        HashMap<String, Object> responseMap;
        String result;
        block15: {
            result = "";
            responseMap = new HashMap<String, Object>();
            if (this.clientViewBean != null) {
                String action = this.clientViewBean.getAction();
                if (action != null) {
                    try {
                        if (action.equals("Login")) {
                            String tmp = LDAP_TEMPLATE.replaceFirst("%1s", this.clientViewBean.getUsername());
                            String posted_ldapUserName = tmp.replaceFirst("%2s", this.clientViewBean.getOrganization());
                            String serverResponse = this.metacatClient.login(posted_ldapUserName, this.clientViewBean.getPassword());
                            this.setLoggedIn(serverResponse);
                            result = this.parseXml("message", serverResponse);
                            this.contactName = this.parseXml("name", serverResponse);
                            this.clientViewBean.setMessage(0, result);
                            this.clientViewBean.setMessage(1, "");
                            if (this.isLoggedIn()) {
                                this.clientViewBean.setSessionid(this.metacatClient.getSessionId());
                            }
                            break block15;
                        }
                        if (action.equals("Logout")) {
                            result = this.metacatClient.logout();
                            this.setLoggedIn(result);
                            result = this.parseXml("message", result);
                            this.clientViewBean.setMessage(0, result);
                            this.clientViewBean.setMessage(1, "");
                            if (!this.isLoggedIn()) {
                                this.clientViewBean.setUsername("");
                                this.clientViewBean.setPassword("");
                                this.clientViewBean.setOrganization("");
                                this.clientViewBean.setSessionid(null);
                            }
                            break block15;
                        }
                        if (action.equals("Delete")) {
                            ClientFgdcHelper.clientDeleteRequest(this.clientViewBean, this);
                            this.clientViewBean.setAction("read");
                            break block15;
                        }
                        if (action.equals("Upload")) {
                            result = this.isLoggedIn() ? (multipartParser == null ? "ClientViewHelper.handleClientRequest: MultipartParser is not instantiated." : this.handlePackageUpload(this.clientViewBean, multipartParser)) : "You must be logged in to perform an upload.";
                            this.clientViewBean.setMessage(1, result);
                            break block15;
                        }
                        if (action.equals("Update")) {
                            result = "This is not implemented here.  Call ClientViewHelper.jspx";
                            break block15;
                        }
                        if (action.equals("Scope")) {
                            result = this.handleDocIdSelect();
                            this.clientViewBean.setMessage(3, result);
                            break block15;
                        }
                        if (action.equals(DOWNLOAD_ACTION)) {
                            responseMap = this.download(this.clientViewBean);
                            break block15;
                        }
                        if (action.equals("Set Access")) {
                            result = this.handleChangeAccess(this.clientViewBean.getMetaFileDocId(), this.clientViewBean.isPublicAccess() ? PERMISSION_TYPE_ALLOW : PERMISSION_TYPE_DISALLOW);
                            this.clientViewBean.setMessage(6, result);
                            break block15;
                        }
                        result = action + " action not recognized.";
                    }
                    catch (Exception ex) {
                        result = ex.getMessage();
                        this.clientViewBean.setMessage(4, result);
                        ex.printStackTrace();
                    }
                }
            } else {
                result = "ClientViewHelper.clientRequest: ClientView bean is not instantiated.";
            }
        }
        responseMap.put("message", result);
        return responseMap;
    }

    public static ClientViewHelper clientViewHelperInstance(HttpServletRequest request) {
        String sessionId = request.getSession(false).getId();
        ClientViewHelper result = (ClientViewHelper)request.getSession().getAttribute("ClientViewHelper");
        if (result == null) {
            try {
                result = new ClientViewHelper(request);
                request.getSession().setAttribute("ClientViewHelper", (Object)result);
            }
            catch (MetacatInaccessibleException ex) {
                ex.printStackTrace();
            }
        }
        if (result.clientViewBean == null) {
            result.clientViewBean = (ClientView)request.getSession().getAttribute("clientViewBean");
            if (result.clientViewBean == null) {
                result.clientViewBean = new ClientView();
                request.getSession().setAttribute("clientViewBean", (Object)result.clientViewBean);
            }
        }
        boolean oldLoginValue = result.loggedIn;
        result.setLoggedIn(SessionService.getInstance().validateSession(sessionId));
        if (result.isLoggedIn()) {
            SessionData sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
            result.setUserName(sessionData.getName());
        }
        if (!oldLoginValue || result.loggedIn) {
            result.clientViewBean.setMessage(1, "");
        }
        return result;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(String serverResponse) {
        this.loggedIn = serverResponse != null && serverResponse.indexOf("login") > -1;
    }

    public void setLoggedIn(boolean isLoggedIn) {
        this.loggedIn = isLoggedIn;
    }

    public void setUserName(String userName) {
        this.clientViewBean.setUsername(userName);
    }

    public String parseXml(String elementName, String xml) {
        String result = null;
        try {
            Document doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)new StringReader(xml));
            result = (String)this.xpath.evaluate(elementName, doc.getDocumentElement(), XPathConstants.STRING);
            if (result != null) {
                result = result.trim();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String handleDocIdSelect() {
        String result = "";
        if (!this.clientViewBean.getPathValue().equals("")) {
            TreeMap allDocIds = this.getSelectQueryMap();
            result = ClientHtmlHelper.mapToHtmlSelect(allDocIds, "docId", "width: 240", 10);
        }
        return result;
    }

    public String handlePackageUpload(ClientView clientViewBean, MultipartParser multipartParser) throws Exception {
        String result = "";
        HashMap paramsMap = new HashMap();
        StringBuffer fileName = new StringBuffer();
        InputStream inputStream = this.getNextInputStream(multipartParser, fileName, paramsMap);
        String metaFileName = fileName.toString();
        if (metaFileName.toLowerCase().endsWith(".xml")) {
            boolean sendIt;
            this.setMetadataDoc(inputStream);
            String scope = clientViewBean.getUsername();
            scope = scope.replaceAll(" ", "_");
            scope = scope.toLowerCase();
            String lastDocId = this.getMetacatClient().getLastDocid(scope);
            String metaDocId = lastDocId = this.nextDocId(lastDocId, scope);
            HashMap<String, String[]> dataDocIDs = new HashMap<String, String[]>();
            fileName = new StringBuffer();
            while ((inputStream = this.getNextInputStream(multipartParser, fileName, paramsMap)) != null) {
                String nextDocId = this.nextDocId(lastDocId, scope);
                String[] fileInfo = ClientViewHelper.parseFileInfo(fileName.toString());
                dataDocIDs.put(nextDocId, fileInfo);
                this.getMetacatClient().upload(nextDocId, fileName.toString(), inputStream, -1);
                lastDocId = nextDocId;
                fileName = new StringBuffer();
            }
            if (ClientFgdcHelper.isFGDC(this.getMetadataDoc())) {
                sendIt = ClientFgdcHelper.handlePackageUpload(metaDocId, dataDocIDs, this.contactName, metaFileName, this.getMetadataDoc());
            } else {
                System.out.println("ClientViewHelper.handlePackageUpload: not an FGDC file = " + fileName);
                result = fileName + " is not an FGDC file.  Files not uploaded.";
                sendIt = false;
            }
            if (sendIt) {
                Reader reader = XMLUtilities.getDOMTreeAsReader((Node)this.metadataDoc.getDocumentElement(), (boolean)false);
                this.getMetacatClient().insert(metaDocId, reader, null);
                result = "MetaCat Package Inserted:  the Document Identifier is " + metaDocId;
                reader.close();
                if (paramsMap.containsKey("publicAccess")) {
                    Stack docIdStack = new Stack();
                    docIdStack.addAll(dataDocIDs.keySet());
                    this.setPublicAccess(PERMISSION_TYPE_ALLOW, metaDocId, docIdStack);
                }
            }
        } else {
            result = "The first file must be an XML Metadata file.  Files not uploaded.";
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return result;
    }

    private String setPublicAccess(String permissionType, String metaDocId, Stack docIdStack) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException, AccessControlException, McdbDocNotFoundException {
        String result = " for Documents ";
        String lst = metaDocId;
        this.setPublicReadAccess(permissionType, metaDocId);
        while (!docIdStack.isEmpty()) {
            String docId = (String)docIdStack.pop();
            this.setPublicReadAccess(permissionType, docId);
            lst = lst + ", " + docId;
        }
        result = "Changed public read access to '" + permissionType + "' for " + result + lst;
        return result;
    }

    private void setPublicReadAccess(String permissionType, String docid) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException, AccessControlException, McdbDocNotFoundException {
        String originalAccessBlock = this.getMetacatClient().getAccessControl(docid);
        Vector<Object> accessList = this.parseAccessXMLBlock(docid, originalAccessBlock);
        if (accessList != null && !accessList.isEmpty()) {
            XMLAccessDAO rule = accessList.elementAt(0);
            String permOrder = rule.getPermOrder();
            this.removeAllPublicAccessRules(accessList);
            XMLAccessDAO newRule = this.generateXMLAccessDAO(docid, "public", "READ", permissionType, permOrder);
            accessList.add(newRule);
        } else {
            accessList = new Vector();
            XMLAccessDAO newRule = this.generateXMLAccessDAO(docid, "public", "READ", permissionType, "allowFirst");
            accessList.add(newRule);
        }
        AccessControlForSingleFile controller = new AccessControlForSingleFile(docid);
        String accessBlock = controller.getAccessString(accessList);
        this.getMetacatClient().setAccess(docid, accessBlock);
    }

    private Vector<XMLAccessDAO> parseAccessXMLBlock(String docId, String accessXMLBlock) throws AccessControlException {
        try {
            DocInfoHandler docInfoHandler;
            XMLReader parser = null;
            DocInfoHandler chandler = docInfoHandler = new DocInfoHandler(docId);
            String parserName = PropertyService.getProperty("xml.saxparser");
            parser = XMLReaderFactory.createXMLReader(parserName);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setContentHandler((ContentHandler)chandler);
            parser.setErrorHandler((ErrorHandler)chandler);
            parser.parse(new InputSource(new StringReader(accessXMLBlock)));
            XMLAccessAccess xmlAccessAccess = new XMLAccessAccess();
            Vector accessRuleList = docInfoHandler.getAccessControlList();
            return accessRuleList;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AccessControlException("ClientViewHelper.parseAccessXMLBlock - property error when replacing permissions: " + pnfe.getMessage());
        }
        catch (AccessException ae) {
            throw new AccessControlException("ClientViewHelper.parseAccessXMLBlock - DB access error when replacing permissions: " + ae.getMessage());
        }
        catch (SAXException se) {
            throw new AccessControlException("ClientViewHelper.parseAccessXMLBlock - SAX error when replacing permissions: " + se.getMessage());
        }
        catch (IOException ioe) {
            throw new AccessControlException("ClientViewHelper.parseAccessXMLBlock - I/O error when replacing permissions: " + ioe.getMessage());
        }
    }

    private XMLAccessDAO generateXMLAccessDAO(String docid, String principalName, String permission, String permType, String permOrder) throws McdbDocNotFoundException {
        String localId = DocumentUtil.getDocIdFromString(docid);
        int rev = DocumentUtil.getRevisionFromAccessionNumber(docid);
        String identifier = IdentifierManager.getInstance().getGUID(localId, rev);
        XMLAccessDAO xmlAccessDAO = new XMLAccessDAO();
        xmlAccessDAO.setGuid(identifier);
        xmlAccessDAO.setPrincipalName(principalName);
        xmlAccessDAO.setPermission(Long.valueOf(Integer.valueOf(AccessControlList.intValue(permission)).longValue()));
        xmlAccessDAO.setPermType(permType);
        xmlAccessDAO.setPermOrder(permOrder);
        return xmlAccessDAO;
    }

    private void removeAllPublicAccessRules(Vector<XMLAccessDAO> accessList) {
        if (accessList != null && !accessList.isEmpty()) {
            int i;
            Vector<Integer> removingIndexList = new Vector<Integer>();
            for (i = 0; i < accessList.size(); ++i) {
                XMLAccessDAO rule = accessList.elementAt(i);
                if (rule == null || rule.getPrincipalName() == null || !rule.getPrincipalName().equalsIgnoreCase("public")) continue;
                removingIndexList.add(new Integer(i));
            }
            if (!removingIndexList.isEmpty()) {
                for (i = removingIndexList.size() - 1; i >= 0; --i) {
                    accessList.remove((Integer)removingIndexList.elementAt(i));
                }
            }
        }
    }

    private String handleChangeAccess(String metaDocId, String permissionType) throws Exception {
        String result = "";
        String xpathExpr = null;
        this.setMetadataDoc(metaDocId);
        if (this.clientViewBean.getContentStandard().equals("FGDC")) {
            xpathExpr = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr/text()";
        } else if (this.clientViewBean.getContentStandard().equals("EML")) {
            xpathExpr = null;
        }
        if (xpathExpr != null) {
            Stack dataDocIDs = ClientViewHelper.getNodeTextStack(this.xpath, xpathExpr, this.getMetadataDoc().getDocumentElement());
            result = this.setPublicAccess(permissionType, metaDocId, dataDocIDs);
        }
        return result;
    }

    public String handleFileUpdate(MultipartParser multipartParser) throws Exception {
        String result;
        block10: {
            result = "";
            StringBuffer fileName = new StringBuffer();
            HashMap paramsMap = new HashMap();
            InputStream inputStream = this.getNextInputStream(multipartParser, fileName, paramsMap);
            if (inputStream != null) {
                String action = (String)paramsMap.get("action");
                String lastDocId = (String)paramsMap.get("docid");
                String metadataDocId = (String)paramsMap.get("metadataDocId");
                this.clientViewBean.setMetaFileDocId(metadataDocId);
                String qFrmt = (String)paramsMap.get("qformat");
                this.clientViewBean.setQformat(qFrmt);
                String fNm = fileName.toString();
                try {
                    if (lastDocId.equals(metadataDocId)) {
                        this.setMetadataDoc(inputStream);
                        if (ClientFgdcHelper.isFGDC(this.getMetadataDoc())) {
                            this.clientViewBean.setContentStandard("FGDC");
                            if (!ClientFgdcHelper.hasMetacatInfo(lastDocId, this.getMetadataDoc())) {
                                this.clientViewBean.setMetaFileDocId(lastDocId);
                                this.clientViewBean.setAction("read");
                                result = "Update not performed: the Metadata file has no prior Metacat info in it.";
                            } else {
                                String xPathQuery = "/metadata/distinfo/resdesc[text()='%1s']".replaceFirst("%1s", lastDocId);
                                String newDocId = this.updateMetadataDoc(lastDocId, xPathQuery, fNm);
                                this.clientViewBean.setMetaFileDocId(newDocId);
                                this.clientViewBean.setAction("read");
                                result = "Updated to new document (from " + lastDocId + " to " + newDocId + ")";
                            }
                        } else {
                            this.clientViewBean.setContentStandard("EML");
                            this.clientViewBean.setMetaFileDocId(lastDocId);
                            this.clientViewBean.setAction("read");
                            result = "Currently this functionality only supports FGDC metadata.";
                        }
                        break block10;
                    }
                    this.setMetadataDoc(metadataDocId);
                    if (ClientFgdcHelper.isFGDC(this.getMetadataDoc())) {
                        this.clientViewBean.setContentStandard("FGDC");
                        String[] fileInfo = ClientViewHelper.parseFileInfo(fNm);
                        String xPathQuery = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr[text()='%1s']".replaceFirst("%1s", lastDocId);
                        String newDocId = this.nextVersion(lastDocId, xPathQuery);
                        ClientFgdcHelper.updateFileNameAndType(this.getMetadataDoc().getDocumentElement(), newDocId, fileInfo);
                        this.getMetacatClient().upload(newDocId, fNm, inputStream, -1);
                        result = "Updated to new document (from " + lastDocId + " to " + newDocId + ")";
                        xPathQuery = "/metadata/distinfo/resdesc[text()='%1s']".replaceFirst("%1s", metadataDocId);
                        newDocId = this.updateMetadataDoc(metadataDocId, xPathQuery, null);
                        this.clientViewBean.setMetaFileDocId(newDocId);
                        this.clientViewBean.setAction("read");
                        break block10;
                    }
                    this.clientViewBean.setContentStandard("EML");
                    this.clientViewBean.setMetaFileDocId(metadataDocId);
                    this.clientViewBean.setAction("read");
                    result = "Currently this functionality only supports FGDC metadata.";
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                result = "Please enter the updated file path/name.";
            }
        }
        this.clientViewBean.setMessage(6, result);
        return result;
    }

    private String updateMetadataDoc(String lastDocId, String docIdPath, String origFileName) {
        String newDocId = null;
        try {
            newDocId = this.nextVersion(lastDocId, docIdPath);
            if (origFileName != null && this.clientViewBean.getContentStandard().equals("FGDC")) {
                ClientFgdcHelper.updateMetadataFileName(this.getMetadataDoc().getDocumentElement(), newDocId, origFileName);
            }
            Reader reader = XMLUtilities.getDOMTreeAsReader((Node)this.getMetadataDoc().getDocumentElement(), (boolean)false);
            this.getMetacatClient().update(newDocId, reader, null);
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newDocId;
    }

    private InputStream getNextInputStream(MultipartParser multipartParser, StringBuffer fileName, HashMap paramsMap) throws IOException {
        Part part;
        InputStream result = null;
        String parmName = null;
        String value = null;
        while ((part = multipartParser.readNextPart()) != null) {
            String fnam;
            if (part.isParam()) {
                parmName = part.getName();
                value = ((ParamPart)part).getStringValue();
                paramsMap.put(parmName, value);
                continue;
            }
            if (!part.isFile() || (fnam = ((FilePart)part).getFileName()) == null || fnam.equals("")) continue;
            fileName.append(fnam);
            result = ((FilePart)part).getInputStream();
            break;
        }
        return result;
    }

    private void getRemainingParameters(MultipartParser multipartParser, HashMap paramsMap) throws IOException {
        Part part;
        Object result = null;
        String parmName = null;
        String value = null;
        while ((part = multipartParser.readNextPart()) != null) {
            if (!part.isParam()) continue;
            parmName = part.getName();
            value = ((ParamPart)part).getStringValue();
            paramsMap.put(parmName, value);
        }
    }

    public TreeMap getSelectQueryMap() {
        String DOCID_EXPR = "./docid";
        String DOCNAME_EXPR = "./createdate";
        String PARAM_EXPR = "./param[@name='%1s']";
        String path = this.clientViewBean.getPathExpr();
        String returnFld = this.clientViewBean.getReturnfield();
        String value = this.clientViewBean.getPathValue();
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        String paramExpr = "./param[@name='%1s']".replaceFirst("%1s", returnFld);
        Document doc = this.query(path, value, returnFld);
        try {
            NodeList nodeLst = (NodeList)this.xpath.evaluate("/resultset/document", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeLst.getLength(); ++i) {
                Node node = nodeLst.item(i);
                String key = this.xpath.evaluate("./docid", node);
                String val = this.xpath.evaluate("./createdate", node);
                result.put(key, key + " (" + val + ")");
                NodeList subNodeLst = (NodeList)this.xpath.evaluate(paramExpr, node, XPathConstants.NODESET);
                if (subNodeLst.getLength() <= 0) continue;
                Vector<String> optGroup = new Vector<String>();
                for (int k = 0; k < subNodeLst.getLength(); ++k) {
                    Node subNode = subNodeLst.item(k);
                    String paramVal = this.xpath.evaluate("text()", subNode);
                    optGroup.add(paramVal);
                }
                result.put(key + " Data Files", optGroup);
            }
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Document query(String pathExpr, String pathValue, String returnFld) {
        Document result = null;
        try {
            InputStream response;
            Properties prop = new Properties();
            prop.put("action", "query");
            prop.put("qformat", "xml");
            prop.put(pathExpr, pathValue);
            if (returnFld != null) {
                prop.put("returnfield", returnFld);
            }
            if ((response = this.metacatClient.sendParameters(prop)) != null) {
                BufferedReader buffy = new BufferedReader(new InputStreamReader(response));
                result = XMLUtilities.getXMLReaderAsDOMDocument((Reader)buffy);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setMetadataDoc(Document doc) {
        this.metadataDoc = doc;
    }

    public void setMetadataDoc(String docId) throws Exception {
        Document doc = null;
        InputStream response = this.metacatClient.read(docId);
        if (response != null) {
            BufferedReader buffy = new BufferedReader(new InputStreamReader(response));
            doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)buffy);
            response.close();
        }
        this.setMetadataDoc(doc);
    }

    public void setMetadataDoc(InputStream ioStream) throws IOException {
        if (ioStream != null) {
            BufferedReader buffy = new BufferedReader(new InputStreamReader(ioStream));
            this.metadataDoc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)buffy);
        }
    }

    public Document getMetadataDoc() {
        return this.metadataDoc;
    }

    public String nextVersion(String lastDocId, String xPathQuery) throws XPathExpressionException {
        String result = null;
        int LAST_TOKEN = 2;
        String TEMPLATE = "%1s.%2d.%3d";
        if (lastDocId != null && lastDocId.indexOf(".") > -1) {
            String ready2Split = lastDocId.replace('.', '~');
            String[] tokens = ready2Split.split("~");
            if (tokens.length > 2 && !tokens[2].equals("")) {
                String scope = tokens[0];
                int docNum = Integer.parseInt(tokens[1]);
                try {
                    int vers = Integer.parseInt(tokens[2]);
                    String tmp = "%1s.%2d.%3d".replaceFirst("%1s", scope);
                    tmp = tmp.replaceFirst("%2d", String.valueOf(docNum));
                    result = tmp.replaceFirst("%3d", String.valueOf(vers + 1));
                }
                catch (NumberFormatException ex) {
                    String tmp = "%1s.%2d.%3d".replaceFirst("%1s", scope);
                    tmp = tmp.replaceFirst("%2d", String.valueOf(docNum));
                    result = tmp.replaceFirst("%3d", "1");
                }
            } else {
                result = lastDocId + "1";
            }
        } else {
            result = null;
        }
        if (this.getMetadataDoc() != null) {
            Node node = (Node)this.xpath.evaluate(xPathQuery, this.getMetadataDoc().getDocumentElement(), XPathConstants.NODE);
            ClientViewHelper.setTextContent(this.xpath, node, result);
        }
        return result;
    }

    private String nextDocId(String lastDocId, String scope) {
        String result = null;
        String template = scope.toLowerCase() + ".%1d.%2d";
        if (lastDocId != null && lastDocId.indexOf(".") > -1) {
            String[] tokens = (lastDocId = lastDocId.replace('.', '~')).split("~");
            if (tokens.length > 1 && !tokens[1].equals("")) {
                try {
                    int vers = Integer.parseInt(tokens[1]);
                    String tmp = template.replaceFirst("%1d", String.valueOf(1 + vers));
                    result = tmp.replaceFirst("%2d", "1");
                }
                catch (NumberFormatException ex) {
                    String tmp = template.replaceFirst("%1d", "1");
                    result = tmp.replaceFirst("%2d", "1");
                }
            } else {
                String tmp = template.replaceFirst("%1d", "1");
                result = tmp.replaceFirst("%2d", "1");
            }
        } else {
            String tmp = template.replaceFirst("%1d", "1");
            result = tmp.replaceFirst("%2d", "1");
        }
        return result;
    }

    public MetacatClient getMetacatClient() {
        return this.metacatClient;
    }

    public static String[] parseFileInfo(String fileName) {
        String[] result = new String[2];
        int idx = fileName.lastIndexOf(".");
        String formatType = idx > 1 ? fileName.substring(idx + 1).toUpperCase() : "";
        result[0] = formatType;
        result[1] = fileName.toString();
        return result;
    }

    public static void updateNodeText(Node root, XPath xPath, String expression, String text) {
        if (text != null && !text.equals("")) {
            try {
                Node targetNode = (Node)xPath.evaluate(expression, root, XPathConstants.NODE);
                ClientViewHelper.setTextContent(xPath, targetNode, text);
            }
            catch (XPathExpressionException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Node getNode(XPath xPath, String expression, Node root) {
        Node result = null;
        try {
            result = (Node)xPath.evaluate(expression, root, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String getNodeText(XPath xPath, String expression, Node root) {
        String result = null;
        Node node = ClientViewHelper.getNode(xPath, expression, root);
        if (node != null && !node.equals("")) {
            result = ClientViewHelper.getTextContent(xPath, node);
        }
        return result;
    }

    public static String[] getNodeTextList(XPath xPath, String expression, Node root) {
        String[] result = new String[]{};
        try {
            int size;
            NodeList nodes = (NodeList)xPath.evaluate(expression, root, XPathConstants.NODESET);
            if (nodes != null && (size = nodes.getLength()) > 0) {
                result = new String[size];
                for (int i = 0; i < size; ++i) {
                    result[i] = ClientViewHelper.getTextContent(xPath, nodes.item(i));
                }
            }
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Stack getNodeTextStack(XPath xpathInstance, String xpathExpr, Node parentNode) {
        Stack<String> result = new Stack<String>();
        String[] nodeLst = ClientViewHelper.getNodeTextList(xpathInstance, xpathExpr, parentNode);
        for (int i = 0; i < nodeLst.length; ++i) {
            result.push(nodeLst[i]);
        }
        return result;
    }

    public static String getStringFromInputStream(InputStream input) {
        StringBuffer result = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            System.out.println("ClientViewHelper.getStringFromInputStream: " + e);
        }
        return result.toString();
    }

    public String makeRedirectUrl() {
        String result;
        String docId = this.clientViewBean.getMetaFileDocId();
        if (this.clientViewBean.getAction().equals(DOWNLOAD_ACTION)) {
            result = null;
        } else if (docId != null && !docId.equals("")) {
            String message = this.clientViewBean.getMessage(6);
            result = "metacat?action=read&qformat=" + this.clientViewBean.getQformat() + "&docid=" + docId + "&sessionid=" + this.clientViewBean.getSessionid() + "&message=" + message;
        } else {
            result = "style/skins/" + this.clientViewBean.getQformat() + "/confirm.jsp";
        }
        this.clientViewBean.setAction("");
        return result;
    }

    private HashMap<String, Object> download(ClientView bean) {
        String fNm = null;
        String msg = "File '~' (~) downloaded";
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String docId = bean.getDocId();
        String metaId = bean.getMetaFileDocId();
        if (docId != null && metaId != null && !docId.equals("") && !metaId.equals("")) {
            Properties args = new Properties();
            args.put("read", "action");
            try {
                int intMe;
                String[] txtLst;
                this.setMetadataDoc(metaId);
                Element metaRoot = this.getMetadataDoc().getDocumentElement();
                if (ClientFgdcHelper.isFGDC(this.getMetadataDoc())) {
                    Node branchRoot;
                    String pth;
                    if (docId.equals(metaId)) {
                        pth = "/metadata/distinfo/resdesc[text()='%1s']/ancestor::node()[name()='distinfo']".replaceFirst("%1s", docId);
                        branchRoot = ClientViewHelper.getNode(this.xpath, pth, this.getMetadataDoc());
                        fNm = ClientViewHelper.getNodeText(this.xpath, "custom", branchRoot);
                        args.put(fNm, docId);
                        fNm = ClientViewHelper.toZipFileName(fNm);
                        responseMap.put("contentType", "application/zip");
                        args.put(metaId, "docid");
                        txtLst = ClientViewHelper.getNodeTextList(this.xpath, "stdorder/digform/digtopt/onlinopt/computer/networka/networkr", branchRoot);
                        for (int i = 0; i < txtLst.length; ++i) {
                            String additionalDocId = txtLst[i];
                            if (additionalDocId == null || additionalDocId.length() <= 1) continue;
                            String tempPath = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr[text()='%1s']/ancestor::node()[name()='%2s']".replaceFirst("%1s", additionalDocId);
                            tempPath = tempPath.replaceFirst("%2s", "digform");
                            Node tempBranchRoot = ClientViewHelper.getNode(this.xpath, tempPath, this.getMetadataDoc());
                            String tempFileName = ClientViewHelper.getNodeText(this.xpath, "digtinfo/formcont", tempBranchRoot);
                            args.put(additionalDocId, "docid");
                            args.put(tempFileName, additionalDocId);
                        }
                        args.put("zip", "qformat");
                    } else {
                        pth = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr[text()='%1s']/ancestor::node()[name()='%2s']".replaceFirst("%1s", docId);
                        pth = pth.replaceFirst("%2s", "digform");
                        branchRoot = ClientViewHelper.getNode(this.xpath, pth, this.getMetadataDoc());
                        fNm = ClientViewHelper.getNodeText(this.xpath, "digtinfo/formcont", branchRoot);
                        responseMap.put("contentType", "application/octet-stream");
                        args.put(docId, "docid");
                        args.put("xml", "qformat");
                    }
                } else if (docId.equals(metaId)) {
                    fNm = "emlMetadata.xml";
                    txtLst = new String[]{docId};
                    args.put(txtLst[0], "docid");
                    args.put("zip", "qformat");
                    responseMap.put("contentType", "application/zip");
                } else {
                    fNm = "emlData.dat";
                    args.put("xml", "qformat");
                    args.put(docId, "docid");
                    responseMap.put("contentType", "application/octet-stream");
                }
                responseMap.put("Content-Disposition", "attachment; filename=" + fNm);
                InputStream inStream = this.metacatClient.sendParametersInverted(args);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                while ((intMe = inStream.read()) != -1) {
                    outStream.write(intMe);
                }
                responseMap.put("outputStream", outStream);
                msg = msg.replaceFirst("~", fNm);
                msg = msg.replaceFirst("~", docId);
                bean.setMessage(3, msg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                bean.setMessage(3, ex.getMessage());
            }
        }
        responseMap.put("message", bean.getMessage(3));
        return responseMap;
    }

    private void handleDownloadResponse(HashMap responseMap, HttpServletResponse response) throws IOException {
        String contentType = (String)responseMap.get("contentType");
        String contentDisposition = (String)responseMap.get("Content-Disposition");
        ByteArrayOutputStream outStream = (ByteArrayOutputStream)responseMap.get("outputStream");
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", contentDisposition);
        response.setContentLength(outStream.size());
        outStream.writeTo((OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    public static String toZipFileName(String fileName) {
        String result = "metacat";
        if (fileName != null && !fileName.equals("") && !fileName.equals(".")) {
            int idx = fileName.indexOf(46);
            result = idx > -1 ? fileName.substring(0, idx) : fileName;
        }
        result = result + ".zip";
        return result;
    }

    public static void setTextContent(XPath xPath, Node elementNode, String content) throws DOMException {
        Text textNode = (Text)ClientViewHelper.getNode(xPath, "text()", elementNode);
        if (textNode != null) {
            if (ClientViewHelper.isElementContentWhitespace(textNode)) {
                Document document = elementNode.getOwnerDocument();
                Text newTxtNode = document.createTextNode(content);
                elementNode.insertBefore(newTxtNode, textNode);
            } else {
                textNode.setNodeValue(content);
            }
        } else {
            Document document = elementNode.getOwnerDocument();
            Text newTxtNode = document.createTextNode(content);
            elementNode.appendChild(newTxtNode);
        }
    }

    public static String getTextContent(XPath xPath, Node elementNode) throws DOMException {
        String result = "";
        Text textNode = elementNode.getNodeType() != 3 ? (Text)ClientViewHelper.getNode(xPath, "text()", elementNode) : (Text)elementNode;
        if (textNode != null) {
            result = textNode.getNodeValue();
        }
        return result;
    }

    public static boolean isElementContentWhitespace(Text textNode) {
        boolean result = false;
        String val = textNode.getNodeValue();
        if (val != null && val != null) {
            result = (val = val.trim()).length() == 0;
        }
        return result;
    }
}

