/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.database;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBConnectionPool
implements Runnable {
    private static DBConnectionPool instance;
    private static Vector<DBConnection> connectionPool;
    private static Thread runner;
    private static int _countOfReachMaximum;
    private static Log logMetacat;
    private static int _maxConnNum;
    private static int _initConnNum;
    private static int _incrConnNum;
    private static long _maxAge;
    private static long _maxConnTime;
    private static int _maxUsageNum;
    private static int _connCountWarnLimit;
    private static String _dbConnRecyclThrd;
    private static long _cyclTimeDbConn;
    static final int MAXIMUMCONNECTIONNUMBER;
    static final int INITIALCONNECTIONNUMBER;
    static final int INCREASECONNECTIONNUMBER;
    static final long MAXIMUMAGE;
    static final long MAXIMUMCONNECTIONTIME;
    static final int MAXIMUMUSAGENUMBER;
    static final String DBCONNECTIONRECYCLETHREAD;
    static final long CYCLETIMEOFDBCONNECTION;
    static final int LIMIT = 2;
    static final int FREE = 0;
    static final int BUSY = 1;

    public static synchronized DBConnectionPool getInstance() throws SQLException {
        if (instance == null) {
            instance = new DBConnectionPool();
            Log log = LogFactory.getLog(DBConnectionPool.class);
            log.debug((Object)("DBConnectionPool.getInstance - MaximumConnectionNumber: " + MAXIMUMCONNECTIONNUMBER));
            log.debug((Object)("DBConnectionPool.getInstance - Intial connection number: " + INITIALCONNECTIONNUMBER));
            log.debug((Object)("DBConnectionPool.getInstance - Increated connection Number: " + INCREASECONNECTIONNUMBER));
            log.debug((Object)("DBConnectionPool.getInstance - Maximum connection age: " + MAXIMUMAGE));
            log.debug((Object)("DBConnectionPool.getInstance - Maximum connection time: " + MAXIMUMCONNECTIONTIME));
            log.debug((Object)("DBConnectionPool.getInstance - Maximum usage count: " + MAXIMUMUSAGENUMBER));
            log.debug((Object)("DBConnectionPool.getInstance - Running recycle thread or not: " + DBCONNECTIONRECYCLETHREAD));
            log.debug((Object)("DBConnectionPool.getInstance - Cycle time of recycle: " + CYCLETIMEOFDBCONNECTION));
        }
        return instance;
    }

    private DBConnectionPool() throws SQLException {
        connectionPool = new Vector();
        this.initialDBConnectionPool();
        if (DBCONNECTIONRECYCLETHREAD.equals("on")) {
            runner = new Thread(this);
            runner.start();
        }
    }

    public int getSizeOfDBConnectionPool() {
        return connectionPool.size();
    }

    private void initialDBConnectionPool() throws SQLException {
        DBConnection dbConn = null;
        for (int i = 0; i < INITIALCONNECTIONNUMBER; ++i) {
            dbConn = new DBConnection();
            connectionPool.add(dbConn);
        }
    }

    public static synchronized DBConnection getDBConnection(String methodName) throws SQLException {
        if (instance == null) {
            instance = DBConnectionPool.getInstance();
        }
        DBConnection db = null;
        int random = 0;
        int index = 0;
        int size = 0;
        size = connectionPool.size();
        for (int j = 0; j < 2; ++j) {
            random = new Double(Math.random() * 100.0).intValue();
            for (int i = 0; i < size; ++i) {
                index = (i + random) % size;
                db = connectionPool.elementAt(index);
                if (db.getStatus() != 0) continue;
                if (DBConnectionPool.validateDBConnection(db)) {
                    db.setStatus(1);
                    db.increaseCheckOutSerialNumber(1);
                    db.increaseUsageCount(1);
                    db.setCheckOutMethodName(methodName);
                    db.setAutoCommit(true);
                    logMetacat.trace((Object)("DBConnectionPool.getDBConnection - The connection is checked out: " + db.getTag()));
                    logMetacat.trace((Object)("DBConnectionPool.getDBConnection - The method for checking is: " + db.getCheckOutMethodName()));
                    logMetacat.trace((Object)("DBConnectionPool.getDBConnection - The age is " + db.getAge()));
                    logMetacat.trace((Object)("DBConnectionPool.getDBConnection - The usage is " + db.getUsageCount()));
                    logMetacat.trace((Object)("DBConnectionPool.getDBConnection - The connection time is: " + db.getConnectionTime()));
                    db.setCheckOutTime(System.currentTimeMillis());
                    _countOfReachMaximum = 0;
                    return db;
                }
                db.close();
                connectionPool.remove(index);
                db = new DBConnection();
                connectionPool.insertElementAt(db, index);
            }
        }
        if (size < MAXIMUMCONNECTIONNUMBER) {
            int i;
            if (size + INCREASECONNECTIONNUMBER < MAXIMUMCONNECTIONNUMBER) {
                for (i = 0; i < INCREASECONNECTIONNUMBER; ++i) {
                    DBConnection dbConn = new DBConnection();
                    connectionPool.add(dbConn);
                }
            } else {
                for (i = size + 1; i <= MAXIMUMCONNECTIONNUMBER; ++i) {
                    DBConnection dbConn = new DBConnection();
                    connectionPool.add(dbConn);
                }
            }
        } else {
            logMetacat.fatal((Object)("DBConnectionPool.getDBConnection - The maximum of " + MAXIMUMCONNECTIONNUMBER + " open db connections is reached. New db connection to MetaCat cannot be established."));
            if (++_countOfReachMaximum >= 10) {
                _countOfReachMaximum = 0;
                logMetacat.fatal((Object)"finally could not get dbconnection");
                return null;
            }
            try {
                logMetacat.debug((Object)"DBConnectionPool.getDBConnection - sleep 5000ms, could not get dbconnection");
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                logMetacat.error((Object)("DBConnectionPool.getDBConnection - General exception: " + e.getMessage()));
            }
        }
        return DBConnectionPool.getDBConnection(methodName);
    }

    private static boolean validateDBConnection(DBConnection dbConn) {
        if (dbConn.getUsageCount() >= MAXIMUMUSAGENUMBER) {
            logMetacat.debug((Object)("DBConnectionPool.validateDBConnection - Connection usageCount is too high: " + dbConn.getUsageCount()));
            return false;
        }
        if (dbConn.getConnectionTime() >= MAXIMUMCONNECTIONTIME) {
            logMetacat.debug((Object)("DBConnectionPool.validateDBConnection - Connection has too much connection time: " + dbConn.getConnectionTime()));
            return false;
        }
        if (dbConn.getAge() >= MAXIMUMAGE) {
            logMetacat.debug((Object)("DBConnectionPool.validateDBConnection - Connection is too old: " + dbConn.getAge()));
            return false;
        }
        try {
            long startTime = System.currentTimeMillis();
            DatabaseMetaData metaData = dbConn.getMetaData();
            long stopTime = System.currentTimeMillis();
            dbConn.increaseUsageCount(1);
            dbConn.setConnectionTime(stopTime - startTime);
        }
        catch (Exception e) {
            logMetacat.error((Object)("DBConnectionPool.validateDBConnection - General error:" + e.getMessage()));
            return false;
        }
        return true;
    }

    public static synchronized void returnDBConnection(DBConnection conn, int serialNumber) {
        int index = -1;
        DBConnection dbConn = null;
        index = DBConnectionPool.getIndexOfPoolForConnection(conn);
        if (index == -1) {
            return;
        }
        if (conn.getCheckOutSerialNumber() == serialNumber) {
            dbConn = connectionPool.elementAt(index);
            dbConn.setStatus(0);
            dbConn.setConnectionTime(System.currentTimeMillis() - dbConn.getCheckOutTime());
            dbConn.setCheckOutTime(0L);
        }
    }

    private static synchronized int getIndexOfPoolForConnection(DBConnection conn) {
        int index = -1;
        String info = null;
        if (conn == null) {
            return -1;
        }
        info = conn.getTag();
        if (info == null || info.equals("")) {
            return index;
        }
        for (int i = 0; i < connectionPool.size(); ++i) {
            DBConnection dbConn = connectionPool.elementAt(i);
            if (!info.equals(dbConn.getTag())) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        if (DBCONNECTIONRECYCLETHREAD.equals("on")) {
            runner.interrupt();
        }
        Vector<DBConnection> vector = connectionPool;
        synchronized (vector) {
            for (int i = 0; i < connectionPool.size(); ++i) {
                try {
                    DBConnection dbConn = connectionPool.elementAt(i);
                    dbConn.close();
                    continue;
                }
                catch (SQLException e) {
                    logMetacat.error((Object)("DBConnectionPool.release - Error in release connection: " + e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DBConnection dbConn = null;
        while (true) {
            Vector<DBConnection> vector = connectionPool;
            synchronized (vector) {
                for (int i = 0; i < connectionPool.size(); ++i) {
                    dbConn = connectionPool.elementAt(i);
                    if (dbConn.getStatus() == 1 && System.currentTimeMillis() - dbConn.getCheckOutTime() >= 30000L) {
                        logMetacat.fatal((Object)("DBConnectionPool.run - This DBConnection is checked out for: " + (System.currentTimeMillis() - dbConn.getCheckOutTime()) / 1000L + " secs"));
                        logMetacat.fatal((Object)("DBConnectionPool.run - " + dbConn.getTag()));
                        logMetacat.error((Object)("DBConnectionPool.run - method: " + dbConn.getCheckOutMethodName()));
                    }
                    if (dbConn.getStatus() != 0) continue;
                    try {
                        if (dbConn.getWarningMessage() != null) {
                            logMetacat.warn((Object)("DBConnectionPool.run - Warning for connection " + dbConn.getTag() + " : " + dbConn.getWarningMessage()));
                        }
                        logMetacat.info((Object)("Checking if the db connection " + dbConn.toString() + " is valid according to metacat.properties parameters."));
                        System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@Checking if the db connection " + dbConn.toString() + " is valid according to metacat.properties parameters.");
                        if (!DBConnectionPool.validateDBConnection(dbConn)) {
                            System.out.println("DB connection is not valid!  Releasing it.");
                            logMetacat.debug((Object)("DBConnectionPool.run - Recyle: " + dbConn.getTag()));
                            dbConn.close();
                            connectionPool.remove(i);
                            dbConn = new DBConnection();
                            connectionPool.insertElementAt(dbConn, i);
                            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@db connection released: " + dbConn.toString());
                        }
                    }
                    catch (SQLException e) {
                        logMetacat.error((Object)("DBConnectionPool.run - SQL error: " + e.getMessage()));
                    }
                    System.out.println("number of connections in pool: " + connectionPool.size());
                    System.out.println("connection pool capacity: " + connectionPool.capacity());
                }
            }
            try {
                Thread.sleep(CYCLETIMEOFDBCONNECTION);
                continue;
            }
            catch (Exception e) {
                logMetacat.error((Object)("DBConnectionPool.run - General error: " + e.getMessage()));
                continue;
            }
            break;
        }
    }

    private static synchronized int getFreeDBConnectionNumber() {
        int numberOfFreeDBConnetion = 0;
        DBConnection db = null;
        int poolSize = 0;
        poolSize = connectionPool.size();
        for (int i = 0; i < poolSize; ++i) {
            db = connectionPool.elementAt(i);
            if (db.getStatus() != 0) continue;
            ++numberOfFreeDBConnetion;
        }
        return numberOfFreeDBConnetion;
    }

    private static void printBusyDBConnections(int usedConnectionCount) {
        boolean showCountWarning = usedConnectionCount > _connCountWarnLimit;
        String warnMessage = "";
        for (DBConnection dbConnection : connectionPool) {
            if (dbConnection.getStatus() != 1) continue;
            if (showCountWarning) {
                warnMessage = warnMessage + "\n   --- Method: " + dbConnection.getCheckOutMethodName() + " is using: " + dbConnection.getTag() + " for " + dbConnection.getAge() + " ms ";
            }
            if (dbConnection.getConnectionTime() <= _maxConnTime) continue;
            logMetacat.warn((Object)("DBConnectionPool.printBusyDBConnections - Excessive connection time, method: " + dbConnection.getCheckOutMethodName() + " is using: " + dbConnection.getTag() + " for " + dbConnection.getConnectionTime() + " ms "));
        }
        if (showCountWarning) {
            logMetacat.warn((Object)("DBConnectionPool.printBusyDBConnections - " + usedConnectionCount + " DB connections currently busy because: " + warnMessage));
        }
    }

    public static synchronized boolean shrinkConnectionPoolSize() {
        int connectionPoolSize = 0;
        int freeConnectionSize = 0;
        int difference = 0;
        boolean hasException = false;
        boolean result = false;
        DBConnection conn = null;
        connectionPoolSize = connectionPool.size();
        freeConnectionSize = DBConnectionPool.getFreeDBConnectionNumber();
        difference = connectionPoolSize - freeConnectionSize;
        if (freeConnectionSize < connectionPoolSize) {
            logMetacat.info((Object)("DBConnectionPool.shrinkConnectionPoolSize - " + difference + " connection(s) being used and connection pool size is " + connectionPoolSize));
        } else {
            logMetacat.info((Object)("DBConnectionPool.shrinkConnectionPoolSize - Connection pool size: " + connectionPoolSize));
            logMetacat.info((Object)("DBConnectionPool.shrinkConnectionPoolSize - Free Connection number: " + freeConnectionSize));
        }
        if (difference == 0 && connectionPoolSize > INITIALCONNECTIONNUMBER) {
            for (int i = connectionPoolSize - 1; i >= INITIALCONNECTIONNUMBER; --i) {
                conn = connectionPool.elementAt(i);
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    hasException = true;
                    logMetacat.error((Object)("DBConnectionPool.shrinkConnectionPoolSize - SQL Exception: " + e.getMessage()));
                }
                connectionPool.remove(i);
                result = true;
            }
        }
        if (hasException) {
            result = false;
        }
        return result;
    }

    public static synchronized void shrinkDBConnectionPoolSize() {
        int connectionPoolSize = 0;
        int freeConnectionSize = 0;
        int usedConnectionCount = 0;
        DBConnection conn = null;
        connectionPoolSize = connectionPool.size();
        freeConnectionSize = DBConnectionPool.getFreeDBConnectionNumber();
        usedConnectionCount = connectionPoolSize - freeConnectionSize;
        DBConnectionPool.printBusyDBConnections(usedConnectionCount);
        if (freeConnectionSize < connectionPoolSize) {
            logMetacat.info((Object)("DBConnectionPool.shrinkDBConnectionPoolSize - " + usedConnectionCount + " connection(s) being used and connection pool size is " + connectionPoolSize));
        } else {
            logMetacat.debug((Object)("DBConnectionPool.shrinkDBConnectionPoolSize - Connection pool size: " + connectionPoolSize));
            logMetacat.debug((Object)("DBConnectionPool.shrinkDBConnectionPoolSize - Free Connection number: " + freeConnectionSize));
        }
        if (usedConnectionCount == 0 && connectionPoolSize > INITIALCONNECTIONNUMBER) {
            for (int i = connectionPoolSize - 1; i >= INITIALCONNECTIONNUMBER; --i) {
                conn = connectionPool.elementAt(i);
                if (conn.getStatus() != 0) continue;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logMetacat.error((Object)("DBConnectionPool.shrinkDBConnectionPoolSize - SQL error: " + e.getMessage()));
                }
                connectionPool.remove(i);
            }
        }
    }

    static {
        _countOfReachMaximum = 0;
        logMetacat = LogFactory.getLog(DBConnectionPool.class);
        try {
            _maxConnNum = Integer.parseInt(PropertyService.getProperty("database.maximumConnections"));
            _initConnNum = Integer.parseInt(PropertyService.getProperty("database.initialConnections"));
            _incrConnNum = Integer.parseInt(PropertyService.getProperty("database.incrementConnections"));
            _maxAge = Integer.parseInt(PropertyService.getProperty("database.maximumConnectionAge"));
            _maxConnTime = Long.parseLong(PropertyService.getProperty("database.maximumConnectionTime"));
            _maxUsageNum = Integer.parseInt(PropertyService.getProperty("database.maximumUsageNumber"));
            _connCountWarnLimit = Integer.parseInt(PropertyService.getProperty("database.connectionCountWarnLimit"));
            _dbConnRecyclThrd = PropertyService.getProperty("database.runDBConnectionRecycleThread");
            _cyclTimeDbConn = Long.parseLong(PropertyService.getProperty("database.cycleTimeOfDBConnection"));
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Could not get property in static block: " + pnfe.getMessage());
        }
        MAXIMUMCONNECTIONNUMBER = _maxConnNum;
        INITIALCONNECTIONNUMBER = _initConnNum;
        INCREASECONNECTIONNUMBER = _incrConnNum;
        MAXIMUMAGE = _maxAge;
        MAXIMUMCONNECTIONTIME = _maxConnTime;
        MAXIMUMUSAGENUMBER = _maxUsageNum;
        DBCONNECTIONRECYCLETHREAD = _dbConnRecyclThrd;
        CYCLETIMEOFDBCONNECTION = _cyclTimeDbConn;
    }
}

