/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.dataone.D1AuthHelper;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.dataone.D1NodeVersionChecker;
import edu.ucsb.nceas.metacat.dataone.ObjectFormatService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.cn.v2.CNAuthorization;
import org.dataone.service.cn.v2.CNCore;
import org.dataone.service.cn.v2.CNRead;
import org.dataone.service.cn.v2.CNReplication;
import org.dataone.service.cn.v2.CNView;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class CNodeService
extends D1NodeService
implements CNAuthorization,
CNCore,
CNRead,
CNReplication,
CNView {
    private Log logMetacat = LogFactory.getLog(CNodeService.class);
    public static final String V2V1MISSMATCH = "The Coordinating Node is not authorized to make systemMetadata changes on this object. Please make changes directly on the authoritative Member Node.";

    public static CNodeService getInstance(HttpServletRequest request) {
        return new CNodeService(request);
    }

    private CNodeService(HttpServletRequest request) {
        super(request);
    }

    public boolean setReplicationPolicy(Session session, Identifier pid, ReplicationPolicy policy, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4883", "The provided identifier was invalid.");
        }
        String serviceFailure = "4882";
        String notFound = "4884";
        this.checkV1SystemMetaPidExist(pid, serviceFailure, "The object for given PID " + pid.getValue() + " couldn't be identified if it exists", notFound, "No object could be found for given PID: " + pid.getValue());
        Lock lock = null;
        Subject subject = session.getSubject();
        if (!this.isAuthorized(session, pid, Permission.CHANGE_PERMISSION)) {
            throw new NotAuthorized("4881", Permission.CHANGE_PERMISSION + " not allowed by " + subject.getValue() + " on " + pid.getValue());
        }
        SystemMetadata systemMetadata = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                if (HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)pid)) {
                    systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                }
                if (systemMetadata == null) {
                    throw new NotFound("4884", "Couldn't find an object identified by " + pid.getValue());
                }
                D1NodeVersionChecker checker = new D1NodeVersionChecker(systemMetadata.getAuthoritativeMemberNode());
                String version = checker.getVersion("MNRead");
                if (version == null) {
                    throw new ServiceFailure("4882", "Couldn't determine the MNRead version of the authoritative member node for the pid " + pid.getValue());
                }
                if (version.equalsIgnoreCase("v2")) {
                    throw new NotAuthorized("4881", V2V1MISSMATCH);
                }
                if (!version.equalsIgnoreCase("v1")) {
                    throw new InvalidRequest("4883", "The version of the MNRead is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
                }
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4886", msg);
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4884", "No record found for: " + pid.getValue());
            }
            systemMetadata.setReplicationPolicy(policy);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                systemMetadata.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
                this.notifyReplicaNodes(systemMetadata);
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4882", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4882", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    public boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference nodeId, long serialVersion) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, VersionMismatch {
        Lock lock = null;
        if (session == null) {
            throw new NotAuthorized("4882", "Session cannot be null. It is not authorized for deleting the replication metadata of the object " + pid.getValue());
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4882", "4884");
        authDel.doCNOnlyAuthorization(session);
        SystemMetadata systemMetadata = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                if (HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)pid)) {
                    systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                }
                if (systemMetadata == null) {
                    throw new NotFound("4884", "Couldn't find an object identified by " + pid.getValue());
                }
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4886", msg);
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4884", "No record found for: " + pid.getValue());
            }
            ArrayList updatedReplicas = new ArrayList(systemMetadata.getReplicaList());
            for (Replica r : systemMetadata.getReplicaList()) {
                if (!r.getReplicaMemberNode().equals((Object)nodeId)) continue;
                updatedReplicas.remove(r);
                break;
            }
            systemMetadata.setReplicaList(updatedReplicas);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4882", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4882", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        Lock lock = null;
        Object cn = null;
        NodeType nodeType = null;
        List nodeList = null;
        if (session == null) {
            throw new InvalidToken("4963", "No session has been provided");
        }
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("4962", "The provided identifier was invalid.");
        }
        String notAuthorizedCode = "4960";
        String notFoundCode = "4961";
        String serviceFailureCode = "4962";
        String invalidTokenCode = "4963";
        boolean needDeleteInfo = false;
        Identifier HeadOfSid = this.getPIDForSID(pid, serviceFailureCode);
        if (HeadOfSid != null) {
            pid = HeadOfSid;
        }
        SystemMetadata sysmeta = null;
        try {
            sysmeta = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidTokenCode, notFoundCode, needDeleteInfo);
        }
        catch (InvalidRequest e) {
            throw new InvalidToken(invalidTokenCode, e.getMessage());
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, notAuthorizedCode, serviceFailureCode);
        authDel.doCNOnlyAuthorization(session);
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            super.delete(session.getSubject().getValue(), pid);
        }
        catch (McdbDocNotFoundException e) {
            try {
                lock = HazelcastService.getInstance().getLock(pid.getValue());
                lock.lock();
                this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
                HazelcastService.getInstance().getSystemMetadataMap().remove((Object)pid);
                HazelcastService.getInstance().getIdentifiers().remove((Object)pid);
                String username = session.getSubject().getValue();
                EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, pid.getValue(), Event.DELETE.xmlValue());
            }
            catch (RuntimeException re) {
                throw new ServiceFailure("4962", "Couldn't delete " + pid.getValue() + ". The error message was: " + re.getMessage());
            }
            finally {
                lock.unlock();
                this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
            }
        }
        catch (SQLException e) {
            throw new ServiceFailure("4962", "Couldn't delete " + pid.getValue() + ". The local id of the object with the identifier can't be identified since " + e.getMessage());
        }
        try {
            nodeList = this.getCNNodeList().getNodeList();
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Can't inform MNs of the deletion of " + pid.getValue() + " due to communication issues with the CN: " + e.getMessage()));
        }
        if (sysmeta.getReplicaList() != null) {
            for (Replica replica : sysmeta.getReplicaList()) {
                NodeReference replicaNode = replica.getReplicaMemberNode();
                try {
                    if (nodeList != null) {
                        for (Node node : nodeList) {
                            if (!node.getIdentifier().getValue().equals(replicaNode.getValue())) continue;
                            nodeType = node.getType();
                            break;
                        }
                    }
                    if (nodeType == null || nodeType != NodeType.MN) continue;
                    Identifier identifier = D1Client.getMN((NodeReference)replicaNode).delete(null, pid);
                }
                catch (Exception e) {
                    this.logMetacat.error((Object)("Error deleting pid: " + pid.getValue() + " from replica MN: " + replicaNode.getValue()), (Throwable)e);
                }
            }
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        if (session == null) {
            throw new InvalidToken("4973", "No session has been provided");
        }
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("4972", "The provided identifier was invalid.");
        }
        String serviceFailureCode = "4972";
        String notFoundCode = "4971";
        String notAuthorizedCode = "4970";
        String invalidTokenCode = "4973";
        boolean needDeleteInfo = false;
        Identifier HeadOfSid = this.getPIDForSID(pid, serviceFailureCode);
        if (HeadOfSid != null) {
            pid = HeadOfSid;
        }
        SystemMetadata sysmeta = null;
        try {
            sysmeta = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidTokenCode, notFoundCode, needDeleteInfo);
        }
        catch (InvalidRequest e) {
            throw new InvalidToken(invalidTokenCode, e.getMessage());
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, notAuthorizedCode, serviceFailureCode);
        authDel.doIsAuthorized(session, sysmeta, Permission.CHANGE_PERMISSION);
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
            this.logMetacat.debug((Object)("CNodeService.archive - lock the system metadata for " + pid.getValue()));
            D1NodeVersionChecker checker = new D1NodeVersionChecker(sysmeta.getAuthoritativeMemberNode());
            String version = checker.getVersion("MNRead");
            if (version == null) {
                throw new ServiceFailure("4972", "Couldn't determine the MNRead version of the authoritative member node for the pid " + pid.getValue());
            }
            if (version.equalsIgnoreCase("v2")) {
                throw new NotAuthorized("4970", V2V1MISSMATCH);
            }
            if (!version.equalsIgnoreCase("v1")) {
                throw new NotImplemented("4974", "The version of the MNRead is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
            }
            boolean needModifyDate = true;
            this.archiveCNObjectWithNotificationReplica(session, pid, sysmeta, needModifyDate);
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
            this.logMetacat.debug((Object)("CNodeService.archive - unlock the system metadata for " + pid.getValue()));
        }
        return pid;
    }

    private Identifier archiveCNObjectWithNotificationReplica(Session session, Identifier pid, SystemMetadata sysMeta, boolean needModifyDate) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        boolean logArchive = true;
        this.archiveCNObject(logArchive, session, pid, sysMeta, needModifyDate);
        this.notifyReplicaNodes(sysMeta);
        return pid;
    }

    public boolean setObsoletedBy(Session session, Identifier pid, Identifier obsoletedByPid, long serialVersion) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4942", "The provided identifier was invalid.");
        }
        if (obsoletedByPid == null || obsoletedByPid.getValue().trim().equals("")) {
            throw new InvalidRequest("4942", "The provided obsoletedByPid was invalid.");
        }
        try {
            if (IdentifierManager.getInstance().systemMetadataSIDExists(obsoletedByPid)) {
                throw new InvalidRequest("4942", "The provided obsoletedByPid " + obsoletedByPid.getValue() + " is an existing SID. However, it must NOT be an SID.");
            }
        }
        catch (SQLException ee) {
            throw new ServiceFailure("4941", "Couldn't determine if the obsoletedByPid " + obsoletedByPid.getValue() + " is an SID or not. The id shouldn't be an SID.");
        }
        Lock lock = null;
        Subject subject = session.getSubject();
        if (!this.isAuthorized(session, pid, Permission.WRITE)) {
            throw new NotAuthorized("4881", Permission.WRITE + " not allowed by " + subject.getValue() + " on " + pid.getValue());
        }
        SystemMetadata systemMetadata = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                if (HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)pid)) {
                    systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                }
                if (systemMetadata == null) {
                    throw new NotFound("4884", "Couldn't find an object identified by " + pid.getValue());
                }
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4886", msg);
                }
                D1NodeVersionChecker checker = new D1NodeVersionChecker(systemMetadata.getAuthoritativeMemberNode());
                String version = checker.getVersion("MNRead");
                if (version == null) {
                    throw new ServiceFailure("4941", "Couldn't determine the MNRead version of the authoritative member node for the pid " + pid.getValue());
                }
                if (version.equalsIgnoreCase("v2")) {
                    throw new NotAuthorized("4945", V2V1MISSMATCH);
                }
                if (!version.equalsIgnoreCase("v1")) {
                    throw new InvalidRequest("4942", "The version of the MNRead is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4884", "No record found for: " + pid.getValue());
            }
            systemMetadata.setObsoletedBy(obsoletedByPid);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                systemMetadata.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4882", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4882", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setReplicationStatus(Session session, Identifier pid, NodeReference targetNode, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        Object msg;
        if (session == null) {
            throw new NotAuthorized("4720", "Session cannot be null");
        }
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4730", "The provided identifier was invalid.");
        }
        Lock lock = null;
        boolean allowed = false;
        int replicaEntryIndex = -1;
        List replicas = null;
        Subject subject = session.getSubject();
        this.logMetacat.debug((Object)("ReplicationStatus for identifier " + pid.getValue() + " is " + status.toString()));
        SystemMetadata systemMetadata = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                if (systemMetadata == null) {
                    this.logMetacat.debug((Object)("systemMetadata is null for " + pid.getValue()));
                    throw new NotFound("4740", "Couldn't find an object identified by " + pid.getValue());
                }
                replicas = systemMetadata.getReplicaList();
                int count = 0;
                if (failure != null && status.equals((Object)ReplicationStatus.FAILED)) {
                    msg = "The replication request of the object identified by " + pid.getValue() + " failed.  The error message was " + failure.getMessage() + ".";
                    this.logMetacat.error(msg);
                }
                if (replicas.size() > 0 && replicas != null) {
                    for (Replica replica : replicas) {
                        String replicaNodeStr = replica.getReplicaMemberNode().getValue();
                        String targetNodeStr = targetNode.getValue();
                        this.logMetacat.debug((Object)("Comparing " + replicaNodeStr + " to " + targetNodeStr));
                        if (replicaNodeStr.equals(targetNodeStr)) {
                            replicaEntryIndex = count;
                            this.logMetacat.debug((Object)("replica entry index is: " + replicaEntryIndex));
                            break;
                        }
                        ++count;
                    }
                }
                List nodes = this.getCNNodeList().getNodeList();
                block11: for (Node node : nodes) {
                    NodeReference nodeReference = node.getIdentifier();
                    this.logMetacat.debug((Object)("In setReplicationStatus(), Node reference is: " + nodeReference.getValue()));
                    if (!targetNode.getValue().equals(nodeReference.getValue()) || !node.getType().equals((Object)NodeType.MN)) continue;
                    List nodeSubjects = node.getSubjectList();
                    for (Subject nodeSubject : nodeSubjects) {
                        this.logMetacat.debug((Object)("In setReplicationStatus(), comparing subjects: " + nodeSubject.getValue() + " and " + subject.getValue()));
                        if (!nodeSubject.equals((Object)subject) || !status.equals((Object)ReplicationStatus.COMPLETED) && !status.equals((Object)ReplicationStatus.INVALIDATED) && !status.equals((Object)ReplicationStatus.FAILED)) continue;
                        allowed = true;
                        continue block11;
                    }
                }
                if (!allowed) {
                    D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4861", "????");
                    authDel.doCNOnlyAuthorization(session);
                    allowed = true;
                }
                if (!allowed) {
                    String msg2 = "The subject identified by " + subject.getValue() + " is not a CN or MN, and does not have permission to set the replication status for the replica identified by " + targetNode.getValue() + ".";
                    this.logMetacat.info((Object)msg2);
                    throw new NotAuthorized("4720", msg2);
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4740", "No record found for: " + pid.getValue() + " : " + e.getMessage());
            }
            Replica targetReplica = new Replica();
            if (replicaEntryIndex != -1) {
                targetReplica = (Replica)replicas.get(replicaEntryIndex);
                if (targetReplica.getReplicationStatus().equals((Object)ReplicationStatus.COMPLETED) && !status.equals((Object)ReplicationStatus.INVALIDATED)) {
                    throw new InvalidRequest("4730", "Status state change from " + targetReplica.getReplicationStatus() + " to " + status.toString() + "is prohibited for identifier " + pid.getValue() + " and target node " + targetReplica.getReplicaMemberNode().getValue());
                }
                if (targetReplica.getReplicationStatus().equals((Object)status)) {
                    boolean nodes = true;
                    return nodes;
                }
                targetReplica.setReplicationStatus(status);
                this.logMetacat.debug((Object)("Set the replication status for " + targetReplica.getReplicaMemberNode().getValue() + " to " + targetReplica.getReplicationStatus() + " for identifier " + pid.getValue()));
            } else {
                targetReplica.setReplicaMemberNode(targetNode);
                targetReplica.setReplicationStatus(status);
                targetReplica.setReplicaVerified(Calendar.getInstance().getTime());
                replicas.add(targetReplica);
            }
            systemMetadata.setReplicaList(replicas);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
                if (!status.equals((Object)ReplicationStatus.QUEUED) && !status.equals((Object)ReplicationStatus.REQUESTED)) {
                    this.logMetacat.trace((Object)("METRICS:\tREPLICATION:\tEND REQUEST:\tPID:\t" + pid.getValue() + "\tNODE:\t" + targetNode.getValue() + "\tSIZE:\t" + systemMetadata.getSize().intValue()));
                    this.logMetacat.trace((Object)("METRICS:\tREPLICATION:\t" + status.toString().toUpperCase() + "\tPID:\t" + pid.getValue() + "\tNODE:\t" + targetNode.getValue() + "\tSIZE:\t" + systemMetadata.getSize().intValue()));
                }
                if (status.equals((Object)ReplicationStatus.FAILED) && failure != null) {
                    this.logMetacat.warn((Object)("Replication failed for identifier " + pid.getValue() + " on target node " + targetNode + ". The exception was: " + failure.getMessage()));
                }
                if (status.equals((Object)ReplicationStatus.COMPLETED) || status.equals((Object)ReplicationStatus.FAILED) || status.equals((Object)ReplicationStatus.INVALIDATED)) {
                    this.notifyReplicaNodes(systemMetadata);
                }
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4700", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            msg = "There was a RuntimeException getting the lock for " + pid.getValue();
            this.logMetacat.info(msg);
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    public Checksum getChecksum(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        boolean isAuthorized = false;
        try {
            isAuthorized = this.isAuthorized(session, pid, Permission.READ);
        }
        catch (InvalidRequest e) {
            throw new ServiceFailure("1410", e.getDescription());
        }
        if (!isAuthorized) {
            throw new NotAuthorized("1400", Permission.READ + " not allowed on " + pid.getValue());
        }
        SystemMetadata systemMetadata = null;
        Checksum checksum = null;
        try {
            systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            if (systemMetadata == null) {
                String error = "";
                boolean existsInIdentifierTable = false;
                try {
                    existsInIdentifierTable = IdentifierManager.getInstance().existsInIdentifierTable(pid);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Couldn't determine if the " + pid.getValue() + " is in the identifier table since " + e.getMessage() + ". So we assume it is not there."));
                }
                if (existsInIdentifierTable) {
                    error = "The object with the PID has been deleted from the node.";
                }
                throw new NotFound("1420", "Couldn't find an object identified by " + pid.getValue() + ". " + error);
            }
            checksum = systemMetadata.getChecksum();
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("1410", "An error occurred getting the checksum for " + pid.getValue() + ". The error message was: " + e.getMessage());
        }
        return checksum;
    }

    public ObjectLocationList resolve(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        throw new NotImplemented("4131", "resolve not implemented");
    }

    public ObjectList search(Session session, String queryType, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        throw new NotImplemented("4281", "Metacat does not implement CN.search");
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier fmtid) throws ServiceFailure, NotFound, NotImplemented {
        return ObjectFormatService.getInstance().getFormat(fmtid);
    }

    public ObjectFormatIdentifier addFormat(Session session, ObjectFormatIdentifier formatId, ObjectFormat format) throws ServiceFailure, NotFound, NotImplemented, NotAuthorized, InvalidToken {
        this.logMetacat.debug((Object)("CNodeService.addFormat() called.\nformat ID: " + format.getFormatId() + "\nformat name: " + format.getFormatName() + "\nformat type: " + format.getFormatType()));
        throw new NotImplemented("0000", "Implementation underway... Will need testing too...");
    }

    private void createNewObjectFormatList(Session session, Identifier lastPid, Identifier nextPid, ObjectFormatList objectFormatList, SystemMetadata lastSysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        PipedInputStream is = new PipedInputStream();
        PipedOutputStream os = null;
        try {
            os = new PipedOutputStream(is);
            TypeMarshaller.marshalTypeToOutputStream((Object)objectFormatList, (OutputStream)os);
        }
        catch (IOException | MarshallingException e) {
            throw new ServiceFailure("0000", "Unable to marshal object format list.\n" + e.getMessage());
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (IOException ioe) {
                throw new ServiceFailure("0000", "Unable to marshal object format list.\n" + ioe.getMessage());
            }
        }
        BigInteger docSize = lastSysmeta.getSize();
        try {
            docSize = BigInteger.valueOf(is.available());
        }
        catch (IOException e) {
            this.logMetacat.warn((Object)"Unable to set an accurate size for the new object format list.", (Throwable)e);
        }
        lastSysmeta.setIdentifier(nextPid);
        lastSysmeta.setObsoletes(lastPid);
        lastSysmeta.setSize(docSize);
        lastSysmeta.setSubmitter(session.getSubject());
        lastSysmeta.setDateUploaded(new Date());
        try {
            this.create(session, nextPid, is, lastSysmeta);
        }
        catch (IdentifierNotUnique | InsufficientResources | InvalidRequest | InvalidSystemMetadata | UnsupportedType e) {
            throw new ServiceFailure("0000", "Unable to create() new object format list" + e.getMessage());
        }
    }

    private void updateOldObjectFormatList(Session session, Identifier lastPid, Identifier obsoletedByPid, SystemMetadata lastSysmeta) throws ServiceFailure {
        lastSysmeta.setObsoletedBy(obsoletedByPid);
        try {
            this.updateSystemMetadata(session, lastPid, lastSysmeta);
        }
        catch (InvalidRequest | InvalidSystemMetadata | InvalidToken | NotAuthorized | NotImplemented | ServiceFailure e) {
            throw new ServiceFailure("0000", "Unable to update metadata of old object format list.\n" + e.getMessage());
        }
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        return ObjectFormatService.getInstance().listFormats();
    }

    public NodeList listNodes() throws NotImplemented, ServiceFailure {
        throw new NotImplemented("4800", "listNodes not implemented");
    }

    public Identifier registerSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata {
        Lock lock = null;
        if (session == null) {
            throw new NotAuthorized("4861", "No Session - could not authorize for registration.  If you are not logged in, please do so and retry the request.");
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4861", "????");
        authDel.doCNOnlyAuthorization(session);
        try {
            if (IdentifierManager.getInstance().systemMetadataSIDExists(pid)) {
                throw new InvalidRequest("4863", "The provided identifier " + pid.getValue() + " is a series id which is not allowed.");
            }
        }
        catch (SQLException sqle) {
            throw new ServiceFailure("4862", "Couldn't determine if the pid " + pid.getValue() + " is a series id since " + sqle.getMessage());
        }
        this.logMetacat.debug((Object)("Comparing guid|sysmeta_guid: " + pid.getValue() + "|" + sysmeta.getIdentifier().getValue()));
        if (!pid.getValue().equals(sysmeta.getIdentifier().getValue())) {
            throw new InvalidRequest("4863", "The identifier in method call (" + pid.getValue() + ") does not match identifier in system metadata (" + sysmeta.getIdentifier().getValue() + ").");
        }
        Identifier sid = sysmeta.getSeriesId();
        if (sid != null && !CNodeService.isValidIdentifier(sid)) {
            throw new InvalidRequest("4863", "The series id in the system metadata is invalid in the request.");
        }
        try {
            lock = HazelcastService.getInstance().getLock(sysmeta.getIdentifier().getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            this.logMetacat.debug((Object)"Checking if identifier exists...");
            if (HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)pid)) {
                throw new InvalidRequest("4863", "The identifier is already in use by an existing object.");
            }
            this.logMetacat.debug((Object)"Starting to insert SystemMetadata...");
            try {
                D1NodeVersionChecker checker = new D1NodeVersionChecker(sysmeta.getAuthoritativeMemberNode());
                String version = checker.getVersion("MNRead");
                if (version != null && version.equalsIgnoreCase("v1")) {
                    sysmeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysmeta.getIdentifier(), (Object)sysmeta);
            }
            catch (RuntimeException e) {
                this.logMetacat.error((Object)("Problem registering system metadata: " + pid.getValue()), (Throwable)e);
                throw new ServiceFailure("4862", "Error inserting system metadata: " + e.getClass() + ": " + e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4862", "Error inserting system metadata: " + e.getClass() + ": " + e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        this.logMetacat.debug((Object)"Returning from registerSystemMetadata");
        try {
            String localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), session.getSubject().getValue(), localId, "registerSystemMetadata");
        }
        catch (McdbDocNotFoundException e) {
            this.logMetacat.warn((Object)("Could not log 'registerSystemMetadata' event because no localId was found for pid: " + pid.getValue()));
        }
        catch (SQLException ee) {
            this.logMetacat.warn((Object)("Could not log 'registerSystemMetadata' event because the localId couldn't be identified for pid: " + pid.getValue()));
        }
        return pid;
    }

    public Identifier reserveIdentifier(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        throw new NotImplemented("4191", "reserveIdentifier not implemented on this node");
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        throw new NotImplemented("4191", "generateIdentifier not implemented on this node");
    }

    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        throw new NotImplemented("4191", "hasReservation not implemented on this node");
    }

    public Identifier setRightsHolder(Session session, Identifier pid, Subject userId, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        Lock lock = null;
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4442", "The provided identifier was invalid.");
        }
        Subject subject = session.getSubject();
        String serviceFailureCode = "4490";
        String notFoundCode = "4460";
        String notAuthorizedCode = "4440";
        String invalidRequestCode = "4442";
        boolean needDeleteInfo = false;
        Identifier HeadOfSid = this.getPIDForSID(pid, serviceFailureCode);
        if (HeadOfSid != null) {
            pid = HeadOfSid;
        }
        SystemMetadata systemMetadata = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidRequestCode, notFoundCode, needDeleteInfo);
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, notAuthorizedCode, serviceFailureCode);
        authDel.doIsAuthorized(session, systemMetadata, Permission.CHANGE_PERMISSION);
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4443", msg);
                }
                D1NodeVersionChecker checker = new D1NodeVersionChecker(systemMetadata.getAuthoritativeMemberNode());
                String version = checker.getVersion("MNRead");
                if (version == null) {
                    throw new ServiceFailure("4490", "Couldn't determine the MNRead version of the authoritative member node storage version for the pid " + pid.getValue());
                }
                if (version.equalsIgnoreCase("v2")) {
                    throw new NotAuthorized("4440", V2V1MISSMATCH);
                }
                if (!version.equalsIgnoreCase("v1")) {
                    throw new InvalidRequest("4442", "The version of the MNRead is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4460", "No record found for: " + pid.getValue());
            }
            systemMetadata.setRightsHolder(userId);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                systemMetadata.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)systemMetadata);
                this.notifyReplicaNodes(systemMetadata);
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4490", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4490", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return pid;
    }

    public boolean isNodeAuthorized(Session originatingNodeSession, Subject targetNodeSubject, Identifier pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        boolean isAllowed = false;
        SystemMetadata sysmeta = null;
        NodeReference targetNode = null;
        try {
            List nodes = this.getCNNodeList().getNodeList();
            if (nodes != null) {
                for (Object node : nodes) {
                    if (node.getSubjectList() != null) {
                        for (Subject nodeSubject : node.getSubjectList()) {
                            if (!nodeSubject.equals((Object)targetNodeSubject)) continue;
                            targetNode = node.getIdentifier();
                            this.logMetacat.debug((Object)("targetNode is : " + targetNode.getValue()));
                            break;
                        }
                    }
                    if (targetNode == null) continue;
                    break;
                }
            } else {
                String msg = "Couldn't get the node list from the CN";
                this.logMetacat.debug((Object)msg);
                throw new ServiceFailure("4872", msg);
            }
            if (targetNode == null) {
                String msg = "There is no Member Node registered with a node subject matching " + targetNodeSubject.getValue();
                this.logMetacat.info((Object)msg);
                throw new NotAuthorized("4871", msg);
            }
            this.logMetacat.debug((Object)("Getting system metadata for identifier " + pid.getValue()));
            sysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            if (sysmeta != null) {
                List replicaList = sysmeta.getReplicaList();
                if (replicaList != null) {
                    for (Replica replica : replicaList) {
                        ReplicationStatus status = replica.getReplicationStatus();
                        NodeReference listedNode = replica.getReplicaMemberNode();
                        if (listedNode == null || targetNode == null) continue;
                        this.logMetacat.debug((Object)("Comparing " + listedNode.getValue() + " to " + targetNode.getValue()));
                        if (!listedNode.getValue().equals(targetNode.getValue()) || !status.equals((Object)ReplicationStatus.REQUESTED)) continue;
                        isAllowed = true;
                        break;
                    }
                }
            } else {
                this.logMetacat.debug((Object)("System metadata for identifier " + pid.getValue() + " is null."));
                String error = "";
                boolean existsInIdentifierTable = false;
                try {
                    existsInIdentifierTable = IdentifierManager.getInstance().existsInIdentifierTable(pid);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Couldn't determine if the " + pid.getValue() + " is in the identifier table since " + e.getMessage() + ". So we assume it is not there."));
                }
                if (existsInIdentifierTable) {
                    error = "The object with the PID has been deleted from the node.";
                }
                throw new NotFound("4874", "Couldn't find an object identified by " + pid.getValue() + ". " + error);
            }
            this.logMetacat.debug((Object)("The " + targetNode.getValue() + " is allowed to replicate: " + isAllowed + " for " + pid.getValue()));
        }
        catch (RuntimeException e) {
            ServiceFailure sf = new ServiceFailure("4872", "Runtime Exception: Couldn't determine if node is allowed: " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return isAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Identifier create(Session session, Identifier pid, InputStream object, SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        block16: {
            try {
                if (!CNodeService.isValidIdentifier(pid)) {
                    throw new InvalidRequest("4891", "The provided identifier is invalid.");
                }
                if (session == null) {
                    throw new InvalidToken("4894", "Session is required to WRITE to the Node.");
                }
                this.logMetacat.debug((Object)("CN.create -start to create the object with pid " + pid.getValue()));
                Lock lock = null;
                try {
                    boolean isAllowed = false;
                    D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4861", "????");
                    authDel.doCNOnlyAuthorization(session);
                    isAllowed = true;
                    if (isAllowed) {
                        lock = HazelcastService.getInstance().getLock(pid.getValue());
                        lock.lock();
                        CNodeService.objectExists(pid);
                        Identifier sid = sysmeta.getSeriesId();
                        if (sid != null && !CNodeService.isValidIdentifier(sid)) {
                            throw new InvalidRequest("4891", "The series id in the system metadata is invalid in the request.");
                        }
                        this.logMetacat.debug((Object)("CN.create - after locking identifier, passing authorization check, continue to create the object " + pid.getValue()));
                        sysmeta.setSerialVersion(BigInteger.ONE);
                        D1NodeVersionChecker checker = new D1NodeVersionChecker(sysmeta.getAuthoritativeMemberNode());
                        String version = checker.getVersion("MNRead");
                        if (version != null && version.equalsIgnoreCase("v1")) {
                            sysmeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                        }
                        try {
                            sysmeta.getOriginMemberNode().getValue();
                            sysmeta.getAuthoritativeMemberNode().getValue();
                        }
                        catch (NullPointerException npe) {
                            throw new InvalidSystemMetadata("4896", "Both the origin and authoritative member node identifiers need to be set.");
                        }
                        pid = super.create(session, pid, object, sysmeta);
                        break block16;
                    }
                    String msg = "The subject listed as " + session.getSubject().getValue() + " isn't allowed to call create() on a Coordinating Node for pid " + pid.getValue();
                    this.logMetacat.error((Object)msg);
                    throw new NotAuthorized("1100", msg);
                }
                catch (RuntimeException e) {
                    String msg = "There was a problem creating the object identified by " + pid.getValue() + ". There error message was: " + e.getMessage();
                    throw new ServiceFailure("4893", msg);
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                        this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)object);
            }
        }
        return pid;
    }

    public boolean setAccessPolicy(Session session, Identifier pid, AccessPolicy accessPolicy, long serialVersion) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, VersionMismatch {
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("4402", "The provided identifier was invalid.");
        }
        String serviceFailureCode = "4430";
        String notFoundCode = "4400";
        String notAuthorizedCode = "4420";
        String invalidRequestCode = "4402";
        boolean needDeleteInfo = false;
        Identifier HeadOfSid = this.getPIDForSID(pid, serviceFailureCode);
        if (HeadOfSid != null) {
            pid = HeadOfSid;
        }
        SystemMetadata systemMetadata = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidRequestCode, notFoundCode, needDeleteInfo);
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, notAuthorizedCode, serviceFailureCode);
        authDel.doIsAuthorized(session, systemMetadata, Permission.CHANGE_PERMISSION);
        Lock lock = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                if (systemMetadata == null) {
                    throw new NotFound("4400", "Couldn't find an object identified by " + pid.getValue());
                }
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4402", msg);
                }
                D1NodeVersionChecker checker = new D1NodeVersionChecker(systemMetadata.getAuthoritativeMemberNode());
                String version = checker.getVersion("MNRead");
                if (version == null) {
                    throw new ServiceFailure("4430", "Couldn't determine the version of MNRead of the authoritative member node for the pid " + pid.getValue());
                }
                if (version.equalsIgnoreCase("v2")) {
                    throw new NotAuthorized("4420", V2V1MISSMATCH);
                }
                if (!version.equalsIgnoreCase("v1")) {
                    throw new InvalidRequest("4402", "The version of the MNRead is " + version + " for the authoritative member node of the object " + pid.getValue() + ". We don't support it.");
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4400", "No record found for: " + pid);
            }
            systemMetadata.setAccessPolicy(accessPolicy);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                systemMetadata.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
                this.notifyReplicaNodes(systemMetadata);
            }
            catch (RuntimeException e) {
                throw new ServiceFailure("4430", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new ServiceFailure("4430", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    public boolean updateReplicationMetadata(Session session, Identifier pid, Replica replica, long serialVersion) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, NotFound, VersionMismatch {
        Lock lock = null;
        Subject subject = session.getSubject();
        if (session == null) {
            throw new NotAuthorized("4851", "Session cannot be null. It is not authorized for updating the replication metadata of the object " + pid.getValue());
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4851", "4852");
        authDel.doCNOnlyAuthorization(session);
        SystemMetadata systemMetadata = null;
        try {
            lock = HazelcastService.getInstance().getLock(pid.getValue());
            lock.lock();
            this.logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
            try {
                systemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                if (systemMetadata.getSerialVersion().longValue() != serialVersion) {
                    String msg = "The requested system metadata version number " + serialVersion + " differs from the current version at " + systemMetadata.getSerialVersion().longValue() + ". Please get the latest copy in order to modify it.";
                    throw new VersionMismatch("4855", msg);
                }
            }
            catch (RuntimeException e) {
                throw new NotFound("4854", "No record found for: " + pid.getValue() + " : " + e.getMessage());
            }
            List replicas = systemMetadata.getReplicaList();
            NodeReference replicaNode = replica.getReplicaMemberNode();
            ReplicationStatus replicaStatus = replica.getReplicationStatus();
            int index = 0;
            for (Replica listedReplica : replicas) {
                if (replicaNode.getValue().equals(listedReplica.getReplicaMemberNode().getValue())) {
                    if (!listedReplica.getReplicationStatus().equals((Object)replicaStatus) && listedReplica.getReplicationStatus().equals((Object)ReplicationStatus.COMPLETED) && !replicaStatus.equals((Object)ReplicationStatus.INVALIDATED)) {
                        throw new InvalidRequest("4853", "Status state change from " + listedReplica.getReplicationStatus() + " to " + replicaStatus.toString() + "is prohibited for identifier " + pid.getValue() + " and target node " + listedReplica.getReplicaMemberNode().getValue());
                    }
                    replicas.remove(index);
                    break;
                }
                ++index;
            }
            replicas.add(replica);
            systemMetadata.setReplicaList(replicas);
            try {
                systemMetadata.setSerialVersion(systemMetadata.getSerialVersion().add(BigInteger.ONE));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)systemMetadata.getIdentifier(), (Object)systemMetadata);
                if (replicaStatus.equals((Object)ReplicationStatus.COMPLETED)) {
                    this.notifyReplicaNodes(systemMetadata);
                }
            }
            catch (RuntimeException e) {
                this.logMetacat.info((Object)("Unknown RuntimeException thrown: " + e.getCause().getMessage()));
                throw new ServiceFailure("4852", e.getMessage());
            }
        }
        catch (RuntimeException e) {
            this.logMetacat.info((Object)("Unknown RuntimeException thrown: " + e.getCause().getMessage()));
            throw new ServiceFailure("4852", e.getMessage());
        }
        finally {
            lock.unlock();
            this.logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
        }
        return true;
    }

    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier formatid, NodeReference nodeId, Identifier identifier, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return super.listObjects(session, startTime, endTime, formatid, identifier, nodeId, start, count);
    }

    public ChecksumAlgorithmList listChecksumAlgorithms() throws ServiceFailure, NotImplemented {
        ChecksumAlgorithmList cal = new ChecksumAlgorithmList();
        cal.addAlgorithm("MD5");
        cal.addAlgorithm("SHA-1");
        return cal;
    }

    public void notifyReplicaNodes(SystemMetadata currentSystemMetadata) {
        Session session = null;
        List replicaList = currentSystemMetadata.getReplicaList();
        NodeReference replicaNodeRef = null;
        Object cn = null;
        NodeType nodeType = null;
        List nodeList = null;
        try {
            nodeList = this.getCNNodeList().getNodeList();
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Can't inform MNs of system metadata changes due to communication issues with the CN: " + e.getMessage()));
        }
        if (replicaList != null) {
            for (Replica replica : replicaList) {
                String replicationVersion = null;
                replicaNodeRef = replica.getReplicaMemberNode();
                try {
                    MNode mn;
                    if (nodeList != null) {
                        for (Node node : nodeList) {
                            if (!node.getIdentifier().getValue().equals(replicaNodeRef.getValue())) continue;
                            nodeType = node.getType();
                            D1NodeVersionChecker checker = new D1NodeVersionChecker(replicaNodeRef);
                            replicationVersion = checker.getVersion("MNRead");
                            break;
                        }
                    }
                    if (replicationVersion == null || nodeType == null || nodeType != NodeType.MN) continue;
                    if (replicationVersion.equalsIgnoreCase("v2")) {
                        mn = D1Client.getMN((NodeReference)replicaNodeRef);
                        mn.systemMetadataChanged(session, currentSystemMetadata.getIdentifier(), currentSystemMetadata.getSerialVersion().longValue(), currentSystemMetadata.getDateSysMetadataModified());
                        continue;
                    }
                    if (!replicationVersion.equalsIgnoreCase("v1")) continue;
                    mn = org.dataone.client.v1.itk.D1Client.getMN((NodeReference)replicaNodeRef);
                    mn.systemMetadataChanged(session, currentSystemMetadata.getIdentifier(), currentSystemMetadata.getSerialVersion().longValue(), currentSystemMetadata.getDateSysMetadataModified());
                }
                catch (Exception e) {
                    this.logMetacat.error((Object)("Can't inform " + replicaNodeRef.getValue() + " of system metadata changes due to communication issues with the CN: " + e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSystemMetadata(Session session, Identifier pid, SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        if (sysmeta == null) {
            throw new InvalidRequest("4863", "The system metadata object should NOT be null in the updateSystemMetadata request.");
        }
        if (pid == null || pid.getValue() == null) {
            throw new InvalidRequest("4863", "Please specify the id in the updateSystemMetadata request ");
        }
        if (session == null) {
            throw new NotAuthorized("4861", "No Session - could not authorize for updating system metadata.  If you are not logged in, please do so and retry the request.");
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "4861", "????");
        authDel.doCNOnlyAuthorization(session);
        boolean success = false;
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
            SystemMetadata currentSysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            if (currentSysmeta == null) {
                throw new InvalidRequest("4863", "We can't find the current system metadata on the member node for the id " + pid.getValue());
            }
            BigInteger currentSerialVersion = currentSysmeta.getSerialVersion();
            sysmeta.setSerialVersion(currentSerialVersion);
            List replicas = currentSysmeta.getReplicaList();
            sysmeta.setReplicaList(replicas);
            boolean needUpdateModificationDate = false;
            boolean fromCN = true;
            success = this.updateSystemMetadata(session, pid, sysmeta, needUpdateModificationDate, currentSysmeta, fromCN);
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
        }
        return success;
    }

    public boolean synchronize(Session session, Identifier pid) throws NotAuthorized, InvalidRequest, NotImplemented {
        throw new NotImplemented("0000", "CN query services are not implemented in Metacat.");
    }

    public QueryEngineDescription getQueryEngineDescription(Session session, String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        throw new NotImplemented("0000", "CN query services are not implemented in Metacat.");
    }

    public QueryEngineList listQueryEngines(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        throw new NotImplemented("0000", "CN query services are not implemented in Metacat.");
    }

    public InputStream query(Session session, String queryEngine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        throw new NotImplemented("0000", "CN query services are not implemented in Metacat.");
    }

    public Node getCapabilities() throws NotImplemented, ServiceFailure {
        throw new NotImplemented("0000", "The CN capabilities are not stored in Metacat.");
    }
}

