/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.EventLogData;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.MetacatVersion;
import edu.ucsb.nceas.metacat.ReadOnlyChecker;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.dataone.D1AuthHelper;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.dataone.D1NodeVersionChecker;
import edu.ucsb.nceas.metacat.dataone.NodeReplicationPolicyChecker;
import edu.ucsb.nceas.metacat.dataone.SyncAccessPolicy;
import edu.ucsb.nceas.metacat.dataone.SystemMetadataFactory;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaServiceManager;
import edu.ucsb.nceas.metacat.dataone.resourcemap.ResourceMapModifier;
import edu.ucsb.nceas.metacat.doi.DOIException;
import edu.ucsb.nceas.metacat.doi.DOIServiceFactory;
import edu.ucsb.nceas.metacat.download.PackageDownloaderV1;
import edu.ucsb.nceas.metacat.download.PackageDownloaderV2;
import edu.ucsb.nceas.metacat.index.MetacatSolrEngineDescriptionHandler;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.object.handler.NonXMLMetadataHandlers;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.formats.ObjectFormatInfo;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.mn.tier1.v2.MNCore;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.mn.tier2.v2.MNAuthorization;
import org.dataone.service.mn.tier3.v2.MNStorage;
import org.dataone.service.mn.tier4.v2.MNReplication;
import org.dataone.service.mn.v2.MNPackage;
import org.dataone.service.mn.v2.MNQuery;
import org.dataone.service.mn.v2.MNView;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Ping;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Schedule;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.ServiceMethodRestriction;
import org.dataone.service.types.v1.Services;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.Synchronization;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.types.v1_1.QueryField;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.Property;
import org.dataone.service.types.v2.TypeFactory;
import org.dataone.service.util.TypeMarshaller;
import org.dataone.speedbagit.SpeedBagException;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ResourceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MNodeService
extends D1NodeService
implements MNAuthorization,
MNCore,
MNRead,
MNReplication,
MNStorage,
MNQuery,
MNView,
MNPackage {
    public static final String UUID_SCHEME = "UUID";
    public static final String DOI_SCHEME = "DOI";
    private static final String UUID_PREFIX = "urn:uuid:";
    private static String XPATH_EML_ID = "/eml:eml/@packageId";
    private static Log logMetacat = LogFactory.getLog(MNodeService.class);
    private CNode cn;
    private static ExecutorService executor = null;
    private static boolean enforcePublicEntirePackageInPublish = true;
    private boolean needSync = true;

    public static MNodeService getInstance(HttpServletRequest request) {
        return new MNodeService(request);
    }

    public static MNodeService getInstance(HttpServletRequest request, String ipAddress, String userAgent) {
        MNodeService mnService = new MNodeService(request);
        mnService.setIpAddress(ipAddress);
        mnService.setUserAgent(userAgent);
        return mnService;
    }

    private MNodeService(HttpServletRequest request) {
        super(request);
        CertificateManager.getInstance().setCertificateLocation(Settings.getConfiguration().getString("D1Client.certificate.file"));
        try {
            this.needSync = new Boolean(PropertyService.getProperty("dataone.nodeSynchronize"));
        }
        catch (PropertyNotFoundException e) {
            logMetacat.warn((Object)"MNodeService.constructor : can't find the property to indicate if the memeber node need to be synchronized. It will use the default value - true.");
        }
    }

    public Identifier delete(Session session, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailureCode = "2902";
        String notFoundCode = "2901";
        String notAuthorizedCode = "2900";
        String invalidTokenCode = "2903";
        boolean needDeleteInfo = false;
        if (this.isReadOnlyMode()) {
            throw new ServiceFailure("2902", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        Identifier HeadOfSid = this.getPIDForSID(id, serviceFailureCode);
        if (HeadOfSid != null) {
            id = HeadOfSid;
        }
        org.dataone.service.types.v2.SystemMetadata sysmeta = null;
        try {
            sysmeta = this.getSystemMetadataForPID(id, serviceFailureCode, invalidTokenCode, notFoundCode, needDeleteInfo);
        }
        catch (InvalidRequest e) {
            throw new InvalidToken(invalidTokenCode, e.getMessage());
        }
        try {
            D1AuthHelper authDel = new D1AuthHelper(this.request, id, notAuthorizedCode, serviceFailureCode);
            authDel.doAdminAuthorization(session);
        }
        catch (NotAuthorized na) {
            NotAuthorized na2 = new NotAuthorized(notAuthorizedCode, "The provided identity does not have permission to delete objects on the Node.");
            na2.initCause((Throwable)na);
            throw na2;
        }
        try {
            String quotaSubject = this.request.getHeader("X-DataONE-Quota-Subject");
            QuotaServiceManager.getInstance().enforce(quotaSubject, session.getSubject(), sysmeta, "delete");
        }
        catch (InsufficientResources e) {
            throw new ServiceFailure(serviceFailureCode, "The user doesn't have enough quota to delete the pid " + id.getValue() + " since " + e.getMessage());
        }
        catch (InvalidRequest e) {
            throw new InvalidToken("2903", "The quota service in the delete action has an invalid request - " + e.getMessage());
        }
        return super.delete(session.getSubject().getValue(), id);
    }

    /*
     * Unable to fully structure code
     */
    public Identifier update(Session session, Identifier pid, InputStream object, Identifier newPid, org.dataone.service.types.v2.SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, NotFound, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        startTime = System.currentTimeMillis();
        if (this.isReadOnlyMode()) {
            throw new ServiceFailure("1310", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        serviceFailureCode = "1310";
        sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        localId = null;
        allowed = false;
        isScienceMetadata = false;
        if (session == null) {
            throw new InvalidToken("1210", "No session has been provided");
        }
        subject = session.getSubject();
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("1202", "The provided identifier is invalid.");
        }
        if (!MNodeService.isValidIdentifier(newPid)) {
            throw new InvalidRequest("1202", "The provided identifier is invalid.");
        }
        if (!MNodeService.isValidIdentifier(sysmeta.getIdentifier())) {
            throw new InvalidRequest("1202", "The provided identifier on the system metadata is invalid.");
        }
        if (!newPid.equals((Object)sysmeta.getIdentifier())) {
            throw new InvalidRequest("1202", "The new identifier " + newPid.getValue() + " doesn't match the identifier " + sysmeta.getIdentifier().getValue() + " in the system metadata.");
        }
        idExists = true;
        try {
            idExists = IdentifierManager.getInstance().identifierExists(newPid.getValue());
        }
        catch (SQLException e) {
            throw new ServiceFailure("1310", "The requested identifier " + newPid.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
        }
        if (idExists) {
            throw new IdentifierNotUnique("1220", "The requested identifier " + newPid.getValue() + " is already used by another object andtherefore can not be used for this object. Clients should choosea new identifier that is unique and retry the operation or use CN.reserveIdentifier() to reserve one.");
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new InvalidRequest("1202", "The object with the provided identifier was not found.");
        }
        catch (SQLException ee) {
            throw new ServiceFailure("1310", "The object with the provided identifier " + pid.getValue() + " can't be identified since - " + ee.getMessage());
        }
        end = System.currentTimeMillis();
        MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on checking the validation of the old pid " + pid.getValue() + " and the new pid " + newPid.getValue() + " is " + (end - startTime) + " milli seconds."));
        originMemberNode = this.getCapabilities().getIdentifier();
        sysmeta.setOriginMemberNode(originMemberNode);
        sysmeta.setSubmitter(subject);
        now = Calendar.getInstance().getTime();
        sysmeta.setDateSysMetadataModified(now);
        sysmeta.setDateUploaded(now);
        serialVersion = sysmeta.getSerialVersion();
        if (serialVersion == null) {
            sysmeta.setSerialVersion(BigInteger.ZERO);
        }
        startTime2 = System.currentTimeMillis();
        invalidRequestCode = "1202";
        notFoundCode = "1280";
        existingSysMeta = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidRequestCode, notFoundCode, true);
        authDel = null;
        try {
            authDel = new D1AuthHelper(this.request, pid, "1200", "1310");
            authDel.doUpdateAuth(session, existingSysMeta, Permission.CHANGE_PERMISSION, this.getCurrentNodeId());
            allowed = true;
        }
        catch (ServiceFailure e) {
            throw new ServiceFailure("1310", "Can't determine if the client has the permission to update the object with id " + pid.getValue() + " since " + e.getDescription());
        }
        catch (NotAuthorized e) {
            try {
                authDel.doUpdateAuth(session, existingSysMeta, Permission.WRITE, this.getCurrentNodeId());
                if (D1NodeService.isAccessControlDirty(sysmeta, existingSysMeta)) {
                    throw new NotAuthorized("1200", "Can't update the object with id " + pid.getValue() + " since the user try to change the access rules without the change permission: " + e.getDescription());
                }
                allowed = true;
            }
            catch (ServiceFailure ee) {
                throw new ServiceFailure("1310", "Can't determine if the client has the permission to update the object with id " + pid.getValue() + " since " + ee.getDescription());
            }
            catch (NotAuthorized ee) {
                throw new NotAuthorized("1200", "Can't update the object with id " + pid.getValue() + " since " + ee.getDescription());
            }
        }
        end = System.currentTimeMillis();
        MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on checking if the user has the permission to update the old pid " + pid.getValue() + " with the new pid " + newPid.getValue() + " is " + (end - startTime2) + " milli seconds."));
        if (allowed) {
            startTime3 = System.currentTimeMillis();
            quotaSubject = this.request.getHeader("X-DataONE-Quota-Subject");
            QuotaServiceManager.getInstance().enforce(quotaSubject, session.getSubject(), sysmeta, "update");
            if (sysmeta.getObsoletedBy() != null) {
                throw new InvalidSystemMetadata("1300", "Cannot include obsoletedBy when updating object");
            }
            if (sysmeta.getObsoletes() != null && !sysmeta.getObsoletes().getValue().equals(pid.getValue())) {
                throw new InvalidSystemMetadata("1300", "The identifier provided in obsoletes does not match old Identifier");
            }
            if (existingSysMeta.getArchived() != null && existingSysMeta.getArchived().booleanValue()) {
                throw new InvalidRequest("1202", "An archived object" + pid.getValue() + " can't be updated");
            }
            existingObsoletedBy = existingSysMeta.getObsoletedBy();
            if (existingObsoletedBy != null) {
                throw new InvalidRequest("1202", "The previous identifier has already been made obsolete by: " + existingObsoletedBy.getValue());
            }
            if (sysmeta.getAuthoritativeMemberNode() == null || sysmeta.getAuthoritativeMemberNode().getValue().trim().equals("") || sysmeta.getAuthoritativeMemberNode().getValue().equals("null")) {
                sysmeta.setAuthoritativeMemberNode(originMemberNode);
            } else if (existingSysMeta.getAuthoritativeMemberNode() != null && !sysmeta.getAuthoritativeMemberNode().getValue().equals(existingSysMeta.getAuthoritativeMemberNode().getValue())) {
                throw new InvalidRequest("1202", "The previous authoriativeMemberNode is " + existingSysMeta.getAuthoritativeMemberNode().getValue() + " and new authoriativeMemberNode is " + sysmeta.getAuthoritativeMemberNode().getValue() + ". They don't match. Clients don't have the permission to change it.");
            }
            end = System.currentTimeMillis();
            MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on checking the quality of the system metadata of the old pid " + pid.getValue() + " and the new pid " + newPid.getValue() + " is " + (end - startTime3) + " milli seconds."));
            sidInSys = sysmeta.getSeriesId();
            if (sidInSys != null) {
                if (!MNodeService.isValidIdentifier(sidInSys)) {
                    throw new InvalidSystemMetadata("1300", "The provided series id in the system metadata is invalid.");
                }
                previousSid = existingSysMeta.getSeriesId();
                if (previousSid != null) {
                    if (!sidInSys.getValue().equals(previousSid.getValue())) {
                        try {
                            idExists = IdentifierManager.getInstance().identifierExists(sidInSys.getValue());
                        }
                        catch (SQLException e) {
                            throw new ServiceFailure("1310", "The requested identifier " + sidInSys.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
                        }
                        if (idExists) {
                            throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata doesn't match the previous series id " + previousSid.getValue() + ", so it should NOT exist. However, it was used by another object.");
                        }
                    }
                } else {
                    try {
                        idExists = IdentifierManager.getInstance().identifierExists(sidInSys.getValue());
                    }
                    catch (SQLException e) {
                        throw new ServiceFailure("1310", "The requested identifier " + sidInSys.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
                    }
                    if (idExists) {
                        throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata should NOT exist since the previous series id is null.However, it was used by another object.");
                    }
                }
                if (sidInSys.getValue().equals(newPid.getValue())) {
                    throw new InvalidSystemMetadata("1300", "The series id " + sidInSys.getValue() + " in the system metadata shouldn't have the same value of the pid.");
                }
            }
            end2 = System.currentTimeMillis();
            MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on checking the sid validation of the old pid " + pid.getValue() + " and the new pid " + newPid.getValue() + " is " + (end2 - end) + " milli seconds."));
            isScienceMetadata = MNodeService.isScienceMetadata(sysmeta);
            if (isScienceMetadata) {
                try {
                    handler = NonXMLMetadataHandlers.newNonXMLMetadataHandler(sysmeta.getFormatId());
                    if (handler != null) {
                        if (this.ipAddress == null) {
                            this.ipAddress = this.request.getRemoteAddr();
                        }
                        if (this.userAgent == null) {
                            this.userAgent = this.request.getHeader("User-Agent");
                        }
                        event = new EventLogData(this.ipAddress, this.userAgent, null, null, "update");
                        localId = handler.save(object, (SystemMetadata)sysmeta, session, event);
                    } else {
                        formatId = null;
                        if (sysmeta.getFormatId() != null) {
                            formatId = sysmeta.getFormatId().getValue();
                        }
                        localId = this.insertOrUpdateDocument(object, "UTF-8", pid, session, "update", formatId, sysmeta.getChecksum());
                    }
                    if (newPid == null) ** GOTO lbl165
                    IdentifierManager.getInstance().createMapping(newPid.getValue(), localId);
                }
                catch (IOException e) {
                    msg = "The Node is unable to create the object: " + pid.getValue() + "There was a problem converting the object to XML";
                    MNodeService.logMetacat.error((Object)msg, (Throwable)e);
                    MNodeService.removeIdFromIdentifierTable(newPid);
                    throw new ServiceFailure("1310", msg + ": " + e.getMessage());
                }
                catch (PropertyNotFoundException e) {
                    msg = "The Node is unable to create the object. " + pid.getValue() + " since the properties are not configured well " + e.getMessage();
                    MNodeService.logMetacat.error((Object)msg, (Throwable)e);
                    MNodeService.removeIdFromIdentifierTable(newPid);
                    throw new ServiceFailure("1310", msg);
                }
                catch (Exception e) {
                    MNodeService.logMetacat.error((Object)("MNService.update - couldn't write the metadata object to the disk since " + e.getMessage()), (Throwable)e);
                    MNodeService.removeIdFromIdentifierTable(newPid);
                    throw e;
                }
            } else {
                try {
                    if (this.ipAddress == null) {
                        this.ipAddress = this.request.getRemoteAddr();
                    }
                    if (this.userAgent == null) {
                        this.userAgent = this.request.getHeader("User-Agent");
                    }
                    event = new EventLogData(this.ipAddress, this.userAgent, null, null, "update");
                    localId = this.insertDataObject(object, newPid, session, sysmeta.getChecksum(), event);
                }
                catch (Exception e) {
                    MNodeService.logMetacat.error((Object)("MNService.update - couldn't write the data object to the disk since " + e.getMessage()), (Throwable)e);
                    MNodeService.removeIdFromIdentifierTable(newPid);
                    throw e;
                }
            }
lbl165:
            // 3 sources

            end3 = System.currentTimeMillis();
            MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on saving the object with the new pid " + newPid.getValue() + " is " + (end3 - end2) + " milli seconds."));
            existingSysMeta.setObsoletedBy(newPid);
            current = existingSysMeta.getSerialVersion();
            current = current.add(BigInteger.ONE);
            existingSysMeta.setSerialVersion(current);
            this.updateSystemMetadata(existingSysMeta);
            sysmeta.setObsoletes(pid);
            this.insertSystemMetadata(sysmeta);
            end4 = System.currentTimeMillis();
            MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on updating/saving system metadata  of the old pid " + pid.getValue() + " and the new pid " + newPid.getValue() + " and saving the log information is " + (end4 - end3) + " milli seconds."));
            try {
                DOIServiceFactory.getDOIService().registerDOI(sysmeta);
            }
            catch (Exception e) {
                message = "MNodeService.update - The object " + newPid.getValue() + " has been saved successfully on Metacat.  However, the new metadata can't be registered on the DOI service: " + e.getMessage();
                MNodeService.logMetacat.error((Object)message);
                throw new ServiceFailure("1310", message);
            }
        }
        throw new NotAuthorized("1200", "The provided identity does not have permission to UPDATE the object identified by " + pid.getValue() + " on the Member Node.");
        end5 = System.currentTimeMillis();
        MNodeService.logMetacat.debug((Object)("MNodeService.update - the time spending on registering the doi (if it is doi ) of the new pid " + newPid.getValue() + " is " + (end5 - end4) + " milli seconds."));
        end6 = System.currentTimeMillis();
        MNodeService.logMetacat.debug((Object)("MNodeService.update - the total time of updating the old pid " + pid.getValue() + " whth the new pid " + newPid.getValue() + " is " + (end6 - startTime) + " milli seconds."));
        return newPid;
    }

    @Override
    public Identifier create(Session session, Identifier pid, InputStream object, org.dataone.service.types.v2.SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        if (this.isReadOnlyMode()) {
            throw new ServiceFailure("1190", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        if (session == null) {
            throw new InvalidToken("1110", "Session is required to WRITE to the Node.");
        }
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("1102", "The provided identifier is invalid.");
        }
        MNodeService.objectExists(pid);
        sysmeta.setSubmitter(session.getSubject());
        NodeReference originMemberNode = this.getCapabilities().getIdentifier();
        sysmeta.setOriginMemberNode(originMemberNode);
        if (sysmeta.getAuthoritativeMemberNode() == null || sysmeta.getAuthoritativeMemberNode().getValue().trim().equals("") || sysmeta.getAuthoritativeMemberNode().getValue().equals("null")) {
            sysmeta.setAuthoritativeMemberNode(originMemberNode);
        }
        sysmeta.setArchived(Boolean.valueOf(false));
        Date now = Calendar.getInstance().getTime();
        sysmeta.setDateSysMetadataModified(now);
        sysmeta.setDateUploaded(now);
        sysmeta.setSerialVersion(BigInteger.ZERO);
        if (sysmeta.getObsoletes() != null && sysmeta.getObsoletes().getValue() != null) {
            throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The obsoletes field cannot have a value when creating entries.");
        }
        if (sysmeta.getObsoletedBy() != null && sysmeta.getObsoletedBy().getValue() != null) {
            throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The obsoletedBy field cannot have a value when creating entries.");
        }
        Identifier sid = sysmeta.getSeriesId();
        boolean idExists = false;
        if (sid != null) {
            if (!MNodeService.isValidIdentifier(sid)) {
                throw new InvalidSystemMetadata("1180", "The provided series id is invalid.");
            }
            try {
                idExists = IdentifierManager.getInstance().identifierExists(sid.getValue());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1190", "The series identifier " + sid.getValue() + " in the system metadata couldn't be determined if it is unique since : " + e.getMessage());
            }
            if (idExists) {
                throw new InvalidSystemMetadata("1180", "The series identifier " + sid.getValue() + " is already used by another object and therefore can not be used for this object. Clients should choose a new identifier that is unique and retry the operation or use CN.reserveIdentifier() to reserve one.");
            }
            if (sid.getValue().equals(pid.getValue())) {
                throw new InvalidSystemMetadata("1180", "The series id " + sid.getValue() + " in the system metadata shouldn't have the same value of the pid.");
            }
        }
        boolean allowed = false;
        try {
            allowed = this.isAuthorized(session, pid, Permission.WRITE);
        }
        catch (NotFound e) {
            allowed = true;
        }
        if (!allowed) {
            throw new NotAuthorized("1100", "Provited Identity doesn't have the WRITE permission on the pid " + pid.getValue());
        }
        logMetacat.debug((Object)("Allowed to create: " + pid.getValue()));
        String quotaSubject = this.request.getHeader("X-DataONE-Quota-Subject");
        try {
            QuotaServiceManager.getInstance().enforce(quotaSubject, session.getSubject(), sysmeta, "create");
        }
        catch (NotFound e) {
            throw new InvalidRequest("1102", "Can't find the resource " + e.getMessage());
        }
        Identifier resultPid = super.create(session, pid, object, sysmeta);
        try {
            DOIServiceFactory.getDOIService().registerDOI(sysmeta);
        }
        catch (Exception e) {
            String message = "MNodeService.create - The object " + pid.getValue() + " has been created successfully on Metacat. However, the metadata can't be registered on the DOI service: " + e.getMessage();
            logMetacat.error((Object)message);
            throw new ServiceFailure("1190", message);
        }
        return resultPid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replicate(Session session, org.dataone.service.types.v2.SystemMetadata sysmeta, NodeReference sourceNode) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InsufficientResources, UnsupportedType {
        if (session == null || sysmeta == null || sourceNode == null) {
            throw new InvalidRequest("2153", "The provided session or systemmetdata or sourceNode should NOT be null.");
        }
        logMetacat.info((Object)("MNodeService.replicate() called with parameters: \n\tSession.Subject      = " + session.getSubject().getValue() + "\n\tidentifier           = " + sysmeta.getIdentifier().getValue() + "\n\tSource NodeReference =" + sourceNode.getValue()));
        boolean result = false;
        String nodeIdStr = null;
        NodeReference nodeId = null;
        Identifier pid = sysmeta.getIdentifier();
        if (!MNodeService.isValidIdentifier(pid)) {
            throw new InvalidRequest("2153", "The provided identifier in the system metadata is invalid.");
        }
        if (!NodeReplicationPolicyChecker.check(sourceNode, (SystemMetadata)sysmeta)) {
            throw new InvalidRequest("2153", "The object " + pid.getValue() + " from sourceNode" + sourceNode.getValue() + " is not allowed to replicate to this node based on the node replication policy.");
        }
        Object object = null;
        Session thisNodeSession = null;
        Object localSystemMetadata = null;
        ServiceFailure failure = null;
        String localId = null;
        if (session == null || session.getSubject() == null) {
            String msg = "No session was provided to replicate identifier " + sysmeta.getIdentifier().getValue();
            logMetacat.error((Object)msg);
            throw new NotAuthorized("2152", msg);
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, sysmeta.getIdentifier(), "2152", "2151");
        authDel.doCNOnlyAuthorization(session);
        logMetacat.debug((Object)("Allowed to replicate: " + pid.getValue()));
        try {
            nodeIdStr = PropertyService.getProperty("dataone.nodeId");
            nodeId = new NodeReference();
            nodeId.setValue(nodeIdStr);
        }
        catch (PropertyNotFoundException e1) {
            String msg = "Couldn't get dataone.nodeId property: " + e1.getMessage();
            failure = new ServiceFailure("2151", msg);
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
        try {
            try {
                try {
                    localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                    ObjectFormat objectFormat = null;
                    String type = null;
                    try {
                        objectFormat = ObjectFormatCache.getInstance().getFormat(sysmeta.getFormatId());
                    }
                    catch (BaseException be) {
                        logMetacat.warn((Object)("MNodeService.getReplica - Could not lookup ObjectFormat for: " + sysmeta.getFormatId()), (Throwable)be);
                    }
                    if (objectFormat != null) {
                        type = objectFormat.getFormatType();
                    }
                    logMetacat.info((Object)("MNodeService.getReplica - the data type for the object " + pid.getValue() + " is " + type));
                    try {
                        object = MetacatHandler.read(localId, type);
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)("Object content not found on this node despite having localId: " + localId));
                        String msg = "Can't read the object bytes properly, replica is invalid.";
                        ServiceFailure serviceFailure = new ServiceFailure("2151", msg);
                        this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)serviceFailure));
                        logMetacat.warn((Object)msg);
                        throw serviceFailure;
                    }
                }
                catch (McdbDocNotFoundException e) {
                    logMetacat.info((Object)"No replica found. Continuing.");
                }
                catch (SQLException ee) {
                    throw new ServiceFailure("2151", "Couldn't identify the local id of the object with the specified identifier " + pid.getValue() + " since - " + ee.getMessage());
                }
                if (object == null) {
                    D1NodeVersionChecker checker = new D1NodeVersionChecker(sourceNode);
                    String nodeVersion = checker.getVersion("MNRead");
                    if (nodeVersion != null && nodeVersion.equals("v1")) {
                        org.dataone.client.v1.MNode mNodeV1 = org.dataone.client.v1.itk.D1Client.getMN((NodeReference)sourceNode);
                        object = mNodeV1.getReplica(thisNodeSession, pid);
                    } else if (nodeVersion != null && nodeVersion.equals("v2")) {
                        MNode mn = D1Client.getMN((NodeReference)sourceNode);
                        object = mn.getReplica(thisNodeSession, pid);
                    } else {
                        throw new ServiceFailure("2151", "The version of MNRead service is " + nodeVersion + " in the source node " + sourceNode.getValue() + " and it is not supported. Please check the information in the cn");
                    }
                    logMetacat.info((Object)("MNodeService.getReplica() called for identifier " + pid.getValue()));
                }
            }
            catch (InvalidToken e) {
                String msg = "Could not retrieve object to replicate (InvalidToken): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            catch (NotFound e) {
                String msg = "Could not retrieve object to replicate (NotFound): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            catch (NotAuthorized e) {
                String msg = "Could not retrieve object to replicate (NotAuthorized): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            catch (NotImplemented e) {
                String msg = "Could not retrieve object to replicate (mn.getReplica NotImplemented): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            catch (ServiceFailure e) {
                String msg = "Could not retrieve object to replicate (ServiceFailure): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            catch (InsufficientResources e) {
                String msg = "Could not retrieve object to replicate (InsufficientResources): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
            logMetacat.info((Object)("MNodeService.replicate - the class of object inputstream is " + object.getClass().getCanonicalName() + ". Does it support the reset method? The answer is " + ((InputStream)object).markSupported()));
            try {
                if (localId == null) {
                    MNodeService.objectExists(pid);
                    Identifier retPid = super.create(session, pid, (InputStream)object, sysmeta);
                    result = retPid.getValue().equals(pid.getValue());
                }
            }
            catch (Exception e) {
                String msg = "Could not save object to local store (" + e.getClass().getName() + "): " + e.getMessage();
                failure = new ServiceFailure("2151", msg);
                this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.FAILED, (BaseException)((Object)failure));
                logMetacat.error((Object)msg);
                throw new ServiceFailure("2151", msg);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(object);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)object);
        this.setReplicationStatus(thisNodeSession, pid, nodeId, ReplicationStatus.COMPLETED, null);
        return result;
    }

    private boolean supportV2Replication(Node node) throws InvalidRequest {
        return this.supportVersionReplication(node, "v2");
    }

    private boolean supportVersionReplication(Node node, String version) throws InvalidRequest {
        boolean support = false;
        if (node == null) {
            throw new InvalidRequest("2153", "There is no capacity information about the node in the replicate.");
        }
        Services services = node.getServices();
        if (services == null) {
            throw new InvalidRequest("2153", "Can't get replica from a node which doesn't have the replicate service.");
        }
        List list = services.getServiceList();
        if (list == null) {
            throw new InvalidRequest("2153", "Can't get replica from a node which doesn't have the replicate service.");
        }
        for (Service service : list) {
            if (service == null || service.getName() == null || !service.getName().equals("MNReplication") || service.getVersion() == null || !service.getVersion().equalsIgnoreCase(version) || !service.getAvailable().booleanValue()) continue;
            support = true;
        }
        return support;
    }

    @Override
    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.get(session, pid);
    }

    public Checksum getChecksum(Session session, Identifier pid, String algorithm) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented {
        Checksum checksum = null;
        String serviceFailure = "1410";
        String notFound = "1420";
        this.checkV1SystemMetaPidExist(pid, serviceFailure, "The checksum for the object specified by " + pid.getValue() + " couldn't be returned ", notFound, "The object specified by " + pid.getValue() + " does not exist at this node.");
        InputStream inputStream = this.get(session, pid);
        try {
            checksum = ChecksumUtil.checksum((InputStream)inputStream, (String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned due to an internal error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned due to an internal error: " + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("MNodeService.getChecksum - can't close the input stream which got the object content since " + e.getMessage()));
                }
            }
        }
        if (checksum == null) {
            throw new ServiceFailure("1410", "The checksum for the object specified by " + pid.getValue() + "could not be returned.");
        }
        return checksum;
    }

    @Override
    public org.dataone.service.types.v2.SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return super.getSystemMetadata(session, pid);
    }

    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Identifier identifier, Boolean replicaStatus, Integer start, Integer count) throws NotAuthorized, InvalidRequest, NotImplemented, ServiceFailure, InvalidToken {
        NodeReference nodeId = null;
        if (!replicaStatus.booleanValue()) {
            nodeId = new NodeReference();
            try {
                PropertyService.getInstance();
                String currentNodeId = PropertyService.getProperty("dataone.nodeId");
                nodeId.setValue(currentNodeId);
            }
            catch (Exception e) {
                throw new ServiceFailure("1580", e.getMessage());
            }
        }
        return super.listObjects(session, startTime, endTime, objectFormatId, identifier, nodeId, start, count);
    }

    public Node getCapabilities() throws ServiceFailure {
        String nodeName = null;
        String nodeId = null;
        String subject = null;
        String contactSubject = null;
        String nodeDesc = null;
        String nodeTypeString = null;
        NodeType nodeType = null;
        List mnCoreServiceVersions = null;
        List mnReadServiceVersions = null;
        List mnAuthorizationServiceVersions = null;
        List mnStorageServiceVersions = null;
        List mnReplicationServiceVersions = null;
        List mnPackageServiceVersions = null;
        List mnQueryServiceVersions = null;
        List mnViewServiceVersions = null;
        boolean nodeSynchronize = false;
        boolean nodeReplicate = false;
        List mnCoreServiceAvailables = null;
        List mnReadServiceAvailables = null;
        List mnAuthorizationServiceAvailables = null;
        List mnStorageServiceAvailables = null;
        List mnReplicationServiceAvailables = null;
        List mnPackageServiceAvailables = null;
        List mnQueryServiceAvailables = null;
        List mnViewServiceAvailables = null;
        Vector<String> allowedSubmitters = null;
        try {
            boolean available;
            String version;
            int i;
            nodeName = Settings.getConfiguration().getString("dataone.nodeName");
            nodeId = Settings.getConfiguration().getString("dataone.nodeId");
            subject = Settings.getConfiguration().getString("dataone.subject");
            contactSubject = Settings.getConfiguration().getString("dataone.contactSubject");
            nodeDesc = Settings.getConfiguration().getString("dataone.nodeDescription");
            nodeTypeString = Settings.getConfiguration().getString("dataone.nodeType");
            nodeType = NodeType.convert((String)nodeTypeString);
            nodeSynchronize = new Boolean(Settings.getConfiguration().getString("dataone.nodeSynchronize"));
            nodeReplicate = new Boolean(Settings.getConfiguration().getString("dataone.nodeReplicate"));
            allowedSubmitters = AuthUtil.getAllowedSubmitters();
            String serviceName = SystemUtil.getContextURL() + "/" + PropertyService.getProperty("dataone.serviceName");
            Node node = new Node();
            node.setBaseURL(serviceName + "/" + nodeTypeString);
            node.setDescription(nodeDesc);
            node.setState(NodeState.UP);
            Ping canPing = new Ping();
            canPing.setSuccess(Boolean.valueOf(false));
            try {
                Date pingDate = this.ping();
                canPing.setSuccess(Boolean.valueOf(pingDate != null));
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
            node.setPing(canPing);
            NodeReference identifier = new NodeReference();
            identifier.setValue(nodeId);
            node.setIdentifier(identifier);
            Subject s = new Subject();
            s.setValue(subject);
            node.addSubject(s);
            Subject contact = new Subject();
            contact.setValue(contactSubject);
            node.addContactSubject(contact);
            node.setName(nodeName);
            node.setReplicate(nodeReplicate);
            node.setSynchronize(nodeSynchronize);
            Services services = new Services();
            mnCoreServiceVersions = Settings.getConfiguration().getList("dataone.mnCore.serviceVersion");
            mnCoreServiceAvailables = Settings.getConfiguration().getList("dataone.mnCore.serviceAvailable");
            if (mnCoreServiceVersions != null && mnCoreServiceAvailables != null && mnCoreServiceVersions.size() == mnCoreServiceAvailables.size()) {
                for (i = 0; i < mnCoreServiceVersions.size(); ++i) {
                    version = (String)mnCoreServiceVersions.get(i);
                    available = new Boolean((String)mnCoreServiceAvailables.get(i));
                    Service sMNCore = new Service();
                    sMNCore.setName("MNCore");
                    sMNCore.setVersion(version);
                    sMNCore.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNCore);
                }
            }
            mnReadServiceVersions = Settings.getConfiguration().getList("dataone.mnRead.serviceVersion");
            mnReadServiceAvailables = Settings.getConfiguration().getList("dataone.mnRead.serviceAvailable");
            if (mnReadServiceVersions != null && mnReadServiceAvailables != null && mnReadServiceVersions.size() == mnReadServiceAvailables.size()) {
                for (i = 0; i < mnReadServiceVersions.size(); ++i) {
                    version = (String)mnReadServiceVersions.get(i);
                    available = new Boolean((String)mnReadServiceAvailables.get(i));
                    Service sMNRead = new Service();
                    sMNRead.setName("MNRead");
                    sMNRead.setVersion(version);
                    sMNRead.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNRead);
                }
            }
            mnAuthorizationServiceVersions = Settings.getConfiguration().getList("dataone.mnAuthorization.serviceVersion");
            mnAuthorizationServiceAvailables = Settings.getConfiguration().getList("dataone.mnAuthorization.serviceAvailable");
            if (mnAuthorizationServiceVersions != null && mnAuthorizationServiceAvailables != null && mnAuthorizationServiceVersions.size() == mnAuthorizationServiceAvailables.size()) {
                for (i = 0; i < mnAuthorizationServiceVersions.size(); ++i) {
                    version = (String)mnAuthorizationServiceVersions.get(i);
                    available = new Boolean((String)mnAuthorizationServiceAvailables.get(i));
                    Service sMNAuthorization = new Service();
                    sMNAuthorization.setName("MNAuthorization");
                    sMNAuthorization.setVersion(version);
                    sMNAuthorization.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNAuthorization);
                }
            }
            mnStorageServiceVersions = Settings.getConfiguration().getList("dataone.mnStorage.serviceVersion");
            mnStorageServiceAvailables = Settings.getConfiguration().getList("dataone.mnStorage.serviceAvailable");
            if (mnStorageServiceVersions != null && mnStorageServiceAvailables != null && mnStorageServiceVersions.size() == mnStorageServiceAvailables.size()) {
                for (i = 0; i < mnStorageServiceVersions.size(); ++i) {
                    version = (String)mnStorageServiceVersions.get(i);
                    available = new Boolean((String)mnStorageServiceAvailables.get(i));
                    Service sMNStorage = new Service();
                    sMNStorage.setName("MNStorage");
                    sMNStorage.setVersion(version);
                    sMNStorage.setAvailable(Boolean.valueOf(available));
                    if (allowedSubmitters != null && !allowedSubmitters.isEmpty()) {
                        ServiceMethodRestriction createRestriction = new ServiceMethodRestriction();
                        createRestriction.setMethodName("create");
                        ServiceMethodRestriction updateRestriction = new ServiceMethodRestriction();
                        updateRestriction.setMethodName("update");
                        for (int j = 0; j < allowedSubmitters.size(); ++j) {
                            Subject allowedSubject = new Subject();
                            allowedSubject.setValue(allowedSubmitters.elementAt(j));
                            createRestriction.addSubject(allowedSubject);
                            updateRestriction.addSubject(allowedSubject);
                        }
                        sMNStorage.addRestriction(createRestriction);
                        sMNStorage.addRestriction(updateRestriction);
                    }
                    services.addService(sMNStorage);
                }
            }
            mnReplicationServiceVersions = Settings.getConfiguration().getList("dataone.mnReplication.serviceVersion");
            mnReplicationServiceAvailables = Settings.getConfiguration().getList("dataone.mnReplication.serviceAvailable");
            if (mnReplicationServiceVersions != null && mnReplicationServiceAvailables != null && mnReplicationServiceVersions.size() == mnReplicationServiceAvailables.size()) {
                for (i = 0; i < mnReplicationServiceVersions.size(); ++i) {
                    version = (String)mnReplicationServiceVersions.get(i);
                    available = new Boolean((String)mnReplicationServiceAvailables.get(i));
                    Service sMNReplication = new Service();
                    sMNReplication.setName("MNReplication");
                    sMNReplication.setVersion(version);
                    sMNReplication.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNReplication);
                }
            }
            mnPackageServiceVersions = Settings.getConfiguration().getList("dataone.mnPackage.serviceVersion");
            mnPackageServiceAvailables = Settings.getConfiguration().getList("dataone.mnPackage.serviceAvailable");
            if (mnPackageServiceVersions != null && mnPackageServiceAvailables != null && mnPackageServiceVersions.size() == mnPackageServiceAvailables.size()) {
                for (i = 0; i < mnPackageServiceVersions.size(); ++i) {
                    version = (String)mnPackageServiceVersions.get(i);
                    available = new Boolean((String)mnPackageServiceAvailables.get(i));
                    Service sMNPakcage = new Service();
                    sMNPakcage.setName("MNPackage");
                    sMNPakcage.setVersion(version);
                    sMNPakcage.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNPakcage);
                }
            }
            mnQueryServiceVersions = Settings.getConfiguration().getList("dataone.mnQuery.serviceVersion");
            mnQueryServiceAvailables = Settings.getConfiguration().getList("dataone.mnQuery.serviceAvailable");
            if (mnQueryServiceVersions != null && mnQueryServiceAvailables != null && mnQueryServiceVersions.size() == mnQueryServiceAvailables.size()) {
                for (i = 0; i < mnQueryServiceVersions.size(); ++i) {
                    version = (String)mnQueryServiceVersions.get(i);
                    available = new Boolean((String)mnQueryServiceAvailables.get(i));
                    Service sMNQuery = new Service();
                    sMNQuery.setName("MNQuery");
                    sMNQuery.setVersion(version);
                    sMNQuery.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNQuery);
                }
            }
            mnViewServiceVersions = Settings.getConfiguration().getList("dataone.mnView.serviceVersion");
            mnViewServiceAvailables = Settings.getConfiguration().getList("dataone.mnView.serviceAvailable");
            if (mnViewServiceVersions != null && mnViewServiceAvailables != null && mnViewServiceVersions.size() == mnViewServiceAvailables.size()) {
                for (i = 0; i < mnViewServiceVersions.size(); ++i) {
                    version = (String)mnViewServiceVersions.get(i);
                    available = new Boolean((String)mnViewServiceAvailables.get(i));
                    Service sMNView = new Service();
                    sMNView.setName("MNView");
                    sMNView.setVersion(version);
                    sMNView.setAvailable(Boolean.valueOf(available));
                    services.addService(sMNView);
                }
            }
            node.setServices(services);
            Synchronization synchronization = new Synchronization();
            Schedule schedule = new Schedule();
            Date now = new Date();
            schedule.setYear(PropertyService.getProperty("dataone.nodeSynchronization.schedule.year"));
            schedule.setMon(PropertyService.getProperty("dataone.nodeSynchronization.schedule.mon"));
            schedule.setMday(PropertyService.getProperty("dataone.nodeSynchronization.schedule.mday"));
            schedule.setWday(PropertyService.getProperty("dataone.nodeSynchronization.schedule.wday"));
            schedule.setHour(PropertyService.getProperty("dataone.nodeSynchronization.schedule.hour"));
            schedule.setMin(PropertyService.getProperty("dataone.nodeSynchronization.schedule.min"));
            schedule.setSec(PropertyService.getProperty("dataone.nodeSynchronization.schedule.sec"));
            synchronization.setSchedule(schedule);
            synchronization.setLastHarvested(now);
            synchronization.setLastCompleteHarvest(now);
            node.setSynchronization(synchronization);
            node.setType(nodeType);
            String upgradeStatus = Settings.getConfiguration().getString("configutil.upgrade.status");
            if (upgradeStatus != null && !upgradeStatus.trim().equals("")) {
                Property statusProperty = new Property();
                statusProperty.setKey("upgrade_status");
                statusProperty.setValue(upgradeStatus);
                node.addProperty(statusProperty);
            }
            try {
                String metacatVersion = MetacatVersion.getVersionFromDB();
                if (metacatVersion != null && !metacatVersion.trim().equals("")) {
                    Property versionProperty = new Property();
                    versionProperty.setKey("metacat_version");
                    versionProperty.setValue(metacatVersion);
                    node.addProperty(versionProperty);
                }
            }
            catch (SQLException e) {
                logMetacat.warn((Object)("MNodeService.getCapabilities - couldn't get the metacat version since " + e.getMessage()));
            }
            String readOnlyStatus = Settings.getConfiguration().getString("application.readOnlyMode");
            if (readOnlyStatus != null && !readOnlyStatus.trim().equals("")) {
                Property readOnlyStatusProperty = new Property();
                readOnlyStatusProperty.setKey("read_only_mode");
                readOnlyStatusProperty.setValue(readOnlyStatus);
                node.addProperty(readOnlyStatusProperty);
            }
            return node;
        }
        catch (PropertyNotFoundException pnfe) {
            String msg = "MNodeService.getCapabilities(): property not found: " + pnfe.getMessage();
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2162", msg);
        }
        catch (MetacatUtilException me) {
            String msg = "MNodeService.getCapabilities(): can't get the allowed submitters list since " + me.getMessage();
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2162", msg);
        }
    }

    public boolean synchronizationFailed(Session session, SynchronizationFailed syncFailed) throws NotImplemented, ServiceFailure, NotAuthorized {
        String localId;
        if (syncFailed.getPid() == null) {
            throw new ServiceFailure("2161", "The identifier cannot be null.");
        }
        Identifier pid = new Identifier();
        pid.setValue(syncFailed.getPid());
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "2162", "2161");
        authDel.doCNOnlyAuthorization(session);
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new ServiceFailure("2161", "The identifier specified by " + syncFailed.getPid() + " was not found on this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("2161", "Couldn't identify the local id of the identifier specified by " + syncFailed.getPid() + " since " + e.getMessage());
        }
        logMetacat.warn((Object)("Synchronization for the object identified by " + pid.getValue() + " failed from " + syncFailed.getNodeId() + " with message: " + syncFailed.getDescription() + ". Logging the event to the Metacat EventLog as a 'syncFailed' event."));
        String principal = "public";
        if (session != null && session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        try {
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "synchronization_failed");
        }
        catch (Exception e) {
            throw new ServiceFailure("2161", "Could not log the error for: " + pid.getValue());
        }
        return true;
    }

    public InputStream getReplica(Session session, Identifier pid) throws NotAuthorized, NotImplemented, ServiceFailure, InvalidToken, NotFound {
        String localId;
        logMetacat.info((Object)"MNodeService.getReplica() called.");
        if (session == null) {
            throw new InvalidToken("2183", "No session was provided.");
        }
        logMetacat.info((Object)("MNodeService.getReplica() called with parameters: \n\tSession.Subject      = " + session.getSubject().getValue() + "\n\tIdentifier           = " + pid.getValue()));
        InputStream inputStream = null;
        boolean allowed = false;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("2185", "The object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("2181", "The local id of the object specified by " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        Subject targetNodeSubject = session.getSubject();
        try {
            allowed = D1Client.getCN().isNodeAuthorized(null, targetNodeSubject, pid);
        }
        catch (InvalidToken e1) {
            throw new ServiceFailure("2181", "Could not determine if node is authorized: " + e1.getMessage());
        }
        catch (NotFound e1) {
            throw new NotFound("2185", "Could not find the object " + pid.getValue() + " in this node - " + e1.getMessage());
        }
        catch (InvalidRequest e1) {
            throw new ServiceFailure("2181", "Could not determine if node is authorized: " + e1.getMessage());
        }
        logMetacat.info((Object)("Called D1Client.isNodeAuthorized(). Allowed = " + allowed + " for identifier " + pid.getValue()));
        if (allowed) {
            org.dataone.service.types.v2.SystemMetadata sm = MNodeService.getInstance(this.request).getSystemMetadata(session, pid);
            ObjectFormat objectFormat = null;
            String type = null;
            try {
                objectFormat = ObjectFormatCache.getInstance().getFormat(sm.getFormatId());
            }
            catch (BaseException be) {
                logMetacat.warn((Object)("MNodeService.getReplica - could not lookup ObjectFormat for: " + sm.getFormatId()), (Throwable)be);
            }
            if (objectFormat != null) {
                type = objectFormat.getFormatType();
            }
            logMetacat.info((Object)("MNodeService.getReplica - the data type for the object " + pid.getValue() + " is " + type));
            try {
                inputStream = MetacatHandler.read(localId, type);
            }
            catch (Exception e) {
                throw new ServiceFailure("2181", "The object specified by " + pid.getValue() + "could not be returned due to error: " + e.getMessage());
            }
        }
        throw new NotAuthorized("2182", "The pid " + pid.getValue() + " is not authorized to be read by the client.");
        if (inputStream == null) {
            throw new ServiceFailure("2181", "The object specified by " + pid.getValue() + " can't be returned from the node.");
        }
        String principal = null;
        if (session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "replicate");
        return inputStream;
    }

    public boolean systemMetadataChanged(Session session, Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken {
        boolean needCheckAuthoriativeNode = true;
        return this.systemMetadataChanged(needCheckAuthoriativeNode, session, pid, serialVersion, dateSysMetaLastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean systemMetadataChanged(boolean needCheckAuthoriativeNode, Session session, Identifier pid, long serialVersion, Date dateSysMetaLastModified) throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken {
        org.dataone.service.types.v2.SystemMetadata newSysMeta;
        org.dataone.service.types.v2.SystemMetadata currentLocalSysMeta;
        block39: {
            if (this.isReadOnlyMode()) {
                throw new InvalidRequest("1334", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
            }
            if (session == null) {
                throw new InvalidToken("1332", "No session was provided.");
            }
            String serviceFailureCode = "1333";
            Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
            if (sid != null) {
                pid = sid;
            }
            currentLocalSysMeta = null;
            newSysMeta = null;
            D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "1331", serviceFailureCode);
            authDel.doCNOnlyAuthorization(session);
            try {
                HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
                try {
                    currentLocalSysMeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                }
                catch (RuntimeException e) {
                    String msg = "SystemMetadata for pid " + pid.getValue() + " couldn't be updated because it couldn't be found locally: " + e.getMessage();
                    logMetacat.error((Object)msg);
                    ServiceFailure sf = new ServiceFailure("1333", msg);
                    sf.initCause((Throwable)e);
                    throw sf;
                }
                if (currentLocalSysMeta == null) {
                    throw new InvalidRequest("1334", "We can't find the system metadata in the node for the id " + pid.getValue());
                }
                if (currentLocalSysMeta.getSerialVersion().longValue() > serialVersion) break block39;
                try {
                    this.cn = D1Client.getCN();
                    newSysMeta = this.cn.getSystemMetadata(null, pid);
                }
                catch (NotFound e) {
                    String msg = "On updating the local copy of system metadata for pid " + pid.getValue() + ", the CN reports it is not found. The error message was: " + e.getMessage();
                    logMetacat.error((Object)msg);
                    InvalidRequest sf = new InvalidRequest("1334", msg);
                    sf.initCause((Throwable)e);
                    throw sf;
                }
                Identifier newSID = newSysMeta.getSeriesId();
                if (newSID != null) {
                    if (!MNodeService.isValidIdentifier(newSID)) {
                        throw new InvalidRequest("1334", "The series identifier in the new system metadata is invalid.");
                    }
                    Identifier currentSID = currentLocalSysMeta.getSeriesId();
                    if (currentSID != null && currentSID.getValue() != null) {
                        if (!newSID.getValue().equals(currentSID.getValue())) {
                            try {
                                if (IdentifierManager.getInstance().identifierExists(newSID.getValue())) {
                                    throw new InvalidRequest("1334", "The series identifier " + newSID.getValue() + " in the new system metadata has been used by another object.");
                                }
                            }
                            catch (SQLException sql) {
                                throw new ServiceFailure("1333", "Couldn't determine if the SID " + newSID.getValue() + " in the system metadata exists in the node since " + sql.getMessage());
                            }
                        }
                    } else {
                        try {
                            if (IdentifierManager.getInstance().identifierExists(newSID.getValue())) {
                                throw new InvalidRequest("1334", "The series identifier " + newSID.getValue() + " in the new system metadata has been used by another object.");
                            }
                        }
                        catch (SQLException sql) {
                            throw new ServiceFailure("1333", "Couldn't determine if the SID " + newSID.getValue() + " in the system metadata exists in the node since " + sql.getMessage());
                        }
                    }
                }
                try {
                    if (needCheckAuthoriativeNode) {
                        if (this.isAuthoritativeNode(pid)) {
                            logMetacat.debug((Object)("MNodeService.systemMetadataChanged - this is the authoritative node for the pid " + pid.getValue()));
                            List replicas = newSysMeta.getReplicaList();
                            newSysMeta = currentLocalSysMeta;
                            newSysMeta.setSerialVersion(new BigInteger(new Long(serialVersion).toString()));
                            newSysMeta.setReplicaList(replicas);
                        } else {
                            logMetacat.debug((Object)("MNodeService.systemMetadataChanged - this is NOT the authoritative node for the pid " + pid.getValue()));
                            logMetacat.debug((Object)("MNodeService.systemMetadataChanged - the new value of archive is " + newSysMeta.getArchived() + " for the pid " + pid.getValue()));
                            logMetacat.debug((Object)("MNodeService.systemMetadataChanged - the local value of archive is " + currentLocalSysMeta.getArchived() + " for the pid " + pid.getValue()));
                            if (newSysMeta.getArchived() != null && newSysMeta.getArchived().booleanValue() && (currentLocalSysMeta.getArchived() != null && !currentLocalSysMeta.getArchived().booleanValue() || currentLocalSysMeta.getArchived() == null)) {
                                logMetacat.debug((Object)("MNodeService.systemMetadataChanged - start to archive object " + pid.getValue()));
                                boolean logArchive = false;
                                boolean needUpdateModificationDate = false;
                                try {
                                    this.archiveObject(logArchive, session, pid, newSysMeta, needUpdateModificationDate);
                                }
                                catch (NotFound e) {
                                    throw new InvalidRequest("1334", "Can't find the pid " + pid.getValue() + " for archive.");
                                }
                            } else if ((newSysMeta.getArchived() == null || !newSysMeta.getArchived().booleanValue()) && currentLocalSysMeta.getArchived() != null && currentLocalSysMeta.getArchived().booleanValue()) {
                                throw new InvalidRequest("1334", "The pid " + pid.getValue() + " has been archived and it can't be reset to false.");
                            }
                        }
                    }
                    HazelcastService.getInstance().getSystemMetadataMap().put((Object)newSysMeta.getIdentifier(), (Object)newSysMeta);
                    logMetacat.info((Object)("Updated local copy of system metadata for pid " + pid.getValue() + " after change notification from the CN."));
                }
                catch (RuntimeException e) {
                    String msg = "SystemMetadata for pid " + pid.getValue() + " couldn't be updated: " + e.getMessage();
                    logMetacat.error((Object)msg);
                    ServiceFailure sf = new ServiceFailure("1333", msg);
                    sf.initCause((Throwable)e);
                    throw sf;
                }
                try {
                    String localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
                    if (this.ipAddress == null) {
                        this.request.getRemoteAddr();
                    }
                    if (this.userAgent == null) {
                        this.userAgent = this.request.getHeader("User-Agent");
                    }
                    EventLog.getInstance().log(this.ipAddress, this.userAgent, session.getSubject().getValue(), localId, "updateSystemMetadata");
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("MNodeService.systemMetadataChanged - Could not log 'updateSystemMetadata' event because no localId was found for pid: " + pid.getValue()));
                }
            }
            finally {
                HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
            }
        }
        if (currentLocalSysMeta.getSerialVersion().longValue() <= serialVersion) {
            try {
                boolean isSysmetaChangeOnly = true;
                MetacatSolrIndex.getInstance().submit(newSysMeta.getIdentifier(), newSysMeta, isSysmetaChangeOnly, null, false);
            }
            catch (Exception e) {
                logMetacat.error((Object)("Could not submit changed systemMetadata for indexing, pid: " + newSysMeta.getIdentifier().getValue()), (Throwable)e);
            }
        }
        return true;
    }

    private void setReplicationStatus(Session session, Identifier pid, NodeReference nodeId, ReplicationStatus status, BaseException failure) throws ServiceFailure, NotImplemented, NotAuthorized, InvalidRequest {
        try {
            this.cn = D1Client.getCN();
            this.cn.setReplicationStatus(session, pid, nodeId, status, failure);
        }
        catch (InvalidToken e) {
            String msg = "Could not set the replication status for " + pid.getValue() + " on the CN (InvalidToken): " + e.getMessage();
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
        catch (NotFound e) {
            String msg = "Could not set the replication status for " + pid.getValue() + " on the CN (NotFound): " + e.getMessage();
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2151", msg);
        }
    }

    private org.dataone.service.types.v2.SystemMetadata makePublicIfNot(org.dataone.service.types.v2.SystemMetadata sysmeta, Identifier pid, boolean needIndex) throws ServiceFailure, InvalidToken, NotFound, NotImplemented, InvalidRequest {
        boolean isPublic = false;
        Subject publicSubject = new Subject();
        publicSubject.setValue("public");
        Session publicSession = new Session();
        publicSession.setSubject(publicSubject);
        AccessRule publicRule = new AccessRule();
        publicRule.addPermission(Permission.READ);
        publicRule.addSubject(publicSubject);
        try {
            isPublic = this.isAuthorized(publicSession, pid, Permission.READ);
        }
        catch (NotAuthorized notAuthorized) {
            // empty catch block
        }
        if (!isPublic) {
            if (sysmeta.getAccessPolicy() != null) {
                sysmeta.getAccessPolicy().addAllow(publicRule);
            } else {
                AccessPolicy policy = new AccessPolicy();
                policy.addAllow(publicRule);
                sysmeta.setAccessPolicy(policy);
            }
            if (needIndex) {
                this.updateSystemMetadata(sysmeta);
            }
        }
        return sysmeta;
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        if (session == null) {
            throw new InvalidToken("2190", "Session is required to generate an Identifier at this Node.");
        }
        Identifier identifier = new Identifier();
        if (scheme.equalsIgnoreCase(UUID_SCHEME)) {
            UUID uuid = UUID.randomUUID();
            identifier.setValue(UUID_PREFIX + uuid.toString());
        } else if (scheme.equalsIgnoreCase(DOI_SCHEME)) {
            try {
                identifier = DOIServiceFactory.getDOIService().generateDOI();
            }
            catch (Exception e) {
                ServiceFailure sf = new ServiceFailure("2191", "Could not generate DOI: " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        } else if (fragment != null) {
            String autogenId = DocumentUtil.generateDocumentId(fragment, 0);
            identifier.setValue(autogenId);
        } else {
            String autogenId = DocumentUtil.generateDocumentId(0);
            identifier.setValue(autogenId);
        }
        return identifier;
    }

    public QueryEngineDescription getQueryEngineDescription(Session session, String engine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        if (engine != null && engine.equals("pathquery")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            QueryEngineDescription qed = new QueryEngineDescription();
            qed.setName("pathquery");
            qed.setQueryEngineVersion("1.0");
            qed.addAdditionalInfo("This is the traditional structured query for Metacat");
            Vector<String> pathsForIndexing = null;
            try {
                pathsForIndexing = SystemUtil.getPathsForIndexing();
            }
            catch (MetacatUtilException e) {
                logMetacat.warn((Object)"Could not get index paths", (Throwable)e);
            }
            for (String fieldName : pathsForIndexing) {
                QueryField field = new QueryField();
                field.addDescription("Indexed field for path '" + fieldName + "'");
                field.setName(fieldName);
                field.setReturnable(true);
                field.setSearchable(true);
                field.setSortable(false);
                field.setType(String.class.getName());
                qed.addQueryField(field);
            }
            return qed;
        }
        if (engine != null && engine.equals("solr")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("solr")) {
                throw new NotImplemented("0000", "MNodeService.getQueryEngineDescription - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            try {
                QueryEngineDescription qed = MetacatSolrEngineDescriptionHandler.getInstance().getQueryEngineDescritpion();
                return qed;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("Solr server error", e.getMessage());
            }
        }
        throw new NotFound("404", "The Metacat member node can't find the query engine - " + engine);
    }

    public QueryEngineList listQueryEngines(Session session) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        QueryEngineList qel = new QueryEngineList();
        List enables = EnabledQueryEngines.getInstance().getEnabled();
        for (String name : enables) {
            qel.addQueryEngine(name);
        }
        return qel;
    }

    public InputStream query(Session session, String engine, String query) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        Set<Subject> subjects = this.getQuerySubjects(session);
        boolean isMNadmin = this.isMNOrCNAdminQuery(session);
        if (engine != null && engine.equals("pathquery")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            String user = "public";
            String[] groups = null;
            if (session != null) {
                user = session.getSubject().getValue();
            }
            if (subjects != null) {
                ArrayList<String> groupList = new ArrayList<String>();
                for (Subject subject : subjects) {
                    groupList.add(subject.getValue());
                }
                groups = groupList.toArray(new String[0]);
            }
            try {
                DBQuery queryobj = new DBQuery();
                String results = queryobj.performPathquery(query, user, groups);
                ContentTypeByteArrayInputStream ctbais = new ContentTypeByteArrayInputStream(results.getBytes("UTF-8"));
                ctbais.setContentType("text/xml");
                return ctbais;
            }
            catch (Exception e) {
                throw new ServiceFailure("Pathquery error", e.getMessage());
            }
        }
        if (engine != null && engine.equals("solr")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("solr")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            logMetacat.info((Object)("MNodeService.query - the solr query is === " + query));
            try {
                return MetacatSolrIndex.getInstance().query(query, subjects, isMNadmin);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceFailure("Solr server error", e.getMessage());
            }
        }
        return null;
    }

    public InputStream postQuery(Session session, String engine, HashMap<String, String[]> params) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        Set<Subject> subjects = this.getQuerySubjects(session);
        boolean isMNadmin = this.isMNOrCNAdminQuery(session);
        if (engine != null && engine.equals("solr")) {
            if (!EnabledQueryEngines.getInstance().isEnabled("solr")) {
                throw new NotImplemented("0000", "MNodeService.query - the query engine " + engine + " hasn't been implemented or has been disabled.");
            }
            try {
                MultiMapSolrParams solrParams = new MultiMapSolrParams(params);
                return MetacatSolrIndex.getInstance().query((SolrParams)solrParams, subjects, isMNadmin, SolrRequest.METHOD.POST);
            }
            catch (Exception e) {
                throw new ServiceFailure("2821", "Solr server error: " + e.getMessage());
            }
        }
        throw new NotImplemented("2824", "The query engine " + engine + " specified on the request isn't supported by the http post method. Now we only support the solr engine.");
    }

    private Set<Subject> getQuerySubjects(Session session) {
        HashSet<Subject> subjects = null;
        if (session != null) {
            subjects = AuthUtils.authorizedClientSubjects((Session)session);
        } else {
            Subject subject = new Subject();
            subject.setValue("public");
            subjects = new HashSet<Subject>();
            subjects.add(subject);
        }
        return subjects;
    }

    private boolean isMNOrCNAdminQuery(Session session) throws ServiceFailure {
        boolean isMNadmin = false;
        if (session != null && session.getSubject() != null) {
            D1AuthHelper authDel = new D1AuthHelper(this.request, null, "2822", "2821");
            try {
                authDel.doAdminAuthorization(session);
                logMetacat.debug((Object)"MNodeService.isMNOrCNAdminQuery - this is a mn/cn admin session, it will bypass the access control rules.");
                isMNadmin = true;
            }
            catch (NotAuthorized e) {
                logMetacat.debug((Object)"MNodeService.isMNOrCNAdminQuery - this is NOT a mn/cn admin session, it can't bypass the access control rules.");
            }
        }
        return isMNadmin;
    }

    public Identifier publish(Session session, Identifier originalIdentifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, IOException {
        Identifier newIdentifier;
        block26: {
            ServiceFailure sf;
            String serviceFailureCode = "1030";
            Identifier sid = this.getPIDForSID(originalIdentifier, serviceFailureCode);
            if (sid != null) {
                originalIdentifier = sid;
            }
            org.dataone.service.types.v2.SystemMetadata originalSystemMetadata = this.getSystemMetadata(session, originalIdentifier);
            org.dataone.service.types.v2.SystemMetadata sysmeta = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                TypeMarshaller.marshalTypeToOutputStream((Object)originalSystemMetadata, (OutputStream)baos);
                sysmeta = (org.dataone.service.types.v2.SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(org.dataone.service.types.v2.SystemMetadata.class, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (Exception e) {
                ServiceFailure sf2 = new ServiceFailure("1030", e.getMessage());
                sf2.initCause((Throwable)e);
                throw sf2;
            }
            newIdentifier = this.generateIdentifier(session, DOI_SCHEME, null);
            sysmeta.setIdentifier(newIdentifier);
            sysmeta.setObsoletes(originalIdentifier);
            sysmeta.setObsoletedBy(null);
            sysmeta = this.makePublicIfNot(sysmeta, originalIdentifier, false);
            InputStream inputStream = null;
            boolean isScienceMetadata = MNodeService.isScienceMetadata(sysmeta);
            if (isScienceMetadata) {
                boolean isEML = false;
                ObjectFormatIdentifier objFormatId = originalSystemMetadata.getFormatId();
                String formatId = objFormatId.getValue();
                if (formatId.contains("ecoinformatics.org/eml")) {
                    logMetacat.debug((Object)("~~~~~~~~~~~~~~~~~~~~~~MNodeService.publish - the object " + originalIdentifier.getValue() + " with format id " + formatId + " is an eml document."));
                    isEML = true;
                } else {
                    logMetacat.debug((Object)("MNodeService.publish - the object " + originalIdentifier.getValue() + " with format id " + formatId + " is NOT an eml document."));
                }
                InputStream originalObject = this.get(session, originalIdentifier);
                inputStream = this.editScienceMetadata(session, originalObject, originalIdentifier, newIdentifier, isEML, sysmeta);
            } else {
                inputStream = this.get(session, originalIdentifier);
            }
            this.update(session, originalIdentifier, inputStream, newIdentifier, sysmeta);
            try {
                InputStream oreInputStream;
                Identifier potentialOreIdentifier;
                block25: {
                    String localId = IdentifierManager.getInstance().getLocalId(originalIdentifier.getValue());
                    potentialOreIdentifier = new Identifier();
                    potentialOreIdentifier.setValue("resourceMap_" + localId);
                    oreInputStream = null;
                    try {
                        oreInputStream = this.get(session, potentialOreIdentifier);
                    }
                    catch (NotFound nf) {
                        logMetacat.warn((Object)("No potential ORE map found for: " + potentialOreIdentifier.getValue() + " by the name convention."));
                        potentialOreIdentifier = this.getNewestORE(session, originalIdentifier);
                        if (potentialOreIdentifier == null) break block25;
                        try {
                            oreInputStream = this.get(session, potentialOreIdentifier);
                        }
                        catch (NotFound nf2) {
                            logMetacat.warn((Object)("No potential ORE map found for: " + potentialOreIdentifier.getValue()));
                        }
                    }
                }
                if (oreInputStream != null) {
                    logMetacat.info((Object)("MNodeService.publish - we find the old ore document " + potentialOreIdentifier + " for the metacat object " + originalIdentifier));
                    Identifier newOreIdentifier = MNodeService.getInstance(this.request).generateIdentifier(session, UUID_SCHEME, null);
                    ResourceMapModifier modifier = new ResourceMapModifier(potentialOreIdentifier, oreInputStream, newOreIdentifier);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    modifier.replaceObsoletedId(originalIdentifier, newIdentifier, out, session.getSubject());
                    String resourceMapString = out.toString("UTF-8");
                    org.dataone.service.types.v2.SystemMetadata originalOreSysMeta = this.getSystemMetadata(session, potentialOreIdentifier);
                    org.dataone.service.types.v2.SystemMetadata oreSysMeta = new org.dataone.service.types.v2.SystemMetadata();
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        TypeMarshaller.marshalTypeToOutputStream((Object)originalOreSysMeta, (OutputStream)baos);
                        oreSysMeta = (org.dataone.service.types.v2.SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(org.dataone.service.types.v2.SystemMetadata.class, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (Exception e) {
                        ServiceFailure sf3 = new ServiceFailure("1030", e.getMessage());
                        sf3.initCause((Throwable)e);
                        throw sf3;
                    }
                    oreSysMeta.setIdentifier(newOreIdentifier);
                    oreSysMeta.setObsoletes(potentialOreIdentifier);
                    oreSysMeta.setObsoletedBy(null);
                    oreSysMeta.setSize(BigInteger.valueOf(resourceMapString.getBytes("UTF-8").length));
                    oreSysMeta.setChecksum(ChecksumUtil.checksum((byte[])resourceMapString.getBytes("UTF-8"), (String)oreSysMeta.getChecksum().getAlgorithm()));
                    oreSysMeta.setFileName("resourceMap_" + newOreIdentifier.getValue() + ".rdf.xml");
                    oreSysMeta = this.makePublicIfNot(oreSysMeta, potentialOreIdentifier, false);
                    List<Identifier> dataIdentifiers = modifier.getSubjectsOfDocumentedBy(newIdentifier);
                    if (enforcePublicEntirePackageInPublish) {
                        ArrayList<String> pidsToSync = new ArrayList<String>();
                        for (Identifier dataId : dataIdentifiers) {
                            org.dataone.service.types.v2.SystemMetadata dataSysMeta = this.getSystemMetadata(session, dataId);
                            dataSysMeta = this.makePublicIfNot(dataSysMeta, dataId, true);
                            pidsToSync.add(dataId.getValue());
                        }
                        SyncAccessPolicy sap = new SyncAccessPolicy();
                        try {
                            sap.sync(pidsToSync);
                        }
                        catch (Exception e) {
                            logMetacat.warn((Object)"Error attempting to sync access for data objects when publishing package");
                        }
                    }
                    logMetacat.info((Object)("MNodeService.publish - the new ore document is " + newOreIdentifier.getValue() + " for the doi " + newIdentifier.getValue()));
                    this.update(session, potentialOreIdentifier, new ByteArrayInputStream(resourceMapString.getBytes("UTF-8")), newOreIdentifier, oreSysMeta);
                    break block26;
                }
                try {
                    String newLocalId = IdentifierManager.getInstance().getLocalId(newIdentifier.getValue());
                    org.dataone.service.types.v2.SystemMetadata systemMetadata = SystemMetadataFactory.createSystemMetadata(newLocalId, true, false);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Could not generate new ORE for published object: " + newIdentifier.getValue()), (Throwable)e);
                }
            }
            catch (McdbDocNotFoundException e) {
                sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (UnsupportedEncodingException e) {
                sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (NoSuchAlgorithmException e) {
                sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (SQLException e) {
                sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        return newIdentifier;
    }

    public InputStream editScienceMetadata(Session session, InputStream object, Identifier pid, Identifier newPid, boolean isEML, org.dataone.service.types.v2.SystemMetadata newSysmeta) throws ServiceFailure, IOException, UnsupportedEncodingException, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        logMetacat.debug((Object)"D1NodeService.editScienceMetadata() called.");
        ByteArrayInputStream newObject = null;
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)object);
            String xmlStr = new String(xmlBytes, "UTF-8");
            Document doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)new StringReader(xmlStr));
            Element docNode = doc.getDocumentElement();
            if (isEML) {
                XMLUtilities.addAttributeNodeToDOMTree((org.w3c.dom.Node)docNode, (String)XPATH_EML_ID, (String)newPid.getValue());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(docNode);
            StreamResult outputTarget = new StreamResult(outputStream);
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
            byte[] output = outputStream.toByteArray();
            Checksum checksum = ChecksumUtil.checksum((byte[])output, (String)newSysmeta.getChecksum().getAlgorithm());
            newObject = new ByteArrayInputStream(output);
            newSysmeta.setChecksum(checksum);
            logMetacat.debug((Object)("MNNodeService.editScienceMetadata - the new checksum is " + checksum.getValue() + " with algorithm " + checksum.getAlgorithm() + " for the new pid " + newPid.getValue() + " which is published from the pid " + pid.getValue()));
        }
        catch (TransformerException e) {
            throw new ServiceFailure("1030", "MNNodeService.editScienceMetadata(): Could not update the ID in the XML document for pid " + pid.getValue() + " : " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("1030", "MNNodeService.editScienceMetadata(): Could not update the ID in the XML document for pid " + pid.getValue() + " : " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceFailure("1030", "MNNodeService.editScienceMetadata(): Could not update the ID in the XML document for pid " + pid.getValue() + " since the checksum can't be computed : " + e.getMessage());
        }
        return newObject;
    }

    public List<Identifier> lookupOreFor(Session session, Identifier guid, boolean includeObsolete) {
        String pid = guid.getValue();
        ArrayList<Identifier> retList = null;
        try {
            InputStream results;
            org.w3c.dom.Node rootNode;
            NodeList nodeList;
            String query = "fl=id,resourceMap&wt=xml&q=-obsoletedBy:[* TO *]+resourceMap:[* TO *]+id:\"" + pid + "\"";
            if (includeObsolete) {
                query = "fl=id,resourceMap&wt=xml&q=resourceMap:[* TO *]+id:\"" + pid + "\"";
            }
            if ((nodeList = XMLUtilities.getNodeListWithXPath((org.w3c.dom.Node)(rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new InputStreamReader(results = this.query(session, "solr", query), "UTF-8"))), (String)"//arr[@name=\"resourceMap\"]/str")) != null && nodeList.getLength() > 0) {
                retList = new ArrayList<Identifier>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String found = nodeList.item(i).getFirstChild().getNodeValue();
                    Identifier oreId = new Identifier();
                    oreId.setValue(found);
                    retList.add(oreId);
                }
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error checking for resourceMap[s] on pid " + pid + ". " + e.getMessage()), (Throwable)e);
        }
        return retList;
    }

    private Identifier getNewestORE(Session session, Identifier metadataPid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Identifier potentialOreIdentifier = null;
        if (metadataPid != null && !metadataPid.getValue().trim().equals("")) {
            List<Identifier> potentialOreIdentifiers = this.lookupOreFor(session, metadataPid);
            if (potentialOreIdentifiers != null && potentialOreIdentifiers.size() > 0) {
                int size = potentialOreIdentifiers.size();
                for (int i = size - 1; i >= 0; --i) {
                    org.dataone.service.types.v2.SystemMetadata sys;
                    Identifier id = potentialOreIdentifiers.get(i);
                    if (id == null || id.getValue() == null || id.getValue().trim().equals("") || (sys = this.getSystemMetadata(session, id)) == null || sys.getObsoletedBy() != null) continue;
                    logMetacat.debug((Object)("MNodeService.getNewestORE - found the ore map from the list when the index is " + i + " and its pid is " + id.getValue()));
                    potentialOreIdentifier = id;
                    break;
                }
            } else {
                logMetacat.warn((Object)("MNodeService.getNewestORE - No potential ORE map found for the metadata object" + metadataPid.getValue() + " by the solr query."));
            }
        }
        return potentialOreIdentifier;
    }

    private List<Identifier> lookupOreFor(Session session, Identifier guid) {
        String pid = guid.getValue();
        ArrayList<Identifier> retList = null;
        try {
            String query = "fl=id,resourceMap&wt=xml&q=id:\"" + pid + "\"";
            InputStream results = this.query(session, "solr", query);
            org.w3c.dom.Node rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)new InputStreamReader(results, "UTF-8"));
            NodeList nodeList = XMLUtilities.getNodeListWithXPath((org.w3c.dom.Node)rootNode, (String)"//arr[@name=\"resourceMap\"]/str");
            if (nodeList != null && nodeList.getLength() > 0) {
                retList = new ArrayList<Identifier>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String found = nodeList.item(i).getFirstChild().getNodeValue();
                    logMetacat.debug((Object)("MNodeService.lookupOreRor - found the resource map" + found));
                    Identifier oreId = new Identifier();
                    oreId.setValue(found);
                    retList.add(oreId);
                }
            }
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error checking for resourceMap[s] on pid " + pid + ". " + e.getMessage()), (Throwable)e);
        }
        return retList;
    }

    private ResourceMap serializeResourceMap(Session session, Identifier pid) throws InvalidToken, NotFound, InvalidRequest, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        org.dataone.service.types.v2.SystemMetadata sysMeta = this.getSystemMetadata(session, pid);
        ResourceMap resMap = null;
        try {
            InputStream oreInputStream = this.get(session, pid);
            resMap = ResourceMapFactory.getInstance().deserializeResourceMap(oreInputStream);
        }
        catch (URISyntaxException | OREException e) {
            logMetacat.error((Object)"There was problem with the resource map. Check that that the resource map is valid.", e);
            throw new ServiceFailure("There was problem with the resource map. Check that that the resource map is valid.", e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logMetacat.error((Object)"The resource map has an unsupported encoding format.", (Throwable)e);
            throw new ServiceFailure("The resource map has an unsupported encoding format.", e.getMessage());
        }
        catch (OREParserException e) {
            logMetacat.error((Object)"Failed to parse the ORE.", (Throwable)e);
            throw new ServiceFailure("Failed to parse the ORE.", e.getMessage());
        }
        return resMap;
    }

    private Map<Identifier, Map<Identifier, List<Identifier>>> parseResourceMap(Session session, Identifier orePid) throws ServiceFailure {
        Map resourceMapStructure = null;
        try {
            InputStream oreInputStream = this.get(session, orePid);
            resourceMapStructure = ResourceMapFactory.getInstance().parseResourceMap(oreInputStream);
        }
        catch (UnsupportedEncodingException | NotImplemented | OREException | OREParserException e) {
            throw new ServiceFailure("Failed to parse the resource map. Check that the resource map is valid", e.getMessage());
        }
        catch (InvalidToken | NotAuthorized e) {
            logMetacat.error((Object)"Invalid token while parsing the resource map. Check that you have permissions.", e);
        }
        catch (URISyntaxException e) {
            throw new ServiceFailure("There was a malformation in the resource map. Check that the resource map is valid", e.getMessage());
        }
        catch (NotFound e) {
            throw new ServiceFailure("Failed to locate the resource map. Check that the right pid was used.", e.getMessage());
        }
        if (resourceMapStructure == null) {
            throw new ServiceFailure("", "There was an error while parsing the resource map.");
        }
        return resourceMapStructure;
    }

    public InputStream getPackage(Session session, ObjectFormatIdentifier formatId, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        if (formatId == null) {
            throw new InvalidRequest("2873", "The format id wasn't specified in the request. Ensure that  the format id is properly set in the request.");
        }
        if (!formatId.getValue().equals("application/bagit-097") && !formatId.getValue().equals("application/bagit-1.0")) {
            throw new NotImplemented("", "The format " + formatId.getValue() + " is not a supported format.");
        }
        String serviceFailureCode = "2871";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        if (formatId.getValue().equals("application/bagit-097")) {
            ServiceFailure sf;
            logMetacat.debug((Object)"Serving a download request for a Version 1 Package");
            PackageDownloaderV1 downloader = null;
            try {
                downloader = new PackageDownloaderV1(pid);
                org.dataone.service.types.v2.SystemMetadata sysMeta = this.getSystemMetadata(session, pid);
                if (ObjectFormatCache.getInstance().getFormat(sysMeta.getFormatId()).getFormatType().equals("RESOURCE")) {
                    InputStream oreInputStream = this.get(session, pid);
                    Map resourceMapStructure = ResourceMapFactory.getInstance().parseResourceMap(oreInputStream);
                    downloader.packagePids.addAll(resourceMapStructure.keySet());
                    for (Map entries : resourceMapStructure.values()) {
                        Set metadataIdentifiers = entries.keySet();
                        for (Identifier metadataID : metadataIdentifiers) {
                            try {
                                org.dataone.service.types.v2.SystemMetadata metadataSysMeta = this.getSystemMetadata(session, metadataID);
                                if (!ObjectFormatCache.getInstance().getFormat(metadataSysMeta.getFormatId()).getFormatType().equals("METADATA")) continue;
                                InputStream metadataStream = this.get(session, metadataID);
                                downloader.addSciPdf(metadataStream, metadataSysMeta, metadataID);
                            }
                            catch (Exception e) {
                                logMetacat.error((Object)e.toString());
                            }
                        }
                        downloader.packagePids.addAll(entries.keySet());
                        for (List dataPids : entries.values()) {
                            downloader.packagePids.addAll(dataPids);
                        }
                    }
                } else {
                    throw new InvalidRequest("2873", "The given pid " + pid.getValue() + " is not a package id (resource map id). Please use a package id instead.");
                }
                HashSet<Identifier> packagePidsUnique = new HashSet<Identifier>(downloader.packagePids);
                int index = 0;
                for (Identifier entryPid : packagePidsUnique) {
                    org.dataone.service.types.v2.SystemMetadata entrySysMeta = this.getSystemMetadata(session, entryPid);
                    String objectFormatType = ObjectFormatCache.getInstance().getFormat(entrySysMeta.getFormatId()).getFormatType();
                    String fileName = null;
                    fileName = entryPid.getValue().replaceAll("[^a-zA-Z0-9\\-\\.]", "_") + "-" + objectFormatType;
                    String extension = ObjectFormatInfo.instance().getExtension(entrySysMeta.getFormatId().getValue());
                    fileName = fileName + extension;
                    if (entrySysMeta.getFileName() != null) {
                        fileName = entrySysMeta.getFileName().replaceAll("[^a-zA-Z0-9\\-\\.]", "_");
                    }
                    InputStream entryInputStream = this.get(session, entryPid);
                    boolean success = false;
                    try {
                        downloader.speedBag.addFile(entryInputStream, Paths.get("data/", fileName).toString(), false);
                    }
                    catch (SpeedBagException e) {
                        fileName = index++ + "-duplicate-" + fileName;
                        logMetacat.warn((Object)("Duplicate data filename, renaming file to add to bag: " + fileName), (Throwable)e);
                        downloader.speedBag.addFile(entryInputStream, Paths.get("data/", fileName).toString(), false);
                    }
                    downloader.pidMapping.append(entryPid.getValue() + "\tdata/" + fileName + "\n");
                }
                ByteArrayInputStream pidFile = new ByteArrayInputStream(downloader.pidMapping.toString().getBytes(StandardCharsets.UTF_8));
                downloader.speedBag.addFile((InputStream)pidFile, "pid-mapping.txt", true);
            }
            catch (SpeedBagException e) {
                e.printStackTrace();
                ServiceFailure sf2 = new ServiceFailure("1030", "Error creating the bag: " + e.getMessage());
                sf2.initCause((Throwable)e);
                throw sf2;
            }
            catch (IOException e) {
                e.printStackTrace();
                ServiceFailure sf3 = new ServiceFailure("1030", e.getMessage());
                sf3.initCause((Throwable)e);
                throw sf3;
            }
            catch (OREException e) {
                e.printStackTrace();
                ServiceFailure sf4 = new ServiceFailure("1030", e.getMessage());
                sf4.initCause((Throwable)e);
                throw sf4;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                ServiceFailure sf5 = new ServiceFailure("1030", e.getMessage());
                sf5.initCause((Throwable)e);
                throw sf5;
            }
            catch (OREParserException e) {
                e.printStackTrace();
                ServiceFailure sf6 = new ServiceFailure("1030", "There was an error while processing the resource map. Ensure that the resource map for the package is valid. " + e.getMessage());
                sf6.initCause((Throwable)e);
                throw sf6;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                ServiceFailure sf7 = new ServiceFailure("1030", "There was an error while adding a file to the archive. Please ensure that the checksumming algorithm is supported." + e.getMessage());
                sf7.initCause((Throwable)e);
                throw sf7;
            }
            try {
                return downloader.speedBag.stream();
            }
            catch (IOException | NullPointerException e) {
                e.printStackTrace();
                sf = new ServiceFailure("1030", "There was an error while streaming the downloaded data package. " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                sf = new ServiceFailure("1030", "While creating the package download, an unsupported checksumming algorithm was encountered. " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        if (formatId.getValue().equals("application/bagit-1.0")) {
            InputStream objectInputStream;
            logMetacat.debug((Object)"Serving a download request for a Version 2 Package");
            Map<Identifier, Map<Identifier, List<Identifier>>> resourceMapStructure = this.parseResourceMap(session, pid);
            ArrayList<Identifier> pidsOfPackageObjects = new ArrayList<Identifier>();
            pidsOfPackageObjects.addAll(resourceMapStructure.keySet());
            for (Map<Identifier, List<Identifier>> entries : resourceMapStructure.values()) {
                pidsOfPackageObjects.addAll(entries.keySet());
                for (List<Identifier> dataPids : entries.values()) {
                    pidsOfPackageObjects.addAll(dataPids);
                }
            }
            ResourceMap resourceMap = this.serializeResourceMap(session, pid);
            org.dataone.service.types.v2.SystemMetadata resourceMapSystemMetadata = this.getSystemMetadata(session, pid);
            PackageDownloaderV2 downloader = new PackageDownloaderV2(pid, resourceMap, resourceMapSystemMetadata);
            List<Identifier> metadataIdentifiers = downloader.getCoreMetadataIdentifiers();
            HashSet uniquePids = new HashSet(pidsOfPackageObjects);
            for (Identifier entryPid : uniquePids) {
                if (metadataIdentifiers.contains(entryPid)) continue;
                org.dataone.service.types.v2.SystemMetadata entrySysMeta = this.getSystemMetadata(session, entryPid);
                objectInputStream = this.get(session, entryPid);
                downloader.addDataFile(entrySysMeta, objectInputStream);
                try {
                    downloader.addSystemMetadata(entrySysMeta);
                }
                catch (NoSuchAlgorithmException e) {
                    ServiceFailure sf = new ServiceFailure("1030", "While creating the package.Could not add the system metadata to the zipfile. " + e.getMessage());
                    sf.initCause((Throwable)e);
                    throw sf;
                }
            }
            try {
                List<Identifier> scienceMetadataIdentifiers = downloader.getScienceMetadataIdentifiers();
                if (scienceMetadataIdentifiers != null && !scienceMetadataIdentifiers.isEmpty()) {
                    Identifier sciMetataId = scienceMetadataIdentifiers.get(0);
                    org.dataone.service.types.v2.SystemMetadata systemMetadata = this.getSystemMetadata(session, sciMetataId);
                    objectInputStream = this.get(session, sciMetataId);
                }
                HashSet<Identifier> uniqueSciPids = new HashSet<Identifier>(scienceMetadataIdentifiers);
                for (Identifier scienceMetadataIdentifier : uniqueSciPids) {
                    logMetacat.debug((Object)"Adding science metadata to the bag");
                    org.dataone.service.types.v2.SystemMetadata systemMetadata = this.getSystemMetadata(session, scienceMetadataIdentifier);
                    InputStream scienceMetadataStream = this.get(session, scienceMetadataIdentifier);
                    downloader.addScienceMetadata(systemMetadata, scienceMetadataStream);
                }
                return downloader.download();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                ServiceFailure sf = new ServiceFailure("1030", "There was an error while streaming the downloaded data package. " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        ServiceFailure sf = new ServiceFailure("", "The download forma,t " + formatId.getValue() + " is not a supported format.");
        throw sf;
    }

    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        if (this.isReadOnlyMode()) {
            throw new ServiceFailure("2912", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        boolean allowed = false;
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        String serviceFailureCode = "1350";
        Identifier sid = this.getPIDForSID(pid, serviceFailureCode);
        if (sid != null) {
            pid = sid;
        }
        try {
            allowed = this.isAuthorized(session, pid, Permission.CHANGE_PERMISSION);
        }
        catch (InvalidRequest e) {
            throw new ServiceFailure("1350", e.getDescription());
        }
        if (allowed) {
            try {
                HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
                logMetacat.debug((Object)("MNodeService.archive - lock the identifier " + pid.getValue() + " in the system metadata map."));
                org.dataone.service.types.v2.SystemMetadata sysmeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                String quotaSubject = this.request.getHeader("X-DataONE-Quota-Subject");
                QuotaServiceManager.getInstance().enforce(quotaSubject, session.getSubject(), sysmeta, "archive");
                boolean needModifyDate = true;
                boolean logArchive = true;
                super.archiveObject(logArchive, session, pid, sysmeta, needModifyDate);
            }
            catch (InsufficientResources e) {
                throw new ServiceFailure("2912", "The user doesn't have enough quota to perform this request " + e.getMessage());
            }
            catch (InvalidRequest ee) {
                throw new InvalidToken("2913", "The request is invalid - " + ee.getMessage());
            }
            finally {
                HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
                logMetacat.debug((Object)("MNodeService.archive - unlock the identifier " + pid.getValue() + " in the system metadata map."));
            }
        } else {
            throw new NotAuthorized("1320", "The provided identity does not have permission to archive the object on the Node.");
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSystemMetadata(Session session, Identifier pid, org.dataone.service.types.v2.SystemMetadata sysmeta) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        if (this.isReadOnlyMode()) {
            throw new ServiceFailure("4868", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        if (sysmeta == null) {
            throw new InvalidRequest("4869", "The system metadata object should NOT be null in the updateSystemMetadata request.");
        }
        if (pid == null || pid.getValue() == null) {
            throw new InvalidRequest("4869", "Please specify the id in the updateSystemMetadata request ");
        }
        if (session == null) {
            throw new NotAuthorized("4861", "No Session - could not authorize for updating system metadata.  If you are not logged in, please do so and retry the request.");
        }
        boolean success = false;
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)pid);
            org.dataone.service.types.v2.SystemMetadata currentSysmeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            if (currentSysmeta == null) {
                throw new InvalidRequest("4869", "We can't find the current system metadata on the member node for the id " + pid.getValue());
            }
            D1AuthHelper authDel = null;
            try {
                authDel = new D1AuthHelper(this.request, pid, "4861", "4868");
                authDel.doUpdateAuth(session, currentSysmeta, Permission.CHANGE_PERMISSION, this.getCurrentNodeId());
            }
            catch (ServiceFailure e) {
                throw new ServiceFailure("4868", "Can't determine if the client has the permission to update the system metacat of the object with id " + pid.getValue() + " since " + e.getDescription());
            }
            catch (NotAuthorized e) {
                try {
                    authDel.doUpdateAuth(session, currentSysmeta, Permission.WRITE, this.getCurrentNodeId());
                    if (D1NodeService.isAccessControlDirty(sysmeta, currentSysmeta)) {
                        throw new NotAuthorized("4861", "Can't update the system metadata of the object with id " + pid.getValue() + " since the user try to change the access rules without the change permission: " + e.getDescription());
                    }
                }
                catch (ServiceFailure ee) {
                    throw new ServiceFailure("4868", "Can't determine if the client has the permission to update the system metadata the object with id " + pid.getValue() + " since " + ee.getDescription());
                }
                catch (NotAuthorized ee) {
                    throw new NotAuthorized("4861", "Can't update the system metadata of object with id " + pid.getValue() + " since " + ee.getDescription());
                }
            }
            Date currentModiDate = currentSysmeta.getDateSysMetadataModified();
            Date commingModiDate = sysmeta.getDateSysMetadataModified();
            if (commingModiDate == null) {
                throw new InvalidRequest("4869", "The system metadata modification date can't be null.");
            }
            if (currentModiDate != null && commingModiDate.getTime() != currentModiDate.getTime()) {
                throw new InvalidRequest("4869", "Your system metadata modification date is " + commingModiDate.toString() + ". It doesn't match our current system metadata modification date in the member node - " + currentModiDate.toString() + ". Please check if you have got the newest version of the system metadata before the modification.");
            }
            if (currentSysmeta.getAuthoritativeMemberNode() != null && sysmeta.getAuthoritativeMemberNode() != null && !currentSysmeta.getAuthoritativeMemberNode().equals((Object)sysmeta.getAuthoritativeMemberNode())) {
                throw new InvalidRequest("4869", "Current authoriativeMemberNode is " + currentSysmeta.getAuthoritativeMemberNode().getValue() + " but the value on the new system metadata is " + sysmeta.getAuthoritativeMemberNode().getValue() + ". They don't match. Clients don't have the permission to change it.");
            }
            if (currentSysmeta.getAuthoritativeMemberNode() != null && sysmeta.getAuthoritativeMemberNode() == null) {
                throw new InvalidRequest("4869", "Current authoriativeMemberNode is " + currentSysmeta.getAuthoritativeMemberNode().getValue() + " but the value on the new system metadata is null. They don't match. Clients don't have the permission to change it.");
            }
            if (currentSysmeta.getAuthoritativeMemberNode() == null && sysmeta.getAuthoritativeMemberNode() != null) {
                throw new InvalidRequest("4869", "Current authoriativeMemberNode is null but the value on the new system metadata is not null. They don't match. Clients don't have the permission to change it.");
            }
            this.checkAddRestrictiveAccessOnDOI(currentSysmeta, sysmeta);
            boolean needUpdateModificationDate = true;
            boolean fromCN = false;
            success = this.updateSystemMetadata(session, pid, sysmeta, needUpdateModificationDate, currentSysmeta, fromCN);
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)pid);
        }
        if (success) {
            try {
                logMetacat.info((Object)("MNodeSerice.updateSystemMetadata - register doi if the pid " + sysmeta.getIdentifier().getValue() + " is a doi"));
                DOIServiceFactory.getDOIService().registerDOI(sysmeta);
            }
            catch (Exception e) {
                logMetacat.error((Object)("MNodeService.updateSystemMetadata - Could not [re]register DOI: " + e.getMessage()), (Throwable)e);
            }
        }
        if (success && this.needSync) {
            logMetacat.debug((Object)("MNodeService.updateSystemMetadata - the cn needs to be notified that the system metadata of object " + pid.getValue() + " has been changed "));
            this.cn = D1Client.getCN();
            Runnable runner = (new Runnable(){
                private CNode cNode = null;
                private org.dataone.service.types.v2.SystemMetadata sys = null;
                private Identifier id = null;

                @Override
                public void run() {
                    try {
                        if (this.cNode == null) {
                            logMetacat.warn((Object)"MNodeService.updateSystemMetadata - can't get the instance of the CN. So can't call cn.synchronize to update the system metadata in CN.");
                        } else if (this.id != null) {
                            logMetacat.info((Object)("MNodeService.updateSystemMetadata - calling cn.synchornized in another thread for pid " + this.id.getValue()));
                            this.cNode.synchronize(null, this.id);
                        } else {
                            logMetacat.warn((Object)"MNodeService.updateSystemMetadata - the pid is null. So can't call cn.synchronize to update the system metadata in CN.");
                        }
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                        logMetacat.error((Object)("It is a DataONEBaseException and its detail code is " + e.getDetail_code() + " and its code is " + e.getCode()));
                        logMetacat.error((Object)("Can't update the systemmetadata of pid " + this.id.getValue() + " in CNs through cn.synchronize method since " + e.getMessage()), (Throwable)e);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logMetacat.error((Object)("Can't update the systemmetadata of pid " + this.id.getValue() + " in CNs through cn.synchronize method since " + e.getMessage()), (Throwable)e);
                    }
                }

                private Runnable init(CNode cn, org.dataone.service.types.v2.SystemMetadata sys, Identifier id) {
                    this.cNode = cn;
                    this.sys = sys;
                    this.id = id;
                    return this;
                }
            }).init(this.cn, sysmeta, pid);
            if (executor != null) {
                executor.submit(runner);
            } else {
                logMetacat.warn((Object)("MNodeSerivce.updateSystemMetadata - since the executor service for submitting the call of cn.synchronize() is null, the system metadata change of the id " + pid.getValue() + " can't go to cn through cn.synchronize."));
            }
        }
        return success;
    }

    public InputStream getStatus(Session session) throws NotAuthorized, ServiceFailure {
        int size = HazelcastService.getInstance().getIndexQueue().size();
        StringBuffer result = new StringBuffer();
        result.append("<?xml version=\"1.0\"?>");
        result.append("<status>");
        result.append("<index>");
        result.append("<sizeOfQueue>");
        result.append(size);
        result.append("</sizeOfQueue>");
        result.append("</index>");
        result.append("</status>");
        return IOUtils.toInputStream((String)result.toString());
    }

    public void publishIdentifier(Session session, Identifier identifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, DOIException {
        String invalidRequestCode = "1202";
        String notFoundCode = "1280";
        if (identifier == null || identifier.getValue().trim().equals("")) {
            throw new InvalidRequest(invalidRequestCode, "MNodeService.publishIdentifier - the identifier which needs to be published can't be null.");
        }
        String serviceFailureCode = "1310";
        Identifier pid = this.getPIDForSID(identifier, serviceFailureCode);
        if (pid == null) {
            pid = identifier;
        }
        logMetacat.info((Object)("MNodeService.publishIdentifier - the PID for the id " + identifier.getValue() + " is " + pid.getValue()));
        org.dataone.service.types.v2.SystemMetadata existingSysMeta = this.getSystemMetadataForPID(pid, serviceFailureCode, invalidRequestCode, notFoundCode, true);
        D1AuthHelper authDel = new D1AuthHelper(this.request, pid, "1200", "1310");
        authDel.doUpdateAuth(session, existingSysMeta, Permission.WRITE, this.getCurrentNodeId());
        existingSysMeta = this.makePublicIfNot(existingSysMeta, pid, true);
        Identifier oreIdentifier = this.getNewestORE(session, pid);
        if (oreIdentifier != null) {
            InputStream oreInputStream;
            org.dataone.service.types.v2.SystemMetadata oreSysmeta = this.getSystemMetadataForPID(oreIdentifier, serviceFailureCode, invalidRequestCode, notFoundCode, true);
            oreSysmeta = this.makePublicIfNot(oreSysmeta, oreIdentifier, true);
            if (enforcePublicEntirePackageInPublish && (oreInputStream = this.get(session, oreIdentifier)) != null) {
                Model model = ModelFactory.createDefaultModel();
                model.read(oreInputStream, null);
                List<Identifier> dataIdentifiers = ResourceMapModifier.getSubjectsOfDocumentedBy(pid, model);
                for (Identifier dataId : dataIdentifiers) {
                    org.dataone.service.types.v2.SystemMetadata dataSysMeta = this.getSystemMetadata(session, dataId);
                    dataSysMeta = this.makePublicIfNot(dataSysMeta, dataId, true);
                }
            }
        }
        try {
            DOIServiceFactory.getDOIService().publishIdentifier(session, identifier);
        }
        catch (PropertyNotFoundException e) {
            throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
        }
        catch (DOIException e) {
            throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
        }
    }

    private void checkAddRestrictiveAccessOnDOI(org.dataone.service.types.v2.SystemMetadata oldSysMeta, org.dataone.service.types.v2.SystemMetadata newSysMeta) throws InvalidRequest {
        String doi = "doi:";
        boolean identifierIsDOI = false;
        boolean sidIsDOI = false;
        if (newSysMeta.getIdentifier() == null) {
            throw new InvalidRequest("4869", "In the MN.updateSystemMetadata method, the identifier shouldn't be null in the new version system metadata ");
        }
        String identifier = newSysMeta.getIdentifier().getValue();
        String sid = null;
        if (newSysMeta.getSeriesId() != null) {
            sid = newSysMeta.getSeriesId().getValue();
        }
        if (identifier != null && identifier.startsWith(doi)) {
            identifierIsDOI = true;
        }
        if (sid != null && sid.startsWith(doi)) {
            sidIsDOI = true;
        }
        if (identifierIsDOI || sidIsDOI) {
            Subject publicUser = new Subject();
            publicUser.setValue("public");
            boolean isOldSysmetaPublicReadable = false;
            AccessPolicy oldAccess = oldSysMeta.getAccessPolicy();
            if (oldAccess != null && oldAccess.getAllowList() != null) {
                for (AccessRule item : oldAccess.getAllowList()) {
                    if (item.getSubjectList() == null || !item.getSubjectList().contains(publicUser) || item.getPermissionList() == null || !item.getPermissionList().contains(Permission.READ)) continue;
                    isOldSysmetaPublicReadable = true;
                    break;
                }
            }
            if (isOldSysmetaPublicReadable) {
                AccessPolicy access = newSysMeta.getAccessPolicy();
                if (access == null) {
                    throw new InvalidRequest("4869", "In the MN.updateSystemMetadata method, the public-readable access rule shouldn't be removed for an DOI object " + identifier + " or SID " + sid);
                }
                boolean found = false;
                if (access.getAllowList() != null) {
                    for (AccessRule item : access.getAllowList()) {
                        if (item.getSubjectList() == null || !item.getSubjectList().contains(publicUser) || item.getPermissionList() == null || !item.getPermissionList().contains(Permission.READ)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    throw new InvalidRequest("4869", "In the MN.updateSystemMetadata method, the public-readable access rule shouldn't be removed for an DOI object " + identifier + " or SID " + sid);
                }
            }
        }
    }

    protected NodeReference getCurrentNodeId() {
        return TypeFactory.buildNodeReference((String)Settings.getConfiguration().getString("dataone.nodeId"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAuthoritativeNode(Identifier pid) throws InvalidRequest {
        boolean isAuthoritativeNode = false;
        if (pid == null) throw new InvalidRequest("4869", "The request pid is null");
        if (pid.getValue() == null) throw new InvalidRequest("4869", "The request pid is null");
        org.dataone.service.types.v2.SystemMetadata sys = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
        if (sys == null) throw new InvalidRequest("4869", "Coudn't find the system metadata associated with the pid " + pid.getValue());
        NodeReference node = sys.getAuthoritativeMemberNode();
        if (node == null) throw new InvalidRequest("4869", "Coudn't find the authoritative member node in the system metadata associated with the pid " + pid.getValue());
        String nodeValue = node.getValue();
        logMetacat.debug((Object)("The authoritative node for id " + pid.getValue() + " is " + nodeValue));
        String currentNodeId = Settings.getConfiguration().getString("dataone.nodeId");
        logMetacat.debug((Object)("The node id in metacat.properties is " + currentNodeId));
        if (currentNodeId == null) return isAuthoritativeNode;
        if (currentNodeId.trim().equals("")) return isAuthoritativeNode;
        if (!currentNodeId.equals(nodeValue)) return isAuthoritativeNode;
        logMetacat.debug((Object)("They are matching, so the authoritative mn of the object " + pid.getValue() + " is the current node"));
        return true;
    }

    protected boolean isReadOnlyMode() {
        boolean readOnly = false;
        ReadOnlyChecker checker = new ReadOnlyChecker();
        readOnly = checker.isReadOnly();
        return readOnly;
    }

    public static void setEnforcePublisEntirePackage(boolean enforce) {
        enforcePublicEntirePackageInPublish = enforce;
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = availableProcessors * 1;
        --nThreads;
        nThreads = Math.max(1, nThreads);
        executor = Executors.newFixedThreadPool(nThreads);
        try {
            enforcePublicEntirePackageInPublish = new Boolean(PropertyService.getProperty("guid.doi.enforcePublicReadableEntirePackage"));
        }
        catch (Exception e) {
            logMetacat.warn((Object)("MNodeService.static - couldn't get the value since " + e.getMessage()));
        }
    }
}

