/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.hazelcast;

import com.hazelcast.core.MapLoader;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.xml.sax.SAXException;

public class ObjectPathMap
implements MapLoader<Identifier, String> {
    private static IdentifierManager im;
    private static String dataPath;
    private static String metadataPath;
    private Log logMetacat = LogFactory.getLog(ObjectPathMap.class);

    public ObjectPathMap() {
        try {
            PropertyService ps = PropertyService.getInstance();
            dataPath = PropertyService.getProperty("application.datafilepath");
            metadataPath = PropertyService.getProperty("application.documentfilepath");
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        im = IdentifierManager.getInstance();
    }

    private String pathToDocid(String localid, Identifier key) throws AccessControlException, HandlerException, MarshallingException, IOException, McdbException, SAXException {
        SystemMetadata systemMetadata = IdentifierManager.getInstance().getSystemMetadata(key.getValue());
        if (!D1NodeService.isScienceMetadata(systemMetadata)) {
            return dataPath + FileUtil.getFS() + localid;
        }
        return metadataPath + FileUtil.getFS() + localid;
    }

    public String load(Identifier key) {
        String docid = null;
        String path = null;
        try {
            docid = im.getLocalId(key.getValue());
            path = this.pathToDocid(docid, key);
        }
        catch (Exception e) {
            if (this.logMetacat.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        return path;
    }

    public Map<Identifier, String> loadAll(Collection<Identifier> identifiers) {
        Hashtable<Identifier, String> map = new Hashtable<Identifier, String>();
        for (Identifier id : identifiers) {
            try {
                String docid = im.getLocalId(id.getValue());
                map.put(id, this.pathToDocid(docid, id));
            }
            catch (Exception e) {
                if (!this.logMetacat.isDebugEnabled()) continue;
                e.printStackTrace();
            }
        }
        return map;
    }

    public Set<Identifier> loadAllKeys() {
        return null;
    }
}

