/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaDBManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.wicket.util.io.IOUtils;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.api.QuotaList;
import org.dataone.bookkeeper.api.Usage;
import org.dataone.bookkeeper.api.UsageList;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;

public class BookKeeperClient {
    public static final int DEFAULT_REMOTE_USAGE_ID = -1;
    private static final String QUOTAS = "quotas";
    private static final String QUOTATYPE = "quotaType";
    private static final String QUOTAID = "quotaId";
    private static final String QUOTASUBJECT = "subject";
    private static final String REQUESTOR = "requestor";
    private static final String USAGES = "usages";
    private static final String INSTANCEID = "instanceId";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer";
    private static Log logMetacat = LogFactory.getLog(BookKeeperClient.class);
    private static BookKeeperClient bookKeeperClient = null;
    private String bookKeeperURL = null;
    private CloseableHttpClient httpClient = null;
    private ObjectMapper mapper = new ObjectMapper();
    private BasicHeader header = null;

    protected BookKeeperClient() throws ServiceFailure {
        if (this.bookKeeperURL == null) {
            this.bookKeeperURL = Settings.getConfiguration().getString("dataone.quotas.bookkeeper.serviceUrl");
            logMetacat.debug((Object)("BookKeeperClient.BookKeeperClient - the bookkeeper service url from the metacat.properties file is " + this.bookKeeperURL));
            if (this.bookKeeperURL == null || this.bookKeeperURL.trim().equals("")) {
                throw new ServiceFailure("0000", "The quota service url can't be null or blank. Please ask the Metacat admin to check the property \"dataone.quotas.bookkeeper.serviceUrl\" in its metacat.properties file.");
            }
            if (!this.bookKeeperURL.endsWith("/")) {
                this.bookKeeperURL = this.bookKeeperURL + "/";
            }
            logMetacat.debug((Object)("BookKeeperClient.BookKeeperClient - the final bookkeeper service url is " + this.bookKeeperURL));
        }
        if (this.header == null) {
            String token = this.readTokenFromFile();
            this.header = new BasicHeader(AUTHORIZATION, "Bearer " + token);
        }
        Timer timer = new Timer("Signing Certificate Monitor");
        long tokenMonitorPeriod = 0x6DDD00L;
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    String token = BookKeeperClient.this.readTokenFromFile();
                    BookKeeperClient.this.header = new BasicHeader(BookKeeperClient.AUTHORIZATION, "Bearer " + token);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("BookKeeperClient - the timer thread couldn't read the token from a file since " + e.getMessage()));
                }
            }
        }, new Date(), tokenMonitorPeriod);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    private String readTokenFromFile() throws ServiceFailure {
        String tokenFilePath = Settings.getConfiguration().getString("dataone.nodeToken.file");
        File tokenFile = new File(tokenFilePath);
        String token = null;
        try {
            token = FileUtils.readFileToString((File)tokenFile, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new ServiceFailure("1190", "BookKeeperClient.readTokenFromFile - The BookKeeper client can't read the token file since " + e.getMessage());
        }
        if (token == null || token.trim().equals("")) {
            throw new ServiceFailure("1190", "BookKeeperClient.readTokenFromFile - The member node token can't be null or blank when it access the remote quota service. Please ask the Metacat admin to check the content of the token file with the path " + tokenFilePath + ". If the token file path is null or blank, please ask the Metacat admin to set the proper token file path at the property \"dataone.bearToken.file\" in its metacat.properties file.");
        }
        logMetacat.info((Object)("BookKeeperClient.readTokenFromFile - successfully read a token from the file " + tokenFilePath));
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BookKeeperClient getInstance() throws ServiceFailure {
        if (bookKeeperClient != null) return bookKeeperClient;
        Class<BookKeeperClient> clazz = BookKeeperClient.class;
        synchronized (BookKeeperClient.class) {
            if (bookKeeperClient != null) return bookKeeperClient;
            bookKeeperClient = new BookKeeperClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return bookKeeperClient;
        }
    }

    public List<Quota> listQuotas(String quotaSubject, String requestor, String quotaType) throws ServiceFailure, NotFound, InvalidRequest, UnsupportedEncodingException {
        List result;
        block21: {
            result = null;
            String restStr = this.bookKeeperURL + QUOTAS;
            boolean hasQuestionMark = false;
            if (quotaSubject != null && !quotaSubject.trim().equals("")) {
                restStr = restStr + "?" + QUOTASUBJECT + "=" + this.escapeURL(quotaSubject);
                hasQuestionMark = true;
            }
            if (quotaType != null && !quotaType.trim().equals("")) {
                if (!hasQuestionMark) {
                    restStr = restStr + "?" + QUOTATYPE + "=" + this.escapeURL(quotaType);
                    hasQuestionMark = true;
                } else {
                    restStr = restStr + "&" + QUOTATYPE + "=" + this.escapeURL(quotaType);
                }
            }
            if (requestor != null && !requestor.trim().equals("")) {
                if (!hasQuestionMark) {
                    restStr = restStr + "?" + REQUESTOR + "=" + this.escapeURL(requestor);
                    hasQuestionMark = true;
                } else {
                    restStr = restStr + "&" + REQUESTOR + "=" + this.escapeURL(requestor);
                }
            }
            logMetacat.debug((Object)("===========================BookKeeperClient.listQuotas - the rest request to list the quotas is " + restStr));
            HttpGet get = new HttpGet(restStr);
            get.addHeader((Header)this.header);
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)get);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    QuotaList list = (QuotaList)this.mapper.readValue(response.getEntity().getContent(), QuotaList.class);
                    if (list != null && list.getQuotas() != null && list.getQuotas().size() > 0) {
                        result = list.getQuotas();
                        logMetacat.debug((Object)("BookKeeperClient.listQuotas - the bookkeeper service return a list of quotas with the size " + result.size()));
                        break block21;
                    }
                    logMetacat.debug((Object)"BookKeeperClient.listQuotas - the bookkeeper service return null or empty");
                    throw new NotFound("1103", "QuotaService didn't find a quota for the quota subject " + quotaSubject + " with quota type " + quotaType + " for the requestor " + requestor);
                }
                if (status == 404) {
                    throw new NotFound("1103", "The quota with the quota subject " + quotaSubject + " is not found");
                }
                String error = IOUtils.toString((InputStream)response.getEntity().getContent());
                throw new ServiceFailure("1190", "Quota service can't fulfill to list quotas since " + error);
            }
            catch (ClientProtocolException e) {
                throw new ServiceFailure("1190", "Quota service can't fulfill to list quotas since " + e.getMessage());
            }
            catch (IOException e) {
                throw new ServiceFailure("1190", "Quota service can't fulfill to list quotas since " + e.getMessage());
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException ee) {
                        logMetacat.warn((Object)("BookKeeperClient.listQuotas - can't close the reponse at the finally cluae since " + ee.getMessage()));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createUsage(Usage usage) throws ClientProtocolException, IOException, ServiceFailure {
        int remoteUsageId = -1;
        String restStr = this.bookKeeperURL + USAGES;
        logMetacat.debug((Object)("BookKeeperClient.createUsage - the rest request to create the usuage is " + restStr));
        String jsonStr = this.mapper.writeValueAsString((Object)usage);
        logMetacat.debug((Object)("BookKeeperClient.createUsage - the json string will be sent is " + jsonStr));
        StringEntity reqEntity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
        reqEntity.setChunked(true);
        HttpPost post = new HttpPost(restStr);
        post.setEntity((HttpEntity)reqEntity);
        post.addHeader((Header)this.header);
        try (CloseableHttpResponse response = null;){
            response = this.httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                String error = IOUtils.toString((InputStream)response.getEntity().getContent());
                throw new ServiceFailure("0000", "Quota service can't create the usage since " + error);
            }
            Usage returnedUsage = (Usage)this.mapper.readValue(response.getEntity().getContent(), Usage.class);
            if (returnedUsage != null && returnedUsage.getId() != null) {
                remoteUsageId = returnedUsage.getId();
                logMetacat.info((Object)("BookKeeperClient.createUsage - successfully create the usage for quota id " + usage.getQuotaId() + " and the instance id " + usage.getInstanceId() + " in the remote book keeper server with the remote usage id " + remoteUsageId));
            }
        }
        logMetacat.debug((Object)("BookKeeperClient.createUsage - the final remoteUsageId is " + remoteUsageId));
        return remoteUsageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteUsage(int quotaId, String instanceId) throws InvalidRequest, ClientProtocolException, ServiceFailure, IOException {
        int remoteUsageId;
        block8: {
            remoteUsageId = -1;
            if (instanceId != null && !instanceId.trim().equals("")) {
                int id = this.getRemoteUsageId(quotaId, instanceId);
                if (id != -1) {
                    logMetacat.debug((Object)("BookKeeperClient.deleteUsage - the book keeper service find the usage with id " + id + " matching the quota id " + quotaId + " and instance id " + instanceId));
                    String restStr = this.bookKeeperURL + USAGES + "/" + id;
                    logMetacat.debug((Object)("BookKeeperClient.deleteUsage - the delete rest command is " + restStr));
                    try (CloseableHttpResponse response = null;){
                        HttpDelete httpdelete = new HttpDelete(restStr);
                        httpdelete.addHeader((Header)this.header);
                        response = this.httpClient.execute((HttpUriRequest)httpdelete);
                        int status = response.getStatusLine().getStatusCode();
                        if (status == 200) {
                            remoteUsageId = id;
                            logMetacat.info((Object)("BookKeeperClient.deleteUsage - successfully delete the usage with id " + id));
                            break block8;
                        }
                        String error = IOUtils.toString((InputStream)response.getEntity().getContent());
                        throw new ServiceFailure("0000", "BookKeeperClient.deleteUsage - can't delete the usage with the id " + id + " since " + error);
                    }
                }
                logMetacat.info((Object)("BookKeeperClient.deleteUsage - the book keeper service can't find the usage matching the quota id " + quotaId + " and instance id " + instanceId + ". So we don't need to delete anything."));
                remoteUsageId = -1;
            } else {
                throw new InvalidRequest("0000", "The instance id can't be null or blank when you try to delete a usage.");
            }
        }
        logMetacat.debug((Object)("BookKeeperClient.deleteUsage - the final deleted remoteUsageId is " + remoteUsageId));
        return remoteUsageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateUsage(int quotaId, String instanceId, Usage usage) throws InvalidRequest, ClientProtocolException, ServiceFailure, IOException {
        int remoteUsageId;
        block8: {
            remoteUsageId = -1;
            if (instanceId != null && !instanceId.trim().equals("")) {
                int id = this.getRemoteUsageId(quotaId, instanceId);
                if (id != -1) {
                    usage.setId(Integer.valueOf(id));
                    logMetacat.debug((Object)("BookKeeperClient.updateUsage - the book keeper service find the usage with id " + id + " matching the quota id " + quotaId + " and instance id " + instanceId));
                    String restStr = this.bookKeeperURL + USAGES + "/" + id;
                    logMetacat.debug((Object)("BookKeeperClient.updateUsage - the update rest command is " + restStr));
                    try (CloseableHttpResponse response = null;){
                        String jsonStr = this.mapper.writeValueAsString((Object)usage);
                        logMetacat.debug((Object)("BookKeeperClient.updateUsage - the json string will be sent is " + jsonStr));
                        StringEntity reqEntity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
                        reqEntity.setChunked(true);
                        HttpPut put = new HttpPut(restStr);
                        put.setEntity((HttpEntity)reqEntity);
                        put.addHeader((Header)this.header);
                        response = this.httpClient.execute((HttpUriRequest)put);
                        int status = response.getStatusLine().getStatusCode();
                        if (status == 200) {
                            logMetacat.info((Object)("BookKeeperClient.updateUsage - successfully update the usage with id " + id));
                            remoteUsageId = id;
                            break block8;
                        }
                        String error = IOUtils.toString((InputStream)response.getEntity().getContent());
                        throw new ServiceFailure("0000", "BookKeeperClient.updateUsage - can't delete the usage with the id " + id + " since " + error);
                    }
                }
                logMetacat.info((Object)("BookKeeperClient.updateUsage - the book keeper service can't find the usage matching the quota id " + quotaId + " and instance id " + instanceId + ". So we don't need to update anything."));
                remoteUsageId = -1;
            } else {
                throw new InvalidRequest("0000", "The instance id can't be null or blank when you try to update a usage.");
            }
        }
        logMetacat.debug((Object)("BookKeeperClient.updateUsage - the final remoteUsageId is " + remoteUsageId));
        return remoteUsageId;
    }

    int getRemoteUsageId(int quotaId, String instanceId) throws ClientProtocolException, ServiceFailure, IOException {
        int remoteUsageId;
        block7: {
            remoteUsageId = -1;
            try {
                remoteUsageId = QuotaDBManager.lookupRemoteUsageId(quotaId, instanceId);
            }
            catch (Exception e) {
                logMetacat.debug((Object)("BookKeeperClient.getRemoteUsageId - failed to get the remote usage id locally for the quota id " + quotaId + " and instance id " + instanceId + " since " + e.getMessage()));
            }
            if (remoteUsageId == -1) {
                logMetacat.debug((Object)("BookKeeperClient.getRemoteUsageId -  Metacat can't find the remote usage id locally. It will get the remote usage id from the remote book keeper server for the quota id " + quotaId + " and instance id " + instanceId));
                List<Usage> usages = null;
                try {
                    usages = this.listUsages(quotaId, instanceId);
                    if (usages == null || usages.size() == 0) {
                        logMetacat.warn((Object)("BookKeeperClient.getRemoteUsageId - the book keeper service don't find any usages matching the quota id " + quotaId + " and instance id " + instanceId + ". So we set the remote id to " + -1));
                        remoteUsageId = -1;
                        break block7;
                    }
                    if (usages.size() == 1) {
                        Usage existedUsage = usages.get(0);
                        remoteUsageId = existedUsage.getId();
                        break block7;
                    }
                    throw new ServiceFailure("0000", "BookKeeperClient.getRemoteUsageId - the bookkeeper service should only send back one record with the given quota id " + quotaId + " and instance id " + instanceId + ". However, it sent back more than one. Something is wrong in the bookkeeper service.");
                }
                catch (NotFound e) {
                    logMetacat.warn((Object)("BookKeeperClient.getRemoteUsageId - the book keeper service don't find any usages matching the quota id " + quotaId + " and instance id " + instanceId + ". So we set the remote id to " + -1));
                    remoteUsageId = -1;
                }
            }
        }
        logMetacat.debug((Object)("BookKeeperClient.getRemoteUsageId - the final returned remote usage id is " + remoteUsageId + " for the quota id " + quotaId + " and instance id " + instanceId));
        return remoteUsageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Usage> listUsages(int quotaId, String instanceId) throws ClientProtocolException, IOException, NotFound, ServiceFailure {
        List result;
        block7: {
            String restStr = this.bookKeeperURL + USAGES + "/?" + QUOTAID + "=" + quotaId + "&" + INSTANCEID + "=" + this.escapeURL(instanceId);
            logMetacat.debug((Object)("BookKeeperClient.getUsageId - the rest request to get the usuage id is " + restStr));
            HttpGet get = new HttpGet(restStr);
            get.addHeader((Header)this.header);
            result = null;
            try (CloseableHttpResponse response = null;){
                response = this.httpClient.execute((HttpUriRequest)get);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    UsageList list = (UsageList)this.mapper.readValue(response.getEntity().getContent(), UsageList.class);
                    if (list != null) {
                        result = list.getUsages();
                    }
                    break block7;
                }
                if (status == 404) {
                    throw new NotFound("0000", "BookKeeperClient.getUsageId - the usage with the quota id " + quotaId + " and instance id " + instanceId + "is not found");
                }
                String error = IOUtils.toString((InputStream)response.getEntity().getContent());
                throw new ServiceFailure("0000", "BookKeeperClient.getUsageId - quota service can't fulfill to list usages since " + error);
            }
        }
        return result;
    }

    private String escapeURL(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "UTF-8");
    }
}

