/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.dataone.quota.BookKeeperClient;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaService;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public class PortalQuotaService
extends QuotaService {
    private static Log logMetacat = LogFactory.getLog(PortalQuotaService.class);
    private static PortalQuotaService service = null;

    private PortalQuotaService(ExecutorService executor, BookKeeperClient client) {
        PortalQuotaService.executor = executor;
        PortalQuotaService.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuotaService getInstance(ExecutorService executor, BookKeeperClient client) {
        if (service != null) return service;
        Class<PortalQuotaService> clazz = PortalQuotaService.class;
        synchronized (PortalQuotaService.class) {
            if (service != null) return service;
            service = new PortalQuotaService(executor, client);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return service;
        }
    }

    @Override
    public void enforce(String quotaSubject, Subject requestor, String instanceId, SystemMetadata sysmeta, String method) throws ServiceFailure, InvalidRequest, InsufficientResources, NotImplemented, NotFound, UnsupportedEncodingException {
        logMetacat.debug((Object)("PortalQuotaService.enforce - checking both portal and storage quota types for the instance " + instanceId));
        double portalQuantity = 1.0;
        if (method != null && method.equals("create")) {
            boolean checkSpace = true;
            int portalQuotaId = this.checkQuota(checkSpace, quotaSubject, requestor.getValue(), "portal", portalQuantity, instanceId);
            this.createUsage(portalQuotaId, instanceId, portalQuantity);
        } else if (method != null && method.equals("archive")) {
            if (this.isLastUnarchivedInChain(sysmeta.getIdentifier().getValue(), instanceId)) {
                boolean checkSpace = false;
                int portalQuotaId = this.checkQuota(checkSpace, quotaSubject, requestor.getValue(), "portal", portalQuantity, instanceId);
                this.updateUsage(portalQuotaId, instanceId, portalQuantity);
            } else {
                logMetacat.debug((Object)("PortalQuotaService.enforce - Metacat is not archiving the last object which hasn't been archived in the series chain " + instanceId + ". It needs to do nothing for the portal quota"));
            }
        } else if (method != null && method.equals("delete")) {
            if (this.isLastUndeletedInChain(sysmeta.getIdentifier().getValue(), instanceId)) {
                boolean checkSpace = false;
                String dummyRequestor = null;
                int portalQuotaId = this.checkQuota(checkSpace, quotaSubject, dummyRequestor, "portal", portalQuantity, instanceId);
                this.deleteUsage(portalQuotaId, instanceId, portalQuantity);
            } else {
                logMetacat.debug((Object)("PortalQuotaService.enforce - Metacat is not deleting the last object in the series chain " + instanceId + ". It needs to do nothing for the portal quota"));
            }
        } else if (method != null && method.equals("update")) {
            logMetacat.info((Object)("PortalQuotaService.enforce - Metacat is updating an object in the series chain " + instanceId + ". It needs to do nothing for the portal quota."));
        } else {
            throw new InvalidRequest("1102", "In the portal quota checking process, Metacat doesn't support the method  " + method + " for the pid " + sysmeta.getIdentifier().getValue());
        }
    }
}

