/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.quota.LocalUsage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Usage;

public class QuotaDBManager {
    public static final String TABLE = "quota_usage_events";
    public static final String USAGELOCALID = "usage_local_id";
    public static final String USAGEREMOTEID = "usage_remote_id";
    public static final String QUOTAID = "quota_id";
    public static final String INSTANCEID = "instance_id";
    public static final String QUANTITY = "quantity";
    public static final String STATUS = "status";
    public static final String DATEREPORTED = "date_reported";
    public static final String OBJECT = "object";
    public static final String NODEID = "node_id";
    public static final String QUOTASUBJECT = "quota_subject";
    public static final String QUOTATYPE = "quota_type";
    public static final String REQUESTOR = "requestor";
    private static Log logMetacat = LogFactory.getLog(QuotaDBManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUsage(Usage usage, Date date) throws SQLException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement stmt = null;
        boolean quotaIdExist = false;
        try {
            dbConn = DBConnectionPool.getDBConnection("QuotaDBManager.createUsage");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String fields = "date_reported,instance_id,quantity,object,status,node_id,quota_subject,quota_type,requestor";
            String values = "?,?,?,?,?,?,?,?,?";
            if (usage.getQuotaId() != null && usage.getQuotaId() > 0) {
                fields = fields + "," + QUOTAID;
                values = values + ",?";
                quotaIdExist = true;
            }
            if (usage.getId() != null && usage.getId() > 0) {
                fields = fields + "," + USAGEREMOTEID;
                values = values + ",?";
            }
            String query = "insert into quota_usage_events ( " + fields + " ) values ( " + values + " )";
            stmt = dbConn.prepareStatement(query);
            if (date == null) {
                stmt.setTimestamp(1, null);
            } else {
                stmt.setTimestamp(1, new Timestamp(date.getTime()));
            }
            stmt.setString(2, usage.getInstanceId());
            stmt.setDouble(3, usage.getQuantity());
            stmt.setString(4, usage.getObject());
            stmt.setString(5, usage.getStatus());
            stmt.setString(6, usage.getNodeId());
            if (usage instanceof LocalUsage) {
                LocalUsage localUsage = (LocalUsage)usage;
                stmt.setString(7, localUsage.getSubscriber());
                stmt.setString(8, localUsage.getQuotaType());
                stmt.setString(9, localUsage.getRequestor());
            } else {
                stmt.setString(7, null);
                stmt.setString(8, null);
                stmt.setString(9, null);
            }
            if (quotaIdExist) {
                stmt.setInt(10, usage.getQuotaId());
            }
            if (usage.getId() != null && usage.getId() > 0) {
                if (quotaIdExist) {
                    stmt.setInt(11, usage.getId());
                } else {
                    stmt.setInt(10, usage.getId());
                }
            }
            logMetacat.debug((Object)("QuotaDBManager.createUsage - the create usage query is " + stmt.toString()));
            int n = stmt.executeUpdate();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setReportedDateAndRemoteId(int localId, Date date, int remoteId) throws SQLException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement stmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("QuotaDBManager.setReportedDate");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String query = "update quota_usage_events set date_reported = ? ,usage_remote_id=? where usage_local_id=?";
            stmt = dbConn.prepareStatement(query);
            stmt.setTimestamp(1, new Timestamp(date.getTime()));
            stmt.setInt(2, remoteId);
            stmt.setInt(3, localId);
            logMetacat.debug((Object)("QuotaDBManager.setReportedDate - the update query is " + stmt.toString()));
            int n = stmt.executeUpdate();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet getUnReportedUsages() throws SQLException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("QuotaDBManager.getUnReportedUsages");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String query = "select usage_local_id, quota_id,instance_id, quantity,object,status,node_id from quota_usage_events where date_reported is null order by usage_local_id ASC";
            stmt = dbConn.prepareStatement(query);
            logMetacat.debug((Object)("QuotaDBManager.getUnReportedUsages - the select query is " + query));
            rs = stmt.executeQuery();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int lookupRemoteUsageId(int quotaId, String instanceId) throws SQLException {
        int remoteId = -1;
        DBConnection dbConn = null;
        int serialNumber = -1;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("QuotaDBManager.lookupRemoteUsageId");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String query = "select usage_remote_id from quota_usage_events where quota_id=" + quotaId + " and " + INSTANCEID + "='" + instanceId + "'";
            stmt = dbConn.prepareStatement(query);
            logMetacat.debug((Object)("QuotaDBManager.lookupRemoteUsageId - the select query is " + query));
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt(1) <= 0) continue;
                remoteId = rs.getInt(1);
                logMetacat.debug((Object)("QuotaDBManager.lookupRemoteUsageId - in the local db, Metacat find the cached remote usage id " + remoteId + " with quota id " + quotaId + " and instance id " + instanceId));
                break;
            }
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        logMetacat.debug((Object)("QuotaDBManager.lookupRemoteUsageId - From the local db, the cached remote usage id is " + remoteId + " with quota id " + quotaId + " and instance id " + instanceId + ". If it is " + -1 + ", which means we don't find one in the local database."));
        return remoteId;
    }
}

