/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.dataone.quota.BookKeeperClient;
import edu.ucsb.nceas.metacat.dataone.quota.LocalUsage;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaDBManager;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Usage;

public abstract class UsageTask
implements Runnable {
    private static Log logMetacat = LogFactory.getLog(UsageTask.class);
    protected Usage usage = null;
    protected BookKeeperClient bookkeeperClient = null;
    protected boolean isLoggedLocally = false;

    public UsageTask(Usage usage, BookKeeperClient bookkeeperClient) {
        this.usage = usage;
        this.bookkeeperClient = bookkeeperClient;
    }

    public void setIsLoggedLocally(boolean isLoggedLocally) {
        this.isLoggedLocally = isLoggedLocally;
    }

    @Override
    public void run() {
        if (this.usage != null) {
            int remoteUsageId = -1;
            try {
                remoteUsageId = this.reportToBookKeeper();
                this.usage.setId(Integer.valueOf(remoteUsageId));
            }
            catch (Exception e) {
                logMetacat.error((Object)("UsageTask.run - can't report the usage to the remote server since " + e.getMessage()));
                if (!this.isLoggedLocally) {
                    try {
                        Date now = null;
                        QuotaDBManager.createUsage(this.usage, now);
                    }
                    catch (Exception ee) {
                        logMetacat.error((Object)("UsageTask.run - can't save the usage to the local usages table since " + ee.getMessage() + " The usage is with the quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the quantity " + this.usage.getQuantity() + " status " + this.usage.getStatus()));
                    }
                } else {
                    logMetacat.debug((Object)("UsageTask.run - even though Metacat failed to report the usage with the quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the quantity " + this.usage.getQuantity() + " status " + this.usage.getStatus() + " to the remote book keeper server. However, the local database already has the record, we don't need to do anything."));
                }
                return;
            }
            Date now = new Date();
            if (!this.isLoggedLocally) {
                logMetacat.debug((Object)("UsageTask.run - Metacat succeeded to report the usage with the quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the quantity " + this.usage.getQuantity() + " status " + this.usage.getStatus() + " to the remote book keep server. However, the local database does NOT have a record for it and Metacat need to create a new usage record with reported date in the local database."));
                try {
                    QuotaDBManager.createUsage(this.usage, now);
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("UsageTask.run - can't create a new usage to the local usages table since " + ee.getMessage() + " The usage is with the quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the status " + this.usage.getStatus() + " the quantity " + this.usage.getQuantity() + " the reported date " + now.getTime() + " object " + this.usage.getObject()));
                }
            } else {
                logMetacat.debug((Object)("UsageTask.run - Metacat succeeded to report the usage with the quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the quantity " + this.usage.getQuantity() + " status " + this.usage.getStatus() + " to the remote book keep server. Moreover, the local database already has the record and Metacat needs to set the local reported date in this record."));
                try {
                    LocalUsage localUsage = (LocalUsage)this.usage;
                    QuotaDBManager.setReportedDateAndRemoteId(localUsage.getLocalId(), now, remoteUsageId);
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("UsageTask.run - can't update the usage in the local quota_usage_event table since " + ee.getMessage() + " The usage is with the with the local usage id " + this.usage.getId() + " quota id " + this.usage.getQuotaId() + " instance id " + this.usage.getInstanceId() + " the quantity " + this.usage.getQuantity() + " the reported date " + now.getTime()));
                }
            }
        }
    }

    protected abstract int reportToBookKeeper() throws Exception;
}

