/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataquery;

import edu.ucsb.nceas.metacat.dataquery.MetacatAuthenticatedEcogridEndPoint;
import edu.ucsb.nceas.metacat.dataquery.MetacatDatabaseConnectionPoolFactory;
import edu.ucsb.nceas.metacat.dataquery.MetacatEcogridEndPoint;
import java.sql.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.Union;
import org.ecoinformatics.datamanager.dataquery.DataquerySpecification;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;

public class DataQuery {
    private static Log log = LogFactory.getLog(DataQuery.class);
    private EcogridEndPointInterface endPointInfo;
    private DatabaseConnectionPoolInterface connectionPool;
    private DataManager dataManager;
    private String parserName = "org.apache.xerces.parsers.SAXParser";

    public DataQuery() {
        this.endPointInfo = new MetacatEcogridEndPoint();
        this.init();
    }

    public DataQuery(String sessionId) {
        this.endPointInfo = new MetacatAuthenticatedEcogridEndPoint(sessionId);
        this.init();
    }

    private void init() {
        this.connectionPool = MetacatDatabaseConnectionPoolFactory.getDatabaseConnectionPoolInterface();
        this.dataManager = DataManager.getInstance((DatabaseConnectionPoolInterface)this.connectionPool, (String)this.connectionPool.getDBAdapterName());
    }

    public ResultSet executeQuery(String xml) throws Exception {
        long startTime = System.currentTimeMillis();
        DataquerySpecification specification = new DataquerySpecification(xml, this.parserName, this.connectionPool, this.endPointInfo);
        long endTime = System.currentTimeMillis();
        log.debug((Object)(endTime - startTime + " ms to parse query"));
        startTime = System.currentTimeMillis();
        ResultSet resultset = null;
        Union union = specification.getUnion();
        if (union != null) {
            resultset = this.dataManager.selectData(union, specification.getDataPackages());
        } else {
            Query query = specification.getQuery();
            resultset = this.dataManager.selectData(query, specification.getDataPackages());
        }
        endTime = System.currentTimeMillis();
        log.debug((Object)(endTime - startTime + " ms to select results"));
        return resultset;
    }
}

