/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataquery;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.postgresql.jdbc3.Jdbc3PoolingDataSource;

public class PostgresDatabaseConnectionPool
implements DatabaseConnectionPoolInterface {
    public static Log log = LogFactory.getLog(PostgresDatabaseConnectionPool.class);
    private static String serverName = null;
    private static String databaseName = null;
    private static String user = null;
    private static String password = null;
    private static int maxConnections = 0;
    private static String databaseAdapterName = null;
    private static Jdbc3PoolingDataSource source = null;
    private static int connCount = 0;

    public PostgresDatabaseConnectionPool() {
        try {
            PostgresDatabaseConnectionPool.loadOptions();
        }
        catch (PropertyNotFoundException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        PostgresDatabaseConnectionPool.initPool();
    }

    private static void initPool() {
        source = new Jdbc3PoolingDataSource();
        source.setServerName(serverName);
        source.setDatabaseName(databaseName);
        source.setUser(user);
        source.setPassword(password);
        source.setMaxConnections(maxConnections);
    }

    private static void loadOptions() throws PropertyNotFoundException {
        serverName = PropertyService.getProperty("datamanager.server");
        databaseName = PropertyService.getProperty("datamanager.database");
        user = PropertyService.getProperty("datamanager.user");
        password = PropertyService.getProperty("datamanager.password");
        maxConnections = Integer.parseInt(PropertyService.getProperty("datamanager.maxconnections"));
        databaseAdapterName = PropertyService.getProperty("datamanager.adapter");
    }

    public String getDBAdapterName() {
        return databaseAdapterName;
    }

    public Connection getConnection() throws SQLException, ConnectionNotAvailableException {
        Connection connection = null;
        try {
            connection = source.getConnection();
            ++connCount;
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        return connection;
    }

    public boolean returnConnection(Connection conn) {
        boolean success = false;
        try {
            conn.close();
            success = true;
            --connCount;
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public static void main(String[] arg) {
        PostgresDatabaseConnectionPool pool = new PostgresDatabaseConnectionPool();
        try {
            Connection conn = pool.getConnection();
            log.debug((Object)("conn=" + conn));
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ConnectionNotAvailableException e) {
            e.printStackTrace();
        }
    }
}

