/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi;

import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.doi.DOIException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.SystemMetadata;

public abstract class DOIService {
    protected static final int PRIMARY_SHOULDER_INDEX = 1;
    protected static boolean doiEnabled = false;
    protected static String serviceBaseUrl = null;
    protected static String username = null;
    protected static String password = null;
    protected static String uriTemplate = null;
    protected static boolean autoPublishDOI = true;
    protected static HashMap<Integer, String> shoulderMap = null;
    private static Log logMetacat = LogFactory.getLog(DOIService.class);

    public DOIService() {
        try {
            doiEnabled = new Boolean(PropertyService.getProperty("guid.doi.enabled"));
            serviceBaseUrl = PropertyService.getProperty("guid.doi.baseurl");
            username = PropertyService.getProperty("guid.doi.username");
            password = PropertyService.getProperty("guid.doi.password");
            autoPublishDOI = new Boolean(PropertyService.getProperty("guid.doi.autoPublish"));
            uriTemplate = PropertyService.getProperty("guid.doi.uritemplate.metadata");
        }
        catch (PropertyNotFoundException e) {
            logMetacat.error((Object)"DOIService.constructor - we can't get the value of the property:", (Throwable)e);
        }
        shoulderMap = new HashMap();
        boolean moreShoulders = true;
        int i = 1;
        while (moreShoulders) {
            try {
                String shoulder = PropertyService.getProperty("guid.doi.doishoulder." + i);
                if (shoulder != null && !shoulder.trim().equals("")) {
                    logMetacat.debug((Object)("DOIService.constructor - add the shoulder " + shoulder + " with the key " + i + " into the shoulder map. "));
                    shoulderMap.put(new Integer(i), shoulder);
                }
                ++i;
            }
            catch (PropertyNotFoundException e) {
                moreShoulders = false;
            }
        }
        if (shoulderMap.size() < 1) {
            logMetacat.error((Object)"DOI support is not configured at this node because no shoulders are configured.");
            return;
        }
    }

    public void refreshStatus() throws PropertyNotFoundException {
        doiEnabled = new Boolean(PropertyService.getProperty("guid.doi.enabled"));
        autoPublishDOI = new Boolean(PropertyService.getProperty("guid.doi.autoPublish"));
    }

    protected String getLandingPage(Identifier identifier) {
        String siteUrl = null;
        try {
            siteUrl = uriTemplate != null ? SystemUtil.getSecureServerURL() + uriTemplate.replaceAll("<IDENTIFIER>", identifier.getValue()) : SystemUtil.getContextURL() + "/d1/mn/v2/object/" + identifier.getValue();
        }
        catch (PropertyNotFoundException e) {
            logMetacat.warn((Object)("DOIService.getLandingPage - No target URI template found in the configuration for: " + e.getMessage()));
        }
        logMetacat.warn((Object)("DOIService.getLandingPage - the landing page url is: " + siteUrl));
        return siteUrl;
    }

    public boolean registerDOI(SystemMetadata sysmeta) throws InvalidRequest, DOIException, NotImplemented, ServiceFailure, InterruptedException, NotAuthorized, InvalidToken, NotFound {
        if (doiEnabled) {
            try {
                Identifier headPid;
                String identifier = sysmeta.getIdentifier().getValue();
                String sid = null;
                if (sysmeta.getSeriesId() != null) {
                    sid = sysmeta.getSeriesId().getValue();
                }
                boolean identifierIsDOI = false;
                boolean sidIsDOI = false;
                for (String shoulder : shoulderMap.values()) {
                    if (shoulder != null && !shoulder.trim().equals("") && identifier != null && identifier.startsWith(shoulder)) {
                        identifierIsDOI = true;
                    }
                    if (shoulder == null || shoulder.trim().equals("") || sid == null || !sid.startsWith(shoulder)) continue;
                    sidIsDOI = true;
                }
                if (identifierIsDOI) {
                    this.submitDOIMetadata(sysmeta.getIdentifier(), sysmeta);
                }
                if (sidIsDOI && (headPid = IdentifierManager.getInstance().getHeadPID(sysmeta.getSeriesId())) != null && headPid.getValue() != null && headPid.getValue().equals(identifier)) {
                    this.submitDOIMetadata(sysmeta.getSeriesId(), sysmeta);
                }
            }
            catch (IOException e) {
                throw new ServiceFailure("1030", e.getMessage());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1030", e.getMessage());
            }
        }
        return true;
    }

    protected abstract void submitDOIMetadata(Identifier var1, SystemMetadata var2) throws InvalidRequest, DOIException, NotImplemented, ServiceFailure, InterruptedException, InvalidToken, NotAuthorized, NotFound, IOException;

    public abstract Identifier generateDOI() throws DOIException, InvalidRequest;

    public abstract void publishIdentifier(Session var1, Identifier var2) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, DOIException;
}

