/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.index;

import edu.ucsb.nceas.metacat.common.index.event.IndexEvent;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;

public class IndexEventDAO {
    private static IndexEventDAO instance = null;
    private static String DELETESQL = "delete from index_event where guid = ?";

    private IndexEventDAO() {
    }

    public static IndexEventDAO getInstance() {
        if (instance == null) {
            instance = new IndexEventDAO();
        }
        return instance;
    }

    public void add(IndexEvent event) throws SQLException {
        String sql = "insert into index_event(guid, event_action, description, event_date) values (?, ?, ?, ?)";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IndexEventDAO.add");
            dbConn.setAutoCommit(false);
            serialNumber = dbConn.getCheckOutSerialNumber();
            if (event != null && event.getIdentifier() != null && event.getIdentifier().getValue() != null && !event.getIdentifier().getValue().trim().equals("")) {
                PreparedStatement deleteStmt = dbConn.prepareStatement(DELETESQL);
                deleteStmt.setString(1, event.getIdentifier().getValue());
                deleteStmt.execute();
                deleteStmt.close();
            }
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, event.getIdentifier().getValue());
            stmt.setString(2, event.getAction().xmlValue());
            stmt.setString(3, event.getDescription());
            stmt.setTimestamp(4, new Timestamp(event.getDate().getTime()));
            stmt.executeUpdate();
            stmt.close();
            dbConn.commit();
        }
        catch (SQLException sqle) {
            try {
                if (dbConn != null) {
                    dbConn.rollback();
                }
            }
            catch (SQLException sqle2) {
                throw new SQLException("Metacat can't roll back the change since " + sqle2.getMessage(), sqle);
            }
            throw sqle;
        }
        finally {
            dbConn.setAutoCommit(true);
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Identifier identifier) throws SQLException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IndexEventDAO.remove");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(DELETESQL);
            stmt.setString(1, identifier.getValue());
            stmt.execute();
            stmt.close();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexEvent get(Identifier identifier) throws SQLException {
        IndexEvent event = null;
        String sql = "select guid, event_action, description, event_date from index_event where guid = ?";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IndexEventDAO.get");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, identifier.getValue());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String action = rs.getString(2);
                String description = rs.getString(3);
                Timestamp timestamp = rs.getTimestamp(4);
                event = new IndexEvent();
                event.setIdentifier(identifier);
                event.setAction(Event.convert((String)action));
                event.setDate((Date)timestamp);
                event.setDescription(description);
            }
            stmt.close();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Identifier> getAllIdentifiers() throws SQLException {
        TreeSet<Identifier> identifiers = new TreeSet<Identifier>();
        String sql = "select guid from index_event";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("IndexEventDAO.getAllIdentifiers");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String guid = rs.getString(1);
                Identifier identifier = new Identifier();
                identifier.setValue(guid);
                identifiers.add(identifier);
            }
            stmt.close();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return identifiers;
    }
}

